/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.runtime.api.model.impl;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.activiti.api.task.model.Task;
import org.activiti.api.task.model.impl.TaskImpl;
import org.activiti.engine.TaskService;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.runtime.api.model.impl.ListConverter;
import org.activiti.runtime.api.model.impl.ModelConverter;
import org.springframework.beans.factory.annotation.Autowired;

public class APITaskConverter
extends ListConverter<Task, org.activiti.api.task.model.Task>
implements ModelConverter<Task, org.activiti.api.task.model.Task> {
    private final TaskService taskService;

    @Autowired
    public APITaskConverter(TaskService taskService) {
        this.taskService = taskService;
    }

    public org.activiti.api.task.model.Task from(Task internalTask) {
        return this.from(internalTask, this.calculateStatus(internalTask));
    }

    public org.activiti.api.task.model.Task fromWithCandidates(Task internalTask) {
        TaskImpl task = this.buildFromInternalTask(internalTask, this.calculateStatus(internalTask));
        this.extractCandidateUsersAndGroups(internalTask, task);
        return task;
    }

    private TaskImpl buildFromInternalTask(Task internalTask, Task.TaskStatus status) {
        TaskImpl task = new TaskImpl(internalTask.getId(), internalTask.getName(), status);
        task.setProcessDefinitionId(internalTask.getProcessDefinitionId());
        task.setProcessInstanceId(internalTask.getProcessInstanceId());
        task.setAssignee(internalTask.getAssignee());
        task.setClaimedDate(internalTask.getClaimTime());
        task.setCreatedDate(internalTask.getCreateTime());
        task.setDueDate(internalTask.getDueDate());
        task.setDescription(internalTask.getDescription());
        task.setOwner(internalTask.getOwner());
        task.setParentTaskId(internalTask.getParentTaskId());
        task.setPriority(internalTask.getPriority());
        task.setFormKey(internalTask.getFormKey());
        task.setTaskDefinitionKey(internalTask.getTaskDefinitionKey());
        task.setAppVersion(Objects.toString(internalTask.getAppVersion(), null));
        task.setBusinessKey(internalTask.getBusinessKey());
        return task;
    }

    public org.activiti.api.task.model.Task from(Task internalTask, Task.TaskStatus status) {
        return this.buildFromInternalTask(internalTask, status);
    }

    public org.activiti.api.task.model.Task fromWithCompletedBy(Task internalTask, Task.TaskStatus status, String completedBy) {
        TaskImpl task = this.buildFromInternalTask(internalTask, status);
        task.setCompletedBy(completedBy);
        return task;
    }

    private void extractCandidateUsersAndGroups(Task source, TaskImpl destination) {
        List candidates = this.taskService.getIdentityLinksForTask(source.getId());
        destination.setCandidateGroups(this.extractCandidatesBy(candidates, IdentityLink::getGroupId));
        destination.setCandidateUsers(this.extractCandidatesBy(candidates, IdentityLink::getUserId));
    }

    private List<String> extractCandidatesBy(List<IdentityLink> candidates, Function<IdentityLink, String> extractor) {
        List<String> result = Collections.emptyList();
        if (candidates != null) {
            result = candidates.stream().filter(candidate -> "candidate".equals(candidate.getType())).map(extractor::apply).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return result;
    }

    private Task.TaskStatus calculateStatus(Task source) {
        if (source instanceof TaskEntity && (((TaskEntity)source).isDeleted() || ((TaskEntity)source).isCanceled())) {
            return Task.TaskStatus.CANCELLED;
        }
        if (source.isSuspended()) {
            return Task.TaskStatus.SUSPENDED;
        }
        if (source.getAssignee() != null && !source.getAssignee().isEmpty()) {
            return Task.TaskStatus.ASSIGNED;
        }
        return Task.TaskStatus.CREATED;
    }
}

