/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.runtime.api.conf;

import java.util.Collections;
import java.util.List;
import org.activiti.api.model.shared.event.VariableCreatedEvent;
import org.activiti.api.model.shared.event.VariableUpdatedEvent;
import org.activiti.api.runtime.shared.events.VariableEventListener;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.delegate.event.ActivitiEventListener;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.runtime.api.event.impl.EphemeralVariableResolver;
import org.activiti.runtime.api.event.impl.ToVariableCreatedConverter;
import org.activiti.runtime.api.event.impl.ToVariableUpdatedConverter;
import org.activiti.runtime.api.event.internal.VariableCreatedListenerDelegate;
import org.activiti.runtime.api.event.internal.VariableEventFilter;
import org.activiti.runtime.api.event.internal.VariableUpdatedListenerDelegate;
import org.activiti.runtime.api.impl.VariableNameValidator;
import org.activiti.runtime.api.model.impl.APIVariableInstanceConverter;
import org.activiti.spring.process.ProcessExtensionService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
public class CommonRuntimeAutoConfiguration {
    @Bean
    public APIVariableInstanceConverter apiVariableInstanceConverter() {
        return new APIVariableInstanceConverter();
    }

    @Bean
    public VariableEventFilter variableEventFilter() {
        return new VariableEventFilter();
    }

    @Bean
    @ConditionalOnMissingBean
    public EphemeralVariableResolver ephemeralVariableResolver(ProcessExtensionService processExtensionService) {
        return new EphemeralVariableResolver(processExtensionService);
    }

    @Bean
    public InitializingBean registerVariableCreatedListenerDelegate(RuntimeService runtimeService, @Autowired(required=false) List<VariableEventListener<VariableCreatedEvent>> listeners, VariableEventFilter variableEventFilter, EphemeralVariableResolver ephemeralVariableResolver) {
        return () -> runtimeService.addEventListener((ActivitiEventListener)new VariableCreatedListenerDelegate(this.getInitializedListeners(listeners), new ToVariableCreatedConverter(ephemeralVariableResolver), variableEventFilter), new ActivitiEventType[]{ActivitiEventType.VARIABLE_CREATED});
    }

    private <T> List<T> getInitializedListeners(List<T> eventListeners) {
        return eventListeners != null ? eventListeners : Collections.emptyList();
    }

    @Bean
    public InitializingBean registerVariableUpdatedListenerDelegate(RuntimeService runtimeService, @Autowired(required=false) List<VariableEventListener<VariableUpdatedEvent>> listeners, VariableEventFilter variableEventFilter, EphemeralVariableResolver ephemeralVariableResolver) {
        return () -> runtimeService.addEventListener((ActivitiEventListener)new VariableUpdatedListenerDelegate(this.getInitializedListeners(listeners), new ToVariableUpdatedConverter(ephemeralVariableResolver), variableEventFilter), new ActivitiEventType[]{ActivitiEventType.VARIABLE_UPDATED});
    }

    @Bean
    public VariableNameValidator variableNameValidator() {
        return new VariableNameValidator();
    }
}

