/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.runtime.api.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.activiti.api.process.model.payloads.ReceiveMessagePayload;
import org.activiti.api.process.model.payloads.SetProcessVariablesPayload;
import org.activiti.api.process.model.payloads.SignalPayload;
import org.activiti.api.process.model.payloads.StartMessagePayload;
import org.activiti.api.process.model.payloads.StartProcessPayload;
import org.activiti.common.util.DateFormatterProvider;
import org.activiti.engine.ActivitiException;
import org.activiti.runtime.api.impl.ExpressionResolver;
import org.activiti.runtime.api.impl.VariableNameValidator;
import org.activiti.spring.process.ProcessExtensionService;
import org.activiti.spring.process.model.Extension;
import org.activiti.spring.process.model.VariableDefinition;
import org.activiti.spring.process.variable.VariableValidationService;

public class ProcessVariablesPayloadValidator {
    private final VariableValidationService variableValidationService;
    private final DateFormatterProvider dateFormatterProvider;
    private final ProcessExtensionService processExtensionService;
    private final VariableNameValidator variableNameValidator;
    private final ExpressionResolver expressionResolver;

    public ProcessVariablesPayloadValidator(DateFormatterProvider dateFormatterProvider, ProcessExtensionService processExtensionService, VariableValidationService variableValidationService, VariableNameValidator variableNameValidator, ExpressionResolver expressionResolver) {
        this.dateFormatterProvider = dateFormatterProvider;
        this.processExtensionService = processExtensionService;
        this.variableValidationService = variableValidationService;
        this.variableNameValidator = variableNameValidator;
        this.expressionResolver = expressionResolver;
    }

    private Optional<Map<String, VariableDefinition>> getVariableDefinitionMap(String processDefinitionId) {
        Extension processExtensionModel = processDefinitionId != null ? this.processExtensionService.getExtensionsForId(processDefinitionId) : null;
        return Optional.ofNullable(processExtensionModel).map(Extension::getProperties);
    }

    private boolean validateVariablesAgainstDefinitions(Optional<Map<String, VariableDefinition>> variableDefinitionMap, Map.Entry<String, Object> payloadVar, Set<String> mismatchedVars) {
        if (variableDefinitionMap.isPresent()) {
            String name = payloadVar.getKey();
            Object value = payloadVar.getValue();
            for (Map.Entry<String, VariableDefinition> variableDefinitionEntry : variableDefinitionMap.get().entrySet()) {
                if (!variableDefinitionEntry.getValue().getName().equals(name)) continue;
                String type = variableDefinitionEntry.getValue().getType();
                if (type.contains("date") && value != null) {
                    try {
                        payloadVar.setValue(this.dateFormatterProvider.toDate(value));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!this.variableValidationService.validateWithErrors(payloadVar.getValue(), variableDefinitionEntry.getValue()).isEmpty()) {
                    mismatchedVars.add(name);
                }
                return true;
            }
        }
        return false;
    }

    private void checkPayloadVariables(Map<String, Object> variablePayloadMap, String processDefinitionId) {
        if (variablePayloadMap == null) {
            return;
        }
        String errorVariableName = "Variable has not a valid name: {0}";
        String errorVariableType = "Variables fail type validation: {0}";
        String errorVariableExpressionValue = "Expressions in variable values are only allowed as default value when modeling the process: {0}";
        Optional<Map<String, VariableDefinition>> variableDefinitionMap = this.getVariableDefinitionMap(processDefinitionId);
        ArrayList<ActivitiException> activitiExceptions = new ArrayList<ActivitiException>();
        HashSet<String> mismatchedVars = new HashSet<String>();
        for (Map.Entry<String, Object> payloadVar : variablePayloadMap.entrySet()) {
            Object value;
            String name = payloadVar.getKey();
            if (!this.variableNameValidator.validate(name)) {
                activitiExceptions.add(new ActivitiException(MessageFormat.format("Variable has not a valid name: {0}", name != null ? name : "null")));
                continue;
            }
            if (this.expressionResolver.containsExpression(payloadVar.getValue())) {
                activitiExceptions.add(new ActivitiException(MessageFormat.format("Expressions in variable values are only allowed as default value when modeling the process: {0}", name != null ? name : "null")));
                continue;
            }
            boolean found = this.validateVariablesAgainstDefinitions(variableDefinitionMap, payloadVar, mismatchedVars);
            if (found || (value = payloadVar.getValue()) == null || !(value instanceof String)) continue;
            try {
                payloadVar.setValue(this.dateFormatterProvider.toDate(value));
            }
            catch (Exception exception) {}
        }
        if (!mismatchedVars.isEmpty()) {
            activitiExceptions.add(new ActivitiException(MessageFormat.format("Variables fail type validation: {0}", String.join((CharSequence)", ", mismatchedVars))));
        }
        if (!activitiExceptions.isEmpty()) {
            throw new IllegalStateException(activitiExceptions.stream().map(ex -> ex.getMessage()).collect(Collectors.joining(",")));
        }
    }

    public void checkPayloadVariables(SetProcessVariablesPayload setProcessVariablesPayload, String processDefinitionId) {
        this.checkPayloadVariables(setProcessVariablesPayload.getVariables(), processDefinitionId);
    }

    public void checkStartProcessPayloadVariables(StartProcessPayload startProcessPayload, String processDefinitionId) {
        this.checkPayloadVariables(startProcessPayload.getVariables(), processDefinitionId);
    }

    public void checkStartMessagePayloadVariables(StartMessagePayload startMessagePayload, String processDefinitionId) {
        this.checkPayloadVariables(startMessagePayload.getVariables(), processDefinitionId);
    }

    public void checkReceiveMessagePayloadVariables(ReceiveMessagePayload receiveMessagePayload, String processDefinitionId) {
        this.checkPayloadVariables(receiveMessagePayload.getVariables(), processDefinitionId);
    }

    public void checkSignalPayloadVariables(SignalPayload signalPayload, String processDefinitionId) {
        this.checkPayloadVariables(signalPayload.getVariables(), processDefinitionId);
    }
}

