/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.runtime.api.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.activiti.api.model.shared.model.VariableInstance;
import org.activiti.api.process.model.ProcessDefinitionMeta;
import org.activiti.api.process.model.ProcessInstance;
import org.activiti.api.process.model.ProcessInstanceMeta;
import org.activiti.api.process.model.builders.ProcessPayloadBuilder;
import org.activiti.api.process.model.payloads.CreateProcessInstancePayload;
import org.activiti.api.process.model.payloads.DeleteProcessPayload;
import org.activiti.api.process.model.payloads.GetProcessDefinitionsPayload;
import org.activiti.api.process.model.payloads.GetProcessInstancesPayload;
import org.activiti.api.process.model.payloads.GetVariablesPayload;
import org.activiti.api.process.model.payloads.ReceiveMessagePayload;
import org.activiti.api.process.model.payloads.RemoveProcessVariablesPayload;
import org.activiti.api.process.model.payloads.ResumeProcessPayload;
import org.activiti.api.process.model.payloads.SetProcessVariablesPayload;
import org.activiti.api.process.model.payloads.SignalPayload;
import org.activiti.api.process.model.payloads.StartMessagePayload;
import org.activiti.api.process.model.payloads.StartProcessPayload;
import org.activiti.api.process.model.payloads.SuspendProcessPayload;
import org.activiti.api.process.model.payloads.UpdateProcessPayload;
import org.activiti.api.process.runtime.ProcessRuntime;
import org.activiti.api.process.runtime.conf.ProcessRuntimeConfiguration;
import org.activiti.api.runtime.model.impl.ProcessDefinitionMetaImpl;
import org.activiti.api.runtime.model.impl.ProcessInstanceImpl;
import org.activiti.api.runtime.model.impl.ProcessInstanceMetaImpl;
import org.activiti.api.runtime.shared.NotFoundException;
import org.activiti.api.runtime.shared.UnprocessableEntityException;
import org.activiti.api.runtime.shared.query.Page;
import org.activiti.api.runtime.shared.query.Pageable;
import org.activiti.api.runtime.shared.security.SecurityManager;
import org.activiti.core.common.spring.security.policies.ActivitiForbiddenException;
import org.activiti.core.common.spring.security.policies.ProcessSecurityPoliciesManager;
import org.activiti.core.common.spring.security.policies.SecurityPolicyAccess;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.repository.ProcessDefinitionQuery;
import org.activiti.engine.runtime.ProcessInstanceBuilder;
import org.activiti.engine.runtime.ProcessInstanceQuery;
import org.activiti.engine.task.TaskQuery;
import org.activiti.runtime.api.impl.ProcessVariablesPayloadValidator;
import org.activiti.runtime.api.model.impl.APIDeploymentConverter;
import org.activiti.runtime.api.model.impl.APIProcessDefinitionConverter;
import org.activiti.runtime.api.model.impl.APIProcessInstanceConverter;
import org.activiti.runtime.api.model.impl.APIVariableInstanceConverter;
import org.activiti.runtime.api.query.impl.PageImpl;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

@PreAuthorize(value="hasRole('ACTIVITI_USER')")
public class ProcessRuntimeImpl
implements ProcessRuntime {
    private static final String EVERYONE_GROUP = "*";
    private final RepositoryService repositoryService;
    private final APIProcessDefinitionConverter processDefinitionConverter;
    private final RuntimeService runtimeService;
    private final TaskService taskService;
    private final APIProcessInstanceConverter processInstanceConverter;
    private final APIVariableInstanceConverter variableInstanceConverter;
    private final APIDeploymentConverter deploymentConverter;
    private final ProcessRuntimeConfiguration configuration;
    private final ProcessSecurityPoliciesManager securityPoliciesManager;
    private final ApplicationEventPublisher eventPublisher;
    private final ProcessVariablesPayloadValidator processVariablesValidator;
    private final SecurityManager securityManager;

    public ProcessRuntimeImpl(RepositoryService repositoryService, APIProcessDefinitionConverter processDefinitionConverter, RuntimeService runtimeService, TaskService taskService, ProcessSecurityPoliciesManager securityPoliciesManager, APIProcessInstanceConverter processInstanceConverter, APIVariableInstanceConverter variableInstanceConverter, APIDeploymentConverter deploymentConverter, ProcessRuntimeConfiguration configuration, ApplicationEventPublisher eventPublisher, ProcessVariablesPayloadValidator processVariablesValidator, SecurityManager securityManager) {
        this.repositoryService = repositoryService;
        this.processDefinitionConverter = processDefinitionConverter;
        this.runtimeService = runtimeService;
        this.taskService = taskService;
        this.securityPoliciesManager = securityPoliciesManager;
        this.processInstanceConverter = processInstanceConverter;
        this.variableInstanceConverter = variableInstanceConverter;
        this.deploymentConverter = deploymentConverter;
        this.configuration = configuration;
        this.eventPublisher = eventPublisher;
        this.processVariablesValidator = processVariablesValidator;
        this.securityManager = securityManager;
    }

    public org.activiti.api.process.model.ProcessDefinition processDefinition(String processDefinitionId) {
        ProcessDefinitionQuery processDefinitionQuery = this.createProcessDefinitionQueryWithAccessCheck().processDefinitionIdOrKey(processDefinitionId);
        ProcessDefinition processDefinition = this.findLatestProcessDefinition(processDefinitionQuery).orElseThrow(() -> new ActivitiObjectNotFoundException("Unable to find process definition for the given id or key:'" + processDefinitionId + "'"));
        this.checkProcessDefinitionBelongsToLatestDeployment(processDefinition);
        if (!this.securityPoliciesManager.canRead(processDefinition.getKey())) {
            throw new ActivitiObjectNotFoundException("Unable to find process definition for the given id or key:'" + processDefinitionId + "'");
        }
        return this.processDefinitionConverter.from(processDefinition);
    }

    private ProcessDefinitionQuery createProcessDefinitionQueryWithAccessCheck() {
        return this.repositoryService.createProcessDefinitionQuery().startableByUser(this.securityManager.getAuthenticatedUserId()).startableByGroups(this.getCurrentUserGroupsIncludingEveryOneGroup());
    }

    private Optional<ProcessDefinition> findLatestProcessDefinition(ProcessDefinitionQuery processDefinitionQuery) {
        return ((ProcessDefinitionQuery)processDefinitionQuery.latestVersion().deploymentIds(this.latestDeploymentIds()).orderByProcessDefinitionAppVersion().desc()).list().stream().findFirst();
    }

    private Set<String> latestDeploymentIds() {
        return this.repositoryService.createDeploymentQuery().latestVersion().list().stream().map(Deployment::getId).collect(Collectors.toSet());
    }

    private void checkProcessDefinitionBelongsToLatestDeployment(ProcessDefinition processDefinition) {
        Integer appVersion = processDefinition.getAppVersion();
        if (appVersion != null && !this.selectLatestDeployment().getVersion().equals(appVersion)) {
            throw new UnprocessableEntityException("Process definition with the given id:'" + processDefinition.getId() + "' belongs to a different application version.");
        }
    }

    public Page<org.activiti.api.process.model.ProcessDefinition> processDefinitions(Pageable pageable) {
        return this.processDefinitions(pageable, ProcessPayloadBuilder.processDefinitions().build(), List.of());
    }

    public Page<org.activiti.api.process.model.ProcessDefinition> processDefinitions(Pageable pageable, List<String> include) {
        return this.processDefinitions(pageable, ProcessPayloadBuilder.processDefinitions().build(), include);
    }

    public Page<org.activiti.api.process.model.ProcessDefinition> processDefinitions(Pageable pageable, GetProcessDefinitionsPayload getProcessDefinitionsPayload) {
        return this.processDefinitions(pageable, getProcessDefinitionsPayload, List.of());
    }

    public Page<org.activiti.api.process.model.ProcessDefinition> processDefinitions(Pageable pageable, GetProcessDefinitionsPayload getProcessDefinitionsPayload, List<String> include) {
        if (getProcessDefinitionsPayload == null) {
            throw new IllegalStateException("payload cannot be null");
        }
        GetProcessDefinitionsPayload securityKeysInPayload = this.securityPoliciesManager.restrictProcessDefQuery(SecurityPolicyAccess.READ);
        if (!securityKeysInPayload.getProcessDefinitionKeys().isEmpty()) {
            getProcessDefinitionsPayload.setProcessDefinitionKeys(securityKeysInPayload.getProcessDefinitionKeys());
        }
        ProcessDefinitionQuery processDefinitionQuery = this.createProcessDefinitionQueryWithAccessCheck().latestVersion().deploymentIds(this.latestDeploymentIds());
        if (getProcessDefinitionsPayload.hasDefinitionKeys()) {
            processDefinitionQuery.processDefinitionKeys(getProcessDefinitionsPayload.getProcessDefinitionKeys());
        }
        return new PageImpl(this.processDefinitionConverter.from(processDefinitionQuery.list()), Math.toIntExact(processDefinitionQuery.count()));
    }

    public ProcessInstance processInstance(String processInstanceId) {
        org.activiti.engine.runtime.ProcessInstance internalProcessInstance = this.internalProcessInstance(processInstanceId);
        if (!this.canReadProcessInstance(internalProcessInstance)) {
            throw new ActivitiObjectNotFoundException("You cannot read the process instance with Id:'" + processInstanceId + "' due to security policies violation");
        }
        return this.processInstanceConverter.from(internalProcessInstance);
    }

    public Page<ProcessInstance> processInstances(Pageable pageable) {
        return this.processInstances(pageable, ProcessPayloadBuilder.processInstances().build());
    }

    public Page<ProcessInstance> processInstances(Pageable pageable, GetProcessInstancesPayload getProcessInstancesPayload) {
        if (getProcessInstancesPayload == null) {
            throw new IllegalStateException("payload cannot be null");
        }
        GetProcessInstancesPayload securityKeysInPayload = this.securityPoliciesManager.restrictProcessInstQuery(SecurityPolicyAccess.READ);
        ProcessInstanceQuery internalQuery = this.runtimeService.createProcessInstanceQuery();
        String currentUserId = this.securityManager.getAuthenticatedUserId();
        internalQuery.involvedUser(currentUserId);
        if (!securityKeysInPayload.getProcessDefinitionKeys().isEmpty()) {
            getProcessInstancesPayload.setProcessDefinitionKeys(securityKeysInPayload.getProcessDefinitionKeys());
        }
        if (getProcessInstancesPayload.getProcessDefinitionKeys() != null && !getProcessInstancesPayload.getProcessDefinitionKeys().isEmpty()) {
            internalQuery.processDefinitionKeys(getProcessInstancesPayload.getProcessDefinitionKeys());
        }
        if (getProcessInstancesPayload.getBusinessKey() != null && !getProcessInstancesPayload.getBusinessKey().isEmpty()) {
            internalQuery.processInstanceBusinessKey(getProcessInstancesPayload.getBusinessKey());
        }
        if (getProcessInstancesPayload.isSuspendedOnly()) {
            internalQuery.suspended();
        }
        if (getProcessInstancesPayload.isActiveOnly()) {
            internalQuery.active();
        }
        if (getProcessInstancesPayload.getParentProcessInstanceId() != null) {
            internalQuery.superProcessInstanceId(getProcessInstancesPayload.getParentProcessInstanceId());
        }
        return new PageImpl(this.processInstanceConverter.from(internalQuery.listPage(pageable.getStartIndex(), pageable.getMaxItems())), Math.toIntExact(internalQuery.count()));
    }

    public ProcessRuntimeConfiguration configuration() {
        return this.configuration;
    }

    public ProcessInstance start(StartProcessPayload startProcessPayload) {
        return this.processInstanceConverter.from(this.createProcessInstanceBuilder(startProcessPayload).start());
    }

    public ProcessInstance startCreatedProcess(String processInstanceId, StartProcessPayload startProcessPayload) {
        org.activiti.engine.runtime.ProcessInstance internalProcessInstance = this.internalProcessInstance(processInstanceId);
        if (internalProcessInstance == null) {
            throw new NotFoundException("Unable to find process instance for the given id:'" + processInstanceId + "'");
        }
        if (!this.canWriteProcessInstance(internalProcessInstance)) {
            throw new ActivitiObjectNotFoundException("You cannot start the process instance with Id:'" + processInstanceId + "' due to security policies violation");
        }
        this.processVariablesValidator.checkStartProcessPayloadVariables(startProcessPayload, internalProcessInstance.getProcessDefinitionId());
        return this.processInstanceConverter.from(this.runtimeService.startCreatedProcessInstance(internalProcessInstance, startProcessPayload.getVariables()));
    }

    public ProcessInstance create(CreateProcessInstancePayload createProcessInstancePayload) {
        return this.processInstanceConverter.from(this.createProcessInstanceBuilder(createProcessInstancePayload).create());
    }

    private ProcessInstanceBuilder createProcessInstanceBuilder(StartProcessPayload startProcessPayload) {
        org.activiti.api.process.model.ProcessDefinition processDefinition = this.getProcessDefinitionAndCheckUserHasRights(startProcessPayload.getProcessDefinitionId(), startProcessPayload.getProcessDefinitionKey());
        this.processVariablesValidator.checkStartProcessPayloadVariables(startProcessPayload, processDefinition.getId());
        return this.runtimeService.createProcessInstanceBuilder().processDefinitionId(processDefinition.getId()).processDefinitionKey(processDefinition.getKey()).businessKey(startProcessPayload.getBusinessKey()).variables(startProcessPayload.getVariables()).name(startProcessPayload.getName());
    }

    private ProcessInstanceBuilder createProcessInstanceBuilder(CreateProcessInstancePayload createProcessPayload) {
        org.activiti.api.process.model.ProcessDefinition processDefinition = this.getProcessDefinitionAndCheckUserHasRights(createProcessPayload.getProcessDefinitionId(), createProcessPayload.getProcessDefinitionKey());
        return this.runtimeService.createProcessInstanceBuilder().processDefinitionId(processDefinition.getId()).processDefinitionKey(processDefinition.getKey()).businessKey(createProcessPayload.getBusinessKey()).name(createProcessPayload.getName());
    }

    public ProcessInstance suspend(SuspendProcessPayload suspendProcessPayload) {
        org.activiti.engine.runtime.ProcessInstance internalProcessInstance = this.internalProcessInstance(suspendProcessPayload.getProcessInstanceId());
        this.checkUserCanWritePermissionOnProcessInstance(internalProcessInstance);
        this.runtimeService.suspendProcessInstanceById(suspendProcessPayload.getProcessInstanceId());
        return this.processInstanceConverter.from((org.activiti.engine.runtime.ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(suspendProcessPayload.getProcessInstanceId()).singleResult());
    }

    public ProcessInstance resume(ResumeProcessPayload resumeProcessPayload) {
        org.activiti.engine.runtime.ProcessInstance internalProcessInstance = this.internalProcessInstance(resumeProcessPayload.getProcessInstanceId());
        this.checkUserCanWritePermissionOnProcessInstance(internalProcessInstance);
        this.runtimeService.activateProcessInstanceById(resumeProcessPayload.getProcessInstanceId());
        return this.processInstanceConverter.from((org.activiti.engine.runtime.ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(resumeProcessPayload.getProcessInstanceId()).singleResult());
    }

    public ProcessInstance delete(DeleteProcessPayload deleteProcessPayload) {
        org.activiti.engine.runtime.ProcessInstance internalProcessInstance = this.internalProcessInstance(deleteProcessPayload.getProcessInstanceId());
        this.checkUserCanWritePermissionOnProcessInstance(internalProcessInstance);
        this.runtimeService.deleteProcessInstance(deleteProcessPayload.getProcessInstanceId(), deleteProcessPayload.getReason());
        ProcessInstanceImpl processInstance = (ProcessInstanceImpl)this.processInstanceConverter.from(internalProcessInstance);
        processInstance.setStatus(ProcessInstance.ProcessInstanceStatus.CANCELLED);
        return processInstance;
    }

    public List<VariableInstance> variables(GetVariablesPayload getVariablesPayload) {
        this.processInstance(getVariablesPayload.getProcessInstanceId());
        Map variables = this.runtimeService.getVariableInstances(getVariablesPayload.getProcessInstanceId());
        return this.variableInstanceConverter.from(variables.values());
    }

    public void removeVariables(RemoveProcessVariablesPayload removeProcessVariablesPayload) {
        org.activiti.engine.runtime.ProcessInstance internalProcessInstance = this.internalProcessInstance(removeProcessVariablesPayload.getProcessInstanceId());
        this.checkUserCanWritePermissionOnProcessInstance(internalProcessInstance);
        this.runtimeService.removeVariables(removeProcessVariablesPayload.getProcessInstanceId(), (Collection)removeProcessVariablesPayload.getVariableNames());
    }

    public void setVariables(SetProcessVariablesPayload setProcessVariablesPayload) {
        org.activiti.engine.runtime.ProcessInstance internalProcessInstance = this.internalProcessInstance(setProcessVariablesPayload.getProcessInstanceId());
        this.checkUserCanWritePermissionOnProcessInstance(internalProcessInstance);
        this.processVariablesValidator.checkPayloadVariables(setProcessVariablesPayload, internalProcessInstance.getProcessDefinitionId());
        this.runtimeService.setVariables(setProcessVariablesPayload.getProcessInstanceId(), setProcessVariablesPayload.getVariables());
    }

    @Transactional
    public void signal(SignalPayload signalPayload) {
        this.processVariablesValidator.checkSignalPayloadVariables(signalPayload, null);
        this.eventPublisher.publishEvent((Object)signalPayload);
    }

    public ProcessDefinitionMeta processDefinitionMeta(String processDefinitionKey) {
        this.processDefinition(processDefinitionKey);
        return new ProcessDefinitionMetaImpl(processDefinitionKey);
    }

    public ProcessInstanceMeta processInstanceMeta(String processInstanceId) {
        this.processInstance(processInstanceId);
        ProcessInstanceMetaImpl processInstanceMeta = new ProcessInstanceMetaImpl(processInstanceId);
        processInstanceMeta.setActiveActivitiesIds(this.runtimeService.getActiveActivityIds(processInstanceId));
        return processInstanceMeta;
    }

    public ProcessInstance update(UpdateProcessPayload updateProcessPayload) {
        org.activiti.engine.runtime.ProcessInstance internalProcessInstance = this.internalProcessInstance(updateProcessPayload.getProcessInstanceId());
        this.checkUserCanWritePermissionOnProcessInstance(internalProcessInstance);
        if (updateProcessPayload.getBusinessKey() != null) {
            this.runtimeService.updateBusinessKey(updateProcessPayload.getProcessInstanceId(), updateProcessPayload.getBusinessKey());
        }
        if (updateProcessPayload.getName() != null) {
            this.runtimeService.setProcessInstanceName(updateProcessPayload.getProcessInstanceId(), updateProcessPayload.getName());
        }
        ProcessInstance updatedProcessInstance = this.processInstanceConverter.from((org.activiti.engine.runtime.ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(updateProcessPayload.getProcessInstanceId()).singleResult());
        return updatedProcessInstance;
    }

    @Transactional
    public void receive(ReceiveMessagePayload messagePayload) {
        this.processVariablesValidator.checkReceiveMessagePayloadVariables(messagePayload, null);
        this.eventPublisher.publishEvent((Object)messagePayload);
    }

    public ProcessInstance start(StartMessagePayload messagePayload) {
        String messageName = messagePayload.getName();
        String businessKey = messagePayload.getBusinessKey();
        Map variables = messagePayload.getVariables();
        this.processVariablesValidator.checkStartMessagePayloadVariables(messagePayload, null);
        ProcessInstance processInstance = this.processInstanceConverter.from(this.runtimeService.startProcessInstanceByMessage(messageName, businessKey, variables));
        return processInstance;
    }

    private void checkUserCanWritePermissionOnProcessDefinition(String processDefinitionKey) {
        if (!this.securityPoliciesManager.canWrite(processDefinitionKey)) {
            throw new ActivitiForbiddenException("Operation not permitted for " + processDefinitionKey + " due security policy violation");
        }
    }

    private void checkUserCanWritePermissionOnProcessInstance(org.activiti.engine.runtime.ProcessInstance processInstance) {
        if (!this.canWriteProcessInstance(processInstance)) {
            throw new ActivitiForbiddenException("Operation not permitted for on process instance " + processInstance.getProcessInstanceId() + " due security policy violation");
        }
    }

    protected org.activiti.api.process.model.ProcessDefinition getProcessDefinitionAndCheckUserHasRights(String processDefinitionId, String processDefinitionKey) {
        String checkId = processDefinitionKey != null ? processDefinitionKey : processDefinitionId;
        org.activiti.api.process.model.ProcessDefinition processDefinition = this.processDefinition(checkId);
        if (processDefinition == null) {
            throw new IllegalStateException("At least Process Definition Id or Key needs to be provided to start a process");
        }
        this.checkUserCanWritePermissionOnProcessDefinition(processDefinition.getKey());
        return processDefinition;
    }

    public org.activiti.api.process.model.Deployment selectLatestDeployment() {
        return this.deploymentConverter.from((Deployment)this.repositoryService.createDeploymentQuery().deploymentName("SpringAutoDeployment").latestVersion().singleResult());
    }

    public org.activiti.engine.runtime.ProcessInstance internalProcessInstance(String processInstanceId) {
        org.activiti.engine.runtime.ProcessInstance internalProcessInstance = (org.activiti.engine.runtime.ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (internalProcessInstance == null) {
            throw new NotFoundException("Unable to find process instance for the given id:'" + processInstanceId + "'");
        }
        return internalProcessInstance;
    }

    private boolean canReadProcessInstance(org.activiti.engine.runtime.ProcessInstance processInstance) {
        return this.securityPoliciesManager.canRead(processInstance.getProcessDefinitionKey()) && (this.securityManager.getAuthenticatedUserId().equals(processInstance.getStartUserId()) || this.isATaskAssigneeOrACandidate(processInstance.getProcessInstanceId()));
    }

    private boolean canWriteProcessInstance(org.activiti.engine.runtime.ProcessInstance processInstance) {
        return this.securityPoliciesManager.canWrite(processInstance.getProcessDefinitionKey()) && this.securityManager.getAuthenticatedUserId().equals(processInstance.getStartUserId());
    }

    private boolean isATaskAssigneeOrACandidate(String processInstanceId) {
        String authenticatedUserId = this.securityManager.getAuthenticatedUserId();
        TaskQuery taskQuery = (TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId);
        ((TaskQuery)((TaskQuery)taskQuery.or()).taskCandidateOrAssigned(this.securityManager.getAuthenticatedUserId(), this.securityManager.getAuthenticatedUserGroups()).taskOwner(authenticatedUserId)).endOr();
        return taskQuery.count() > 0L;
    }

    private List<String> getCurrentUserGroupsIncludingEveryOneGroup() {
        ArrayList<String> groups = new ArrayList<String>(this.securityManager.getAuthenticatedUserGroups());
        groups.add(EVERYONE_GROUP);
        return groups;
    }
}

