/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.api.process.model.payloads;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.activiti.api.model.shared.Payload;

public class GetProcessDefinitionsPayload
implements Payload {
    private String id = UUID.randomUUID().toString();
    private Set<String> processDefinitionIds;
    private Set<String> processDefinitionKeys;
    private boolean latestVersionOnly;

    public GetProcessDefinitionsPayload() {
    }

    public GetProcessDefinitionsPayload(Set<String> processDefinitionIds, Set<String> processDefinitionKeys) {
        this();
        this.processDefinitionIds = processDefinitionIds;
        this.processDefinitionKeys = processDefinitionKeys;
    }

    public GetProcessDefinitionsPayload(Set<String> processDefinitionIds, Set<String> processDefinitionKeys, boolean latestVersionOnly) {
        this();
        this.processDefinitionIds = processDefinitionIds;
        this.processDefinitionKeys = processDefinitionKeys;
        this.latestVersionOnly = latestVersionOnly;
    }

    public GetProcessDefinitionsPayload(String processDefinitionId, Set<String> processDefinitionKeys) {
        this(new HashSet<String>(Set.of(processDefinitionId)), processDefinitionKeys);
    }

    public GetProcessDefinitionsPayload(String processDefinitionId, Set<String> processDefinitionKeys, boolean latestVersionOnly) {
        this(new HashSet<String>(Set.of(processDefinitionId)), processDefinitionKeys, latestVersionOnly);
    }

    public String getId() {
        return this.id;
    }

    @Deprecated(since="Use getProcessDefinitionIds() instead")
    public String getProcessDefinitionId() {
        if (this.processDefinitionIds == null) {
            return null;
        }
        return this.processDefinitionIds.stream().findFirst().orElse(null);
    }

    public Set<String> getProcessDefinitionIds() {
        return this.processDefinitionIds;
    }

    public void setProcessDefinitionIds(Set<String> processDefinitionIds) {
        this.processDefinitionIds = processDefinitionIds;
    }

    public Set<String> getProcessDefinitionKeys() {
        return this.processDefinitionKeys;
    }

    public boolean hasDefinitionKeys() {
        return this.processDefinitionKeys != null && !this.processDefinitionKeys.isEmpty();
    }

    public boolean hasDefinitionIds() {
        return this.processDefinitionIds != null && !this.processDefinitionIds.isEmpty();
    }

    public void setProcessDefinitionKeys(Set<String> processDefinitionKeys) {
        this.processDefinitionKeys = processDefinitionKeys;
    }

    public boolean isLatestVersionOnly() {
        return this.latestVersionOnly;
    }

    public void setLatestVersionOnly(boolean latestVersionOnly) {
        this.latestVersionOnly = latestVersionOnly;
    }
}

