/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.api.process.model.builders;

import java.util.HashSet;
import java.util.Set;
import org.activiti.api.process.model.payloads.GetProcessDefinitionsPayload;

public class GetProcessDefinitionsPayloadBuilder {
    private Set<String> processDefinitionIds;
    private Set<String> processDefinitionKeys = new HashSet<String>();
    private boolean latestVersionOnly;

    public GetProcessDefinitionsPayloadBuilder withProcessDefinitionKeys(Set<String> processDefinitionKeys) {
        this.processDefinitionKeys = processDefinitionKeys;
        return this;
    }

    public GetProcessDefinitionsPayloadBuilder withProcessDefinitionIds(Set<String> processDefinitionIds) {
        this.processDefinitionIds = processDefinitionIds;
        return this;
    }

    public GetProcessDefinitionsPayloadBuilder withProcessDefinitionId(String processDefinitionId) {
        if (this.processDefinitionIds == null) {
            this.processDefinitionIds = new HashSet<String>();
        }
        this.processDefinitionIds.add(processDefinitionId);
        return this;
    }

    public GetProcessDefinitionsPayloadBuilder withProcessDefinitionKey(String processDefinitionKey) {
        if (this.processDefinitionKeys == null) {
            this.processDefinitionKeys = new HashSet<String>();
        }
        this.processDefinitionKeys.add(processDefinitionKey);
        return this;
    }

    public GetProcessDefinitionsPayloadBuilder withLatestVersionOnly(boolean latestVersionOnly) {
        this.latestVersionOnly = latestVersionOnly;
        return this;
    }

    public GetProcessDefinitionsPayload build() {
        return new GetProcessDefinitionsPayload(this.processDefinitionIds, this.processDefinitionKeys, this.latestVersionOnly);
    }
}

