/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.api.runtime.conf.impl;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.module.SimpleAbstractTypeResolver;
import com.fasterxml.jackson.databind.module.SimpleModule;
import org.activiti.api.model.shared.EmptyResult;
import org.activiti.api.model.shared.Payload;
import org.activiti.api.model.shared.Result;
import org.activiti.api.model.shared.model.VariableInstance;
import org.activiti.api.runtime.conf.impl.PayloadMixIn;
import org.activiti.api.runtime.conf.impl.ResultMixIn;
import org.activiti.api.runtime.model.impl.VariableInstanceImpl;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.PropertySource;

@AutoConfiguration
@PropertySource(value={"classpath:conf/rest-jackson-configuration.properties"})
public class CommonModelAutoConfiguration {
    @Bean
    public Module customizeCommonModelObjectMapper() {
        SimpleModule module = new SimpleModule("mapCommonModelInterfaces", Version.unknownVersion());
        SimpleAbstractTypeResolver resolver = new SimpleAbstractTypeResolver(){

            public JavaType resolveAbstractType(DeserializationConfig config, BeanDescription typeDesc) {
                return this.findTypeMapping(config, typeDesc.getType());
            }
        };
        resolver.addMapping(VariableInstance.class, VariableInstanceImpl.class);
        module.setAbstractTypes(resolver);
        module.setMixInAnnotation(Payload.class, PayloadMixIn.class);
        module.setMixInAnnotation(Result.class, ResultMixIn.class);
        module.registerSubtypes(new NamedType[]{new NamedType(EmptyResult.class, EmptyResult.class.getSimpleName())});
        return module;
    }
}

