/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.core;

import java.nio.ByteBuffer;
import org.opencv.core.CvType;
import org.opencv.core.Point;
import org.opencv.core.Range;
import org.opencv.core.Rect;
import org.opencv.core.Scalar;
import org.opencv.core.Size;

public class Mat {
    public final long nativeObj;

    public Mat(long l) {
        if (l == 0L) {
            throw new UnsupportedOperationException("Native object address is NULL");
        }
        this.nativeObj = l;
    }

    public Mat() {
        this.nativeObj = Mat.n_Mat();
    }

    public Mat(int n, int n2, int n3) {
        this.nativeObj = Mat.n_Mat(n, n2, n3);
    }

    public Mat(int n, int n2, int n3, ByteBuffer byteBuffer) {
        this.nativeObj = Mat.n_Mat(n, n2, n3, byteBuffer);
    }

    public Mat(int n, int n2, int n3, ByteBuffer byteBuffer, long l) {
        this.nativeObj = Mat.n_Mat(n, n2, n3, byteBuffer, l);
    }

    public Mat(Size size, int n) {
        this.nativeObj = Mat.n_Mat(size.width, size.height, n);
    }

    public Mat(int[] nArray, int n) {
        this.nativeObj = Mat.n_Mat(nArray.length, nArray, n);
    }

    public Mat(int n, int n2, int n3, Scalar scalar) {
        this.nativeObj = Mat.n_Mat(n, n2, n3, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3]);
    }

    public Mat(Size size, int n, Scalar scalar) {
        this.nativeObj = Mat.n_Mat(size.width, size.height, n, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3]);
    }

    public Mat(int[] nArray, int n, Scalar scalar) {
        this.nativeObj = Mat.n_Mat(nArray.length, nArray, n, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3]);
    }

    public Mat(Mat mat, Range range, Range range2) {
        this.nativeObj = Mat.n_Mat(mat.nativeObj, range.start, range.end, range2.start, range2.end);
    }

    public Mat(Mat mat, Range range) {
        this.nativeObj = Mat.n_Mat(mat.nativeObj, range.start, range.end);
    }

    public Mat(Mat mat, Range[] rangeArray) {
        this.nativeObj = Mat.n_Mat(mat.nativeObj, rangeArray);
    }

    public Mat(Mat mat, Rect rect) {
        this.nativeObj = Mat.n_Mat(mat.nativeObj, rect.y, rect.y + rect.height, rect.x, rect.x + rect.width);
    }

    public Mat adjustROI(int n, int n2, int n3, int n4) {
        return new Mat(Mat.n_adjustROI(this.nativeObj, n, n2, n3, n4));
    }

    public void assignTo(Mat mat, int n) {
        Mat.n_assignTo(this.nativeObj, mat.nativeObj, n);
    }

    public void assignTo(Mat mat) {
        Mat.n_assignTo(this.nativeObj, mat.nativeObj);
    }

    public int channels() {
        return Mat.n_channels(this.nativeObj);
    }

    public int checkVector(int n, int n2, boolean bl) {
        return Mat.n_checkVector(this.nativeObj, n, n2, bl);
    }

    public int checkVector(int n, int n2) {
        return Mat.n_checkVector(this.nativeObj, n, n2);
    }

    public int checkVector(int n) {
        return Mat.n_checkVector(this.nativeObj, n);
    }

    public Mat clone() {
        return new Mat(Mat.n_clone(this.nativeObj));
    }

    public Mat col(int n) {
        return new Mat(Mat.n_col(this.nativeObj, n));
    }

    public Mat colRange(int n, int n2) {
        return new Mat(Mat.n_colRange(this.nativeObj, n, n2));
    }

    public Mat colRange(Range range) {
        return new Mat(Mat.n_colRange(this.nativeObj, range.start, range.end));
    }

    public int dims() {
        return Mat.n_dims(this.nativeObj);
    }

    public int cols() {
        return Mat.n_cols(this.nativeObj);
    }

    public void convertTo(Mat mat, int n, double d, double d2) {
        Mat.n_convertTo(this.nativeObj, mat.nativeObj, n, d, d2);
    }

    public void convertTo(Mat mat, int n, double d) {
        Mat.n_convertTo(this.nativeObj, mat.nativeObj, n, d);
    }

    public void convertTo(Mat mat, int n) {
        Mat.n_convertTo(this.nativeObj, mat.nativeObj, n);
    }

    public void copyTo(Mat mat) {
        Mat.n_copyTo(this.nativeObj, mat.nativeObj);
    }

    public void copyTo(Mat mat, Mat mat2) {
        Mat.n_copyTo(this.nativeObj, mat.nativeObj, mat2.nativeObj);
    }

    public void create(int n, int n2, int n3) {
        Mat.n_create(this.nativeObj, n, n2, n3);
    }

    public void create(Size size, int n) {
        Mat.n_create(this.nativeObj, size.width, size.height, n);
    }

    public void create(int[] nArray, int n) {
        Mat.n_create(this.nativeObj, nArray.length, nArray, n);
    }

    public void copySize(Mat mat) {
        Mat.n_copySize(this.nativeObj, mat.nativeObj);
    }

    public Mat cross(Mat mat) {
        return new Mat(Mat.n_cross(this.nativeObj, mat.nativeObj));
    }

    public long dataAddr() {
        return Mat.n_dataAddr(this.nativeObj);
    }

    public int depth() {
        return Mat.n_depth(this.nativeObj);
    }

    public Mat diag(int n) {
        return new Mat(Mat.n_diag(this.nativeObj, n));
    }

    public Mat diag() {
        return new Mat(Mat.n_diag(this.nativeObj, 0));
    }

    public static Mat diag(Mat mat) {
        return new Mat(Mat.n_diag(mat.nativeObj));
    }

    public double dot(Mat mat) {
        return Mat.n_dot(this.nativeObj, mat.nativeObj);
    }

    public long elemSize() {
        return Mat.n_elemSize(this.nativeObj);
    }

    public long elemSize1() {
        return Mat.n_elemSize1(this.nativeObj);
    }

    public boolean empty() {
        return Mat.n_empty(this.nativeObj);
    }

    public static Mat eye(int n, int n2, int n3) {
        return new Mat(Mat.n_eye(n, n2, n3));
    }

    public static Mat eye(Size size, int n) {
        return new Mat(Mat.n_eye(size.width, size.height, n));
    }

    public Mat inv(int n) {
        return new Mat(Mat.n_inv(this.nativeObj, n));
    }

    public Mat inv() {
        return new Mat(Mat.n_inv(this.nativeObj));
    }

    public boolean isContinuous() {
        return Mat.n_isContinuous(this.nativeObj);
    }

    public boolean isSubmatrix() {
        return Mat.n_isSubmatrix(this.nativeObj);
    }

    public void locateROI(Size size, Point point) {
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        Mat.locateROI_0(this.nativeObj, dArray, dArray2);
        if (size != null) {
            size.width = dArray[0];
            size.height = dArray[1];
        }
        if (point != null) {
            point.x = dArray2[0];
            point.y = dArray2[1];
        }
    }

    public Mat mul(Mat mat, double d) {
        return new Mat(Mat.n_mul(this.nativeObj, mat.nativeObj, d));
    }

    public Mat mul(Mat mat) {
        return new Mat(Mat.n_mul(this.nativeObj, mat.nativeObj));
    }

    public Mat matMul(Mat mat) {
        return new Mat(Mat.n_matMul(this.nativeObj, mat.nativeObj));
    }

    public static Mat ones(int n, int n2, int n3) {
        return new Mat(Mat.n_ones(n, n2, n3));
    }

    public static Mat ones(Size size, int n) {
        return new Mat(Mat.n_ones(size.width, size.height, n));
    }

    public static Mat ones(int[] nArray, int n) {
        return new Mat(Mat.n_ones(nArray.length, nArray, n));
    }

    public void push_back(Mat mat) {
        Mat.n_push_back(this.nativeObj, mat.nativeObj);
    }

    public void release() {
        Mat.n_release(this.nativeObj);
    }

    public Mat reshape(int n, int n2) {
        return new Mat(Mat.n_reshape(this.nativeObj, n, n2));
    }

    public Mat reshape(int n) {
        return new Mat(Mat.n_reshape(this.nativeObj, n));
    }

    public Mat reshape(int n, int[] nArray) {
        return new Mat(Mat.n_reshape_1(this.nativeObj, n, nArray.length, nArray));
    }

    public Mat row(int n) {
        return new Mat(Mat.n_row(this.nativeObj, n));
    }

    public Mat rowRange(int n, int n2) {
        return new Mat(Mat.n_rowRange(this.nativeObj, n, n2));
    }

    public Mat rowRange(Range range) {
        return new Mat(Mat.n_rowRange(this.nativeObj, range.start, range.end));
    }

    public int rows() {
        return Mat.n_rows(this.nativeObj);
    }

    public Mat setTo(Scalar scalar) {
        return new Mat(Mat.n_setTo(this.nativeObj, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3]));
    }

    public Mat setTo(Scalar scalar, Mat mat) {
        return new Mat(Mat.n_setTo(this.nativeObj, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3], mat.nativeObj));
    }

    public Mat setTo(Mat mat, Mat mat2) {
        return new Mat(Mat.n_setTo(this.nativeObj, mat.nativeObj, mat2.nativeObj));
    }

    public Mat setTo(Mat mat) {
        return new Mat(Mat.n_setTo(this.nativeObj, mat.nativeObj));
    }

    public Size size() {
        return new Size(Mat.n_size(this.nativeObj));
    }

    public int size(int n) {
        return Mat.n_size_i(this.nativeObj, n);
    }

    public long step1(int n) {
        return Mat.n_step1(this.nativeObj, n);
    }

    public long step1() {
        return Mat.n_step1(this.nativeObj);
    }

    public Mat submat(int n, int n2, int n3, int n4) {
        return new Mat(Mat.n_submat_rr(this.nativeObj, n, n2, n3, n4));
    }

    public Mat submat(Range range, Range range2) {
        return new Mat(Mat.n_submat_rr(this.nativeObj, range.start, range.end, range2.start, range2.end));
    }

    public Mat submat(Range[] rangeArray) {
        return new Mat(Mat.n_submat_ranges(this.nativeObj, rangeArray));
    }

    public Mat submat(Rect rect) {
        return new Mat(Mat.n_submat(this.nativeObj, rect.x, rect.y, rect.width, rect.height));
    }

    public Mat t() {
        return new Mat(Mat.n_t(this.nativeObj));
    }

    public long total() {
        return Mat.n_total(this.nativeObj);
    }

    public int type() {
        return Mat.n_type(this.nativeObj);
    }

    public static Mat zeros(int n, int n2, int n3) {
        return new Mat(Mat.n_zeros(n, n2, n3));
    }

    public static Mat zeros(Size size, int n) {
        return new Mat(Mat.n_zeros(size.width, size.height, n));
    }

    public static Mat zeros(int[] nArray, int n) {
        return new Mat(Mat.n_zeros(nArray.length, nArray, n));
    }

    protected void finalize() throws Throwable {
        Mat.n_delete(this.nativeObj);
        super.finalize();
    }

    public String toString() {
        Object object = this.dims() > 0 ? "" : "-1*-1*";
        for (int i = 0; i < this.dims(); ++i) {
            object = (String)object + this.size(i) + "*";
        }
        return "Mat [ " + (String)object + CvType.typeToString(this.type()) + ", isCont=" + this.isContinuous() + ", isSubmat=" + this.isSubmatrix() + ", nativeObj=0x" + Long.toHexString(this.nativeObj) + ", dataAddr=0x" + Long.toHexString(this.dataAddr()) + " ]";
    }

    public String dump() {
        return Mat.nDump(this.nativeObj);
    }

    public int put(int n, int n2, double ... dArray) {
        int n3 = this.type();
        if (dArray == null || dArray.length % CvType.channels(n3) != 0) {
            throw new UnsupportedOperationException("Provided data element number (" + (dArray == null ? 0 : dArray.length) + ") should be multiple of the Mat channels count (" + CvType.channels(n3) + ")");
        }
        return Mat.nPutD(this.nativeObj, n, n2, dArray.length, dArray);
    }

    public int put(int[] nArray, double ... dArray) {
        int n = this.type();
        if (dArray == null || dArray.length % CvType.channels(n) != 0) {
            throw new UnsupportedOperationException("Provided data element number (" + (dArray == null ? 0 : dArray.length) + ") should be multiple of the Mat channels count (" + CvType.channels(n) + ")");
        }
        if (nArray.length != this.dims()) {
            throw new IllegalArgumentException("Incorrect number of indices");
        }
        return Mat.nPutDIdx(this.nativeObj, nArray, dArray.length, dArray);
    }

    public int put(int n, int n2, float[] fArray) {
        int n3 = this.type();
        if (fArray == null || fArray.length % CvType.channels(n3) != 0) {
            throw new UnsupportedOperationException("Provided data element number (" + (fArray == null ? 0 : fArray.length) + ") should be multiple of the Mat channels count (" + CvType.channels(n3) + ")");
        }
        if (CvType.depth(n3) == 5) {
            return Mat.nPutF(this.nativeObj, n, n2, fArray.length, fArray);
        }
        throw new UnsupportedOperationException("Mat data type is not compatible: " + n3);
    }

    public int put(int[] nArray, float[] fArray) {
        int n = this.type();
        if (fArray == null || fArray.length % CvType.channels(n) != 0) {
            throw new UnsupportedOperationException("Provided data element number (" + (fArray == null ? 0 : fArray.length) + ") should be multiple of the Mat channels count (" + CvType.channels(n) + ")");
        }
        if (nArray.length != this.dims()) {
            throw new IllegalArgumentException("Incorrect number of indices");
        }
        if (CvType.depth(n) == 5) {
            return Mat.nPutFIdx(this.nativeObj, nArray, fArray.length, fArray);
        }
        throw new UnsupportedOperationException("Mat data type is not compatible: " + n);
    }

    public int put(int n, int n2, int[] nArray) {
        int n3 = this.type();
        if (nArray == null || nArray.length % CvType.channels(n3) != 0) {
            throw new UnsupportedOperationException("Provided data element number (" + (nArray == null ? 0 : nArray.length) + ") should be multiple of the Mat channels count (" + CvType.channels(n3) + ")");
        }
        if (CvType.depth(n3) == 4) {
            return Mat.nPutI(this.nativeObj, n, n2, nArray.length, nArray);
        }
        throw new UnsupportedOperationException("Mat data type is not compatible: " + n3);
    }

    public int put(int[] nArray, int[] nArray2) {
        int n = this.type();
        if (nArray2 == null || nArray2.length % CvType.channels(n) != 0) {
            throw new UnsupportedOperationException("Provided data element number (" + (nArray2 == null ? 0 : nArray2.length) + ") should be multiple of the Mat channels count (" + CvType.channels(n) + ")");
        }
        if (nArray.length != this.dims()) {
            throw new IllegalArgumentException("Incorrect number of indices");
        }
        if (CvType.depth(n) == 4) {
            return Mat.nPutIIdx(this.nativeObj, nArray, nArray2.length, nArray2);
        }
        throw new UnsupportedOperationException("Mat data type is not compatible: " + n);
    }

    public int put(int n, int n2, short[] sArray) {
        int n3 = this.type();
        if (sArray == null || sArray.length % CvType.channels(n3) != 0) {
            throw new UnsupportedOperationException("Provided data element number (" + (sArray == null ? 0 : sArray.length) + ") should be multiple of the Mat channels count (" + CvType.channels(n3) + ")");
        }
        if (CvType.depth(n3) == 2 || CvType.depth(n3) == 3) {
            return Mat.nPutS(this.nativeObj, n, n2, sArray.length, sArray);
        }
        throw new UnsupportedOperationException("Mat data type is not compatible: " + n3);
    }

    public int put(int[] nArray, short[] sArray) {
        int n = this.type();
        if (sArray == null || sArray.length % CvType.channels(n) != 0) {
            throw new UnsupportedOperationException("Provided data element number (" + (sArray == null ? 0 : sArray.length) + ") should be multiple of the Mat channels count (" + CvType.channels(n) + ")");
        }
        if (nArray.length != this.dims()) {
            throw new IllegalArgumentException("Incorrect number of indices");
        }
        if (CvType.depth(n) == 2 || CvType.depth(n) == 3) {
            return Mat.nPutSIdx(this.nativeObj, nArray, sArray.length, sArray);
        }
        throw new UnsupportedOperationException("Mat data type is not compatible: " + n);
    }

    public int put(int n, int n2, byte[] byArray) {
        int n3 = this.type();
        if (byArray == null || byArray.length % CvType.channels(n3) != 0) {
            throw new UnsupportedOperationException("Provided data element number (" + (byArray == null ? 0 : byArray.length) + ") should be multiple of the Mat channels count (" + CvType.channels(n3) + ")");
        }
        if (CvType.depth(n3) == 0 || CvType.depth(n3) == 1) {
            return Mat.nPutB(this.nativeObj, n, n2, byArray.length, byArray);
        }
        throw new UnsupportedOperationException("Mat data type is not compatible: " + n3);
    }

    public int put(int[] nArray, byte[] byArray) {
        int n = this.type();
        if (byArray == null || byArray.length % CvType.channels(n) != 0) {
            throw new UnsupportedOperationException("Provided data element number (" + (byArray == null ? 0 : byArray.length) + ") should be multiple of the Mat channels count (" + CvType.channels(n) + ")");
        }
        if (nArray.length != this.dims()) {
            throw new IllegalArgumentException("Incorrect number of indices");
        }
        if (CvType.depth(n) == 0 || CvType.depth(n) == 1) {
            return Mat.nPutBIdx(this.nativeObj, nArray, byArray.length, byArray);
        }
        throw new UnsupportedOperationException("Mat data type is not compatible: " + n);
    }

    public int put(int n, int n2, byte[] byArray, int n3, int n4) {
        int n5 = this.type();
        if (byArray == null || n4 % CvType.channels(n5) != 0) {
            throw new UnsupportedOperationException("Provided data element number (" + (byArray == null ? 0 : byArray.length) + ") should be multiple of the Mat channels count (" + CvType.channels(n5) + ")");
        }
        if (CvType.depth(n5) == 0 || CvType.depth(n5) == 1) {
            return Mat.nPutBwOffset(this.nativeObj, n, n2, n4, n3, byArray);
        }
        throw new UnsupportedOperationException("Mat data type is not compatible: " + n5);
    }

    public int put(int[] nArray, byte[] byArray, int n, int n2) {
        int n3 = this.type();
        if (byArray == null || n2 % CvType.channels(n3) != 0) {
            throw new UnsupportedOperationException("Provided data element number (" + (byArray == null ? 0 : byArray.length) + ") should be multiple of the Mat channels count (" + CvType.channels(n3) + ")");
        }
        if (nArray.length != this.dims()) {
            throw new IllegalArgumentException("Incorrect number of indices");
        }
        if (CvType.depth(n3) == 0 || CvType.depth(n3) == 1) {
            return Mat.nPutBwIdxOffset(this.nativeObj, nArray, n2, n, byArray);
        }
        throw new UnsupportedOperationException("Mat data type is not compatible: " + n3);
    }

    public int get(int n, int n2, byte[] byArray) {
        int n3 = this.type();
        if (byArray == null || byArray.length % CvType.channels(n3) != 0) {
            throw new UnsupportedOperationException("Provided data element number (" + (byArray == null ? 0 : byArray.length) + ") should be multiple of the Mat channels count (" + CvType.channels(n3) + ")");
        }
        if (CvType.depth(n3) == 0 || CvType.depth(n3) == 1) {
            return Mat.nGetB(this.nativeObj, n, n2, byArray.length, byArray);
        }
        throw new UnsupportedOperationException("Mat data type is not compatible: " + n3);
    }

    public int get(int[] nArray, byte[] byArray) {
        int n = this.type();
        if (byArray == null || byArray.length % CvType.channels(n) != 0) {
            throw new UnsupportedOperationException("Provided data element number (" + (byArray == null ? 0 : byArray.length) + ") should be multiple of the Mat channels count (" + CvType.channels(n) + ")");
        }
        if (nArray.length != this.dims()) {
            throw new IllegalArgumentException("Incorrect number of indices");
        }
        if (CvType.depth(n) == 0 || CvType.depth(n) == 1) {
            return Mat.nGetBIdx(this.nativeObj, nArray, byArray.length, byArray);
        }
        throw new UnsupportedOperationException("Mat data type is not compatible: " + n);
    }

    public int get(int n, int n2, short[] sArray) {
        int n3 = this.type();
        if (sArray == null || sArray.length % CvType.channels(n3) != 0) {
            throw new UnsupportedOperationException("Provided data element number (" + (sArray == null ? 0 : sArray.length) + ") should be multiple of the Mat channels count (" + CvType.channels(n3) + ")");
        }
        if (CvType.depth(n3) == 2 || CvType.depth(n3) == 3) {
            return Mat.nGetS(this.nativeObj, n, n2, sArray.length, sArray);
        }
        throw new UnsupportedOperationException("Mat data type is not compatible: " + n3);
    }

    public int get(int[] nArray, short[] sArray) {
        int n = this.type();
        if (sArray == null || sArray.length % CvType.channels(n) != 0) {
            throw new UnsupportedOperationException("Provided data element number (" + (sArray == null ? 0 : sArray.length) + ") should be multiple of the Mat channels count (" + CvType.channels(n) + ")");
        }
        if (nArray.length != this.dims()) {
            throw new IllegalArgumentException("Incorrect number of indices");
        }
        if (CvType.depth(n) == 2 || CvType.depth(n) == 3) {
            return Mat.nGetSIdx(this.nativeObj, nArray, sArray.length, sArray);
        }
        throw new UnsupportedOperationException("Mat data type is not compatible: " + n);
    }

    public int get(int n, int n2, int[] nArray) {
        int n3 = this.type();
        if (nArray == null || nArray.length % CvType.channels(n3) != 0) {
            throw new UnsupportedOperationException("Provided data element number (" + (nArray == null ? 0 : nArray.length) + ") should be multiple of the Mat channels count (" + CvType.channels(n3) + ")");
        }
        if (CvType.depth(n3) == 4) {
            return Mat.nGetI(this.nativeObj, n, n2, nArray.length, nArray);
        }
        throw new UnsupportedOperationException("Mat data type is not compatible: " + n3);
    }

    public int get(int[] nArray, int[] nArray2) {
        int n = this.type();
        if (nArray2 == null || nArray2.length % CvType.channels(n) != 0) {
            throw new UnsupportedOperationException("Provided data element number (" + (nArray2 == null ? 0 : nArray2.length) + ") should be multiple of the Mat channels count (" + CvType.channels(n) + ")");
        }
        if (nArray.length != this.dims()) {
            throw new IllegalArgumentException("Incorrect number of indices");
        }
        if (CvType.depth(n) == 4) {
            return Mat.nGetIIdx(this.nativeObj, nArray, nArray2.length, nArray2);
        }
        throw new UnsupportedOperationException("Mat data type is not compatible: " + n);
    }

    public int get(int n, int n2, float[] fArray) {
        int n3 = this.type();
        if (fArray == null || fArray.length % CvType.channels(n3) != 0) {
            throw new UnsupportedOperationException("Provided data element number (" + (fArray == null ? 0 : fArray.length) + ") should be multiple of the Mat channels count (" + CvType.channels(n3) + ")");
        }
        if (CvType.depth(n3) == 5) {
            return Mat.nGetF(this.nativeObj, n, n2, fArray.length, fArray);
        }
        throw new UnsupportedOperationException("Mat data type is not compatible: " + n3);
    }

    public int get(int[] nArray, float[] fArray) {
        int n = this.type();
        if (fArray == null || fArray.length % CvType.channels(n) != 0) {
            throw new UnsupportedOperationException("Provided data element number (" + (fArray == null ? 0 : fArray.length) + ") should be multiple of the Mat channels count (" + CvType.channels(n) + ")");
        }
        if (nArray.length != this.dims()) {
            throw new IllegalArgumentException("Incorrect number of indices");
        }
        if (CvType.depth(n) == 5) {
            return Mat.nGetFIdx(this.nativeObj, nArray, fArray.length, fArray);
        }
        throw new UnsupportedOperationException("Mat data type is not compatible: " + n);
    }

    public int get(int n, int n2, double[] dArray) {
        int n3 = this.type();
        if (dArray == null || dArray.length % CvType.channels(n3) != 0) {
            throw new UnsupportedOperationException("Provided data element number (" + (dArray == null ? 0 : dArray.length) + ") should be multiple of the Mat channels count (" + CvType.channels(n3) + ")");
        }
        if (CvType.depth(n3) == 6) {
            return Mat.nGetD(this.nativeObj, n, n2, dArray.length, dArray);
        }
        throw new UnsupportedOperationException("Mat data type is not compatible: " + n3);
    }

    public int get(int[] nArray, double[] dArray) {
        int n = this.type();
        if (dArray == null || dArray.length % CvType.channels(n) != 0) {
            throw new UnsupportedOperationException("Provided data element number (" + (dArray == null ? 0 : dArray.length) + ") should be multiple of the Mat channels count (" + CvType.channels(n) + ")");
        }
        if (nArray.length != this.dims()) {
            throw new IllegalArgumentException("Incorrect number of indices");
        }
        if (CvType.depth(n) == 6) {
            return Mat.nGetDIdx(this.nativeObj, nArray, dArray.length, dArray);
        }
        throw new UnsupportedOperationException("Mat data type is not compatible: " + n);
    }

    public double[] get(int n, int n2) {
        return Mat.nGet(this.nativeObj, n, n2);
    }

    public double[] get(int[] nArray) {
        if (nArray.length != this.dims()) {
            throw new IllegalArgumentException("Incorrect number of indices");
        }
        return Mat.nGetIdx(this.nativeObj, nArray);
    }

    public int height() {
        return this.rows();
    }

    public int width() {
        return this.cols();
    }

    public <T> Atable<T> at(Class<T> clazz, int n, int n2) {
        if (clazz == Byte.class || clazz == Byte.TYPE) {
            return new AtableByte(this, n, n2);
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return new AtableDouble(this, n, n2);
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return new AtableFloat(this, n, n2);
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return new AtableInteger(this, n, n2);
        }
        if (clazz == Short.class || clazz == Short.TYPE) {
            return new AtableShort(this, n, n2);
        }
        throw new RuntimeException("Unsupported class type");
    }

    public <T> Atable<T> at(Class<T> clazz, int[] nArray) {
        if (clazz == Byte.class || clazz == Byte.TYPE) {
            return new AtableByte(this, nArray);
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return new AtableDouble(this, nArray);
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return new AtableFloat(this, nArray);
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return new AtableInteger(this, nArray);
        }
        if (clazz == Short.class || clazz == Short.TYPE) {
            return new AtableShort(this, nArray);
        }
        throw new RuntimeException("Unsupported class parameter");
    }

    public long getNativeObjAddr() {
        return this.nativeObj;
    }

    private static native long n_Mat();

    private static native long n_Mat(int var0, int var1, int var2);

    private static native long n_Mat(int var0, int[] var1, int var2);

    private static native long n_Mat(int var0, int var1, int var2, ByteBuffer var3);

    private static native long n_Mat(int var0, int var1, int var2, ByteBuffer var3, long var4);

    private static native long n_Mat(double var0, double var2, int var4);

    private static native long n_Mat(int var0, int var1, int var2, double var3, double var5, double var7, double var9);

    private static native long n_Mat(double var0, double var2, int var4, double var5, double var7, double var9, double var11);

    private static native long n_Mat(int var0, int[] var1, int var2, double var3, double var5, double var7, double var9);

    private static native long n_Mat(long var0, int var2, int var3, int var4, int var5);

    private static native long n_Mat(long var0, int var2, int var3);

    private static native long n_Mat(long var0, Range[] var2);

    private static native long n_adjustROI(long var0, int var2, int var3, int var4, int var5);

    private static native void n_assignTo(long var0, long var2, int var4);

    private static native void n_assignTo(long var0, long var2);

    private static native int n_channels(long var0);

    private static native int n_checkVector(long var0, int var2, int var3, boolean var4);

    private static native int n_checkVector(long var0, int var2, int var3);

    private static native int n_checkVector(long var0, int var2);

    private static native long n_clone(long var0);

    private static native long n_col(long var0, int var2);

    private static native long n_colRange(long var0, int var2, int var3);

    private static native int n_dims(long var0);

    private static native int n_cols(long var0);

    private static native void n_convertTo(long var0, long var2, int var4, double var5, double var7);

    private static native void n_convertTo(long var0, long var2, int var4, double var5);

    private static native void n_convertTo(long var0, long var2, int var4);

    private static native void n_copyTo(long var0, long var2);

    private static native void n_copyTo(long var0, long var2, long var4);

    private static native void n_create(long var0, int var2, int var3, int var4);

    private static native void n_create(long var0, double var2, double var4, int var6);

    private static native void n_create(long var0, int var2, int[] var3, int var4);

    private static native void n_copySize(long var0, long var2);

    private static native long n_cross(long var0, long var2);

    private static native long n_dataAddr(long var0);

    private static native int n_depth(long var0);

    private static native long n_diag(long var0, int var2);

    private static native long n_diag(long var0);

    private static native double n_dot(long var0, long var2);

    private static native long n_elemSize(long var0);

    private static native long n_elemSize1(long var0);

    private static native boolean n_empty(long var0);

    private static native long n_eye(int var0, int var1, int var2);

    private static native long n_eye(double var0, double var2, int var4);

    private static native long n_inv(long var0, int var2);

    private static native long n_inv(long var0);

    private static native boolean n_isContinuous(long var0);

    private static native boolean n_isSubmatrix(long var0);

    private static native void locateROI_0(long var0, double[] var2, double[] var3);

    private static native long n_mul(long var0, long var2, double var4);

    private static native long n_mul(long var0, long var2);

    private static native long n_matMul(long var0, long var2);

    private static native long n_ones(int var0, int var1, int var2);

    private static native long n_ones(double var0, double var2, int var4);

    private static native long n_ones(int var0, int[] var1, int var2);

    private static native void n_push_back(long var0, long var2);

    private static native void n_release(long var0);

    private static native long n_reshape(long var0, int var2, int var3);

    private static native long n_reshape(long var0, int var2);

    private static native long n_reshape_1(long var0, int var2, int var3, int[] var4);

    private static native long n_row(long var0, int var2);

    private static native long n_rowRange(long var0, int var2, int var3);

    private static native int n_rows(long var0);

    private static native long n_setTo(long var0, double var2, double var4, double var6, double var8);

    private static native long n_setTo(long var0, double var2, double var4, double var6, double var8, long var10);

    private static native long n_setTo(long var0, long var2, long var4);

    private static native long n_setTo(long var0, long var2);

    private static native double[] n_size(long var0);

    private static native int n_size_i(long var0, int var2);

    private static native long n_step1(long var0, int var2);

    private static native long n_step1(long var0);

    private static native long n_submat_rr(long var0, int var2, int var3, int var4, int var5);

    private static native long n_submat_ranges(long var0, Range[] var2);

    private static native long n_submat(long var0, int var2, int var3, int var4, int var5);

    private static native long n_t(long var0);

    private static native long n_total(long var0);

    private static native int n_type(long var0);

    private static native long n_zeros(int var0, int var1, int var2);

    private static native long n_zeros(double var0, double var2, int var4);

    private static native long n_zeros(int var0, int[] var1, int var2);

    private static native void n_delete(long var0);

    private static native int nPutD(long var0, int var2, int var3, int var4, double[] var5);

    private static native int nPutDIdx(long var0, int[] var2, int var3, double[] var4);

    private static native int nPutF(long var0, int var2, int var3, int var4, float[] var5);

    private static native int nPutFIdx(long var0, int[] var2, int var3, float[] var4);

    private static native int nPutI(long var0, int var2, int var3, int var4, int[] var5);

    private static native int nPutIIdx(long var0, int[] var2, int var3, int[] var4);

    private static native int nPutS(long var0, int var2, int var3, int var4, short[] var5);

    private static native int nPutSIdx(long var0, int[] var2, int var3, short[] var4);

    private static native int nPutB(long var0, int var2, int var3, int var4, byte[] var5);

    private static native int nPutBIdx(long var0, int[] var2, int var3, byte[] var4);

    private static native int nPutBwOffset(long var0, int var2, int var3, int var4, int var5, byte[] var6);

    private static native int nPutBwIdxOffset(long var0, int[] var2, int var3, int var4, byte[] var5);

    private static native int nGetB(long var0, int var2, int var3, int var4, byte[] var5);

    private static native int nGetBIdx(long var0, int[] var2, int var3, byte[] var4);

    private static native int nGetS(long var0, int var2, int var3, int var4, short[] var5);

    private static native int nGetSIdx(long var0, int[] var2, int var3, short[] var4);

    private static native int nGetI(long var0, int var2, int var3, int var4, int[] var5);

    private static native int nGetIIdx(long var0, int[] var2, int var3, int[] var4);

    private static native int nGetF(long var0, int var2, int var3, int var4, float[] var5);

    private static native int nGetFIdx(long var0, int[] var2, int var3, float[] var4);

    private static native int nGetD(long var0, int var2, int var3, int var4, double[] var5);

    private static native int nGetDIdx(long var0, int[] var2, int var3, double[] var4);

    private static native double[] nGet(long var0, int var2, int var3);

    private static native double[] nGetIdx(long var0, int[] var2);

    private static native String nDump(long var0);

    private static class AtableByte
    extends AtableBase
    implements Atable<Byte> {
        public AtableByte(Mat mat, int n, int n2) {
            super(mat, n, n2);
        }

        public AtableByte(Mat mat, int[] nArray) {
            super(mat, nArray);
        }

        @Override
        public Byte getV() {
            byte[] byArray = new byte[1];
            this.mat.get(this.indices, byArray);
            return byArray[0];
        }

        @Override
        public void setV(Byte by) {
            byte[] byArray = new byte[]{by};
            this.mat.put(this.indices, byArray);
        }

        @Override
        public Tuple2<Byte> getV2c() {
            byte[] byArray = new byte[2];
            this.mat.get(this.indices, byArray);
            return new Tuple2<Byte>(byArray[0], byArray[1]);
        }

        @Override
        public void setV2c(Tuple2<Byte> tuple2) {
            byte[] byArray = new byte[]{(Byte)tuple2._0, (Byte)tuple2._1};
            this.mat.put(this.indices, byArray);
        }

        @Override
        public Tuple3<Byte> getV3c() {
            byte[] byArray = new byte[3];
            this.mat.get(this.indices, byArray);
            return new Tuple3<Byte>(byArray[0], byArray[1], byArray[2]);
        }

        @Override
        public void setV3c(Tuple3<Byte> tuple3) {
            byte[] byArray = new byte[]{(Byte)tuple3._0, (Byte)tuple3._1, (Byte)tuple3._2};
            this.mat.put(this.indices, byArray);
        }

        @Override
        public Tuple4<Byte> getV4c() {
            byte[] byArray = new byte[4];
            this.mat.get(this.indices, byArray);
            return new Tuple4<Byte>(byArray[0], byArray[1], byArray[2], byArray[3]);
        }

        @Override
        public void setV4c(Tuple4<Byte> tuple4) {
            byte[] byArray = new byte[]{(Byte)tuple4._0, (Byte)tuple4._1, (Byte)tuple4._2, (Byte)tuple4._3};
            this.mat.put(this.indices, byArray);
        }
    }

    private static class AtableDouble
    extends AtableBase
    implements Atable<Double> {
        public AtableDouble(Mat mat, int n, int n2) {
            super(mat, n, n2);
        }

        public AtableDouble(Mat mat, int[] nArray) {
            super(mat, nArray);
        }

        @Override
        public Double getV() {
            double[] dArray = new double[1];
            this.mat.get(this.indices, dArray);
            return dArray[0];
        }

        @Override
        public void setV(Double d) {
            double[] dArray = new double[]{d};
            this.mat.put(this.indices, dArray);
        }

        @Override
        public Tuple2<Double> getV2c() {
            double[] dArray = new double[2];
            this.mat.get(this.indices, dArray);
            return new Tuple2<Double>(dArray[0], dArray[1]);
        }

        @Override
        public void setV2c(Tuple2<Double> tuple2) {
            double[] dArray = new double[]{(Double)tuple2._0, (Double)tuple2._1};
            this.mat.put(this.indices, dArray);
        }

        @Override
        public Tuple3<Double> getV3c() {
            double[] dArray = new double[3];
            this.mat.get(this.indices, dArray);
            return new Tuple3<Double>(dArray[0], dArray[1], dArray[2]);
        }

        @Override
        public void setV3c(Tuple3<Double> tuple3) {
            double[] dArray = new double[]{(Double)tuple3._0, (Double)tuple3._1, (Double)tuple3._2};
            this.mat.put(this.indices, dArray);
        }

        @Override
        public Tuple4<Double> getV4c() {
            double[] dArray = new double[4];
            this.mat.get(this.indices, dArray);
            return new Tuple4<Double>(dArray[0], dArray[1], dArray[2], dArray[3]);
        }

        @Override
        public void setV4c(Tuple4<Double> tuple4) {
            double[] dArray = new double[]{(Double)tuple4._0, (Double)tuple4._1, (Double)tuple4._2, (Double)tuple4._3};
            this.mat.put(this.indices, dArray);
        }
    }

    private static class AtableFloat
    extends AtableBase
    implements Atable<Float> {
        public AtableFloat(Mat mat, int n, int n2) {
            super(mat, n, n2);
        }

        public AtableFloat(Mat mat, int[] nArray) {
            super(mat, nArray);
        }

        @Override
        public Float getV() {
            float[] fArray = new float[1];
            this.mat.get(this.indices, fArray);
            return Float.valueOf(fArray[0]);
        }

        @Override
        public void setV(Float f) {
            float[] fArray = new float[]{f.floatValue()};
            this.mat.put(this.indices, fArray);
        }

        @Override
        public Tuple2<Float> getV2c() {
            float[] fArray = new float[2];
            this.mat.get(this.indices, fArray);
            return new Tuple2<Float>(Float.valueOf(fArray[0]), Float.valueOf(fArray[1]));
        }

        @Override
        public void setV2c(Tuple2<Float> tuple2) {
            float[] fArray = new float[]{((Float)tuple2._0).floatValue(), ((Float)tuple2._1).floatValue()};
            this.mat.put(this.indices, fArray);
        }

        @Override
        public Tuple3<Float> getV3c() {
            float[] fArray = new float[3];
            this.mat.get(this.indices, fArray);
            return new Tuple3<Float>(Float.valueOf(fArray[0]), Float.valueOf(fArray[1]), Float.valueOf(fArray[2]));
        }

        @Override
        public void setV3c(Tuple3<Float> tuple3) {
            float[] fArray = new float[]{((Float)tuple3._0).floatValue(), ((Float)tuple3._1).floatValue(), ((Float)tuple3._2).floatValue()};
            this.mat.put(this.indices, fArray);
        }

        @Override
        public Tuple4<Float> getV4c() {
            float[] fArray = new float[4];
            this.mat.get(this.indices, fArray);
            return new Tuple4<Float>(Float.valueOf(fArray[0]), Float.valueOf(fArray[1]), Float.valueOf(fArray[2]), Float.valueOf(fArray[3]));
        }

        @Override
        public void setV4c(Tuple4<Float> tuple4) {
            double[] dArray = new double[]{((Float)tuple4._0).floatValue(), ((Float)tuple4._1).floatValue(), ((Float)tuple4._2).floatValue(), ((Float)tuple4._3).floatValue()};
            this.mat.put(this.indices, dArray);
        }
    }

    private static class AtableInteger
    extends AtableBase
    implements Atable<Integer> {
        public AtableInteger(Mat mat, int n, int n2) {
            super(mat, n, n2);
        }

        public AtableInteger(Mat mat, int[] nArray) {
            super(mat, nArray);
        }

        @Override
        public Integer getV() {
            int[] nArray = new int[1];
            this.mat.get(this.indices, nArray);
            return nArray[0];
        }

        @Override
        public void setV(Integer n) {
            int[] nArray = new int[]{n};
            this.mat.put(this.indices, nArray);
        }

        @Override
        public Tuple2<Integer> getV2c() {
            int[] nArray = new int[2];
            this.mat.get(this.indices, nArray);
            return new Tuple2<Integer>(nArray[0], nArray[1]);
        }

        @Override
        public void setV2c(Tuple2<Integer> tuple2) {
            int[] nArray = new int[]{(Integer)tuple2._0, (Integer)tuple2._1};
            this.mat.put(this.indices, nArray);
        }

        @Override
        public Tuple3<Integer> getV3c() {
            int[] nArray = new int[3];
            this.mat.get(this.indices, nArray);
            return new Tuple3<Integer>(nArray[0], nArray[1], nArray[2]);
        }

        @Override
        public void setV3c(Tuple3<Integer> tuple3) {
            int[] nArray = new int[]{(Integer)tuple3._0, (Integer)tuple3._1, (Integer)tuple3._2};
            this.mat.put(this.indices, nArray);
        }

        @Override
        public Tuple4<Integer> getV4c() {
            int[] nArray = new int[4];
            this.mat.get(this.indices, nArray);
            return new Tuple4<Integer>(nArray[0], nArray[1], nArray[2], nArray[3]);
        }

        @Override
        public void setV4c(Tuple4<Integer> tuple4) {
            int[] nArray = new int[]{(Integer)tuple4._0, (Integer)tuple4._1, (Integer)tuple4._2, (Integer)tuple4._3};
            this.mat.put(this.indices, nArray);
        }
    }

    private static class AtableShort
    extends AtableBase
    implements Atable<Short> {
        public AtableShort(Mat mat, int n, int n2) {
            super(mat, n, n2);
        }

        public AtableShort(Mat mat, int[] nArray) {
            super(mat, nArray);
        }

        @Override
        public Short getV() {
            short[] sArray = new short[1];
            this.mat.get(this.indices, sArray);
            return sArray[0];
        }

        @Override
        public void setV(Short s) {
            short[] sArray = new short[]{s};
            this.mat.put(this.indices, sArray);
        }

        @Override
        public Tuple2<Short> getV2c() {
            short[] sArray = new short[2];
            this.mat.get(this.indices, sArray);
            return new Tuple2<Short>(sArray[0], sArray[1]);
        }

        @Override
        public void setV2c(Tuple2<Short> tuple2) {
            short[] sArray = new short[]{(Short)tuple2._0, (Short)tuple2._1};
            this.mat.put(this.indices, sArray);
        }

        @Override
        public Tuple3<Short> getV3c() {
            short[] sArray = new short[3];
            this.mat.get(this.indices, sArray);
            return new Tuple3<Short>(sArray[0], sArray[1], sArray[2]);
        }

        @Override
        public void setV3c(Tuple3<Short> tuple3) {
            short[] sArray = new short[]{(Short)tuple3._0, (Short)tuple3._1, (Short)tuple3._2};
            this.mat.put(this.indices, sArray);
        }

        @Override
        public Tuple4<Short> getV4c() {
            short[] sArray = new short[4];
            this.mat.get(this.indices, sArray);
            return new Tuple4<Short>(sArray[0], sArray[1], sArray[2], sArray[3]);
        }

        @Override
        public void setV4c(Tuple4<Short> tuple4) {
            short[] sArray = new short[]{(Short)tuple4._0, (Short)tuple4._1, (Short)tuple4._2, (Short)tuple4._3};
            this.mat.put(this.indices, sArray);
        }
    }

    private static class AtableBase {
        protected final Mat mat;
        protected final int[] indices;

        protected AtableBase(Mat mat, int n, int n2) {
            this.mat = mat;
            this.indices = new int[2];
            this.indices[0] = n;
            this.indices[1] = n2;
        }

        protected AtableBase(Mat mat, int[] nArray) {
            this.mat = mat;
            this.indices = nArray;
        }
    }

    public static interface Atable<T> {
        public T getV();

        public void setV(T var1);

        public Tuple2<T> getV2c();

        public void setV2c(Tuple2<T> var1);

        public Tuple3<T> getV3c();

        public void setV3c(Tuple3<T> var1);

        public Tuple4<T> getV4c();

        public void setV4c(Tuple4<T> var1);
    }

    public static class Tuple4<T> {
        private final T _0;
        private final T _1;
        private final T _2;
        private final T _3;

        public Tuple4(T t, T t2, T t3, T t4) {
            this._0 = t;
            this._1 = t2;
            this._2 = t3;
            this._3 = t4;
        }

        public T get_0() {
            return this._0;
        }

        public T get_1() {
            return this._1;
        }

        public T get_2() {
            return this._2;
        }

        public T get_3() {
            return this._3;
        }
    }

    public static class Tuple3<T> {
        private final T _0;
        private final T _1;
        private final T _2;

        public Tuple3(T t, T t2, T t3) {
            this._0 = t;
            this._1 = t2;
            this._2 = t3;
        }

        public T get_0() {
            return this._0;
        }

        public T get_1() {
            return this._1;
        }

        public T get_2() {
            return this._2;
        }
    }

    public static class Tuple2<T> {
        private final T _0;
        private final T _1;

        public Tuple2(T t, T t2) {
            this._0 = t;
            this._1 = t2;
        }

        public T get_0() {
            return this._0;
        }

        public T get_1() {
            return this._1;
        }
    }
}

