/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.core;

import org.opencv.core.Rect;

public class Point {
    public double x;
    public double y;

    public Point(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public Point() {
        this(0.0, 0.0);
    }

    public Point(double[] dArray) {
        this();
        this.set(dArray);
    }

    public void set(double[] dArray) {
        if (dArray != null) {
            this.x = dArray.length > 0 ? dArray[0] : 0.0;
            this.y = dArray.length > 1 ? dArray[1] : 0.0;
        } else {
            this.x = 0.0;
            this.y = 0.0;
        }
    }

    public Point clone() {
        return new Point(this.x, this.y);
    }

    public double dot(Point point) {
        return this.x * point.x + this.y * point.y;
    }

    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.x);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.y);
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Point)) {
            return false;
        }
        Point point = (Point)object;
        return this.x == point.x && this.y == point.y;
    }

    public boolean inside(Rect rect) {
        return rect.contains(this);
    }

    public String toString() {
        return "{" + this.x + ", " + this.y + "}";
    }
}

