/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.core;

import java.util.Arrays;
import java.util.List;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.Point;
import org.opencv.core.Range;
import org.opencv.core.RotatedRect;
import org.opencv.core.Size;

public class MatOfRotatedRect
extends Mat {
    private static final int _depth = 5;
    private static final int _channels = 5;

    public MatOfRotatedRect() {
    }

    protected MatOfRotatedRect(long l) {
        super(l);
        if (!this.empty() && this.checkVector(5, 5) < 0) {
            throw new IllegalArgumentException("Incompatible Mat");
        }
    }

    public static MatOfRotatedRect fromNativeAddr(long l) {
        return new MatOfRotatedRect(l);
    }

    public MatOfRotatedRect(Mat mat) {
        super(mat, Range.all());
        if (!this.empty() && this.checkVector(5, 5) < 0) {
            throw new IllegalArgumentException("Incompatible Mat");
        }
    }

    public MatOfRotatedRect(RotatedRect ... rotatedRectArray) {
        this.fromArray(rotatedRectArray);
    }

    public void alloc(int n) {
        if (n > 0) {
            super.create(n, 1, CvType.makeType(5, 5));
        }
    }

    public void fromArray(RotatedRect ... rotatedRectArray) {
        if (rotatedRectArray == null || rotatedRectArray.length == 0) {
            return;
        }
        int n = rotatedRectArray.length;
        this.alloc(n);
        float[] fArray = new float[n * 5];
        for (int i = 0; i < n; ++i) {
            RotatedRect rotatedRect = rotatedRectArray[i];
            fArray[5 * i + 0] = (float)rotatedRect.center.x;
            fArray[5 * i + 1] = (float)rotatedRect.center.y;
            fArray[5 * i + 2] = (float)rotatedRect.size.width;
            fArray[5 * i + 3] = (float)rotatedRect.size.height;
            fArray[5 * i + 4] = (float)rotatedRect.angle;
        }
        this.put(0, 0, fArray);
    }

    public RotatedRect[] toArray() {
        int n = (int)this.total();
        RotatedRect[] rotatedRectArray = new RotatedRect[n];
        if (n == 0) {
            return rotatedRectArray;
        }
        float[] fArray = new float[5];
        for (int i = 0; i < n; ++i) {
            this.get(i, 0, fArray);
            rotatedRectArray[i] = new RotatedRect(new Point(fArray[0], fArray[1]), new Size(fArray[2], fArray[3]), fArray[4]);
        }
        return rotatedRectArray;
    }

    public void fromList(List<RotatedRect> list) {
        RotatedRect[] rotatedRectArray = list.toArray(new RotatedRect[0]);
        this.fromArray(rotatedRectArray);
    }

    public List<RotatedRect> toList() {
        RotatedRect[] rotatedRectArray = this.toArray();
        return Arrays.asList(rotatedRectArray);
    }
}

