/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.core;

import java.util.Arrays;
import java.util.List;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.Range;
import org.opencv.core.Rect2d;

public class MatOfRect2d
extends Mat {
    private static final int _depth = 6;
    private static final int _channels = 4;

    public MatOfRect2d() {
    }

    protected MatOfRect2d(long l) {
        super(l);
        if (!this.empty() && this.checkVector(4, 6) < 0) {
            throw new IllegalArgumentException("Incompatible Mat");
        }
    }

    public static MatOfRect2d fromNativeAddr(long l) {
        return new MatOfRect2d(l);
    }

    public MatOfRect2d(Mat mat) {
        super(mat, Range.all());
        if (!this.empty() && this.checkVector(4, 6) < 0) {
            throw new IllegalArgumentException("Incompatible Mat");
        }
    }

    public MatOfRect2d(Rect2d ... rect2dArray) {
        this.fromArray(rect2dArray);
    }

    public void alloc(int n) {
        if (n > 0) {
            super.create(n, 1, CvType.makeType(6, 4));
        }
    }

    public void fromArray(Rect2d ... rect2dArray) {
        if (rect2dArray == null || rect2dArray.length == 0) {
            return;
        }
        int n = rect2dArray.length;
        this.alloc(n);
        double[] dArray = new double[n * 4];
        for (int i = 0; i < n; ++i) {
            Rect2d rect2d = rect2dArray[i];
            dArray[4 * i + 0] = rect2d.x;
            dArray[4 * i + 1] = rect2d.y;
            dArray[4 * i + 2] = rect2d.width;
            dArray[4 * i + 3] = rect2d.height;
        }
        this.put(0, 0, dArray);
    }

    public Rect2d[] toArray() {
        int n = (int)this.total();
        Rect2d[] rect2dArray = new Rect2d[n];
        if (n == 0) {
            return rect2dArray;
        }
        double[] dArray = new double[n * 4];
        this.get(0, 0, dArray);
        for (int i = 0; i < n; ++i) {
            rect2dArray[i] = new Rect2d(dArray[i * 4], dArray[i * 4 + 1], dArray[i * 4 + 2], dArray[i * 4 + 3]);
        }
        return rect2dArray;
    }

    public void fromList(List<Rect2d> list) {
        Rect2d[] rect2dArray = list.toArray(new Rect2d[0]);
        this.fromArray(rect2dArray);
    }

    public List<Rect2d> toList() {
        Rect2d[] rect2dArray = this.toArray();
        return Arrays.asList(rect2dArray);
    }
}

