/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.core;

import java.util.Arrays;
import java.util.List;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.Point;
import org.opencv.core.Range;

public class MatOfPoint
extends Mat {
    private static final int _depth = 4;
    private static final int _channels = 2;

    public MatOfPoint() {
    }

    protected MatOfPoint(long l) {
        super(l);
        if (!this.empty() && this.checkVector(2, 4) < 0) {
            throw new IllegalArgumentException("Incompatible Mat");
        }
    }

    public static MatOfPoint fromNativeAddr(long l) {
        return new MatOfPoint(l);
    }

    public MatOfPoint(Mat mat) {
        super(mat, Range.all());
        if (!this.empty() && this.checkVector(2, 4) < 0) {
            throw new IllegalArgumentException("Incompatible Mat");
        }
    }

    public MatOfPoint(Point ... pointArray) {
        this.fromArray(pointArray);
    }

    public void alloc(int n) {
        if (n > 0) {
            super.create(n, 1, CvType.makeType(4, 2));
        }
    }

    public void fromArray(Point ... pointArray) {
        if (pointArray == null || pointArray.length == 0) {
            return;
        }
        int n = pointArray.length;
        this.alloc(n);
        int[] nArray = new int[n * 2];
        for (int i = 0; i < n; ++i) {
            Point point = pointArray[i];
            nArray[2 * i + 0] = (int)point.x;
            nArray[2 * i + 1] = (int)point.y;
        }
        this.put(0, 0, nArray);
    }

    public Point[] toArray() {
        int n = (int)this.total();
        Point[] pointArray = new Point[n];
        if (n == 0) {
            return pointArray;
        }
        int[] nArray = new int[n * 2];
        this.get(0, 0, nArray);
        for (int i = 0; i < n; ++i) {
            pointArray[i] = new Point(nArray[i * 2], nArray[i * 2 + 1]);
        }
        return pointArray;
    }

    public void fromList(List<Point> list) {
        Point[] pointArray = list.toArray(new Point[0]);
        this.fromArray(pointArray);
    }

    public List<Point> toList() {
        Point[] pointArray = this.toArray();
        return Arrays.asList(pointArray);
    }
}

