/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

public class BulkScorerWrapperScorer
extends Scorer {
    private final BulkScorer scorer;
    private int i = -1;
    private int doc = -1;
    private int next = 0;
    private final int[] docs;
    private final int[] freqs;
    private final float[] scores;
    private int bufferLength;

    public BulkScorerWrapperScorer(Weight weight, BulkScorer scorer, int bufferSize) {
        super(weight);
        this.scorer = scorer;
        this.docs = new int[bufferSize];
        this.freqs = new int[bufferSize];
        this.scores = new float[bufferSize];
    }

    private void refill(int target) throws IOException {
        this.bufferLength = 0;
        while (this.next != Integer.MAX_VALUE && this.bufferLength == 0) {
            int min = Math.max(target, this.next);
            int max = min + this.docs.length;
            this.next = this.scorer.score(new LeafCollector(){
                Scorer scorer;

                public void setScorer(Scorer scorer) throws IOException {
                    this.scorer = scorer;
                }

                public void collect(int doc) throws IOException {
                    ((BulkScorerWrapperScorer)BulkScorerWrapperScorer.this).docs[((BulkScorerWrapperScorer)BulkScorerWrapperScorer.this).bufferLength] = doc;
                    ((BulkScorerWrapperScorer)BulkScorerWrapperScorer.this).freqs[((BulkScorerWrapperScorer)BulkScorerWrapperScorer.this).bufferLength] = this.scorer.freq();
                    ((BulkScorerWrapperScorer)BulkScorerWrapperScorer.this).scores[((BulkScorerWrapperScorer)BulkScorerWrapperScorer.this).bufferLength] = this.scorer.score();
                    BulkScorerWrapperScorer.this.bufferLength += 1;
                }
            }, null, min, max);
        }
        this.i = -1;
    }

    public float score() throws IOException {
        return this.scores[this.i];
    }

    public int freq() throws IOException {
        return this.freqs[this.i];
    }

    public int docID() {
        return this.doc;
    }

    public DocIdSetIterator iterator() {
        return new DocIdSetIterator(){

            public int docID() {
                return BulkScorerWrapperScorer.this.doc;
            }

            public int nextDoc() throws IOException {
                return this.advance(this.docID() + 1);
            }

            public int advance(int target) throws IOException {
                if (BulkScorerWrapperScorer.this.bufferLength == 0 || BulkScorerWrapperScorer.this.docs[BulkScorerWrapperScorer.this.bufferLength - 1] < target) {
                    BulkScorerWrapperScorer.this.refill(target);
                }
                BulkScorerWrapperScorer.this.i = Arrays.binarySearch(BulkScorerWrapperScorer.this.docs, BulkScorerWrapperScorer.this.i + 1, BulkScorerWrapperScorer.this.bufferLength, target);
                if (BulkScorerWrapperScorer.this.i < 0) {
                    BulkScorerWrapperScorer.this.i = -1 - BulkScorerWrapperScorer.this.i;
                }
                if (BulkScorerWrapperScorer.this.i == BulkScorerWrapperScorer.this.bufferLength) {
                    return BulkScorerWrapperScorer.this.doc = Integer.MAX_VALUE;
                }
                return BulkScorerWrapperScorer.this.doc = BulkScorerWrapperScorer.this.docs[BulkScorerWrapperScorer.this.i];
            }

            public long cost() {
                return BulkScorerWrapperScorer.this.scorer.cost();
            }
        };
    }
}

