/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.asserting;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.codecs.LiveDocsFormat;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.MutableBits;
import org.apache.lucene.util.TestUtil;

public class AssertingLiveDocsFormat
extends LiveDocsFormat {
    private final LiveDocsFormat in = TestUtil.getDefaultCodec().liveDocsFormat();

    public MutableBits newLiveDocs(int size) throws IOException {
        assert (size >= 0);
        MutableBits raw = this.in.newLiveDocs(size);
        assert (raw != null);
        assert (raw.length() == size);
        for (int i = 0; i < raw.length(); ++i) {
            assert (raw.get(i));
        }
        return new AssertingMutableBits(raw);
    }

    public MutableBits newLiveDocs(Bits existing) throws IOException {
        assert (existing instanceof AssertingBits);
        Bits rawExisting = ((AssertingBits)existing).in;
        MutableBits raw = this.in.newLiveDocs(rawExisting);
        assert (raw != null);
        assert (raw.length() == rawExisting.length());
        for (int i = 0; i < raw.length(); ++i) {
            assert (rawExisting.get(i) == raw.get(i));
        }
        return new AssertingMutableBits(raw);
    }

    public Bits readLiveDocs(Directory dir, SegmentCommitInfo info, IOContext context) throws IOException {
        Bits raw = this.in.readLiveDocs(dir, info, context);
        assert (raw != null);
        this.check(raw, info.info.maxDoc(), info.getDelCount());
        return new AssertingBits(raw);
    }

    public void writeLiveDocs(MutableBits bits, Directory dir, SegmentCommitInfo info, int newDelCount, IOContext context) throws IOException {
        assert (bits instanceof AssertingMutableBits);
        MutableBits raw = (MutableBits)((AssertingMutableBits)bits).in;
        this.check((Bits)raw, info.info.maxDoc(), info.getDelCount() + newDelCount);
        this.in.writeLiveDocs(raw, dir, info, newDelCount, context);
    }

    private void check(Bits bits, int expectedLength, int expectedDeleteCount) {
        assert (bits.length() == expectedLength);
        int deletedCount = 0;
        for (int i = 0; i < bits.length(); ++i) {
            if (bits.get(i)) continue;
            ++deletedCount;
        }
        assert (deletedCount == expectedDeleteCount);
    }

    public void files(SegmentCommitInfo info, Collection<String> files) throws IOException {
        this.in.files(info, files);
    }

    public String toString() {
        return "Asserting(" + this.in + ")";
    }

    static class AssertingMutableBits
    extends AssertingBits
    implements MutableBits {
        AssertingMutableBits(MutableBits in) {
            super((Bits)in);
        }

        public void clear(int index) {
            assert (index >= 0);
            assert (index < this.in.length());
            ((MutableBits)this.in).clear(index);
        }
    }

    static class AssertingBits
    implements Bits {
        final Bits in;

        AssertingBits(Bits in) {
            this.in = in;
            assert (in.length() >= 0);
        }

        public boolean get(int index) {
            assert (index >= 0);
            assert (index < this.in.length());
            return this.in.get(index);
        }

        public int length() {
            return this.in.length();
        }

        public String toString() {
            return "Asserting(" + this.in + ")";
        }
    }
}

