/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.ui.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.owasp.html.AttributePolicy;
import org.owasp.html.Encoding;
import org.owasp.html.HtmlPolicyBuilder;
import org.owasp.html.HtmlStreamEventProcessor;
import org.owasp.html.HtmlStreamEventReceiver;
import org.owasp.html.HtmlStreamEventReceiverWrapper;
import org.owasp.html.PolicyFactory;
import org.owasp.html.Sanitizers;

public class StringUtils {
    private static final Log logger = LogFactory.getLog(StringUtils.class);
    private static final String DOCTYPE = "!DOCTYPE";
    private static final String HTML = "html";
    private static final String BODY = "body";
    private static final String HEAD = "head";
    protected static boolean overrideDocType = true;
    protected static PolicyFactory basePolicy;
    protected static PolicyFactory docPolicy;
    private static final AttributePolicy INTEGER;

    public void setOverrideDocType(boolean overrideDocType) {
        StringUtils.overrideDocType = overrideDocType;
    }

    public static String encode(String string) {
        if (string == null) {
            return "";
        }
        StringBuilder sb = null;
        for (int i = 0; i < string.length(); ++i) {
            Object enc = null;
            char c = string.charAt(i);
            switch (c) {
                case '\'': {
                    enc = "&#39;";
                    break;
                }
                case '\"': {
                    enc = "&#34;";
                    break;
                }
                case '&': {
                    enc = "&amp;";
                    break;
                }
                case '<': {
                    enc = "&lt;";
                    break;
                }
                case '>': {
                    enc = "&gt;";
                    break;
                }
                case '\u20ac': {
                    enc = "&euro;";
                    break;
                }
                case '\u00ab': {
                    enc = "&laquo;";
                    break;
                }
                case '\u00bb': {
                    enc = "&raquo;";
                    break;
                }
                case '\u00a0': {
                    enc = "&nbsp;";
                    break;
                }
                default: {
                    if (c < '\u0080') break;
                    enc = "&#" + c + ";";
                }
            }
            if (enc != null) {
                if (sb == null) {
                    String soFar = string.substring(0, i);
                    sb = new StringBuilder(i + 16);
                    sb.append(soFar);
                }
                sb.append((String)enc);
                continue;
            }
            if (sb == null) continue;
            sb.append(c);
        }
        if (sb == null) {
            return string;
        }
        return sb.toString();
    }

    public static String cropEncode(String text) {
        return StringUtils.cropEncode(text, 32);
    }

    public static String cropEncode(String text, int length) {
        if (text.length() > length) {
            String label = text.substring(0, length - 3) + "...";
            StringBuilder buf = new StringBuilder(length + 32 + text.length());
            buf.append("<span title=\"").append(StringUtils.encode(text)).append("\">").append(StringUtils.encode(label)).append("</span>");
            return buf.toString();
        }
        return StringUtils.encode(text);
    }

    public static String encodeJavascript(String s) {
        StringBuilder buf = new StringBuilder(s.length() * 3);
        for (int i = 0; i < s.length(); ++i) {
            char c;
            char iChar = c = s.charAt(i);
            buf.append('%');
            buf.append(Integer.toHexString(iChar));
        }
        return buf.toString();
    }

    public static String stripUnsafeHTMLTags(String s) {
        return StringUtils.stripUnsafeHTMLTags(s, true);
    }

    public static String stripUnsafeHTMLTags(String s, boolean encode) {
        return StringUtils.stripUnsafeHTMLTags(s, encode, false);
    }

    public static String stripUnsafeHTMLDocument(String doc, boolean encode) {
        return StringUtils.stripUnsafeHTMLTags(doc, encode, overrideDocType, true);
    }

    public static String stripUnsafeHTMLTags(String s, boolean encode, boolean overrideDocumentType) {
        return StringUtils.stripUnsafeHTMLTags(s, encode, overrideDocumentType, overrideDocumentType);
    }

    public static String stripUnsafeHTMLTags(String s, boolean encode, boolean overrideDocumentType, boolean isHTMLDoc) {
        return StringUtils.stripUnsafeHTMLTags(s, encode, overrideDocumentType, isHTMLDoc, true);
    }

    public static String stripUnsafeHTMLTags(String s, boolean encode, boolean overrideDocumentType, boolean isHTMLDoc, boolean runTwice) {
        if (s != null) {
            String result;
            String unescapedHTML = Encoding.decodeHtml((String)s);
            boolean isTextEncoded = !s.equals(unescapedHTML);
            PolicyFactory policy = isHTMLDoc ? docPolicy.and(basePolicy) : basePolicy;
            policy = policy.and(StringUtils.getEncodePolicy(encode, isTextEncoded));
            String sanitizedHTML = policy.sanitize(unescapedHTML);
            StringBuffer buf = new StringBuffer();
            if (isHTMLDoc && overrideDocumentType) {
                buf.append('<').append(DOCTYPE).append(' ').append(HTML).append('>');
            }
            buf.append(sanitizedHTML);
            String string = result = encode || isTextEncoded ? buf.toString() : Encoding.decodeHtml((String)buf.toString());
            if (runTwice) {
                result = encode ? Encoding.decodeHtml((String)result) : result;
                return StringUtils.stripUnsafeHTMLTags(result, encode, overrideDocumentType, isHTMLDoc, false);
            }
            return result;
        }
        return "";
    }

    private static PolicyFactory getEncodePolicy(final boolean encode, final boolean isTextEncoded) {
        return new HtmlPolicyBuilder().withPreprocessor(new HtmlStreamEventProcessor(){

            public HtmlStreamEventReceiver wrap(HtmlStreamEventReceiver r) {
                return new HtmlStreamEventReceiverWrapper(r){

                    public void text(String txt) {
                        if (txt != null && encode && isTextEncoded) {
                            this.underlying.text(StringUtils.encode(txt));
                        } else {
                            this.underlying.text(txt);
                        }
                    }
                };
            }
        }).toFactory();
    }

    public static String replace(String str, String repl, String with) {
        if (str == null) {
            return null;
        }
        int lastindex = 0;
        int pos = str.indexOf(repl);
        if (pos < 0) {
            return str;
        }
        int len = repl.length();
        int lendiff = with.length() - repl.length();
        StringBuilder out = new StringBuilder(lendiff <= 0 ? str.length() : str.length() + (lendiff << 3));
        while (pos >= 0) {
            out.append(str.substring(lastindex, pos)).append(with);
            lastindex = pos + len;
            pos = str.indexOf(repl, lastindex);
        }
        return out.append(str.substring(lastindex, str.length())).toString();
    }

    public static String remove(String str, String match) {
        int lastindex = 0;
        int pos = str.indexOf(match);
        if (pos < 0) {
            return str;
        }
        int len = match.length();
        StringBuilder out = new StringBuilder(str.length());
        while (pos >= 0) {
            out.append(str.substring(lastindex, pos));
            lastindex = pos + len;
            pos = str.indexOf(match, lastindex);
        }
        return out.append(str.substring(lastindex, str.length())).toString();
    }

    public static String replaceLineBreaks(String str, boolean xhtml) {
        String replaced;
        block4: {
            replaced = null;
            if (str != null) {
                try {
                    StringBuilder parsedContent = new StringBuilder(str.length() + 32);
                    BufferedReader reader = new BufferedReader(new StringReader(str));
                    String line = reader.readLine();
                    while (line != null) {
                        parsedContent.append(line);
                        line = reader.readLine();
                        if (line == null) continue;
                        parsedContent.append(xhtml ? "<br/>" : "<br>");
                    }
                    replaced = parsedContent.toString();
                }
                catch (IOException ioe) {
                    if (!logger.isWarnEnabled()) break block4;
                    logger.warn((Object)("Failed to replace line breaks in string: " + str));
                }
            }
        }
        return replaced;
    }

    public static String join(Object[] value) {
        return StringUtils.join(value, null);
    }

    public static String join(Object[] value, String delim) {
        StringBuilder buf = new StringBuilder(value.length << 4);
        for (int i = 0; i < value.length; ++i) {
            if (i != 0 && delim != null) {
                buf.append(delim);
            }
            buf.append(value[i] != null ? value[i].toString() : "");
        }
        return buf.toString();
    }

    static {
        INTEGER = new AttributePolicy(){

            public String apply(String elementName, String attributeName, String value) {
                int n = value.length();
                if (n == 0) {
                    return null;
                }
                for (int i = 0; i < n; ++i) {
                    char ch = value.charAt(i);
                    if (ch == '.') {
                        if (i == 0) {
                            return null;
                        }
                        return value.substring(0, i);
                    }
                    if ('0' <= ch && ch <= '9') continue;
                    return null;
                }
                return value;
            }
        };
        basePolicy = Sanitizers.FORMATTING.and(Sanitizers.BLOCKS).and(Sanitizers.LINKS).and(Sanitizers.IMAGES).and(Sanitizers.TABLES).and(Sanitizers.STYLES).and(new HtmlPolicyBuilder().allowElements(new String[]{"hr", "pre", "table"}).allowAttributes(new String[]{"border", "cellpadding", "cellspacing"}).matching(INTEGER).onElements(new String[]{"table"}).toFactory()).and(new HtmlPolicyBuilder().allowAttributes(new String[]{"id"}).globally().toFactory());
        docPolicy = new HtmlPolicyBuilder().allowElements(new String[]{HTML, BODY, HEAD}).toFactory();
    }
}

