/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.servlet;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigService;
import org.springframework.extensions.surf.util.Base64;
import org.springframework.extensions.surf.util.URLDecoder;
import org.springframework.extensions.surf.util.URLEncoder;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class CSRFFilter
implements Filter {
    private static Log logger = LogFactory.getLog(CSRFFilter.class);
    private ServletContext servletContext = null;
    private boolean enabled = true;
    private boolean createSession = false;
    private List<Rule> rules = null;
    private Map<String, String> properties = new HashMap<String, String>();
    private String PROPERTY_PREFIX = "csrf.filter.";
    private Boolean HTTP_SECURED_SESSION_PROP = null;
    private String COOKIES_SAMESITE = null;
    private String PARAM_ENABLED = "enabled";
    private final String PARAM_TOKEN = "token";
    private final String USER_ID = "_alf_USER_ID";
    private final String ISSET_USER_ID = "isset_alf_USER_ID";
    private final String ISSET_TOKEN = "isset_token";
    private Properties globalProperties = null;

    public void init(FilterConfig config) throws ServletException {
        ConfigService configService;
        Config csrfConfig;
        ApplicationContext context;
        block17: {
            this.HTTP_SECURED_SESSION_PROP = Boolean.parseBoolean(System.getProperty("http.secured.session"));
            this.COOKIES_SAMESITE = System.getProperty("cookies.sameSite");
            this.servletContext = config.getServletContext();
            context = this.getApplicationContext();
            try {
                this.globalProperties = (Properties)this.getApplicationContext().getBean("global-properties");
            }
            catch (NoSuchBeanDefinitionException exc) {
                if (!logger.isDebugEnabled()) break block17;
                logger.debug((Object)("global-properties bean is missing" + exc));
            }
        }
        if (this.globalProperties != null) {
            for (Map.Entry<Object, Object> globalEntry : this.globalProperties.entrySet()) {
                String property = (String)globalEntry.getKey();
                if (!property.startsWith(this.PROPERTY_PREFIX) || !property.replaceFirst(this.PROPERTY_PREFIX, "").equals(this.PARAM_ENABLED)) continue;
                this.enabled = Boolean.parseBoolean((String)globalEntry.getValue());
            }
        }
        if ((csrfConfig = (configService = (ConfigService)context.getBean("web.config")).getConfig((Object)"CSRFPolicy")) == null || !this.enabled) {
            this.enabled = false;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"There is no 'CSRFPolicy' config, filter will allow all requests.");
            }
        } else {
            ConfigElement filterConfig;
            List propertiesConfigList;
            ConfigElement propertiesConfig;
            ConfigElement sessionConfig = csrfConfig.getConfigElement("session");
            boolean bl = this.createSession = sessionConfig != null && "true".equals(sessionConfig.getValue());
            if (this.createSession && logger.isDebugEnabled()) {
                logger.debug((Object)"The CSRFFilter will automatically create a user Session on a path match.");
            }
            if ((propertiesConfig = csrfConfig.getConfigElement("properties")) != null && (propertiesConfigList = propertiesConfig.getChildren()) != null && propertiesConfigList.size() > 0) {
                for (ConfigElement propertyConfig : propertiesConfigList) {
                    String value = propertyConfig.getValue();
                    this.properties.put(propertyConfig.getName(), value != null ? value : "");
                }
            }
            if ((filterConfig = csrfConfig.getConfigElement("filter")) == null) {
                this.enabled = false;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"The 'CSRFPolicy' config had no filter, filter will allow all requests.");
                }
            } else {
                List rulesConfigList = filterConfig.getChildren("rule");
                if (rulesConfigList == null || rulesConfigList.size() == 0) {
                    this.enabled = false;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"The 'CSRFPolicy' filter config was empty, filter will allow all requests.");
                    }
                } else {
                    this.rules = new LinkedList<Rule>();
                    for (ConfigElement ruleConfig : rulesConfigList) {
                        this.rules.add(this.createRule(ruleConfig));
                    }
                }
            }
        }
    }

    protected Rule createRule(ConfigElement ruleConfig) throws ServletException {
        List actionConfigs;
        Rule rule = new Rule();
        ConfigElement requestConfig = ruleConfig.getChild("request");
        if (requestConfig != null) {
            List attributeConfigs;
            ConfigElement sessionConfig;
            rule.setMethod(this.resolve(requestConfig.getChildValue("method")));
            rule.setPath(this.resolve(requestConfig.getChildValue("path")));
            List headerConfigs = requestConfig.getChildren("header");
            if (headerConfigs != null && headerConfigs.size() > 0) {
                HashMap<String, String> headers = new HashMap<String, String>();
                for (ConfigElement headerConfig : headerConfigs) {
                    String value = headerConfig.getValue();
                    headers.put(this.resolve(headerConfig.getAttribute("name")), this.resolve(value));
                }
                rule.setHeaders(headers);
            }
            if ((sessionConfig = requestConfig.getChild("session")) != null && (attributeConfigs = sessionConfig.getChildren("attribute")) != null && attributeConfigs.size() > 0) {
                HashMap<String, String> sessionAttributes = new HashMap<String, String>();
                for (ConfigElement attributeConfig : attributeConfigs) {
                    String value = attributeConfig.getValue();
                    sessionAttributes.put(this.resolve(attributeConfig.getAttribute("name")), this.resolve(value));
                }
                rule.setSessionAttributes(sessionAttributes);
            }
        }
        if ((actionConfigs = ruleConfig.getChildren("action")) != null && actionConfigs.size() > 0) {
            LinkedList<Action> actions = new LinkedList<Action>();
            for (ConfigElement actionConfig : actionConfigs) {
                String actionName = this.resolve(actionConfig.getAttribute("name"));
                Action action = this.createAction(actionName);
                if (action == null) {
                    String message = "There is no action named '" + actionName + "'";
                    if (logger.isErrorEnabled()) {
                        logger.error((Object)message);
                    }
                    throw new ServletException(message);
                }
                action.setName(actionName);
                HashMap<String, String> parameters = new HashMap<String, String>();
                List actionParameterConfigs = actionConfig.getChildren("param");
                if (actionParameterConfigs != null) {
                    for (ConfigElement actionParameterConfig : actionParameterConfigs) {
                        parameters.put(this.resolve(actionParameterConfig.getAttribute("name")), this.resolve(actionParameterConfig.getValue()));
                    }
                }
                action.init(parameters);
                actions.add(action);
            }
            rule.setActions(actions);
        }
        return rule;
    }

    protected Action createAction(String name) throws ServletException {
        switch (name) {
            case "generateToken": {
                return new GenerateTokenAction();
            }
            case "assertToken": {
                return new AssertTokenAction();
            }
            case "clearToken": {
                return new ClearTokenAction();
            }
            case "assertReferer": {
                return new AssertRefererAction();
            }
            case "assertOrigin": {
                return new AssertOriginAction();
            }
            case "throwError": {
                return new ThrowErrorAction();
            }
        }
        return null;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (this.enabled && servletRequest instanceof HttpServletRequest && servletResponse instanceof HttpServletResponse) {
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            HttpSession session = request.getSession(this.createSession);
            this.preprocessOnHttpBasicAuth(request, session);
            for (Rule rule : this.rules) {
                if (!this.matchRequest(rule, request, session)) continue;
                List<Action> actions = rule.getActions();
                if (actions != null) {
                    for (Action action : actions) {
                        action.run(request, response, session);
                    }
                }
                this.postprocessOnHttpBasicAuth(request, session);
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
            this.postprocessOnHttpBasicAuth(request, session);
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    protected void preprocessOnHttpBasicAuth(HttpServletRequest request, HttpSession session) {
        String authHeader = request.getHeader("Authorization");
        if (authHeader != null) {
            Cookie[] cookies;
            String decodedAuthHeader;
            String[] decodedAuthParts;
            String[] authParts;
            String tokenName = this.properties.getOrDefault("token", "Alfresco-CSRFToken");
            if (session.getAttribute("_alf_USER_ID") == null && (authParts = authHeader.split(" ")).length == 2 && authParts[0].equalsIgnoreCase("basic") && (decodedAuthParts = (decodedAuthHeader = new String(Base64.decode((String)authParts[1]))).split(":")).length == 2) {
                session.setAttribute("_alf_USER_ID", (Object)decodedAuthParts[0]);
                request.setAttribute("isset_alf_USER_ID", (Object)true);
            }
            if (session.getAttribute(tokenName) == null && (cookies = request.getCookies()) != null) {
                for (Cookie cookie : cookies) {
                    if (!cookie.getName().equals(tokenName)) continue;
                    session.setAttribute(tokenName, new ArrayList<String>(List.of(URLDecoder.decode((String)cookie.getValue()))));
                    request.setAttribute("isset_token", (Object)true);
                }
            }
            if (session.getAttribute(tokenName) == null && (request.getMethod().equals("POST") || request.getMethod().equals("PUT") || request.getMethod().equals("DELETE"))) {
                session.setAttribute(tokenName, new ArrayList<String>(List.of("")));
                request.setAttribute("isset_token", (Object)true);
            }
        }
    }

    protected void postprocessOnHttpBasicAuth(HttpServletRequest request, HttpSession session) {
        String authHeader = request.getHeader("Authorization");
        if (authHeader != null) {
            String tokenName = this.properties.getOrDefault("token", "Alfresco-CSRFToken");
            if (request.getAttribute("isset_alf_USER_ID") != null) {
                session.removeAttribute("_alf_USER_ID");
            }
            if (request.getAttribute("isset_token") != null) {
                session.removeAttribute(tokenName);
            }
        }
    }

    public void destroy() {
    }

    protected String getPath(HttpServletRequest request) {
        return request.getRequestURI().substring(request.getContextPath().length());
    }

    protected boolean matchRequest(Rule rule, HttpServletRequest request, HttpSession session) throws ServletException {
        if (rule.getMethod() != null && !this.matchString(request.getMethod(), rule.getMethod())) {
            return false;
        }
        if (rule.getPath() != null && !this.matchString(this.getPath(request), rule.getPath())) {
            return false;
        }
        Map<String, String> headers = rule.getHeaders();
        if (headers != null) {
            for (String headerName : headers.keySet()) {
                if (this.matchString(request.getHeader(headerName), headers.get(headerName))) continue;
                return false;
            }
        }
        boolean matched = true;
        Map<String, String> sessionAttributes = rule.getSessionAttributes();
        if (sessionAttributes != null && sessionAttributes.size() != 0) {
            if (session == null) {
                matched = false;
            } else {
                for (String name : sessionAttributes.keySet()) {
                    Object value = session.getAttribute(name);
                    if (value instanceof List) {
                        List list = (List)value;
                        value = list.get(list.size() - 1);
                    }
                    if (value != null && !(value instanceof String)) {
                        matched = false;
                        break;
                    }
                    if (this.matchString((String)value, sessionAttributes.get(name))) continue;
                    matched = false;
                    break;
                }
            }
        }
        return matched;
    }

    protected boolean matchString(String str, String regexp) {
        if (regexp == null && str == null) {
            return true;
        }
        if (regexp != null && str == null || regexp == null && str != null) {
            return false;
        }
        return str.matches(regexp);
    }

    private ApplicationContext getApplicationContext() {
        return WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.servletContext);
    }

    private String listToString(List<String> list) {
        Object str = "";
        int il = list.size();
        for (int i = 0; i < il; ++i) {
            if (i != 0) {
                str = (String)str + ", ";
            }
            str = (String)str + list.get(i);
        }
        return str;
    }

    private String getServerString(HttpServletRequest request) {
        String scheme = request.getScheme();
        int port = request.getServerPort();
        String currentServerContext = "http".equals(scheme) && port == 80 || "https".equals(scheme) && port == 443 ? scheme + "://" + request.getServerName() : scheme + "://" + request.getServerName() + ":" + port;
        return currentServerContext;
    }

    private String resolve(String str) {
        return this.resolve(str, this.properties);
    }

    private String resolve(String str, Map<String, String> propertyMap) {
        if (str == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("\\{(.+?)\\}");
        Matcher matcher = pattern.matcher(str);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            if (!propertyMap.containsKey(matcher.group(1))) continue;
            String replacement = this.resolve(propertyMap.get(matcher.group(1)), propertyMap);
            matcher.appendReplacement(buffer, replacement != null ? Matcher.quoteReplacement(replacement) : "null");
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    private class Rule {
        protected String method;
        protected String path;
        protected Map<String, String> headers;
        protected Map<String, String> sessionAttributes;
        protected List<Action> actions;

        private Rule() {
        }

        public String getMethod() {
            return this.method;
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public void setHeaders(Map<String, String> headers) {
            this.headers = headers;
        }

        public Map<String, String> getSessionAttributes() {
            return this.sessionAttributes;
        }

        public void setSessionAttributes(Map<String, String> sessionAttributes) {
            this.sessionAttributes = sessionAttributes;
        }

        public List<Action> getActions() {
            return this.actions;
        }

        public void setActions(List<Action> actions) {
            this.actions = actions;
        }
    }

    private abstract class Action {
        protected String name;
        protected Map<String, String> params = new HashMap<String, String>();

        private Action() {
        }

        public void setName(String name) {
            this.name = name;
        }

        public void init(Map<String, String> params) throws ServletException {
            this.params = params;
        }

        public abstract void run(HttpServletRequest var1, HttpServletResponse var2, HttpSession var3) throws ServletException;
    }

    private class GenerateTokenAction
    extends Action {
        public static final String PARAM_SESSION = "session";
        public static final String PARAM_COOKIE = "cookie";
        public static final String PARAM_SIZE = "size";
        public static final String PARAM_DELAY = "delay";
        private final String SESSION_ATTRIBUTE_TOKEN_REFRESHED = this.getClass().getName() + ".SESSION_ATTRIBUTE_TOKEN_REFRESHED";
        private final SecureRandom random = new SecureRandom();
        private String session = null;
        private String cookie = null;
        private int size = 5;
        private long delay = 3000L;

        private GenerateTokenAction() {
        }

        @Override
        public void init(Map<String, String> params) throws ServletException {
            super.init(params);
            if (params != null) {
                if (params.containsKey(PARAM_SESSION)) {
                    this.session = params.get(PARAM_SESSION);
                }
                if (params.containsKey(PARAM_COOKIE)) {
                    this.cookie = params.get(PARAM_COOKIE);
                }
                if (params.containsKey(PARAM_SIZE)) {
                    String sizeParam = params.get(PARAM_SIZE);
                    try {
                        this.size = Integer.parseInt(sizeParam);
                    }
                    catch (NumberFormatException nfe) {
                        String message = "Parameter 'size' must be an integer with a value greater or equals to 1.";
                        if (logger.isErrorEnabled()) {
                            logger.error((Object)message);
                        }
                        throw new ServletException(message);
                    }
                    if (this.size < 1) {
                        String message = "Parameter 'size' must be an integer with a value greater than or equal to 1.";
                        if (logger.isErrorEnabled()) {
                            logger.error((Object)message);
                        }
                        throw new ServletException(message);
                    }
                }
                if (params.containsKey(PARAM_DELAY)) {
                    String delayParam = params.get(PARAM_DELAY);
                    try {
                        this.delay = Integer.parseInt(delayParam);
                    }
                    catch (NumberFormatException nfe) {
                        String message = "Parameter 'delay' must be an integer or long.";
                        if (logger.isErrorEnabled()) {
                            logger.error((Object)message);
                        }
                        throw new ServletException(message);
                    }
                }
            }
            if (this.session == null || this.cookie == null) {
                String message = "Parameter 'session' and 'cookie' must be defined.";
                if (logger.isErrorEnabled()) {
                    logger.error((Object)message);
                }
                throw new ServletException(message);
            }
        }

        @Override
        public void run(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, HttpSession httpSession) {
            byte[] bytes = new byte[32];
            this.random.nextBytes(bytes);
            String newToken = Base64.encodeBytes((byte[])bytes);
            if (httpSession != null) {
                List<String> sessionTokens = (List<String>)httpSession.getAttribute(this.session);
                if (sessionTokens == null) {
                    sessionTokens = Collections.synchronizedList(new LinkedList());
                    sessionTokens.add(newToken);
                    httpSession.setAttribute(this.session, sessionTokens);
                    httpSession.setAttribute(this.SESSION_ATTRIBUTE_TOKEN_REFRESHED, (Object)new Date().getTime());
                } else if (httpSession.getAttribute(this.SESSION_ATTRIBUTE_TOKEN_REFRESHED) == null) {
                    httpSession.setAttribute(this.SESSION_ATTRIBUTE_TOKEN_REFRESHED, (Object)new Date().getTime());
                } else {
                    Long now = new Date().getTime();
                    Long tokenRefreshed = (Long)httpSession.getAttribute(this.SESSION_ATTRIBUTE_TOKEN_REFRESHED);
                    if (now > tokenRefreshed + this.delay) {
                        sessionTokens.add(newToken);
                        httpSession.setAttribute(this.SESSION_ATTRIBUTE_TOKEN_REFRESHED, (Object)new Date().getTime());
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Generate token " + httpServletRequest.getMethod() + " " + httpServletRequest.getRequestURI() + " :: '" + newToken + "'"));
                        }
                    } else {
                        return;
                    }
                    if (sessionTokens.size() > this.size) {
                        sessionTokens.subList(0, sessionTokens.size() - this.size).clear();
                    }
                }
            }
            int TIMEOUT = 604800;
            String userCookie = this.cookie + "=" + URLEncoder.encode((String)newToken) + ";";
            userCookie = httpServletRequest.getContextPath().isEmpty() ? userCookie + " Path=/;" : userCookie + " Path=" + httpServletRequest.getContextPath() + ";";
            userCookie = userCookie + " Max-Age=" + TIMEOUT + ";";
            if (CSRFFilter.this.HTTP_SECURED_SESSION_PROP.booleanValue()) {
                userCookie = userCookie + " Secure;";
            }
            if (CSRFFilter.this.COOKIES_SAMESITE != null) {
                userCookie = userCookie + " SameSite=" + CSRFFilter.this.COOKIES_SAMESITE + ";";
            }
            httpServletResponse.addHeader("Set-Cookie", userCookie);
        }
    }

    private class AssertTokenAction
    extends Action {
        public static final String PARAM_SESSION = "session";
        public static final String PARAM_HEADER = "header";
        public static final String PARAM_PARAMETER = "parameter";
        private String session = null;
        private String header = null;
        private String parameter = null;

        private AssertTokenAction() {
        }

        @Override
        public void init(Map<String, String> params) throws ServletException {
            super.init(params);
            if (params != null) {
                if (params.containsKey(PARAM_SESSION)) {
                    this.session = params.get(PARAM_SESSION);
                }
                if (params.containsKey(PARAM_HEADER)) {
                    this.header = params.get(PARAM_HEADER);
                }
                if (params.containsKey(PARAM_PARAMETER)) {
                    this.parameter = params.get(PARAM_PARAMETER);
                }
            }
            if (this.session == null) {
                String message = "Parameter 'session' must be defined.";
                if (logger.isErrorEnabled()) {
                    logger.error((Object)message);
                }
                throw new ServletException(message);
            }
            if (this.header == null && this.parameter == null) {
                String message = "Parameter 'header' or 'parameter' must be defined.";
                if (logger.isErrorEnabled()) {
                    logger.error((Object)message);
                }
                throw new ServletException(message);
            }
        }

        @Override
        public void run(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, HttpSession httpSession) throws ServletException {
            List sessionTokens = null;
            if (httpSession != null) {
                sessionTokens = (List)httpSession.getAttribute(this.session);
            }
            if (this.header != null) {
                String headerToken = httpServletRequest.getHeader(this.header);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Assert token " + httpServletRequest.getMethod() + " " + httpServletRequest.getRequestURI() + " :: session: '" + CSRFFilter.this.listToString(sessionTokens) + "' vs header: '" + headerToken + "'"));
                }
                if (headerToken == null || sessionTokens == null || !sessionTokens.contains(headerToken)) {
                    String message = "Possible CSRF attack noted when comparing token in session and request header. Request: " + httpServletRequest.getMethod() + " " + httpServletRequest.getRequestURI();
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)message);
                    }
                    throw new ServletException(message);
                }
            } else if (this.parameter != null) {
                String parameterToken = httpServletRequest.getParameter(this.parameter);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Assert token " + httpServletRequest.getMethod() + " " + httpServletRequest.getRequestURI() + " :: session: '" + CSRFFilter.this.listToString(sessionTokens) + "' vs parameter: '" + parameterToken + "'"));
                }
                if (parameterToken == null || sessionTokens == null || !sessionTokens.contains(parameterToken)) {
                    String message = "Possible CSRF attack noted when comparing token in session and request parameter. Request: " + httpServletRequest.getMethod() + " " + httpServletRequest.getRequestURI();
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)message);
                    }
                    throw new ServletException(message);
                }
            }
        }
    }

    private class ClearTokenAction
    extends Action {
        public static final String PARAM_SESSION = "session";
        public static final String PARAM_COOKIE = "cookie";
        private String cookie = null;
        private String session = null;

        private ClearTokenAction() {
        }

        @Override
        public void init(Map<String, String> params) throws ServletException {
            super.init(params);
            if (params != null) {
                if (params.containsKey(PARAM_SESSION)) {
                    this.session = params.get(PARAM_SESSION);
                }
                if (params.containsKey(PARAM_COOKIE)) {
                    this.cookie = params.get(PARAM_COOKIE);
                }
            }
            if (this.session == null || this.cookie == null) {
                String message = "Parameter 'session' and 'cookie' must be defined.";
                if (logger.isErrorEnabled()) {
                    logger.error((Object)message);
                }
                throw new ServletException(message);
            }
        }

        @Override
        public void run(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, HttpSession httpSession) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Clear token " + httpServletRequest.getMethod() + " " + httpServletRequest.getRequestURI()));
            }
            if (httpSession != null) {
                httpSession.setAttribute(this.session, null);
            }
            String userCookie = this.cookie + "=;";
            userCookie = userCookie + " Path=" + httpServletRequest.getContextPath() + ";";
            userCookie = userCookie + " Max-Age=0;";
            if (CSRFFilter.this.HTTP_SECURED_SESSION_PROP.booleanValue()) {
                userCookie = userCookie + " Secure;";
            }
            if (CSRFFilter.this.COOKIES_SAMESITE != null) {
                userCookie = userCookie + " SameSite=" + CSRFFilter.this.COOKIES_SAMESITE + ";";
            }
            httpServletResponse.addHeader("Set-Cookie", userCookie);
        }
    }

    private class AssertRefererAction
    extends Action {
        public static final String PARAM_ALWAYS = "always";
        public static final String PARAM_REFERER = "referer";
        public static final String HEADER_REFERER = "Referer";
        private boolean always = false;
        private String referer = null;

        private AssertRefererAction() {
        }

        @Override
        public void init(Map<String, String> params) throws ServletException {
            super.init(params);
            if (params != null) {
                if (params.containsKey(PARAM_ALWAYS)) {
                    String alwaysParam = params.get(PARAM_ALWAYS);
                    if (!alwaysParam.equals("true") && !alwaysParam.equals("false")) {
                        String message = "Parameter 'always' must be a boolean and be set to true or false.";
                        if (logger.isErrorEnabled()) {
                            logger.error((Object)message);
                        }
                        throw new ServletException(message);
                    }
                    this.always = alwaysParam.equals("true");
                }
                if (params.containsKey(PARAM_REFERER)) {
                    this.referer = params.get(PARAM_REFERER);
                }
            }
            if (CSRFFilter.this.globalProperties != null) {
                for (Map.Entry<Object, Object> globalEntry : CSRFFilter.this.globalProperties.entrySet()) {
                    String property = (String)globalEntry.getKey();
                    if (!property.startsWith(CSRFFilter.this.PROPERTY_PREFIX)) continue;
                    if (property.replaceFirst(CSRFFilter.this.PROPERTY_PREFIX, "").equals(PARAM_REFERER)) {
                        this.referer = (String)globalEntry.getValue();
                        continue;
                    }
                    if (!property.replaceFirst(CSRFFilter.this.PROPERTY_PREFIX, "").equals("referer.always")) continue;
                    this.always = Boolean.valueOf((String)globalEntry.getValue());
                }
            }
        }

        @Override
        public void run(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, HttpSession httpSession) throws ServletException {
            String refererServer;
            String refererHeader = httpServletRequest.getHeader(HEADER_REFERER);
            if (refererHeader == null) {
                refererHeader = "";
            }
            Object currentServer = CSRFFilter.this.getServerString(httpServletRequest);
            String string = refererServer = this.params.containsKey(PARAM_REFERER) ? (String)this.params.get(PARAM_REFERER) : null;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Assert referer " + httpServletRequest.getMethod() + " " + httpServletRequest.getRequestURI() + " :: referer: '" + httpServletRequest.getHeader(HEADER_REFERER) + "' vs server & context: " + (String)currentServer + " (string)" + (String)(this.referer != null ? " or " + this.referer + " (regexp)" : "")));
            }
            if (!((String)currentServer).endsWith("/")) {
                currentServer = (String)currentServer + "/";
            }
            if (!refererHeader.isEmpty() || this.always) {
                boolean valid = false;
                if (refererHeader.startsWith((String)currentServer)) {
                    valid = true;
                }
                if (this.referer != null && !this.referer.isEmpty() && refererHeader.matches(this.referer)) {
                    valid = true;
                }
                if (!valid) {
                    String message = "Possible CSRF attack noted when asserting referer header '" + httpServletRequest.getHeader(HEADER_REFERER) + "'. Request: " + httpServletRequest.getMethod() + " " + httpServletRequest.getRequestURI();
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)message);
                    }
                    message = message + ", FAILED TEST: Assert referer " + httpServletRequest.getMethod() + " " + httpServletRequest.getRequestURI() + " :: referer: '" + httpServletRequest.getHeader(HEADER_REFERER) + "' vs server & context: " + (String)currentServer + " (string)" + (String)(refererServer != null ? " or " + refererServer + " (regexp)" : "");
                    throw new ServletException(message);
                }
            }
        }
    }

    private class AssertOriginAction
    extends Action {
        public static final String PARAM_ALWAYS = "always";
        public static final String PARAM_ORIGIN = "origin";
        public static final String HEADER_ORIGIN = "Origin";
        private boolean always = false;
        private String origin = null;

        private AssertOriginAction() {
        }

        @Override
        public void init(Map<String, String> params) throws ServletException {
            super.init(params);
            if (params != null) {
                if (params.containsKey(PARAM_ALWAYS)) {
                    String alwaysParam = params.get(PARAM_ALWAYS);
                    if (!alwaysParam.equals("true") && !alwaysParam.equals("false")) {
                        String message = "Parameter 'always' must be a boolean and be set to true or false.";
                        if (logger.isErrorEnabled()) {
                            logger.error((Object)message);
                        }
                        throw new ServletException(message);
                    }
                    this.always = alwaysParam.equals("true");
                }
                if (params.containsKey(PARAM_ORIGIN)) {
                    this.origin = params.get(PARAM_ORIGIN);
                }
            }
            if (CSRFFilter.this.globalProperties != null) {
                for (Map.Entry<Object, Object> globalEntry : CSRFFilter.this.globalProperties.entrySet()) {
                    String property = (String)globalEntry.getKey();
                    if (!property.startsWith(CSRFFilter.this.PROPERTY_PREFIX)) continue;
                    if (property.replaceFirst(CSRFFilter.this.PROPERTY_PREFIX, "").equals(PARAM_ORIGIN)) {
                        this.origin = (String)globalEntry.getValue();
                        continue;
                    }
                    if (!property.replaceFirst(CSRFFilter.this.PROPERTY_PREFIX, "").equals("origin.always")) continue;
                    this.always = Boolean.valueOf((String)globalEntry.getValue());
                }
            }
        }

        @Override
        public void run(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, HttpSession httpSession) throws ServletException {
            String originHeader = httpServletRequest.getHeader(HEADER_ORIGIN);
            if (originHeader == null) {
                originHeader = "";
            }
            String currentServer = CSRFFilter.this.getServerString(httpServletRequest);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Assert origin " + httpServletRequest.getMethod() + " " + httpServletRequest.getRequestURI() + " :: origin: '" + httpServletRequest.getHeader(HEADER_ORIGIN) + "' vs server: " + currentServer + " (string)" + (String)(this.origin != null ? " or " + this.origin + " (regexp)" : "")));
            }
            if (!originHeader.isEmpty() || this.always) {
                boolean valid = false;
                if (originHeader.startsWith(currentServer)) {
                    valid = true;
                }
                if (this.origin != null && !this.origin.isEmpty() && originHeader.matches(this.origin)) {
                    valid = true;
                }
                if (!valid) {
                    String message = "Possible CSRF attack noted when asserting origin header '" + httpServletRequest.getHeader(HEADER_ORIGIN) + "'. Request: " + httpServletRequest.getMethod() + " " + httpServletRequest.getRequestURI();
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)message);
                    }
                    throw new ServletException(message);
                }
            }
        }
    }

    private class ThrowErrorAction
    extends Action {
        public static final String PARAM_MESSAGE = "message";
        private String message = "Request is not allowed to be executed.";

        private ThrowErrorAction() {
        }

        @Override
        public void init(Map<String, String> params) throws ServletException {
            super.init(params);
            if (params != null && params.containsKey(PARAM_MESSAGE)) {
                this.message = params.get(PARAM_MESSAGE);
            }
        }

        @Override
        public void run(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, HttpSession httpSession) throws ServletException {
            String str = this.message + " Request: " + httpServletRequest.getMethod() + " " + httpServletRequest.getRequestURI();
            if (logger.isInfoEnabled()) {
                logger.info((Object)str);
            }
            throw new ServletException(str);
        }
    }
}

