/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.processor;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.WrapFactory;
import org.mozilla.javascript.WrappedException;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigService;
import org.springframework.extensions.surf.core.scripts.ScriptException;
import org.springframework.extensions.surf.core.scripts.ScriptResourceHelper;
import org.springframework.extensions.surf.core.scripts.ScriptResourceLoader;
import org.springframework.extensions.webscripts.NativeMap;
import org.springframework.extensions.webscripts.ScriptContent;
import org.springframework.extensions.webscripts.ScriptValueConverter;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.processor.AbstractScriptProcessor;
import org.springframework.util.FileCopyUtils;

public class JSScriptProcessor
extends AbstractScriptProcessor
implements ScriptResourceLoader {
    private static final Log logger = LogFactory.getLog(JSScriptProcessor.class);
    private static WrapFactory wrapFactory = new PresentationWrapFactory();
    private static final String PATH_CLASSPATH = "classpath:";
    private Scriptable secureScope;
    private Scriptable nonSecureScope;
    private boolean compile = true;
    private boolean shareSealedScopes = true;
    private Map<String, Script> scriptCache = new ConcurrentHashMap<String, Script>(256);
    private ConfigService configService;
    private Boolean isDebugMode = null;

    public void setConfigService(ConfigService configService) {
        this.configService = configService;
    }

    public void setCompile(boolean compile) {
        this.compile = compile;
    }

    public void setShareSealedScopes(boolean shareSealedScopes) {
        this.shareSealedScopes = shareSealedScopes;
    }

    @Override
    public String getExtension() {
        return "js";
    }

    @Override
    public String getName() {
        return "javascript";
    }

    @Override
    public void init() {
        super.init();
        this.initProcessor();
    }

    @Override
    public ScriptContent findScript(String path) {
        return this.getScriptLoader().getScript(path);
    }

    @Override
    public Object executeScript(String path, Map<String, Object> model) {
        ScriptContent scriptLocation = this.findScript(path);
        if (scriptLocation == null) {
            throw new WebScriptException("Unable to locate script " + path);
        }
        return this.executeScript(scriptLocation, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object executeScript(ScriptContent location, Map<String, Object> model) {
        try {
            String path = location.getPath();
            Script script = null;
            if (this.compile && location.isCachable() && !this.isDebugMode()) {
                script = this.scriptCache.get(path);
            }
            if (script == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Resolving and compiling script path: " + path));
                }
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                FileCopyUtils.copy((InputStream)location.getInputStream(), (OutputStream)os);
                byte[] bytes = os.toByteArray();
                String source = new String(bytes, "UTF-8");
                source = ScriptResourceHelper.resolveScriptImports(source, this, logger);
                Context cx = Context.enter();
                try {
                    script = cx.compileString(source, path, 1, null);
                    if (this.compile && location.isCachable() && !this.isDebugMode()) {
                        this.scriptCache.put(path, script);
                    }
                }
                finally {
                    Context.exit();
                }
            }
            return this.executeScriptImpl(script, model, location.isSecure());
        }
        catch (ScriptException se) {
            throw new WebScriptException("Failed to load script '" + location.toString() + "': " + se.getMessage(), (Throwable)((Object)se));
        }
        catch (Throwable e) {
            throw new WebScriptException("Failed to execute script '" + location.toString() + "': " + e.getMessage(), e);
        }
    }

    @Override
    public String loadScriptResource(String resource) {
        if (resource.startsWith(PATH_CLASSPATH)) {
            try {
                String scriptClasspath = resource.substring(PATH_CLASSPATH.length());
                InputStream stream = this.getClass().getClassLoader().getResource(scriptClasspath).openStream();
                if (stream == null) {
                    throw new ScriptException("Unable to load included script classpath resource: " + resource);
                }
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                FileCopyUtils.copy((InputStream)stream, (OutputStream)os);
                byte[] bytes = os.toByteArray();
                return new String(bytes, "UTF-8");
            }
            catch (IOException err) {
                throw new ScriptException("Unable to load included script classpath resource: " + resource);
            }
        }
        ScriptContent scriptLocation = this.findScript(resource);
        if (scriptLocation == null) {
            throw new ScriptException("Unable to locate script " + resource);
        }
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            FileCopyUtils.copy((InputStream)scriptLocation.getInputStream(), (OutputStream)os);
            byte[] bytes = os.toByteArray();
            return new String(bytes, "UTF-8");
        }
        catch (Throwable e) {
            throw new ScriptException("Failed to load script '" + scriptLocation.toString() + "': " + e.getMessage(), e);
        }
    }

    private Object executeScriptImpl(Script script, Map<String, Object> model, boolean secure) {
        long startTime = 0L;
        if (logger.isDebugEnabled()) {
            startTime = System.nanoTime();
        }
        Context cx = Context.enter();
        cx.setOptimizationLevel(1);
        try {
            Object result;
            Scriptable scope;
            cx.setWrapFactory(wrapFactory);
            if (this.shareSealedScopes) {
                Scriptable sharedScope = secure ? this.nonSecureScope : this.secureScope;
                scope = cx.newObject(sharedScope);
                scope.setPrototype(sharedScope);
                scope.setParentScope(null);
            } else {
                scope = this.initScope(cx, secure, false);
            }
            if (model == null) {
                model = new HashMap<String, Object>();
            }
            this.addProcessorModelExtensions(model);
            for (String key : model.keySet()) {
                Object obj = model.get(key);
                ScriptableObject.putProperty((Scriptable)scope, (String)key, (Object)obj);
            }
            Object object = result = script.exec(cx, scope);
            return object;
        }
        catch (WrappedException w) {
            Throwable err = w.getWrappedException();
            throw new WebScriptException(err.getMessage(), err);
        }
        catch (Throwable e) {
            throw new WebScriptException(e.getMessage(), e);
        }
        finally {
            Context.exit();
            if (logger.isDebugEnabled()) {
                long endTime = System.nanoTime();
                logger.debug((Object)("Time to execute script: " + (float)(endTime - startTime) / 1000000.0f + "ms"));
            }
        }
    }

    @Override
    public Object unwrapValue(Object value) {
        return ScriptValueConverter.unwrapValue(value);
    }

    @Override
    public void reset() {
        this.init();
        this.scriptCache.clear();
    }

    protected void initProcessor() {
        Context cx = Context.enter();
        try {
            cx.setWrapFactory(wrapFactory);
            this.secureScope = this.initScope(cx, false, true);
        }
        finally {
            Context.exit();
        }
        cx = Context.enter();
        try {
            cx.setWrapFactory(wrapFactory);
            this.nonSecureScope = this.initScope(cx, true, true);
        }
        finally {
            Context.exit();
        }
    }

    protected Scriptable initScope(Context cx, boolean secure, boolean sealed) {
        ScriptableObject scope;
        if (secure) {
            scope = new ImporterTopLevel(cx, sealed);
        } else {
            scope = cx.initStandardObjects(null, sealed);
            scope.delete("Packages");
            scope.delete("getClass");
            scope.delete("java");
        }
        return scope;
    }

    protected boolean isDebugMode() {
        if (this.isDebugMode == null) {
            ConfigElement clientDebug;
            ConfigElement flags;
            Config global;
            Boolean debugValue = false;
            if (this.configService != null && (global = this.configService.getGlobalConfig()) != null && (flags = global.getConfigElement("flags")) != null && (clientDebug = flags.getChild("client-debug")) != null) {
                debugValue = Boolean.valueOf(clientDebug.getValue());
            }
            this.isDebugMode = debugValue;
        }
        return this.isDebugMode;
    }

    public static class PresentationWrapFactory
    extends WrapFactory {
        public Scriptable wrapAsJavaObject(Context cx, Scriptable scope, Object javaObject, Class staticType) {
            if (javaObject instanceof Map) {
                return new NativeMap(scope, (Map)javaObject);
            }
            return super.wrapAsJavaObject(cx, scope, javaObject, staticType);
        }
    }
}

