/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.connector;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.springframework.extensions.config.ConfigService;
import org.springframework.extensions.config.RemoteConfigElement;
import org.springframework.extensions.surf.exception.WebScriptsPlatformException;
import org.springframework.extensions.surf.util.Base64;
import org.springframework.extensions.webscripts.connector.AbstractClient;
import org.springframework.extensions.webscripts.connector.HttpMethod;
import org.springframework.extensions.webscripts.connector.Response;
import org.springframework.extensions.webscripts.connector.ResponseStatus;

public class RemoteClient
extends AbstractClient
implements Cloneable {
    private static Log logger = LogFactory.getLog(RemoteClient.class);
    protected static final String GENERIC_ERROR_MESSAGE = "The stack details have been removed for security reasons.";
    protected static final String HEADER_TRANSFER_ENCODING = "Transfer-Encoding";
    protected static final String HEADER_CONTENT_LENGTH = "Content-Length";
    protected static final String HEADER_CONTENT_TYPE = "Content-Type";
    protected static final String HEADER_SET_COOKIE = "Set-Cookie";
    protected static final String HEADER_COOKIE = "Cookie";
    protected static final String HEADER_SERVER = "Server";
    protected static final int DEFAULT_CONNECT_TIMEOUT = 10000;
    protected static final int DEFAULT_READ_TIMEOUT = 120000;
    protected static final int DEFAULT_BUFFERSIZE = 4096;
    protected static final int DEFAULT_MAX_REDIRECTS = 10;
    protected static final int DEFAULT_POOLSIZE = 200;
    protected static final String DEFAULT_TICKET_NAME = "alf_ticket";
    protected static final String DEFAULT_REQUEST_CONTENT_TYPE = "application/octet-stream";
    protected static final String X_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";
    protected static final String CHARSETEQUALS = "charset=";
    private static final String XML_START = "<?xml";
    private static final Pattern XML_ENCODING = Pattern.compile("<\\?xml.*.encoding=\"([^\"]*)\"");
    private static final int XML_ENC_READ_LIMIT = 100;
    private static HttpHost s_httpProxyHost = RemoteClient.createProxyHost("http.proxyHost", "http.proxyPort", 80);
    private static HttpHost s_httpsProxyHost = RemoteClient.createProxyHost("https.proxyHost", "https.proxyPort", 443);
    private PoolingHttpClientConnectionManager connectionManager;
    private ConfigService configService;
    private Map<String, String> cookies;
    private String ticket;
    private String requestContentType = null;
    private HttpMethod requestMethod = HttpMethod.GET;
    private String username;
    private String password;
    private boolean commitResponseOnAuthenticationError = true;
    private boolean exceptionOnError = false;
    private HashMap<String, String> requestProperties = new HashMap(0);
    private HashMap<String, String> requestHeaders = new HashMap(0);
    private String ticketName = "alf_ticket";
    private String defaultEncoding = null;
    private String defaultContentType = "application/octet-stream";
    private int bufferSize = 4096;
    private int connectTimeout = 10000;
    private int readTimeout = 120000;
    private int maxRedirects = 10;
    private int poolSize = 200;
    private boolean allowHttpProxy = true;
    private boolean allowHttpsProxy = true;
    private Set<String> removeRequestHeaders = Collections.emptySet();
    private Set<String> removeResponseHeaders = Collections.emptySet();
    private boolean httpTcpNodelay = true;
    private boolean httpConnectionStalecheck = true;
    public static final int SC_MOVED_TEMPORARILY = 302;
    public static final int SC_MOVED_PERMANENTLY = 301;
    public static final int SC_SEE_OTHER = 303;
    public static final int SC_TEMPORARY_REDIRECT = 307;

    public void init() {
        RemoteConfigElement remoteConfig = (RemoteConfigElement)this.configService.getConfig((Object)"Remote").getConfigElement("remote");
        RemoteConfigElement.SSLConfigDescriptor sslConfigDescriptor = null;
        if (remoteConfig != null) {
            sslConfigDescriptor = remoteConfig.getSSLConfigDescriptor();
        }
        this.connectionManager = sslConfigDescriptor != null && sslConfigDescriptor.getSocketFactoryRegistry() != null ? new PoolingHttpClientConnectionManager(sslConfigDescriptor.getSocketFactoryRegistry()) : new PoolingHttpClientConnectionManager();
        this.connectionManager.setMaxTotal(this.poolSize);
        this.connectionManager.setDefaultMaxPerRoute(this.poolSize);
    }

    public Object clone() throws CloneNotSupportedException {
        RemoteClient clone = (RemoteClient)super.clone();
        clone.allowHttpProxy = this.allowHttpProxy;
        clone.allowHttpsProxy = this.allowHttpsProxy;
        clone.bufferSize = this.bufferSize;
        clone.connectTimeout = this.connectTimeout;
        clone.defaultContentType = this.defaultContentType;
        clone.defaultEncoding = this.defaultEncoding;
        clone.httpConnectionStalecheck = this.httpConnectionStalecheck;
        clone.httpTcpNodelay = this.httpTcpNodelay;
        clone.maxRedirects = this.maxRedirects;
        clone.readTimeout = this.readTimeout;
        clone.readTimeout = this.readTimeout;
        clone.removeRequestHeaders = (Set)((HashSet)this.removeRequestHeaders).clone();
        clone.removeResponseHeaders = (Set)((HashSet)this.removeResponseHeaders).clone();
        clone.requestHeaders = (HashMap)this.requestHeaders.clone();
        clone.ticketName = this.ticketName;
        clone.poolSize = this.poolSize;
        return clone;
    }

    public void setConfigService(ConfigService configService) {
        this.configService = configService;
    }

    public ConfigService getConfigService() {
        return this.configService;
    }

    public void setTicketName(String ticketName) {
        this.ticketName = ticketName;
    }

    public String getTicketName() {
        return this.ticketName;
    }

    public void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    public void setDefaultContentType(String defaultContentType) {
        this.defaultContentType = defaultContentType;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setMaxRedirects(int maxRedirects) {
        this.maxRedirects = maxRedirects;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public void setAllowHttpProxy(boolean allowHttpProxy) {
        this.allowHttpProxy = allowHttpProxy;
    }

    public void setAllowHttpsProxy(boolean allowHttpsProxy) {
        this.allowHttpsProxy = allowHttpsProxy;
    }

    public void setRemoveRequestHeaders(Set<String> removeRequestHeaders) {
        if (removeRequestHeaders != null) {
            this.removeRequestHeaders = new HashSet<String>(removeRequestHeaders.size());
            for (String key : removeRequestHeaders) {
                this.removeRequestHeaders.add(key.toLowerCase());
            }
        }
    }

    public void setRemoveResponseHeaders(Set<String> removeResponseHeaders) {
        if (removeResponseHeaders != null) {
            this.removeResponseHeaders = new HashSet<String>(removeResponseHeaders.size());
            for (String key : removeResponseHeaders) {
                this.removeResponseHeaders.add(key.toLowerCase());
            }
        }
    }

    public void setTicket(String ticket) {
        this.ticket = ticket;
    }

    public String getTicket() {
        return this.ticket;
    }

    public void setUsernamePassword(String user, String pass) {
        this.username = user;
        this.password = pass;
    }

    public void setRequestContentType(String contentType) {
        this.requestContentType = contentType;
    }

    public String getRequestContentType() {
        if (this.requestContentType == null) {
            this.requestContentType = this.defaultContentType;
        }
        return this.requestContentType;
    }

    public void setRequestMethod(HttpMethod method) {
        if (method != null) {
            this.requestMethod = method;
        }
    }

    public HttpMethod getRequestMethod() {
        return this.requestMethod;
    }

    public void setRequestProperties(Map<String, String> requestProperties) {
        if (requestProperties != null) {
            this.requestProperties = new HashMap(requestProperties.size());
            for (String key : requestProperties.keySet()) {
                this.requestProperties.put(key.toLowerCase(), requestProperties.get(key));
            }
        }
    }

    public void setRequestHeaders(Map<String, String> requestHeaders) {
        if (requestHeaders != null) {
            this.requestHeaders = new HashMap(requestHeaders.size());
            for (String key : requestHeaders.keySet()) {
                this.requestHeaders.put(key.toLowerCase(), requestHeaders.get(key));
            }
        }
    }

    public void setCookies(Map<String, String> cookies) {
        this.cookies = cookies;
    }

    public Map<String, String> getCookies() {
        return this.cookies;
    }

    public void setHttpTcpNodelay(boolean httpTcpNodelay) {
        this.httpTcpNodelay = httpTcpNodelay;
    }

    public void setHttpConnectionStalecheck(boolean httpConnectionStalecheck) {
        this.httpConnectionStalecheck = httpConnectionStalecheck;
    }

    public void setCommitResponseOnAuthenticationError(boolean commitResponseOnAuthenticationError) {
        this.commitResponseOnAuthenticationError = commitResponseOnAuthenticationError;
    }

    public void setExceptionOnError(boolean exceptionOnError) {
        this.exceptionOnError = exceptionOnError;
    }

    public Response call(String uri) {
        return this.call(uri, true, null);
    }

    public Response call(String uri, String body) {
        try {
            byte[] bytes = body.getBytes("UTF-8");
            return this.call(uri, true, new ByteArrayInputStream(bytes));
        }
        catch (UnsupportedEncodingException e) {
            throw new WebScriptsPlatformException("Encoding not supported.", e);
        }
    }

    public Response call(String uri, InputStream in) {
        return this.call(uri, true, in);
    }

    public Response call(String uri, boolean buildResponseString, InputStream in) {
        Response result;
        if (in != null && this.requestMethod != HttpMethod.POST && this.requestMethod != HttpMethod.PUT) {
            this.requestMethod = HttpMethod.POST;
        }
        ResponseStatus status = new ResponseStatus();
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream(this.bufferSize);
            String encoding = this.service(this.buildURL(uri), in, bOut, status);
            if (buildResponseString) {
                String data;
                if (encoding != null) {
                    data = bOut.toString(encoding);
                } else {
                    String string = data = this.defaultEncoding != null ? bOut.toString(this.defaultEncoding) : bOut.toString();
                    if (data.startsWith(XML_START)) {
                        Matcher xmlMatcher;
                        String searchXML = data;
                        if (data.length() > 100) {
                            searchXML = data.substring(0, 100);
                        }
                        if ((xmlMatcher = XML_ENCODING.matcher(searchXML)).find()) {
                            data = bOut.toString(xmlMatcher.group(1));
                        }
                    }
                }
                result = new Response(data, status);
            } else {
                result = new Response(new ByteArrayInputStream(bOut.toByteArray()), status);
            }
            result.setEncoding(encoding);
        }
        catch (IOException ioErr) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Error status " + status.getCode() + " " + status.getMessage()), (Throwable)ioErr);
            }
            result = new Response(status);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)("Error status " + status.getCode() + " " + status.getMessage()), e);
            }
            result = new Response(status);
        }
        return result;
    }

    public Response call(String uri, OutputStream out) {
        return this.call(uri, null, out);
    }

    public Response call(String uri, InputStream in, OutputStream out) {
        Response result;
        if (in != null && this.requestMethod != HttpMethod.POST && this.requestMethod != HttpMethod.PUT) {
            this.requestMethod = HttpMethod.POST;
        }
        ResponseStatus status = new ResponseStatus();
        try {
            String encoding = this.service(this.buildURL(uri), in, out, status);
            result = new Response(status);
            result.setEncoding(encoding);
        }
        catch (IOException ioErr) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Error status " + status.getCode() + " " + status.getMessage()), (Throwable)ioErr);
            }
            result = new Response(status);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)("Error status " + status.getCode() + " " + status.getMessage()), e);
            }
            result = new Response(status);
        }
        return result;
    }

    public Response call(String uri, HttpServletRequest req, HttpServletResponse res) {
        Response result;
        ResponseStatus status = new ResponseStatus();
        try {
            boolean isPush = this.requestMethod == HttpMethod.POST || this.requestMethod == HttpMethod.PUT;
            String encoding = this.service(this.buildURL(uri), (InputStream)(isPush ? req.getInputStream() : null), (OutputStream)(res != null ? res.getOutputStream() : null), req, res, status);
            result = new Response(status);
            result.setEncoding(encoding);
        }
        catch (IOException ioErr) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Error status " + status.getCode() + " " + status.getMessage()), (Throwable)ioErr);
            }
            result = new Response(status);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)("Error status " + status.getCode() + " " + status.getMessage()), e);
            }
            result = new Response(status);
        }
        return result;
    }

    protected URL processResponse(URL url, HttpResponse response) throws MalformedURLException {
        String redirectLocation = null;
        for (Header header : response.getAllHeaders()) {
            String headerValue;
            int z;
            String headerName = header.getName();
            if (this.cookies != null && headerName.equalsIgnoreCase(HEADER_SET_COOKIE) && (z = (headerValue = header.getValue()).indexOf(61)) != -1) {
                String cookieName = headerValue.substring(0, z);
                String cookieValue = headerValue.substring(z + 1, headerValue.length());
                int y = cookieValue.indexOf(59);
                if (y != -1) {
                    cookieValue = cookieValue.substring(0, y);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("RemoteClient found Set-Cookie: " + cookieName + " = " + cookieValue));
                }
                this.cookies.put(cookieName, cookieValue);
            }
            if (!headerName.equalsIgnoreCase("Location")) continue;
            switch (response.getStatusLine().getStatusCode()) {
                case 301: 
                case 302: 
                case 303: 
                case 307: {
                    redirectLocation = header.getValue();
                }
            }
        }
        return redirectLocation == null ? null : new URL(url, redirectLocation);
    }

    protected URL buildURL(String uri) throws MalformedURLException {
        String resolvedUri;
        String string = resolvedUri = uri.startsWith(this.endpoint) ? uri : this.endpoint + uri;
        URL url = this.getTicket() == null ? new URL(resolvedUri) : new URL(resolvedUri + (uri.lastIndexOf(63) == -1 ? "?" + this.getTicketName() + "=" + this.getTicket() : "&" + this.getTicketName() + "=" + this.getTicket()));
        return url;
    }

    private String service(URL url, InputStream in, OutputStream out, ResponseStatus status) throws IOException {
        return this.service(url, in, out, null, null, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private String service(URL url, InputStream in, OutputStream out, HttpServletRequest req, HttpServletResponse res, ResponseStatus status) throws IOException {
        boolean trace = logger.isTraceEnabled();
        boolean debug = logger.isDebugEnabled();
        if (debug) {
            logger.debug((Object)("Executing (" + this.requestMethod + ") " + url.toString()));
            if (in != null) {
                logger.debug((Object)" - InputStream supplied - will push...");
            }
            if (out != null) {
                logger.debug((Object)" - OutputStream supplied - will stream response...");
            }
            if (req != null && res != null) {
                logger.debug((Object)" - Full Proxy mode between servlet request and response...");
            }
        }
        HttpClient httpClient = this.createHttpClient(url);
        URL redirectURL = url;
        HttpGet method = null;
        int retries = 0;
        int maxRetries = in == null ? this.maxRedirects : 1;
        try {
            int csi;
            void var17_32;
            HttpResponse response;
            do {
                boolean urlencoded;
                Object headers;
                if (method != null) {
                    method.reset();
                    method = null;
                }
                switch (this.requestMethod) {
                    default: {
                        method = new HttpGet(redirectURL.toString());
                        break;
                    }
                    case PUT: {
                        method = new HttpPut(redirectURL.toString());
                        break;
                    }
                    case POST: {
                        method = new HttpPost(redirectURL.toString());
                        break;
                    }
                    case DELETE: {
                        method = new HttpDelete(redirectURL.toString());
                        break;
                    }
                    case HEAD: {
                        method = new HttpHead(redirectURL.toString());
                        break;
                    }
                    case OPTIONS: {
                        method = new HttpOptions(redirectURL.toString());
                    }
                }
                if (req != null) {
                    headers = req.getHeaderNames();
                    while (headers.hasMoreElements()) {
                        Object key = (String)headers.nextElement();
                        if (key == null || this.removeRequestHeaders.contains(key = ((String)key).toLowerCase()) || this.requestProperties.containsKey(key) || this.requestHeaders.containsKey(key)) continue;
                        method.setHeader((String)key, req.getHeader((String)key));
                        if (!trace) continue;
                        logger.trace((Object)("Proxy request header: " + (String)key + "=" + req.getHeader((String)key)));
                    }
                }
                headers = (Map)this.requestHeaders.clone();
                headers.putAll(this.requestProperties);
                if (headers.size() != 0) {
                    for (Map.Entry entry : headers.entrySet()) {
                        String headerName = (String)entry.getKey();
                        String headerValue = (String)headers.get(headerName);
                        if (headerValue != null) {
                            method.setHeader(headerName, headerValue);
                        }
                        if (!trace) continue;
                        logger.trace((Object)("Set request header: " + headerName + "=" + headerValue));
                    }
                }
                if (this.cookies != null && !this.cookies.isEmpty()) {
                    StringBuilder builder = new StringBuilder(128);
                    for (Map.Entry<String, String> entry2 : this.cookies.entrySet()) {
                        if (builder.length() != 0) {
                            builder.append(';');
                        }
                        builder.append(entry2.getKey());
                        builder.append('=');
                        builder.append(entry2.getValue());
                    }
                    String string = builder.toString();
                    if (debug) {
                        logger.debug((Object)("Setting Cookie header: " + string));
                    }
                    method.setHeader(HEADER_COOKIE, string);
                }
                if (this.username != null && this.password != null) {
                    String auth = this.username + ":" + this.password;
                    method.addHeader("Authorization", "Basic " + Base64.encodeBytes((byte[])auth.getBytes(), (int)8));
                    if (debug) {
                        logger.debug((Object)("Applied HTTP Basic Authorization for user: " + this.username));
                    }
                }
                if (in == null) continue;
                method.setHeader(HEADER_CONTENT_TYPE, this.getRequestContentType());
                if (debug) {
                    logger.debug((Object)("Set Content-Type=" + this.getRequestContentType()));
                }
                if (!(urlencoded = this.getRequestContentType().startsWith(X_WWW_FORM_URLENCODED))) {
                    String contentLengthStr;
                    long l = -1L;
                    if (req != null && (contentLengthStr = req.getHeader(HEADER_CONTENT_LENGTH)) != null) {
                        try {
                            long actualContentLength = Long.parseLong(contentLengthStr);
                            if (actualContentLength > 0L) {
                                l = actualContentLength;
                            }
                        }
                        catch (NumberFormatException e) {
                            logger.warn((Object)("Can't parse 'Content-Length' header from '" + contentLengthStr + "'. The contentLength is set to -1"));
                        }
                    }
                    if (debug) {
                        logger.debug((Object)(this.requestMethod + " entity Content-Length=" + l));
                    }
                    method.removeHeaders(HEADER_CONTENT_LENGTH);
                    try {
                        InputStreamEntity entity = new InputStreamEntity(in, l);
                        ((HttpEntityEnclosingRequest)method).setEntity((HttpEntity)(l == -1L || l > 16384L ? entity : new BufferedHttpEntity((HttpEntity)entity)));
                        ((HttpEntityEnclosingRequest)method).setHeader("Expect", "100-continue");
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e.getMessage(), e);
                    }
                }
                if (req != null) {
                    Map map = req.getParameterMap();
                    if (map != null) {
                        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>(map.size());
                        for (String key : map.keySet()) {
                            String[] values = (String[])map.get(key);
                            for (int i = 0; i < values.length; ++i) {
                                params.add(new BasicNameValuePair(key, values[i]));
                            }
                        }
                        ((HttpEntityEnclosingRequest)method).setEntity((HttpEntity)new UrlEncodedFormEntity(params));
                    }
                    method.removeHeaders(HEADER_CONTENT_LENGTH);
                    continue;
                }
                InputStreamEntity inputStreamEntity = new InputStreamEntity(in, -1L);
                ((HttpEntityEnclosingRequest)method).setEntity((HttpEntity)inputStreamEntity);
                ((HttpEntityEnclosingRequest)method).setHeader("Expect", "100-continue");
            } while ((redirectURL = this.processResponse(redirectURL, response = httpClient.execute((HttpUriRequest)method))) != null && ++retries < maxRetries);
            int responseCode = response.getStatusLine().getStatusCode();
            if (responseCode >= 500 && this.exceptionOnError) {
                this.buildProxiedServerError(response);
            } else if (responseCode == 503) {
                throw new ConnectException(response.toString());
            }
            boolean allowResponseCommit = responseCode != 401 || this.commitResponseOnAuthenticationError;
            status.setCode(responseCode);
            if (debug) {
                logger.debug((Object)("Response status code: " + responseCode));
            }
            Object var17_31 = null;
            Header contentLength = null;
            for (Header header : response.getAllHeaders()) {
                String key = header.getName();
                if (key == null) continue;
                if (!key.equalsIgnoreCase(HEADER_SERVER) && !key.equalsIgnoreCase(HEADER_TRANSFER_ENCODING)) {
                    if (res != null && allowResponseCommit && !this.removeResponseHeaders.contains(key.toLowerCase())) {
                        res.setHeader(key, header.getValue());
                    }
                    status.setHeader(key, header.getValue());
                    if (trace) {
                        logger.trace((Object)("Response header: " + key + "=" + header.getValue()));
                    }
                }
                if (var17_32 == null && key.equalsIgnoreCase(HEADER_CONTENT_TYPE)) {
                    Header header2 = header;
                    this.processContentType(url, res, header2);
                    continue;
                }
                if (contentLength != null || !key.equalsIgnoreCase(HEADER_CONTENT_LENGTH)) continue;
                contentLength = header;
            }
            String encoding = null;
            String ct = null;
            if (var17_32 != null && (csi = (ct = var17_32.getValue()).indexOf(CHARSETEQUALS)) != -1) {
                encoding = ct.substring(csi + CHARSETEQUALS.length());
                if ((csi = encoding.lastIndexOf(59)) != -1) {
                    encoding = encoding.substring(0, csi);
                }
                if (debug) {
                    logger.debug((Object)("Response charset: " + encoding));
                }
            }
            if (debug) {
                logger.debug((Object)("Response encoding: " + (Header)var17_32));
            }
            if (res != null && responseCode == 401 && allowResponseCommit) {
                res.sendError(responseCode, response.getStatusLine().getReasonPhrase());
            } else {
                long length;
                if (res != null && allowResponseCommit) {
                    res.setStatus(responseCode);
                }
                int bufferSize = this.bufferSize;
                if (contentLength != null && (length = Long.parseLong(contentLength.getValue())) < (long)bufferSize) {
                    bufferSize = (int)length;
                }
                this.copyResponseStreamOutput(url, res, out, response, ct, bufferSize);
            }
            String string = encoding;
            return string;
        }
        catch (SocketTimeoutException | ConnectTimeoutException timeErr) {
            logger.info((Object)("Exception calling (" + this.requestMethod + ") " + url.toString()), timeErr);
            status.setCode(408);
            status.setException(new RuntimeException(GENERIC_ERROR_MESSAGE));
            status.setMessage(GENERIC_ERROR_MESSAGE);
            if (res != null) {
                res.sendError(408, GENERIC_ERROR_MESSAGE);
            }
            throw timeErr;
        }
        catch (ConnectException | UnknownHostException hostErr) {
            logger.info((Object)("Exception calling (" + this.requestMethod + ") " + url.toString()), (Throwable)hostErr);
            status.setCode(503);
            status.setException(new RuntimeException(GENERIC_ERROR_MESSAGE));
            status.setMessage(GENERIC_ERROR_MESSAGE);
            if (res != null) {
                res.sendError(503, GENERIC_ERROR_MESSAGE);
            }
            throw hostErr;
        }
        catch (IOException ioErr) {
            logger.info((Object)("Exception calling (" + this.requestMethod + ") " + url.toString()), (Throwable)ioErr);
            status.setCode(500);
            status.setException(new RuntimeException(GENERIC_ERROR_MESSAGE));
            status.setMessage(GENERIC_ERROR_MESSAGE);
            if (res != null) {
                res.sendError(500, GENERIC_ERROR_MESSAGE);
            }
            throw ioErr;
        }
        catch (RuntimeException e) {
            logger.debug((Object)("Exception calling (" + this.requestMethod + ") " + url.toString()), (Throwable)e);
            status.setCode(500);
            status.setException(new RuntimeException(GENERIC_ERROR_MESSAGE));
            status.setMessage(GENERIC_ERROR_MESSAGE);
            if (res != null) {
                res.sendError(500, GENERIC_ERROR_MESSAGE);
            }
            String string = null;
            return string;
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
            this.setRequestContentType(null);
            this.requestMethod = HttpMethod.GET;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyResponseStreamOutput(URL url, HttpServletResponse res, OutputStream out, HttpResponse response, String contentType, int bufferSize) throws IOException {
        boolean responseCommit = false;
        boolean trace = logger.isTraceEnabled();
        StringBuilder traceBuf = null;
        if (trace) {
            traceBuf = new StringBuilder(bufferSize);
        }
        if (response.getEntity() != null) {
            InputStream input = response.getEntity().getContent();
            try {
                byte[] buffer = new byte[bufferSize];
                int read = input.read(buffer);
                if (read != -1) {
                    responseCommit = true;
                }
                while (read != -1) {
                    if (out != null) {
                        out.write(buffer, 0, read);
                    }
                    if (trace && contentType != null && (contentType.startsWith("text/") || contentType.startsWith("application/json"))) {
                        traceBuf.append(new String(buffer, 0, read));
                    }
                    read = input.read(buffer);
                }
            }
            finally {
                block21: {
                    if (trace && traceBuf.length() != 0) {
                        logger.trace((Object)("Output (" + traceBuf.length() + " bytes) from: " + url.toString()));
                        logger.trace((Object)traceBuf.toString());
                    }
                    try {
                        try {
                            input.close();
                        }
                        finally {
                            if (responseCommit && out != null) {
                                out.close();
                            }
                        }
                    }
                    catch (IOException e) {
                        if (!logger.isWarnEnabled()) break block21;
                        logger.warn((Object)"Exception during close() of HTTP API connection", (Throwable)e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildProxiedServerError(HttpResponse response) {
        ByteArrayOutputStream out;
        block15: {
            boolean gzip = false;
            for (Header header : response.getAllHeaders()) {
                if (!header.getName().equalsIgnoreCase("Content-Encoding")) continue;
                gzip = header.getValue().contains("gzip");
            }
            out = new ByteArrayOutputStream(512);
            try {
                if (response.getEntity() == null) break block15;
                InputStream input = response.getEntity().getContent();
                if (gzip) {
                    input = new GZIPInputStream(input);
                }
                try {
                    byte[] buffer = new byte[this.bufferSize];
                    int read = input.read(buffer);
                    while (read != -1) {
                        if (out != null) {
                            out.write(buffer, 0, read);
                        }
                        read = input.read(buffer);
                    }
                }
                finally {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            throw new WebScriptsPlatformException(out.toString("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return;
        }
    }

    protected void processContentType(URL url, HttpServletResponse res, Header contentType) {
    }

    protected HttpClient createHttpClient(URL url) {
        DefaultProxyRoutePlanner routePlanner = null;
        if (s_httpProxyHost != null && this.allowHttpProxy && url.getProtocol().equals("http") && this.requiresProxy(url.getHost())) {
            routePlanner = new DefaultProxyRoutePlanner(s_httpProxyHost);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(" - using HTTP proxy host for: " + url));
            }
        } else if (s_httpsProxyHost != null && this.allowHttpsProxy && url.getProtocol().equals("https") && this.requiresProxy(url.getHost())) {
            routePlanner = new DefaultProxyRoutePlanner(s_httpsProxyHost);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(" - using HTTPS proxy host for: " + url));
            }
        }
        return HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)this.connectionManager).setRoutePlanner(routePlanner).setRedirectStrategy(new RedirectStrategy(){

            public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
                return false;
            }

            public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
                return null;
            }
        }).setDefaultRequestConfig(RequestConfig.custom().setStaleConnectionCheckEnabled(this.httpConnectionStalecheck).setConnectTimeout(this.connectTimeout).setSocketTimeout(this.readTimeout).build()).build();
    }

    protected static HttpHost createProxyHost(String hostProperty, String portProperty, int defaultPort) {
        String proxyHost = System.getProperty(hostProperty);
        HttpHost proxy = null;
        if (proxyHost != null && proxyHost.length() != 0) {
            String strProxyPort = System.getProperty(portProperty);
            proxy = strProxyPort == null || strProxyPort.length() == 0 ? new HttpHost(proxyHost, defaultPort) : new HttpHost(proxyHost, Integer.parseInt(strProxyPort));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("ProxyHost: " + proxy.toString()));
            }
        }
        return proxy;
    }

    private boolean requiresProxy(String targetHost) {
        boolean requiresProxy = true;
        String nonProxyHosts = System.getProperty("http.nonProxyHosts");
        if (nonProxyHosts != null) {
            StringTokenizer tokenizer = new StringTokenizer(nonProxyHosts, "|");
            while (tokenizer.hasMoreTokens()) {
                String pattern = tokenizer.nextToken();
                if (!targetHost.matches(pattern = pattern.replaceAll("\\.", "\\\\.").replaceAll("\\*", ".*"))) continue;
                requiresProxy = false;
                break;
            }
        }
        return requiresProxy;
    }
}

