/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.connector;

import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.exception.AuthenticationException;
import org.springframework.extensions.surf.util.URLEncoder;
import org.springframework.extensions.webscripts.connector.AbstractAuthenticator;
import org.springframework.extensions.webscripts.connector.ConnectorSession;
import org.springframework.extensions.webscripts.connector.Credentials;
import org.springframework.extensions.webscripts.connector.RemoteClient;
import org.springframework.extensions.webscripts.connector.Response;

public class ActivitiAuthenticator
extends AbstractAuthenticator {
    private static Log logger = LogFactory.getLog(ActivitiAuthenticator.class);
    private static final String API_LOGIN = "/authentication";
    private static final String FORM_LOGIN = "j_username={0}&j_password={1}&_spring_security_remember_me=true&submit=Login";
    private static final String MIMETYPE_FORM_URLENCODED = "application/x-www-form-urlencoded";

    @Override
    public ConnectorSession authenticate(String endpoint, Credentials credentials, ConnectorSession connectorSession) throws AuthenticationException {
        String pass;
        String user;
        ConnectorSession cs = null;
        if (credentials != null && (user = (String)credentials.getProperty("cleartextUsername")) != null && (pass = (String)credentials.getProperty("cleartextPassword")) != null) {
            RemoteClient remoteClient = this.buildRemoteClient(endpoint);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Authenticating Activiti user: " + user));
            }
            remoteClient.setRequestContentType(MIMETYPE_FORM_URLENCODED);
            String body = MessageFormat.format(FORM_LOGIN, URLEncoder.encode((String)user), URLEncoder.encode((String)pass));
            Response response = remoteClient.call(API_LOGIN, body);
            if (response.getStatus().getCode() == 200) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"200 status received - storing auth cookie...");
                }
                this.processResponse(response, connectorSession);
                cs = connectorSession;
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("Authentication failed, received response code: " + response.getStatus().getCode()));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)"No user credentials available - cannot authenticate.");
        }
        return cs;
    }

    @Override
    public boolean isAuthenticated(String endpoint, ConnectorSession connectorSession) {
        return connectorSession.getCookieNames().length != 0;
    }
}

