/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.ServerProperties;
import org.springframework.extensions.surf.util.Content;
import org.springframework.extensions.surf.util.InputStreamContent;
import org.springframework.extensions.surf.util.URLDecoder;
import org.springframework.extensions.webscripts.Match;
import org.springframework.extensions.webscripts.Runtime;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequestImpl;
import org.springframework.extensions.webscripts.servlet.FormData;

public class WebScriptServletRequest
extends WebScriptRequestImpl {
    private static final Log logger = LogFactory.getLog(WebScriptServletRequest.class);
    private static final String HEADER_ALF_FORCE_SUCCESS_RESPONSE = "alf-force-success-response";
    private static final String HEADER_USER_AGENT = "user-agent";
    private ServerProperties serverProperties;
    private HttpServletRequest req;
    private Match serviceMatch;
    private FormData formData;
    private Content content = null;

    public WebScriptServletRequest(Runtime container, HttpServletRequest req, Match serviceMatch, ServerProperties serverProperties) {
        super(container);
        this.serverProperties = serverProperties;
        this.req = req;
        this.serviceMatch = serviceMatch;
        String contentType = this.getContentType();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Content Type: " + contentType));
        }
        if (contentType != null && contentType.equals("multipart/form-data") && serviceMatch != null && serviceMatch.getWebScript().getDescription().getMultipartProcessing()) {
            this.formData = (FormData)this.parseContent();
        }
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.req;
    }

    @Override
    public Match getServiceMatch() {
        return this.serviceMatch;
    }

    @Override
    public String getServerPath() {
        return this.getServerScheme() + "://" + this.getServerName() + ":" + this.getServerPort();
    }

    @Override
    public String getContextPath() {
        return this.req.getContextPath();
    }

    @Override
    public String getServiceContextPath() {
        return this.req.getContextPath() + this.req.getServletPath();
    }

    @Override
    public String getServicePath() {
        String pathInfo = this.getPathInfo();
        return this.getServiceContextPath() + (pathInfo == null ? "" : pathInfo);
    }

    @Override
    public String getURL() {
        String queryString = this.getQueryString();
        if (queryString != null) {
            return this.getServicePath() + "?" + queryString;
        }
        return this.getServicePath();
    }

    @Override
    public String getPathInfo() {
        String requestURI = this.req.getRequestURI();
        String serviceContextPath = this.getServiceContextPath();
        String pathInfo = serviceContextPath.length() > requestURI.length() ? this.req.getPathInfo() : URLDecoder.decode((String)requestURI.substring(serviceContextPath.length()));
        return pathInfo;
    }

    @Override
    public String getQueryString() {
        String queryString = this.req.getQueryString();
        if (queryString != null) {
            queryString = URLDecoder.decode((String)queryString);
        }
        return queryString;
    }

    @Override
    public String[] getParameterNames() {
        Set keys = this.req.getParameterMap().keySet();
        if (this.formData != null) {
            Set<String> formkeys = this.formData.getParameters().keySet();
            keys = new HashSet(keys);
            keys.addAll(formkeys);
        }
        String[] names = new String[keys.size()];
        keys.toArray(names);
        return names;
    }

    @Override
    public String getParameter(String name) {
        String val = null;
        if (this.formData != null) {
            String[] vals = this.formData.getParameters().get(name);
            String string = val = vals == null ? null : vals[0];
        }
        if (val == null) {
            val = this.req.getParameter(name);
        }
        return val;
    }

    @Override
    public String[] getParameterValues(String name) {
        String[] vals = null;
        if (this.formData != null) {
            vals = this.formData.getParameters().get(name);
        }
        if (vals == null) {
            vals = this.req.getParameterValues(name);
        }
        return vals;
    }

    @Override
    public String[] getHeaderNames() {
        ArrayList<String> headersList = new ArrayList<String>();
        Enumeration enumNames = this.req.getHeaderNames();
        while (enumNames.hasMoreElements()) {
            headersList.add((String)enumNames.nextElement());
        }
        String[] headers = new String[headersList.size()];
        headersList.toArray(headers);
        return headers;
    }

    @Override
    public String getHeader(String name) {
        return this.req.getHeader(name);
    }

    @Override
    public String[] getHeaderValues(String name) {
        String[] values = null;
        Enumeration enumValues = this.req.getHeaders(name);
        if (enumValues.hasMoreElements()) {
            ArrayList<String> valuesList = new ArrayList<String>(2);
            do {
                valuesList.add((String)enumValues.nextElement());
            } while (enumValues.hasMoreElements());
            values = new String[valuesList.size()];
            valuesList.toArray(values);
        }
        return values;
    }

    @Override
    public String getAgent() {
        return WebScriptServletRequest.resolveUserAgent(this.req.getHeader(HEADER_USER_AGENT));
    }

    public static String resolveUserAgent(String userAgent) {
        if (userAgent != null) {
            if (userAgent.indexOf("Firefox/") != -1) {
                return "Firefox";
            }
            if (userAgent.indexOf("MSIE") != -1) {
                return "MSIE";
            }
        }
        return null;
    }

    @Override
    public Content getContent() {
        if (this.content == null) {
            try {
                this.content = new InputStreamContent((InputStream)this.req.getInputStream(), this.getContentType(), this.req.getCharacterEncoding());
            }
            catch (IOException e) {
                throw new WebScriptException("Failed to retrieve request content", e);
            }
        }
        return this.content;
    }

    @Override
    public String getContentType() {
        String contentType = this.req.getContentType();
        if (contentType == null || contentType.length() == 0) {
            contentType = super.getContentType();
        }
        if (contentType != null && contentType.startsWith("multipart/form-data")) {
            contentType = "multipart/form-data";
        }
        return contentType;
    }

    private String getServerScheme() {
        String scheme = null;
        if (this.serverProperties != null) {
            scheme = this.serverProperties.getScheme();
        }
        if (scheme == null) {
            scheme = this.req.getScheme();
        }
        return scheme;
    }

    private String getServerName() {
        String name = null;
        if (this.serverProperties != null) {
            name = this.serverProperties.getHostName();
        }
        if (name == null) {
            name = this.req.getServerName();
        }
        return name;
    }

    private int getServerPort() {
        Integer port = null;
        if (this.serverProperties != null) {
            port = this.serverProperties.getPort();
        }
        if (port == null) {
            port = this.req.getServerPort();
        }
        return port;
    }

    public FormData.FormField getFileField(String name) {
        FormData.FormField[] fields;
        FormData.FormField field = null;
        for (FormData.FormField f : fields = this.formData.getFields()) {
            if (!f.getName().equals(name)) continue;
            if (!f.getIsFile()) break;
            field = f;
            break;
        }
        return field;
    }

    @Override
    public boolean forceSuccessStatus() {
        String forceSuccess = this.req.getHeader(HEADER_ALF_FORCE_SUCCESS_RESPONSE);
        return Boolean.valueOf(forceSuccess);
    }

    public String toString() {
        return this.getURL();
    }
}

