/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.servlet;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigService;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SecurityHeadersFilter
implements Filter {
    private static Log logger = LogFactory.getLog(SecurityHeadersFilter.class);
    private ServletContext servletContext = null;
    private Boolean enabled = true;
    private List<Header> headers = new LinkedList<Header>();

    public void init(FilterConfig config) throws ServletException {
        this.servletContext = config.getServletContext();
        ApplicationContext context = this.getApplicationContext();
        ConfigService configService = (ConfigService)context.getBean("web.config");
        Config securityHeadersConfig = configService.getConfig((Object)"SecurityHeadersPolicy");
        if (securityHeadersConfig == null) {
            this.enabled = false;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"There is no 'SecurityHeadersPolicy' config, no headers will be added.");
            }
        } else {
            ConfigElement headersConfig = securityHeadersConfig.getConfigElement("headers");
            if (headersConfig == null) {
                this.enabled = false;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"The 'SecurityHeadersPolicy' config had no headers, no headers will be added.");
                }
            } else {
                List headersConfigList = headersConfig.getChildren("header");
                if (headersConfigList == null || headersConfigList.size() == 0) {
                    this.enabled = false;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"The 'SecurityHeadersPolicy' headers config was empty, no headers will be added.");
                    }
                } else {
                    HashMap<String, Header> allHeaders = new HashMap<String, Header>();
                    for (ConfigElement headerConfig : headersConfigList) {
                        ConfigElement enabledConfig;
                        Header header;
                        String name = headerConfig.getChildValue("name");
                        if (allHeaders.containsKey(name)) {
                            header = (Header)allHeaders.get(name);
                        } else {
                            header = new Header();
                            header.setName(name);
                            allHeaders.put(name, header);
                        }
                        ConfigElement valueConfig = headerConfig.getChild("value");
                        if (valueConfig != null) {
                            header.setValue(valueConfig.getValue());
                        }
                        if ((enabledConfig = headerConfig.getChild("enabled")) == null) continue;
                        String enabled = enabledConfig.getValue();
                        header.setEnabled(enabled == null || enabled.equalsIgnoreCase("true"));
                    }
                    for (Header header : allHeaders.values()) {
                        if (!header.getEnabled().booleanValue()) continue;
                        this.headers.add(header);
                    }
                }
            }
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (this.enabled.booleanValue() && servletRequest instanceof HttpServletRequest && servletResponse instanceof HttpServletResponse) {
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            for (Header header : this.headers) {
                response.setHeader(header.getName(), header.getValue());
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }

    private ApplicationContext getApplicationContext() {
        return WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.servletContext);
    }

    private class Header {
        private String name;
        private String value;
        private Boolean enabled = true;

        private Header() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }
    }
}

