/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.connector;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.exception.AuthenticationException;
import org.springframework.extensions.webscripts.connector.Authenticator;
import org.springframework.extensions.webscripts.connector.Connector;
import org.springframework.extensions.webscripts.connector.ConnectorContext;
import org.springframework.extensions.webscripts.connector.ConnectorSession;
import org.springframework.extensions.webscripts.connector.Credentials;
import org.springframework.extensions.webscripts.connector.EndpointManager;
import org.springframework.extensions.webscripts.connector.Response;

public class AuthenticatingConnector
implements Connector {
    private static Log endpointLogger = LogFactory.getLog(EndpointManager.class);
    protected static Log logger = LogFactory.getLog(AuthenticatingConnector.class);
    protected Connector connector = null;
    protected Authenticator authenticator = null;

    public AuthenticatingConnector(Connector connector, Authenticator authenticator) {
        this.connector = connector;
        this.authenticator = authenticator;
    }

    @Override
    public Response call(String uri) {
        Response response = null;
        boolean handshake = false;
        boolean firstcall = true;
        if (this.isAuthenticated()) {
            response = this.connector.call(uri);
            firstcall = false;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Received " + response.getStatus().getCode() + " on first call to: " + uri));
            }
            if (response.getStatus().getCode() == 401) {
                handshake = true;
            }
        } else {
            handshake = true;
        }
        if (handshake) {
            this.handshake();
            response = this.connector.call(uri);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Received " + response.getStatus().getCode() + " on " + (firstcall ? "first" : "second") + " call to: " + uri));
            }
        }
        return response;
    }

    @Override
    public Response call(String uri, ConnectorContext context) {
        Response response = null;
        boolean handshake = false;
        boolean firstcall = true;
        if (this.isAuthenticated()) {
            response = this.connector.call(uri, context);
            firstcall = false;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Received " + response.getStatus().getCode() + " on first call to: " + uri));
            }
            if (response.getStatus().getCode() == 401) {
                handshake = true;
            }
        } else {
            handshake = true;
        }
        if (handshake) {
            this.handshake();
            response = this.connector.call(uri, context);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Received " + response.getStatus().getCode() + " on " + (firstcall ? "first" : "second") + " call to: " + uri));
            }
        }
        return response;
    }

    @Override
    public Response call(String uri, ConnectorContext context, InputStream in) {
        Response response = null;
        boolean handshake = false;
        boolean firstcall = true;
        if (this.isAuthenticated()) {
            response = this.connector.call(uri, context, in);
            firstcall = false;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Received " + response.getStatus().getCode() + " on first call to: " + uri));
            }
            if (response.getStatus().getCode() == 401) {
                handshake = true;
            }
        } else {
            handshake = true;
        }
        if (handshake) {
            this.handshake();
            if (in.markSupported()) {
                try {
                    in.reset();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            response = this.connector.call(uri, context, in);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Received " + response.getStatus().getCode() + " on " + (firstcall ? "first" : "second") + " call to: " + uri));
            }
        }
        return response;
    }

    @Override
    public Response call(String uri, ConnectorContext context, InputStream in, OutputStream out) {
        Response response = null;
        boolean handshake = false;
        boolean firstcall = true;
        if (this.isAuthenticated()) {
            context.setCommitResponseOnAuthenticationError(false);
            response = this.connector.call(uri, context, in, out);
            firstcall = false;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Received " + response.getStatus().getCode() + " on first call to: " + uri));
            }
            if (response.getStatus().getCode() == 401) {
                handshake = true;
            }
        } else {
            handshake = true;
        }
        if (handshake) {
            this.handshake();
            if (in.markSupported()) {
                try {
                    in.reset();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            context.setCommitResponseOnAuthenticationError(true);
            response = this.connector.call(uri, context, in, out);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Received " + response.getStatus().getCode() + " on " + (firstcall ? "first" : "second") + " call to: " + uri));
            }
        }
        return response;
    }

    @Override
    public Response call(String uri, ConnectorContext context, HttpServletRequest req, HttpServletResponse res) {
        Response response = null;
        boolean handshake = false;
        boolean firstcall = true;
        if (this.isAuthenticated()) {
            context.setCommitResponseOnAuthenticationError(false);
            response = this.connector.call(uri, context, req, res);
            firstcall = false;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Received " + response.getStatus().getCode() + " on first call to: " + uri));
            }
            if (response.getStatus().getCode() == 401) {
                handshake = true;
            }
        } else {
            handshake = true;
        }
        if (handshake) {
            this.handshake();
            context.setCommitResponseOnAuthenticationError(true);
            response = this.connector.call(uri, context, req, res);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Received " + response.getStatus().getCode() + " on " + (firstcall ? "first" : "second") + " call to: " + uri));
            }
        }
        return response;
    }

    @Override
    public void setCredentials(Credentials credentials) {
        this.connector.setCredentials(credentials);
    }

    @Override
    public Credentials getCredentials() {
        return this.connector.getCredentials();
    }

    @Override
    public void setEndpoint(String endpoint) {
        this.connector.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        return this.connector.getEndpoint();
    }

    @Override
    public void setConnectorSession(ConnectorSession connectorSession) {
        this.connector.setConnectorSession(connectorSession);
    }

    @Override
    public ConnectorSession getConnectorSession() {
        return this.connector.getConnectorSession();
    }

    protected boolean isAuthenticated() {
        return this.authenticator.isAuthenticated(this.getEndpoint(), this.getConnectorSession());
    }

    public final boolean handshake() {
        boolean success = false;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Performing authentication handshake");
        }
        if (EndpointManager.allowConnect(this.getEndpoint())) {
            ConnectorSession cs = null;
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Authentication handshake using credentials: " + this.getCredentials()));
                    logger.debug((Object)("Authentication handshake using connectorSession: " + this.getConnectorSession()));
                }
                cs = this.authenticator.authenticate(this.getEndpoint(), this.getCredentials(), this.getConnectorSession());
            }
            catch (AuthenticationException ae) {
                logger.error((Object)("An exception occurred while attempting authentication handshake for endpoint: " + this.getEndpoint()), (Throwable)ae);
            }
            if (cs != null) {
                this.setConnectorSession(cs);
                success = true;
            }
        } else if (endpointLogger.isInfoEnabled()) {
            endpointLogger.info((Object)("Throttled authentication handshake, waiting for reconnect timeout on: " + this.getEndpoint()));
        }
        return success;
    }

    public String toString() {
        return this.connector.toString();
    }
}

