/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.util.Collections;
import java.util.Map;
import org.springframework.extensions.surf.exception.PlatformRuntimeException;
import org.springframework.extensions.webscripts.StatusTemplate;
import org.springframework.extensions.webscripts.StatusTemplateFactory;

public class WebScriptException
extends PlatformRuntimeException
implements StatusTemplateFactory {
    private static final long serialVersionUID = -7338963365877285084L;
    private int status = 500;
    private StatusTemplateFactory statusTemplateFactory;

    public WebScriptException(String msgId) {
        super(msgId);
    }

    public WebScriptException(int status, String msgId) {
        this(msgId);
        this.status = status;
    }

    public WebScriptException(String msgId, Throwable cause) {
        super(msgId, cause);
    }

    public WebScriptException(int status, String msgId, Throwable cause) {
        super(msgId, cause);
        this.status = status;
    }

    public WebScriptException(String msgId, Object ... args) {
        super(msgId, args);
    }

    public WebScriptException(int status, String msgId, Object ... args) {
        super(msgId, args);
        this.status = status;
    }

    public WebScriptException(String msgId, Throwable cause, Object ... args) {
        super(msgId, args, cause);
    }

    public WebScriptException(int status, String msgId, Throwable cause, Object ... args) {
        super(msgId, args, cause);
        this.status = status;
    }

    public void setStatusTemplate(final StatusTemplate statusTemplate, final Map<String, Object> statusModel) {
        this.setStatusTemplateFactory(new StatusTemplateFactory(){

            @Override
            public Map<String, Object> getStatusModel() {
                return statusModel;
            }

            @Override
            public StatusTemplate getStatusTemplate() {
                return statusTemplate;
            }
        });
    }

    public void setStatusTemplateFactory(StatusTemplateFactory statusTemplateFactory) {
        this.statusTemplateFactory = statusTemplateFactory;
    }

    public int getStatus() {
        return this.status;
    }

    @Override
    public StatusTemplate getStatusTemplate() {
        return this.statusTemplateFactory == null ? null : this.statusTemplateFactory.getStatusTemplate();
    }

    @Override
    public Map<String, Object> getStatusModel() {
        Map<String, Object> statusModel = null;
        if (this.statusTemplateFactory != null) {
            statusModel = this.statusTemplateFactory.getStatusModel();
        }
        return statusModel == null ? Collections.emptyMap() : statusModel;
    }
}

