/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import freemarker.ext.dom.NodeModel;
import java.io.StringReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.ConfigService;
import org.springframework.extensions.webscripts.ConfigModel;
import org.xml.sax.InputSource;

public class TemplateConfigModel
extends ConfigModel {
    private Object model;
    private static Log logger = LogFactory.getLog(TemplateConfigModel.class);

    public TemplateConfigModel(ConfigService configService, String scriptConfig) {
        super(configService, scriptConfig);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.toString() + " created:\nconfig service: " + this.configService + "\nglobal config: " + this.globalConfig + "\nscript config: " + this.scriptConfig));
        }
    }

    @Override
    public Object getScript() {
        if (this.model == null) {
            if (this.scriptConfig != null) {
                StringReader reader = new StringReader(this.scriptConfig);
                InputSource is = new InputSource(reader);
                try {
                    this.model = NodeModel.parse((InputSource)is);
                }
                catch (Exception e) {
                    if (logger.isWarnEnabled()) {
                        logger.warn((Object)("Failed to create 'script' config model: " + e.getMessage()));
                    }
                }
            } else {
                this.model = NodeModel.NOTHING;
            }
        }
        return this.model;
    }
}

