/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import org.dom4j.Element;
import org.springframework.extensions.webscripts.AbstractBaseDescription;

public class ResourceDescription
extends AbstractBaseDescription {
    public static final String ROOT_ELEMENT_NAME = "resource";
    public static final String WEBSCRIPTS_ELEMENT_NAME = "webscripts";
    private String[] scriptIds;

    public String getScriptIdsAsString() {
        StringBuffer sb = new StringBuffer();
        for (String scriptId : this.scriptIds) {
            sb.append(scriptId);
            sb.append(",");
        }
        String str = sb.toString();
        if (str.endsWith(",")) {
            return str.substring(0, str.length() - 1);
        }
        return str;
    }

    public String[] getScriptIds() {
        return this.scriptIds;
    }

    public void setScriptIds(String[] scriptIds) {
        this.scriptIds = scriptIds;
    }

    @Override
    public void parse(Element elem) {
        if (this.validateRootElement(elem, ROOT_ELEMENT_NAME)) {
            super.parse(elem);
            Element webscriptElement = elem.element(WEBSCRIPTS_ELEMENT_NAME);
            if (webscriptElement != null) {
                String[] webscriptIds = webscriptElement.getTextTrim().split(",");
                this.setScriptIds(webscriptIds);
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    ").append("    ").append("<").append(ROOT_ELEMENT_NAME).append(">").append("\n");
        sb.append("    ").append("    ").append("    ").append("<shortname>").append(this.getShortName()).append("</shortname>").append("\n");
        sb.append("    ").append("    ").append("    ").append("<description>").append(this.getDescription()).append("</description>").append("\n");
        sb.append("    ").append("    ").append("    ").append("<").append(WEBSCRIPTS_ELEMENT_NAME).append(">").append(this.getScriptIdsAsString()).append("</").append(WEBSCRIPTS_ELEMENT_NAME).append(">").append("\n");
        sb.append("    ").append("    ").append("</").append(ROOT_ELEMENT_NAME).append(">");
        return sb.toString();
    }

    public static ResourceDescription newInstance() {
        ResourceDescription newResourceDescription = new ResourceDescription("shortname", "description", new String[0]);
        return newResourceDescription;
    }

    public boolean compare(ResourceDescription newResourceDescription) {
        return !this.compareField(newResourceDescription.getShortName(), this.getShortName()) || !this.compareField(newResourceDescription.getDescription(), this.getDescription()) || !this.compareField(newResourceDescription.getScriptIdsAsString(), this.getScriptIdsAsString());
    }

    public ResourceDescription(String shortName, String description, String[] scriptIds) {
        super("", shortName, description);
        this.scriptIds = scriptIds;
    }

    public ResourceDescription() {
    }
}

