/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigImpl;
import org.springframework.extensions.config.ConfigLookupContext;
import org.springframework.extensions.config.ConfigSection;
import org.springframework.extensions.config.ConfigService;
import org.springframework.extensions.webscripts.ScriptConfigModel;

public class ExtendedScriptConfigModel
extends ScriptConfigModel {
    private static Log logger = LogFactory.getLog(ExtendedScriptConfigModel.class);
    private ConfigImpl globalConfig;
    private Map<String, List<ConfigSection>> sectionsByArea;
    private List<ConfigSection> sections;
    private Map<String, ConfigElement> globalConfigElements;

    public ExtendedScriptConfigModel(ConfigService configService, String xmlConfig, ConfigImpl globalConfig, Map<String, List<ConfigSection>> sectionsByArea, List<ConfigSection> sections) {
        super(configService, xmlConfig);
        this.globalConfig = globalConfig;
        this.globalConfigElements = globalConfig != null ? globalConfig.getConfigElements() : Collections.emptyMap();
        this.sectionsByArea = sectionsByArea;
        this.sections = sections;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.toString() + " created:\nconfig service: " + this.configService + "\nglobal config: " + this.globalConfig + "\nscript config: " + this.scriptConfig));
        }
    }

    @Override
    public Object getScript() {
        return this.scriptConfig;
    }

    @Override
    public Map<String, ConfigElement> getGlobal() {
        return this.globalConfigElements;
    }

    @Override
    public Map<String, ConfigElement> getScoped() {
        return new ExtendedScopedConfigMap();
    }

    public class ExtendedScopedConfigMap
    extends HashMap {
        @Override
        public Object get(Object identifier) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Getting scoped config for '" + identifier + "'"));
            }
            Map map = null;
            if (ExtendedScriptConfigModel.this.configService != null) {
                Config result = ExtendedScriptConfigModel.this.configService.getConfig(identifier, new ConfigLookupContext(), ExtendedScriptConfigModel.this.globalConfig, ExtendedScriptConfigModel.this.sectionsByArea, ExtendedScriptConfigModel.this.sections);
                map = result.getConfigElements();
            } else {
                map = Collections.emptyMap();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Returning config for '" + identifier + "': " + map));
            }
            return map;
        }
    }
}

