/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.extensions.webscripts.annotation.ScriptClass;
import org.springframework.extensions.webscripts.annotation.ScriptClassType;

@ScriptClass(help="Given a URL string and N named/value pairs, replace each URL argument with \nrespective name/value pair (if name matches existing URL argument), or add \nname/value pair to URL (if name does not match existing URL argument).\n\nUsage: argreplace(url.args, \"skipCount\", cursor.nextPage, ...)", code="[#if cursor.hasFirstPage]\n<link rel=\"first\" href=\"${absurl(encodeuri(scripturl(argreplace(url.args, pageNo,\ncursor.firstPage, pageSize, cursor.pageSize))))?xml}\" type=\"${format.type}\"/>\n[/#if]", types={ScriptClassType.TemplateRootObject})
public final class ArgReplaceMethod
implements TemplateMethodModelEx {
    public Object exec(List args) throws TemplateModelException {
        if (args.size() == 0) {
            return "";
        }
        String urlArgs = "";
        Object arg0 = args.get(0);
        if (arg0 instanceof TemplateScalarModel) {
            urlArgs = ((TemplateScalarModel)arg0).getAsString();
        }
        if (args.size() == 1) {
            return urlArgs;
        }
        HashMap<String, String> replacements = new HashMap<String, String>();
        for (int i = 1; i < args.size(); ++i) {
            String name = null;
            String val = null;
            Object argname = args.get(i);
            if (!(argname instanceof TemplateScalarModel)) continue;
            name = ((TemplateScalarModel)argname).getAsString();
            if (++i >= args.size()) continue;
            Object argval = args.get(i);
            if (argval instanceof TemplateScalarModel) {
                val = ((TemplateScalarModel)argval).getAsString();
            } else if (argval instanceof TemplateNumberModel) {
                val = ((TemplateNumberModel)argval).getAsNumber().toString();
            } else if (argval instanceof TemplateBooleanModel) {
                val = Boolean.toString(((TemplateBooleanModel)argval).getAsBoolean());
            }
            if (val == null) continue;
            replacements.put(name, val);
        }
        if (replacements.size() == 0) {
            return urlArgs;
        }
        StringBuilder newUrlArgs = new StringBuilder();
        if (urlArgs.length() > 0) {
            String[] argPairs = urlArgs.split("&");
            int n = 0;
            for (String argPair : argPairs) {
                String[] nameVal = argPair.split("=");
                String name = nameVal[0];
                String val = nameVal.length > 1 ? nameVal[1] : null;
                String replaceVal = (String)replacements.get(name);
                if (replaceVal != null) {
                    val = replaceVal;
                }
                newUrlArgs.append(name);
                if (val != null) {
                    newUrlArgs.append("=");
                    newUrlArgs.append(val);
                    replacements.remove(name);
                }
                if (++n >= argPairs.length && replacements.size() <= 0) continue;
                newUrlArgs.append("&");
            }
        }
        int rs = replacements.entrySet().size();
        int r = 0;
        for (Map.Entry entry : replacements.entrySet()) {
            newUrlArgs.append((String)entry.getKey());
            if (entry.getValue() == null) continue;
            newUrlArgs.append("=");
            newUrlArgs.append((String)entry.getValue());
            if (++r >= rs) continue;
            newUrlArgs.append("&");
        }
        return newUrlArgs;
    }
}

