/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.WrappedException;
import org.springframework.extensions.config.HasAikauVersion;
import org.springframework.extensions.surf.extensibility.ExtensibilityModel;
import org.springframework.extensions.surf.extensibility.HandlesExtensibility;
import org.springframework.extensions.surf.extensibility.impl.ModelWriter;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.extensions.surf.util.StringBuilderWriter;
import org.springframework.extensions.webscripts.AbsoluteUrlMethod;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.ClientResourceUrlFunctionMethod;
import org.springframework.extensions.webscripts.ClientUrlFunctionMethod;
import org.springframework.extensions.webscripts.Container;
import org.springframework.extensions.webscripts.DefaultURLModel;
import org.springframework.extensions.webscripts.Description;
import org.springframework.extensions.webscripts.Format;
import org.springframework.extensions.webscripts.FormatModel;
import org.springframework.extensions.webscripts.FormatReader;
import org.springframework.extensions.webscripts.FormatRegistry;
import org.springframework.extensions.webscripts.FormatWriterMethod;
import org.springframework.extensions.webscripts.MessageMethod;
import org.springframework.extensions.webscripts.ModuleBundleSentinel;
import org.springframework.extensions.webscripts.Path;
import org.springframework.extensions.webscripts.PathImpl;
import org.springframework.extensions.webscripts.ResourceUrlMethod;
import org.springframework.extensions.webscripts.ScriptConfigModel;
import org.springframework.extensions.webscripts.ScriptContent;
import org.springframework.extensions.webscripts.ScriptMessage;
import org.springframework.extensions.webscripts.ScriptProcessor;
import org.springframework.extensions.webscripts.ScriptUrlMethod;
import org.springframework.extensions.webscripts.ScriptValueConverter;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.StatusTemplate;
import org.springframework.extensions.webscripts.StatusTemplateFactory;
import org.springframework.extensions.webscripts.TemplateConfigModel;
import org.springframework.extensions.webscripts.TemplateProcessor;
import org.springframework.extensions.webscripts.URLModel;
import org.springframework.extensions.webscripts.URLModelFactory;
import org.springframework.extensions.webscripts.WebScript;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptPropertyResourceBundle;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.extensions.webscripts.json.JSONWriter;

public abstract class AbstractWebScript
implements WebScript {
    private static final Log logger = LogFactory.getLog(AbstractWebScript.class);
    private static final String DOT_PROPS = ".properties";
    private Container container;
    private Description description;
    private final Map<Locale, ResourceBundle> resources = new HashMap<Locale, ResourceBundle>(4);
    private final ReadWriteLock resourcesLock = new ReentrantReadWriteLock();
    private final Map<String, String> jsonResources = new HashMap<String, String>(4);
    private final ReadWriteLock jsonResourcesLock = new ReentrantReadWriteLock();
    private final Map<String, StatusTemplate> statusTemplates = new HashMap<String, StatusTemplate>(4);
    private final ReadWriteLock statusTemplateLock = new ReentrantReadWriteLock();
    private String basePath;
    private final Map<String, ScriptDetails> scripts = new HashMap<String, ScriptDetails>(4);
    private final ReadWriteLock scriptLock = new ReentrantReadWriteLock();
    private final ReadWriteLock moduleBundleCacheLock = new ReentrantReadWriteLock();
    private final Map<String, ResourceBundle> moduleBundleCache = new HashMap<String, ResourceBundle>(5);
    private static final ScriptDetails NULLSENTINEL = new ScriptDetails(null, null);
    private MessageMethod messageMethod = null;
    private ScriptMessage scriptMessage = null;
    private ScriptConfigModel scriptConfigModel = null;
    private TemplateConfigModel templateConfigModel = null;
    private String xmlConfig = null;
    private boolean xmlConfigInitialised = false;
    private URLModelFactory urlModelFactory = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(Container container, Description description) {
        if (this.container != null && !this.container.equals(container)) {
            throw new WebScriptException("WebScript " + description.getId() + " already associated with the '" + this.container.getName() + "' container");
        }
        this.container = container;
        this.description = description;
        this.basePath = description.getId();
        this.statusTemplateLock.writeLock().lock();
        try {
            this.statusTemplates.clear();
        }
        finally {
            this.statusTemplateLock.writeLock().unlock();
        }
        this.moduleBundleCacheLock.writeLock().lock();
        try {
            this.moduleBundleCache.clear();
        }
        finally {
            this.moduleBundleCacheLock.writeLock().unlock();
        }
        this.getResources();
        this.scriptLock.writeLock().lock();
        try {
            this.scripts.clear();
        }
        finally {
            this.scriptLock.writeLock().unlock();
        }
    }

    protected final Container getContainer() {
        return this.container;
    }

    @Override
    public final Description getDescription() {
        return this.description;
    }

    protected ResourceBundle checkModuleBundleCache(String path) {
        ResourceBundle bundle = null;
        this.moduleBundleCacheLock.readLock().lock();
        try {
            bundle = this.moduleBundleCache.get(path);
        }
        finally {
            this.moduleBundleCacheLock.readLock().unlock();
        }
        return bundle;
    }

    protected void addModuleBundleToCache(String path, ResourceBundle bundle) {
        this.moduleBundleCacheLock.writeLock().lock();
        try {
            this.moduleBundleCache.put(path, bundle);
        }
        finally {
            this.moduleBundleCacheLock.writeLock().unlock();
        }
    }

    private WebScriptPropertyResourceBundle getExtensionBundle(HandlesExtensibility container, ResourceBundle result, String bundlePath) {
        WebScriptPropertyResourceBundle extensionBundle = new WebScriptPropertyResourceBundle(result, bundlePath);
        if (container != null) {
            if (result instanceof WebScriptPropertyResourceBundle) {
                bundlePath = ((WebScriptPropertyResourceBundle)result).getResourcePath();
            }
            if (bundlePath != null) {
                String webScriptId = this.getDescription().getId();
                String suffix = webScriptId.substring(AbstractWebScript.lastSlashIndex(webScriptId));
                String prefix = bundlePath.substring(0, AbstractWebScript.lastSlashIndex(bundlePath));
                LinkedHashSet<String> paths = this.buildLocalePathList(prefix + suffix, I18NUtil.getLocale());
                Object[] arrayOfPaths = paths.toArray();
                for (int i = arrayOfPaths.length - 1; i >= 0; --i) {
                    String currPath = arrayOfPaths[i].toString();
                    for (String moduleBundlePath : container.getExtendingModuleFiles(currPath)) {
                        try {
                            ResourceBundle moduleBundle = this.checkModuleBundleCache(moduleBundlePath);
                            if (moduleBundle == null) {
                                moduleBundle = this.getBundleFromPath(moduleBundlePath);
                                if (moduleBundle == null) {
                                    this.addModuleBundleToCache(moduleBundlePath, ModuleBundleSentinel.getInstance());
                                } else {
                                    this.addModuleBundleToCache(moduleBundlePath, moduleBundle);
                                }
                            }
                            if (moduleBundle == null || moduleBundle == ModuleBundleSentinel.getInstance()) continue;
                            extensionBundle.merge(moduleBundlePath, moduleBundle);
                        }
                        catch (IOException e) {
                            if (!logger.isDebugEnabled()) continue;
                            logger.error((Object)("It was not possible to merge properties from: " + moduleBundlePath), (Throwable)e);
                        }
                    }
                }
            }
        }
        return extensionBundle;
    }

    private static int lastSlashIndex(String str) {
        int lastSlashIndex = str.lastIndexOf(47);
        if (lastSlashIndex == -1) {
            lastSlashIndex = 0;
        }
        return lastSlashIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ResourceBundle getResources() {
        boolean containsLocaleKey;
        ResourceBundle result = null;
        Locale locale = I18NUtil.getLocale();
        this.resourcesLock.readLock().lock();
        try {
            result = this.resources.get(locale);
            containsLocaleKey = this.resources.containsKey(locale);
        }
        finally {
            this.resourcesLock.readLock().unlock();
        }
        if (result == null && !containsLocaleKey) {
            try {
                LinkedHashSet<String> paths = this.buildLocalePathList(this.getDescription(), locale);
                Object[] arrayOfPaths = paths.toArray();
                for (int i = arrayOfPaths.length - 1; i >= 0; --i) {
                    String currPath = arrayOfPaths[i].toString();
                    ResourceBundle currPathResult = this.getBundleFromPath(currPath);
                    if (currPathResult == null) continue;
                    if (result == null) {
                        result = currPathResult;
                        continue;
                    }
                    if (!(result instanceof WebScriptPropertyResourceBundle)) continue;
                    ((WebScriptPropertyResourceBundle)result).merge(currPath, currPathResult);
                }
                if (result != null && result instanceof WebScriptPropertyResourceBundle) {
                    try {
                        WebScriptPropertyResourceBundle importedBundles = null;
                        String includeBundles = result.getString("surf.include.resources");
                        if (includeBundles != null) {
                            String aikauVersion = null;
                            if (this.container instanceof HasAikauVersion) {
                                aikauVersion = ((HasAikauVersion)((Object)this.container)).getAikauVersion();
                            }
                            for (String includeBundle : includeBundles.toString().split("\\s*,\\s*")) {
                                if (aikauVersion != null) {
                                    includeBundle = includeBundle.replaceAll("\\{aikauVersion\\}", aikauVersion);
                                }
                                LinkedHashSet<String> importPaths = this.buildLocalePathList(includeBundle, locale);
                                Object[] arrayOfImportPaths = importPaths.toArray();
                                for (int i = arrayOfImportPaths.length - 1; i >= 0; --i) {
                                    String currPath = arrayOfImportPaths[i].toString();
                                    WebScriptPropertyResourceBundle currPathResult = (WebScriptPropertyResourceBundle)this.getBundleFromPath(currPath);
                                    if (currPathResult == null) continue;
                                    if (importedBundles == null) {
                                        importedBundles = currPathResult;
                                    }
                                    if (!(importedBundles instanceof WebScriptPropertyResourceBundle)) continue;
                                    importedBundles.merge(currPath, currPathResult);
                                }
                            }
                        }
                        if (importedBundles != null) {
                            ((WebScriptPropertyResourceBundle)result).merge(this.getDescription().toString(), importedBundles);
                        }
                    }
                    catch (MissingResourceException importedBundles) {
                    }
                    catch (IOException e) {
                        logger.error((Object)e);
                    }
                }
                this.resourcesLock.writeLock().lock();
                try {
                    this.resources.put(locale, result);
                }
                finally {
                    this.resourcesLock.writeLock().unlock();
                }
            }
            catch (IOException resErr) {
                logger.error((Object)resErr);
            }
        }
        if (this.container instanceof HandlesExtensibility) {
            ResourceBundle extendedBundle = ((HandlesExtensibility)((Object)this.container)).getCachedExtendedBundle(this.getDescription().getId());
            if (extendedBundle != null) {
                result = extendedBundle;
            } else {
                WebScriptPropertyResourceBundle extensionBundle = this.getExtensionBundle((HandlesExtensibility)((Object)this.container), result, this.getDescription().getId());
                ((HandlesExtensibility)((Object)this.container)).addExtensionBundleToCache(this.getDescription().getId(), extensionBundle);
                result = extensionBundle;
            }
        }
        return result;
    }

    private LinkedHashSet<String> buildLocalePathList(String path, Locale locale) {
        LinkedHashSet<String> pathSet = new LinkedHashSet<String>();
        pathSet.add(path + "_" + locale.toString() + DOT_PROPS);
        if (locale.getCountry().length() != 0) {
            pathSet.add(path + "_" + locale.getLanguage() + "_" + locale.getCountry() + DOT_PROPS);
        }
        pathSet.add(path + "_" + locale.getLanguage() + DOT_PROPS);
        if (!locale.equals(Locale.getDefault())) {
            Locale defLocale = locale.getDefault();
            pathSet.add(path + "_" + defLocale.toString() + DOT_PROPS);
            if (defLocale.getCountry().length() != 0) {
                pathSet.add(path + "_" + defLocale.getLanguage() + "_" + defLocale.getCountry() + DOT_PROPS);
            }
            pathSet.add(path + "_" + defLocale.getLanguage() + DOT_PROPS);
        }
        pathSet.add(path + DOT_PROPS);
        return pathSet;
    }

    private LinkedHashSet<String> buildLocalePathList(Description description, Locale locale) {
        LinkedHashSet<String> paths = this.buildLocalePathList(description.getId(), locale);
        return paths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceBundle getBundleFromPath(String path) throws IOException {
        WebScriptPropertyResourceBundle result = null;
        if (this.container.getSearchPath().hasDocument(path)) {
            try (InputStream is = this.container.getSearchPath().getDocument(path);){
                result = new WebScriptPropertyResourceBundle(is, path);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ScriptDetails getExecuteScript(String mimetype) {
        ScriptDetails script = null;
        String key = mimetype == null ? "<UNKNOWN>" : mimetype;
        this.scriptLock.readLock().lock();
        try {
            script = this.scripts.get(key);
        }
        finally {
            this.scriptLock.readLock().unlock();
        }
        if (script == null) {
            FormatRegistry formatRegistry = this.getContainer().getFormatRegistry();
            ScriptContent scriptContent = null;
            String generalizedMimetype = mimetype;
            while (generalizedMimetype != null) {
                String validScriptPath;
                String format = formatRegistry.getFormat(null, generalizedMimetype);
                if (format != null && (validScriptPath = this.getContainer().getScriptProcessorRegistry().findValidScriptPath(this.basePath + "." + format)) != null) {
                    ScriptProcessor scriptProcessor = this.getContainer().getScriptProcessorRegistry().getScriptProcessor(validScriptPath);
                    scriptContent = scriptProcessor.findScript(validScriptPath);
                    break;
                }
                generalizedMimetype = formatRegistry.generalizeMimetype(generalizedMimetype);
            }
            if (scriptContent == null) {
                String validScriptPath = this.getContainer().getScriptProcessorRegistry().findValidScriptPath(this.basePath);
                if (validScriptPath != null) {
                    ScriptProcessor scriptProcessor = this.getContainer().getScriptProcessorRegistry().getScriptProcessor(validScriptPath);
                    scriptContent = scriptProcessor.findScript(validScriptPath);
                }
                String string = generalizedMimetype = Format.FORMDATA.mimetype().equals(mimetype) ? mimetype : null;
            }
            if (scriptContent != null) {
                if (formatRegistry.getReader(generalizedMimetype) == null) {
                    throw new WebScriptException("No reader registered for \"" + generalizedMimetype + "\"");
                }
                script = new ScriptDetails(scriptContent, generalizedMimetype);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Caching script " + (script == null ? "null" : script.getContent().getPathDescription()) + " for web script " + this.basePath + " and request mimetype " + (mimetype == null ? "null" : mimetype)));
            }
            this.scriptLock.writeLock().lock();
            try {
                this.scripts.put(key, script != null ? script : NULLSENTINEL);
            }
            finally {
                this.scriptLock.writeLock().unlock();
            }
        }
        return script != NULLSENTINEL ? script : null;
    }

    protected Map<String, Object> createScriptParameters(WebScriptRequest req, WebScriptResponse res, ScriptDetails script, Map<String, Object> customParams) {
        HashMap<String, Object> params = new HashMap<String, Object>(32, 1.0f);
        params.put("webscript", req.getServiceMatch().getWebScript().getDescription());
        params.put("format", new FormatModel(this.container.getFormatRegistry(), req.getFormat()));
        params.put("args", this.createArgs(req));
        params.put("argsM", this.createArgsM(req));
        params.put("headers", this.createHeaders(req));
        params.put("headersM", this.createHeadersM(req));
        params.put("guest", req.isGuest());
        params.put("url", this.createURLModel(req));
        params.put("msg", this.getScriptMessage());
        String contentType = req.getContentType();
        if (script != null) {
            FormatReader<Object> reader = this.container.getFormatRegistry().getReader(script.getRequestType());
            if (!"multipart/form-data".equals(contentType) || this.getDescription().getMultipartProcessing()) {
                params.putAll(reader.createScriptParameters(req, res));
            }
        }
        params.putAll(req.getRuntime().getScriptParameters());
        params.putAll(this.container.getScriptParameters());
        this.setupScriptConfig();
        params.put("config", this.scriptConfigModel);
        if (customParams != null) {
            params.putAll(customParams);
        }
        return params;
    }

    @Override
    public void setURLModelFactory(URLModelFactory urlModelFactory) {
        this.urlModelFactory = urlModelFactory;
    }

    private URLModel createURLModel(WebScriptRequest request) {
        URLModel urlModel = null;
        urlModel = this.urlModelFactory == null ? new DefaultURLModel(request) : this.urlModelFactory.createURLModel(request);
        return urlModel;
    }

    protected Map<String, Object> createTemplateParameters(WebScriptRequest req, WebScriptResponse res, Map<String, Object> customParams) {
        HashMap<String, Object> params = new HashMap<String, Object>(64, 1.0f);
        params.putAll(req.getRuntime().getTemplateParameters());
        params.putAll(this.container.getTemplateParameters());
        params.put("webscript", req.getServiceMatch().getWebScript().getDescription());
        params.put("format", new FormatModel(this.container.getFormatRegistry(), req.getFormat()));
        params.put("args", this.createArgs(req));
        params.put("argsM", this.createArgsM(req));
        params.put("headers", this.createHeaders(req));
        params.put("headersM", this.createHeadersM(req));
        params.put("guest", req.isGuest());
        params.put("url", this.createURLModel(req));
        params.put("absurl", new AbsoluteUrlMethod(req.getServerPath()));
        if (params.get("scripturl") == null) {
            params.put("scripturl", new ScriptUrlMethod(req, res));
        }
        if (params.get("clienturlfunction") == null) {
            params.put("clienturlfunction", new ClientUrlFunctionMethod(res));
        }
        if (params.get("resourceurl") == null) {
            params.put("resourceurl", new ResourceUrlMethod(req, res));
        }
        if (params.get("clientresourceurlfunction") == null) {
            params.put("clientresourceurlfunction", new ClientResourceUrlFunctionMethod(res));
        }
        params.put("formatwrite", new FormatWriterMethod(this.container.getFormatRegistry(), req.getFormat()));
        params.put("message", this.getMessageMethod());
        params.put("msg", this.getMessageMethod());
        params.put("messages", this.renderJSONResources(this.getResources()));
        this.setupScriptConfig();
        params.put("config", this.templateConfigModel);
        if (customParams != null) {
            params.putAll(customParams);
        }
        return params;
    }

    protected final Map<String, String> createArgs(WebScriptRequest req) {
        String[] names = req.getParameterNames();
        HashMap<String, String> args = new HashMap<String, String>(names.length, 1.0f);
        for (String name : names) {
            args.put(name, req.getParameter(name));
        }
        return args;
    }

    protected final Map<String, String[]> createArgsM(WebScriptRequest req) {
        String[] names = req.getParameterNames();
        HashMap<String, String[]> args = new HashMap<String, String[]>(names.length, 1.0f);
        for (String name : names) {
            args.put(name, req.getParameterValues(name));
        }
        return args;
    }

    protected final Map<String, String> createHeaders(WebScriptRequest req) {
        String[] names;
        TreeMap<String, String> headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (String name : names = req.getHeaderNames()) {
            headers.put(name, req.getHeader(name));
        }
        return headers;
    }

    protected final Map<String, String[]> createHeadersM(WebScriptRequest req) {
        String[] names;
        TreeMap<String, String[]> headers = new TreeMap<String, String[]>(String.CASE_INSENSITIVE_ORDER);
        for (String name : names = req.getHeaderNames()) {
            headers.put(name, req.getHeaderValues(name));
        }
        return headers;
    }

    protected final void renderTemplate(String templatePath, Map<String, Object> model, Writer writer) {
        String validTemplatePath;
        boolean debug = logger.isDebugEnabled();
        long start = 0L;
        if (debug) {
            start = System.nanoTime();
        }
        if ((validTemplatePath = this.getContainer().getTemplateProcessorRegistry().findValidTemplatePath(templatePath)) != null) {
            Container container = this.getContainer();
            if (container instanceof HandlesExtensibility && !((HandlesExtensibility)((Object)container)).isExtensibilitySuppressed()) {
                HandlesExtensibility extHandler = (HandlesExtensibility)((Object)container);
                ExtensibilityModel extModel = extHandler.getCurrentExtensibilityModel();
                extModel.addUnboundContent();
                ModelWriter extModelWriter = extModel.getWriter();
                extHandler.addExtensibilityDirectives(model, extModel);
                TemplateProcessor templateProcessor = container.getTemplateProcessorRegistry().getTemplateProcessor(validTemplatePath);
                extHandler.setFileBeingProcessed(validTemplatePath);
                templateProcessor.process(validTemplatePath, model, extModelWriter);
                extModel.switchToExtensionProcessing();
                for (String moduleTemplatePath : extHandler.getExtendingModuleFiles(templatePath)) {
                    String modulePath = container.getTemplateProcessorRegistry().findValidTemplatePath(moduleTemplatePath);
                    if (modulePath == null) continue;
                    extHandler.setFileBeingProcessed(modulePath);
                    templateProcessor.process(modulePath, model, extModelWriter);
                }
            } else {
                TemplateProcessor templateProcessor = this.getContainer().getTemplateProcessorRegistry().getTemplateProcessor(validTemplatePath);
                templateProcessor.process(validTemplatePath, model, writer);
            }
            if (debug) {
                logger.debug((Object)("Rendered template " + templatePath + " in " + (float)(System.nanoTime() - start) / 1000000.0f + "ms"));
            }
        } else {
            throw new WebScriptException("Cannot locate template processor for template " + templatePath);
        }
    }

    protected final void renderString(String template, Map<String, Object> model, Writer writer) {
        this.renderString(template, model, writer, "ftl");
    }

    protected final void renderString(String template, Map<String, Object> model, Writer writer, String extension) {
        TemplateProcessor processor = this.container.getTemplateProcessorRegistry().getTemplateProcessorByExtension(extension);
        if (processor == null) {
            throw new WebScriptException("No processor found for extension " + extension);
        }
        processor.processString(template, model, writer);
    }

    protected final void sendStatus(WebScriptRequest req, WebScriptResponse res, Status status, Cache cache, String format, Map<String, Object> model) throws IOException {
        int statusCode = status.getCode();
        String statusFormat = format == null ? "" : format;
        String scriptId = this.getDescription().getId();
        StatusTemplate template = this.getStatusTemplate(scriptId, statusCode, statusFormat);
        String mimetype = this.container.getFormatRegistry().getMimeType(req.getAgent(), template.getFormat());
        if (mimetype == null) {
            throw new WebScriptException("Web Script format '" + template.getFormat() + "' is not registered");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Force success status header in response: " + req.forceSuccessStatus()));
            logger.debug((Object)("Sending status " + statusCode + " (Template: " + template.getPath() + ")"));
            logger.debug((Object)("Rendering response: content type=" + mimetype));
        }
        res.reset();
        res.setCache(cache);
        res.setStatus(req.forceSuccessStatus() ? 200 : statusCode);
        String location = status.getLocation();
        if (location != null && location.length() > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Setting location to " + location));
            }
            res.setHeader("Location", location);
        }
        res.setContentType(mimetype + ";charset=UTF-8");
        this.renderTemplate(template.getPath(), model, res.getWriter());
    }

    protected final WebScriptException createStatusException(Throwable e, final WebScriptRequest req, final WebScriptResponse res) {
        Object current = e;
        while (!(current instanceof WebScriptException)) {
            if (current instanceof WrappedException) {
                current = ((WrappedException)current).getWrappedException();
            } else {
                if (current instanceof JavaScriptException) {
                    Object unwrapped;
                    int code = 500;
                    Object msg = "Wrapped Exception (with status template): " + ((Throwable)current).getMessage();
                    Object val = ((JavaScriptException)current).getValue();
                    if (val instanceof ScriptableObject && (unwrapped = ScriptValueConverter.unwrapValue(val)) instanceof Map) {
                        Object cause;
                        String strMsg;
                        Number numCode = (Number)((Map)unwrapped).get("code");
                        if (numCode != null) {
                            code = numCode.intValue();
                        }
                        if ((strMsg = (String)((Map)unwrapped).get("message")) != null) {
                            msg = strMsg;
                        }
                        if ((cause = ((Map)unwrapped).get("javaException")) instanceof Throwable) {
                            current = (Throwable)cause;
                        }
                    }
                    current = new WebScriptException(code, (String)msg, (Throwable)current);
                    break;
                }
                current = ((Throwable)current).getCause();
            }
            if (current != null) continue;
        }
        final WebScriptException we = current == null ? new WebScriptException(500, "Wrapped Exception (with status template): " + e.getMessage(), e) : (WebScriptException)current;
        we.setStatusTemplateFactory(new StatusTemplateFactory(){

            @Override
            public Map<String, Object> getStatusModel() {
                return AbstractWebScript.this.createTemplateParameters(req, res, null);
            }

            @Override
            public StatusTemplate getStatusTemplate() {
                int statusCode = we.getStatus();
                String format = req.getFormat();
                String scriptId = AbstractWebScript.this.getDescription().getId();
                return AbstractWebScript.this.getStatusTemplate(scriptId, statusCode, format == null ? "" : format);
            }
        });
        return we;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StatusTemplate getStatusTemplate(String scriptId, int statusCode, String format) {
        StatusTemplate statusTemplate = null;
        String key = statusCode + "." + format;
        this.statusTemplateLock.readLock().lock();
        try {
            statusTemplate = this.statusTemplates.get(key);
        }
        finally {
            this.statusTemplateLock.readLock().unlock();
        }
        if (statusTemplate == null) {
            Path path;
            statusTemplate = this.getScriptStatusTemplate(scriptId, statusCode, format);
            if (statusTemplate == null && (statusTemplate = this.getPackageStatusTemplate(path = this.container.getRegistry().getPackage(PathImpl.concatPath("/", this.getDescription().getScriptPath())), statusCode, format)) == null) {
                statusTemplate = this.getDefaultStatusTemplate(statusCode);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Caching template " + statusTemplate.getPath() + " for web script " + scriptId + " and status " + statusCode + " (format: " + format + ")"));
            }
            this.statusTemplateLock.writeLock().lock();
            try {
                this.statusTemplates.put(key, statusTemplate);
            }
            finally {
                this.statusTemplateLock.writeLock().unlock();
            }
        }
        return statusTemplate;
    }

    private StatusTemplate getScriptStatusTemplate(String scriptId, int statusCode, String format) {
        String validTemplatePath = this.getContainer().getTemplateProcessorRegistry().findValidTemplatePath(scriptId + "." + format + "." + statusCode);
        if (validTemplatePath != null) {
            return new StatusTemplate(scriptId + "." + format + "." + statusCode, format);
        }
        validTemplatePath = this.getContainer().getTemplateProcessorRegistry().findValidTemplatePath(scriptId + "." + format + ".status");
        if (validTemplatePath != null) {
            return new StatusTemplate(scriptId + "." + format + ".status", format);
        }
        return null;
    }

    private StatusTemplate getPackageStatusTemplate(Path scriptPath, int statusCode, String format) {
        while (scriptPath != null) {
            String path = PathImpl.concatPath(scriptPath.getPath(), format + "." + statusCode + ".ftl");
            String validTemplatePath = this.container.getTemplateProcessorRegistry().findValidTemplatePath(path);
            if (validTemplatePath != null) {
                return new StatusTemplate(path, format);
            }
            path = PathImpl.concatPath(scriptPath.getPath(), format + ".status.ftl");
            validTemplatePath = this.container.getTemplateProcessorRegistry().findValidTemplatePath(path);
            if (validTemplatePath != null) {
                return new StatusTemplate(path, format);
            }
            scriptPath = scriptPath.getParent();
        }
        return null;
    }

    private StatusTemplate getDefaultStatusTemplate(int statusCode) {
        Object path = statusCode + ".ftl";
        String validTemplatePath = this.container.getTemplateProcessorRegistry().findValidTemplatePath((String)path);
        if (validTemplatePath != null) {
            return new StatusTemplate((String)path, "html");
        }
        path = "status.ftl";
        validTemplatePath = this.container.getTemplateProcessorRegistry().findValidTemplatePath((String)path);
        if (validTemplatePath != null) {
            return new StatusTemplate((String)path, "html");
        }
        throw new WebScriptException("Default status template /status.ftl could not be found");
    }

    private synchronized void setupScriptConfig() {
        if (!this.xmlConfigInitialised) {
            InputStream input = null;
            try {
                String configPath = this.getDescription().getId() + ".config.xml";
                input = this.container.getSearchPath().getDocument(configPath);
                if (input != null) {
                    int read;
                    StringBuilder fileContents = new StringBuilder(1024);
                    BufferedReader reader = new BufferedReader(new InputStreamReader(input, "UTF-8"), 1024);
                    char[] buf = new char[1024];
                    while ((read = reader.read(buf)) != -1) {
                        fileContents.append(buf, 0, read);
                    }
                    this.xmlConfig = fileContents.toString();
                }
            }
            catch (IOException ioe) {
                throw new WebScriptException("Failed to read script configuration file", ioe);
            }
            finally {
                this.xmlConfigInitialised = true;
            }
        }
        if (this.container instanceof HandlesExtensibility) {
            this.scriptConfigModel = ((HandlesExtensibility)((Object)this.container)).getExtendedScriptConfigModel(this.xmlConfig);
            this.templateConfigModel = ((HandlesExtensibility)((Object)this.container)).getExtendedTemplateConfigModel(this.xmlConfig);
        }
        if (this.scriptConfigModel == null) {
            this.scriptConfigModel = new ScriptConfigModel(this.container.getConfigService(), this.xmlConfig);
        }
        if (this.templateConfigModel == null) {
            this.templateConfigModel = new TemplateConfigModel(this.container.getConfigService(), this.xmlConfig);
        }
    }

    protected void executeScript(ScriptContent location, Map<String, Object> model) {
        boolean debug = logger.isDebugEnabled();
        long start = 0L;
        if (debug) {
            start = System.nanoTime();
        }
        ScriptProcessor scriptProcessor = this.container.getScriptProcessorRegistry().getScriptProcessor(location);
        scriptProcessor.executeScript(location, model);
        Container container = this.getContainer();
        if (container instanceof HandlesExtensibility) {
            for (String moduleScriptPath : ((HandlesExtensibility)((Object)container)).getExtendingModuleFiles(this.basePath)) {
                String validScriptPath = this.getContainer().getScriptProcessorRegistry().findValidScriptPath(moduleScriptPath);
                if (validScriptPath == null) continue;
                scriptProcessor = this.getContainer().getScriptProcessorRegistry().getScriptProcessor(validScriptPath);
                ScriptContent scriptContent = scriptProcessor.findScript(validScriptPath);
                scriptProcessor.executeScript(scriptContent, model);
            }
        }
        if (debug) {
            logger.debug((Object)("Executed script " + location.getPathDescription() + " in " + (float)(System.nanoTime() - start) / 1000000.0f + "ms"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String renderJSONResources(ResourceBundle resources) {
        String result = "{}";
        if (resources != null) {
            Locale locale = I18NUtil.getLocale();
            Object cacheKey = locale.toString();
            if (resources instanceof WebScriptPropertyResourceBundle) {
                cacheKey = (String)cacheKey + "_" + ((WebScriptPropertyResourceBundle)resources).getMergedBundlePaths();
            }
            this.jsonResourcesLock.readLock().lock();
            try {
                result = this.jsonResources.get(cacheKey);
            }
            finally {
                this.jsonResourcesLock.readLock().unlock();
            }
            if (result == null) {
                StringBuilderWriter buf = new StringBuilderWriter(256);
                JSONWriter out = new JSONWriter((Writer)buf);
                try {
                    out.startObject();
                    Enumeration<String> keys = resources.getKeys();
                    while (keys.hasMoreElements()) {
                        String key = keys.nextElement();
                        out.writeValue(key, resources.getString(key));
                    }
                    out.endObject();
                }
                catch (IOException jsonErr) {
                    throw new WebScriptException("Error rendering I18N resources.", jsonErr);
                }
                result = buf.toString();
                this.jsonResourcesLock.writeLock().lock();
                try {
                    this.jsonResources.put((String)cacheKey, result);
                }
                finally {
                    this.jsonResourcesLock.writeLock().unlock();
                }
            }
        }
        return result;
    }

    private MessageMethod getMessageMethod() {
        if (this.messageMethod == null) {
            this.messageMethod = new MessageMethod(this);
        }
        return this.messageMethod;
    }

    private ScriptMessage getScriptMessage() {
        if (this.scriptMessage == null) {
            this.scriptMessage = new ScriptMessage(this);
        }
        return this.scriptMessage;
    }

    public String toString() {
        return this.basePath;
    }

    protected static class ScriptDetails {
        private final ScriptContent content;
        private final String requestType;

        private ScriptDetails(ScriptContent content, String requestType) {
            this.content = content;
            this.requestType = requestType;
        }

        public ScriptContent getContent() {
            return this.content;
        }

        public String getRequestType() {
            return this.requestType;
        }
    }
}

