/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.Base64;
import org.springframework.extensions.webscripts.Authenticator;
import org.springframework.extensions.webscripts.Description;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.servlet.ServletAuthenticatorFactory;
import org.springframework.extensions.webscripts.servlet.WebScriptServletRequest;
import org.springframework.extensions.webscripts.servlet.WebScriptServletResponse;

public abstract class AbstractBasicHttpAuthenticatorFactory
implements ServletAuthenticatorFactory {
    private static Log logger = LogFactory.getLog(AbstractBasicHttpAuthenticatorFactory.class);
    protected String guestUserName = "Guest";
    protected String basicRealm = "WebScripts";

    @Override
    public Authenticator create(WebScriptServletRequest req, WebScriptServletResponse res) {
        return new BasicHttpAuthenticator(req, res);
    }

    public abstract boolean doAuthenticate(String var1, String var2);

    public abstract boolean doAuthorize(String var1, Description.RequiredAuthentication var2);

    public void setGuestUserName(String guestUserName) {
        this.guestUserName = guestUserName;
    }

    public void setBasicRealm(String basicRealm) {
        this.basicRealm = basicRealm;
    }

    public class BasicHttpAuthenticator
    implements Authenticator {
        private WebScriptServletRequest servletReq;
        private WebScriptServletResponse servletRes;
        private String authorization;

        public BasicHttpAuthenticator(WebScriptServletRequest req, WebScriptServletResponse res) {
            this.servletReq = req;
            this.servletRes = res;
            HttpServletRequest httpReq = this.servletReq.getHttpServletRequest();
            this.authorization = httpReq.getHeader("Authorization");
        }

        @Override
        public boolean authenticate(Description.RequiredAuthentication required, boolean isGuest) {
            boolean authenticated = false;
            HttpServletResponse res = this.servletRes.getHttpServletResponse();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("HTTP Authorization provided: " + (this.authorization != null && this.authorization.length() != 0)));
            }
            if (isGuest && Description.RequiredAuthentication.guest == required) {
                authenticated = true;
            } else if (this.authorization != null && this.authorization.length() > 0) {
                String[] authorizationParts = this.authorization.split(" ");
                if (!authorizationParts[0].equalsIgnoreCase("basic")) {
                    throw new WebScriptException("Authorization '" + authorizationParts[0] + "' not supported.");
                }
                String decodedAuthorisation = new String(Base64.decode((String)authorizationParts[1]));
                String[] parts = decodedAuthorisation.split(":");
                if (parts.length == 2) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Authenticating (BASIC HTTP) user " + parts[0]));
                    }
                    try {
                        authenticated = AbstractBasicHttpAuthenticatorFactory.this.doAuthenticate(parts[0], parts[1]);
                        if (authenticated && !AbstractBasicHttpAuthenticatorFactory.this.doAuthorize(parts[0], required)) {
                            authenticated = false;
                        }
                    }
                    catch (Throwable err) {
                        logger.warn((Object)("Failed during authorization: " + err.getMessage()), err);
                        if (err instanceof RuntimeException) {
                            throw (RuntimeException)err;
                        }
                        throw new RuntimeException(err);
                    }
                }
            }
            if (!authenticated) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Requesting authorization credentials");
                }
                res.setStatus(401);
                res.setHeader("WWW-Authenticate", "Basic realm=\"" + AbstractBasicHttpAuthenticatorFactory.this.basicRealm + "\"");
            }
            return authenticated;
        }

        @Override
        public boolean emptyCredentials() {
            return this.authorization == null || this.authorization.length() == 0;
        }
    }
}

