/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.extensibility;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.springframework.extensions.surf.extensibility.Customization;
import org.springframework.extensions.surf.extensibility.XMLHelper;

public class BasicExtensionModule {
    private static final Log logger = LogFactory.getLog(BasicExtensionModule.class);
    public static final String ID = "id";
    public static final String AUTO_DEPLOY = "auto-deploy";
    public static final String DESCRIPTION = "description";
    public static final String VERSION = "version";
    public static final String AUTO_DEPLOY_INDEX = "auto-deploy-index";
    public static final String EVALUATOR = "evaluator";
    public static final String EVALUATOR_TYPE = "type";
    public static final String EVALUATOR_PROPS = "params";
    public static final String COMPONENTS = "components";
    public static final String COMPONENT = "component";
    public static final String CUSTOMIZATIONS = "customizations";
    public static final String CUSTOMIZATION = "customization";
    public static final String CONFIGURATIONS = "configurations";
    private String id = null;
    private boolean autoDeploy = false;
    private String description = null;
    private String version = null;
    private String autoDeployIndex = null;
    private String evaluator = null;
    private Map<String, String> evaluatorProperties = new HashMap<String, String>();
    private List<Customization> customizations = new ArrayList<Customization>();
    private List<Element> configurations = new ArrayList<Element>();

    public BasicExtensionModule(Element element) {
        this.id = XMLHelper.getStringData(ID, element, true);
        this.autoDeploy = Boolean.valueOf(XMLHelper.getStringData(AUTO_DEPLOY, element, false));
        if (this.id != null) {
            this.description = XMLHelper.getStringData(DESCRIPTION, element, false);
            this.version = XMLHelper.getStringData(VERSION, element, false);
            this.autoDeployIndex = XMLHelper.getStringData(AUTO_DEPLOY_INDEX, element, false);
            Element evaluatorEl = element.element(EVALUATOR);
            if (evaluatorEl != null) {
                this.evaluator = evaluatorEl.attributeValue(EVALUATOR_TYPE);
                this.evaluatorProperties = XMLHelper.getProperties(EVALUATOR_PROPS, evaluatorEl);
            }
            List customizationsList = element.elements(CUSTOMIZATIONS);
            for (Element customizationsEl : customizationsList) {
                List customizationList = customizationsEl.elements(CUSTOMIZATION);
                for (Element customizationEl : customizationList) {
                    this.customizations.add(new Customization(customizationEl));
                }
            }
            this.configurations = element.elements(CONFIGURATIONS);
        } else if (logger.isErrorEnabled()) {
            logger.error((Object)"A <module> was found with no identification");
        }
    }

    public String getId() {
        return this.id;
    }

    public boolean isAutoDeploy() {
        return this.autoDeploy;
    }

    public String getDescription() {
        return this.description;
    }

    public String getVersion() {
        return this.version;
    }

    public String getAutoDeployIndex() {
        return this.autoDeployIndex;
    }

    public String getEvaluator() {
        return this.evaluator;
    }

    public Map<String, String> getEvaluatorProperties() {
        return this.evaluatorProperties;
    }

    public List<Customization> getCustomizations() {
        return this.customizations;
    }

    public List<Element> getConfigurations() {
        return this.configurations;
    }
}

