/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.config.source;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.source.BaseConfigSource;
import org.springframework.extensions.config.source.FileConfigSource;
import org.springframework.web.context.ServletContextAware;

public class WebAppConfigSource
extends BaseConfigSource
implements ServletContextAware {
    private static Log logger = LogFactory.getLog(FileConfigSource.class);
    private ServletContext servletCtx;

    public WebAppConfigSource(String filename) {
        this(Collections.singletonList(filename));
    }

    public WebAppConfigSource(List<String> sourceStrings) {
        super(sourceStrings);
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletCtx = servletContext;
    }

    public InputStream getInputStream(String sourceString) {
        BufferedInputStream is;
        block2: {
            is = null;
            try {
                String fullPath = this.servletCtx.getRealPath(sourceString);
                is = new BufferedInputStream(new FileInputStream(fullPath));
            }
            catch (IOException ioe) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug((Object)("Failed to obtain input stream to file: " + sourceString), (Throwable)ioe);
            }
        }
        return is;
    }
}

