/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.site.servlet.config;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.keycloak.common.enums.SslRequired;
import org.keycloak.representations.adapters.config.AdapterConfig;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigService;

public class AIMSConfig {
    private static final Log logger = LogFactory.getLog(AIMSConfig.class);
    private boolean enabled;
    private ConfigService configService;
    private AdapterConfig adapterConfig;

    public void init() {
        Config config = this.configService.getConfig((Object)"AIMS");
        this.setEnabled(Boolean.parseBoolean(config.getConfigElementValue("enabled")));
        this.initAdapterConfig(config);
    }

    public void setConfigService(ConfigService configService) {
        this.configService = configService;
    }

    private void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private void initAdapterConfig(Config config) {
        this.adapterConfig = new AdapterConfig();
        for (Map.Entry configElement : config.getConfigElements().entrySet()) {
            String value = ((ConfigElement)configElement.getValue()).getValue();
            String methodName = "set" + StringUtils.capitalize((String)((String)configElement.getKey()));
            if (value == null) continue;
            for (Method method : this.adapterConfig.getClass().getMethods()) {
                try {
                    if (!method.getName().equals(methodName) || method.getParameterCount() != 1) continue;
                    if (method.getParameterTypes()[0] == String.class) {
                        try {
                            if (methodName.equals("setSslRequired")) {
                                SslRequired.valueOf((String)value.toUpperCase());
                            }
                            method.invoke((Object)this.adapterConfig, value);
                        }
                        catch (IllegalArgumentException e) {
                            method.invoke((Object)this.adapterConfig, SslRequired.EXTERNAL.toString().toLowerCase());
                        }
                        continue;
                    }
                    if (method.getParameterTypes()[0] != Boolean.TYPE) continue;
                    method.invoke((Object)this.adapterConfig, Boolean.parseBoolean(value));
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    logger.debug((Object)e.getMessage());
                }
            }
        }
    }

    public AdapterConfig getAdapterConfig() {
        return this.adapterConfig;
    }
}

