/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.site.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.sasl.RealmCallback;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.jlan.server.auth.kerberos.KerberosDetails;
import org.alfresco.jlan.server.auth.ntlm.NTLM;
import org.alfresco.jlan.server.auth.ntlm.NTLMLogonDetails;
import org.alfresco.jlan.server.auth.ntlm.NTLMMessage;
import org.alfresco.jlan.server.auth.ntlm.Type1NTLMMessage;
import org.alfresco.jlan.server.auth.ntlm.Type2NTLMMessage;
import org.alfresco.jlan.server.auth.ntlm.Type3NTLMMessage;
import org.alfresco.jlan.server.auth.spnego.NegTokenInit;
import org.alfresco.jlan.server.auth.spnego.NegTokenTarg;
import org.alfresco.jlan.server.auth.spnego.OID;
import org.alfresco.jlan.server.auth.spnego.SPNEGO;
import org.alfresco.util.Pair;
import org.alfresco.util.log.NDC;
import org.alfresco.web.site.servlet.KerberosSessionSetupPrivilegedAction;
import org.alfresco.web.site.servlet.SlingshotLoginController;
import org.alfresco.web.site.servlet.config.AIMSConfig;
import org.alfresco.web.site.servlet.config.KerberosConfigElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.extensions.config.ConfigService;
import org.springframework.extensions.config.RemoteConfigElement;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.RequestContextUtil;
import org.springframework.extensions.surf.exception.ConnectorServiceException;
import org.springframework.extensions.surf.exception.PlatformRuntimeException;
import org.springframework.extensions.surf.mvc.PageViewResolver;
import org.springframework.extensions.surf.site.AuthenticationUtil;
import org.springframework.extensions.surf.types.Page;
import org.springframework.extensions.surf.util.Base64;
import org.springframework.extensions.webscripts.Description;
import org.springframework.extensions.webscripts.connector.Connector;
import org.springframework.extensions.webscripts.connector.ConnectorContext;
import org.springframework.extensions.webscripts.connector.ConnectorService;
import org.springframework.extensions.webscripts.connector.Response;
import org.springframework.extensions.webscripts.servlet.DependencyInjectedFilter;
import org.springframework.web.util.WebUtils;

public class SSOAuthenticationFilter
implements DependencyInjectedFilter,
CallbackHandler,
ApplicationContextAware {
    private static Log logger = LogFactory.getLog(SSOAuthenticationFilter.class);
    private static final String AUTH_NTLM = "NTLM";
    private static final String AUTH_SPNEGO = "Negotiate";
    private static final String HEADER_WWWAUTHENTICATE = "WWW-Authenticate";
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String HEADER_ACCEPT_LANGUAGE = "Accept-Language";
    private static final String NTLM_AUTH_DETAILS = "_alfwfNTLMDetails";
    private static final String AUTH_BY_KERBEROS = "_alfAuthByKerberos";
    private static final String MIME_HTML_TEXT = "text/html";
    private static final String PAGE_SERVLET_PATH = "/page";
    private static final String LOGIN_PATH_INFORMATION = "/dologin";
    private static final String LOGIN_PARAMETER = "login";
    private static final String ERROR_PARAMETER = "error";
    private static final String UNAUTHENTICATED_ACCESS_PROXY = "/proxy/alfresco-noauth";
    private static final String PAGE_VIEW_RESOLVER = "pageViewResolver";
    private ApplicationContext context;
    private ConnectorService connectorService;
    private String endpoint;
    private String userHeader;
    private Pattern userIdPattern;
    private SlingshotLoginController loginController;
    private String krbAccountName;
    private String krbPassword;
    private String krbRealm;
    private String krbEndpointSPN;
    private String jaasLoginEntryName;
    private LoginContext jaasLoginContext;
    private boolean stripUserNameSuffix;

    public void init() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Initializing the SSOAuthenticationFilter.");
        }
        this.loginController = (SlingshotLoginController)this.context.getBean("loginController");
        this.connectorService = (ConnectorService)this.context.getBean("connector.service");
        ConfigService configService = (ConfigService)this.context.getBean("web.config");
        RemoteConfigElement remoteConfig = (RemoteConfigElement)configService.getConfig((Object)"Remote").getConfigElement("remote");
        if (remoteConfig == null) {
            logger.error((Object)"There is no Remote configuration element. This is required to use SSOAuthenticationFilter.");
            return;
        }
        if (this.endpoint == null) {
            logger.error((Object)"There is no 'endpoint' property in the SSOAuthenticationFilter bean parameters. Cannot initialise filter.");
            return;
        }
        RemoteConfigElement.EndpointDescriptor endpointDescriptor = remoteConfig.getEndpointDescriptor(this.endpoint);
        if (endpointDescriptor == null || !endpointDescriptor.getExternalAuth()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No External Auth endpoint configured for " + this.endpoint));
            }
            this.endpoint = null;
            return;
        }
        try {
            Connector conn = this.connectorService.getConnector(this.endpoint);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Endpoint is " + this.endpoint));
            }
            this.userHeader = conn.getConnectorSession().getParameter("userHeader");
            String userIdPattern = conn.getConnectorSession().getParameter("userIdPattern");
            if (userIdPattern != null) {
                this.userIdPattern = Pattern.compile(userIdPattern);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("userHeader is " + this.userHeader));
                logger.debug((Object)("userIdPattern is " + userIdPattern));
            }
        }
        catch (ConnectorServiceException e) {
            logger.error((Object)("Unable to find connector " + endpointDescriptor.getConnectorId() + " for the endpoint " + this.endpoint), (Throwable)e);
        }
        this.initKerberos(configService);
        if (logger.isInfoEnabled()) {
            logger.info((Object)"SSOAuthenticationFilter initialised.");
        }
    }

    private void initKerberos(ConfigService configService) {
        KerberosConfigElement config = (KerberosConfigElement)configService.getConfig((Object)"Kerberos").getConfigElement("kerberos");
        if (config != null) {
            String krbRealm;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Found configuration for Kerberos authentication.");
            }
            if ((krbRealm = config.getRealm()) != null && krbRealm.length() > 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Found Kerberos realm: " + krbRealm));
                }
            } else {
                throw new AlfrescoRuntimeException("Kerberos realm not specified");
            }
            this.krbRealm = krbRealm;
            String srvPassword = config.getPassword();
            if (srvPassword == null || srvPassword.length() <= 0) {
                throw new AlfrescoRuntimeException("HTTP service account password not specified");
            }
            this.krbPassword = srvPassword;
            String krbEndpointSPN = config.getEndpointSPN();
            if (krbEndpointSPN != null && krbEndpointSPN.length() > 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("The Service Principal Name to use on the endpoint: " + krbEndpointSPN));
                }
            } else {
                throw new AlfrescoRuntimeException("endpoint service principal name not specified");
            }
            this.krbEndpointSPN = krbEndpointSPN;
            String loginEntry = config.getLoginEntryName();
            if (loginEntry != null) {
                if (loginEntry.length() > 0) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("The login configuration entry name to use: " + loginEntry));
                    }
                    this.jaasLoginEntryName = loginEntry;
                } else {
                    throw new AlfrescoRuntimeException("Invalid login entry specified");
                }
            }
            boolean stripUserNameSuffix = config.getStripUserNameSuffix();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("The stripUserNameSuffix property is set to: " + stripUserNameSuffix));
            }
            this.stripUserNameSuffix = stripUserNameSuffix;
            try {
                this.jaasLoginContext = new LoginContext(this.jaasLoginEntryName, (CallbackHandler)this);
                this.jaasLoginContext.login();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"HTTP Kerberos login successful");
                }
            }
            catch (LoginException ex) {
                if (logger.isErrorEnabled()) {
                    logger.error((Object)"HTTP Kerberos web filter error", (Throwable)ex);
                }
                throw new AlfrescoRuntimeException("Failed to login HTTP server service");
            }
            Subject subj = this.jaasLoginContext.getSubject();
            Principal princ = subj.getPrincipals().iterator().next();
            this.krbAccountName = princ.getName();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Logged on using principal " + this.krbAccountName));
            }
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.context = applicationContext;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    protected ServletRequest wrapHeaderAuthenticatedRequest(ServletRequest sreq) {
        if (this.userHeader != null && sreq instanceof HttpServletRequest) {
            HttpServletRequest req = (HttpServletRequest)sreq;
            sreq = new /* Unavailable Anonymous Inner Class!! */;
        }
        return sreq;
    }

    public void doFilter(ServletContext context, ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.doFilter(request, response, chain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest sreq, ServletResponse sresp, FilterChain chain) throws IOException, ServletException {
        block68: {
            PageViewResolver pageViewResolver;
            boolean skip;
            block67: {
                skip = false;
                try {
                    AIMSConfig aimsConfig = (AIMSConfig)this.context.getBean("aims.config");
                    if (aimsConfig.isEnabled()) {
                        skip = true;
                    }
                }
                catch (BeansException e) {
                    if (!logger.isErrorEnabled()) break block67;
                    logger.error((Object)e);
                }
            }
            if (skip) {
                chain.doFilter(sreq, sresp);
                return;
            }
            NDC.remove();
            NDC.push((String)Thread.currentThread().getName());
            boolean debug = logger.isDebugEnabled();
            sreq = this.wrapHeaderAuthenticatedRequest(sreq);
            if (this.endpoint == null) {
                if (debug) {
                    logger.debug((Object)"There is no endpoint with external auth enabled.");
                }
                chain.doFilter(sreq, sresp);
                return;
            }
            HttpServletRequest req = (HttpServletRequest)sreq;
            HttpServletResponse res = (HttpServletResponse)sresp;
            HttpSession session = req.getSession();
            if (req.getServletPath() != null && req.getServletPath().startsWith(UNAUTHENTICATED_ACCESS_PROXY)) {
                if (debug) {
                    logger.debug((Object)"SSO is by-passed for unauthenticated access endpoint.");
                }
                chain.doFilter(sreq, sresp);
                return;
            }
            if (debug) {
                logger.debug((Object)("Processing request " + req.getRequestURI() + " SID:" + session.getId()));
            }
            String pathInfo = req.getPathInfo();
            if (PAGE_SERVLET_PATH.equals(req.getServletPath()) && (LOGIN_PATH_INFORMATION.equals(pathInfo) || pathInfo == null && LOGIN_PARAMETER.equals(req.getParameter("pt")))) {
                if (debug) {
                    logger.debug((Object)"Login page requested, chaining ...");
                }
                chain.doFilter(sreq, sresp);
                return;
            }
            RequestContext context = null;
            try {
                context = RequestContextUtil.initRequestContext((ApplicationContext)this.context, (HttpServletRequest)req, (boolean)true);
            }
            catch (Exception ex) {
                logger.error((Object)"Error calling initRequestContext", (Throwable)ex);
                throw new ServletException((Throwable)ex);
            }
            Page page = context.getPage();
            if (page == null && pathInfo != null && (pageViewResolver = (PageViewResolver)this.context.getBean(PAGE_VIEW_RESOLVER)) != null) {
                try {
                    if (pageViewResolver.resolveViewName(pathInfo, null) != null) {
                        page = context.getPage();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (page != null && page.getAuthentication() == Description.RequiredAuthentication.none) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Unauthenticated page requested - skipping auth filter...");
                }
                chain.doFilter(sreq, sresp);
                return;
            }
            if (this.userHeader != null) {
                String userId = AuthenticationUtil.getUserId((HttpServletRequest)req);
                if (userId != null && req.getRemoteUser() != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"userHeader external auth - skipping auth filter...");
                    }
                    this.setExternalAuthSession(session);
                    this.onSuccess(req, res, session, req.getRemoteUser());
                    chain.doFilter(sreq, sresp);
                    return;
                }
                this.challengeOrPassThrough(chain, req, res, session);
                return;
            }
            String authHdr = req.getHeader(HEADER_AUTHORIZATION);
            if (authHdr == null && AuthenticationUtil.isAuthenticated((HttpServletRequest)req)) {
                if (debug) {
                    logger.debug((Object)"Touching the repo to ensure we still have an authenticated session.");
                }
                this.challengeOrPassThrough(chain, req, res, session);
                return;
            }
            if (authHdr == null) {
                if (debug) {
                    logger.debug((Object)("New auth request from " + req.getRemoteHost() + " (" + req.getRemoteAddr() + ":" + req.getRemotePort() + ")"));
                }
                this.challengeOrPassThrough(chain, req, res, session);
                return;
            }
            if (authHdr.startsWith(AUTH_SPNEGO) && this.krbRealm != null) {
                byte[] spnegoByts;
                if (debug) {
                    logger.debug((Object)"Processing SPNEGO / Kerberos authentication.");
                }
                if (this.isNTLMSSPBlob(spnegoByts = Base64.decode((byte[])authHdr.substring(10).getBytes()), 0)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Client sent an NTLMSSP security blob");
                    }
                    this.restartAuthProcess(session, req, res, AUTH_SPNEGO);
                    return;
                }
                int tokType = -1;
                try {
                    tokType = SPNEGO.checkTokenType((byte[])spnegoByts, (int)0, (int)spnegoByts.length);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (tokType == 0) {
                    if (debug) {
                        logger.debug((Object)"Parsing the SPNEGO security blob to get the Kerberos ticket.");
                    }
                    NegTokenInit negToken = new NegTokenInit();
                    try {
                        negToken.decode(spnegoByts, 0, spnegoByts.length);
                        String oidStr = null;
                        if (negToken.numberOfOids() > 0) {
                            oidStr = negToken.getOidAt(0).toString();
                        }
                        if (oidStr != null && (oidStr.equals("1.2.840.48018.1.2.2") || oidStr.equals("1.2.840.113554.1.2.2"))) {
                            if (debug) {
                                logger.debug((Object)"Kerberos logon.");
                            }
                            if (this.doKerberosLogon(negToken, req, res, session) != null) {
                                chain.doFilter((ServletRequest)req, (ServletResponse)res);
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)"Request processing ended");
                                }
                            } else {
                                this.restartAuthProcess(session, req, res, AUTH_SPNEGO);
                            }
                            break block68;
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Unsupported SPNEGO mechanism " + oidStr));
                        }
                        this.restartAuthProcess(session, req, res, AUTH_SPNEGO);
                    }
                    catch (IOException ex) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)ex);
                        }
                        break block68;
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Unknown SPNEGO token type");
                }
                this.restartAuthProcess(session, req, res, AUTH_SPNEGO);
            } else if (authHdr.startsWith(AUTH_NTLM)) {
                if (debug) {
                    logger.debug((Object)"Processing NTLM authentication.");
                }
                byte[] authHdrByts = authHdr.substring(5).getBytes();
                byte[] ntlmByts = Base64.decode((byte[])authHdrByts);
                int ntlmTyp = NTLMMessage.isNTLMType((byte[])ntlmByts);
                Object sessionMutex = WebUtils.getSessionMutex((HttpSession)session);
                if (ntlmTyp == 1) {
                    if (debug) {
                        logger.debug((Object)"Process the type 1 NTLM message.");
                    }
                    Type1NTLMMessage type1Msg = new Type1NTLMMessage(ntlmByts);
                    Object object = sessionMutex;
                    synchronized (object) {
                        this.processType1(type1Msg, req, res, session);
                    }
                } else if (ntlmTyp == 3) {
                    if (debug) {
                        logger.debug((Object)"Process the type 3 NTLM message.");
                    }
                    Type3NTLMMessage type3Msg = new Type3NTLMMessage(ntlmByts);
                    Object object = sessionMutex;
                    synchronized (object) {
                        this.processType3(type3Msg, req, res, session, chain);
                    }
                } else {
                    if (debug) {
                        logger.debug((Object)"NTLM not handled, redirecting to login page");
                    }
                    this.redirectToLoginPage(req, res);
                }
            } else {
                if (debug) {
                    logger.debug((Object)"Processing Basic Authentication.");
                }
                if (AuthenticationUtil.isAuthenticated((HttpServletRequest)req) || req.getRemoteUser() != null) {
                    if (debug) {
                        logger.debug((Object)"Ensuring the session is still valid.");
                    }
                    this.challengeOrPassThrough(chain, req, res, session);
                } else {
                    if (debug) {
                        logger.debug((Object)"Establish a new session or bring up the login page.");
                    }
                    chain.doFilter((ServletRequest)req, (ServletResponse)res);
                }
            }
        }
    }

    private void clearSession(HttpSession session) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Clearing the session.");
        }
        Enumeration names = session.getAttributeNames();
        while (names.hasMoreElements()) {
            session.removeAttribute((String)names.nextElement());
        }
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Processing the JAAS callback list of " + callbacks.length + " items."));
        }
        for (int i = 0; i < callbacks.length; ++i) {
            Callback cb;
            if (callbacks[i] instanceof NameCallback) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Request for user name.");
                }
                cb = (NameCallback)callbacks[i];
                ((NameCallback)cb).setName(this.krbAccountName);
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Request for password.");
                }
                cb = (PasswordCallback)callbacks[i];
                ((PasswordCallback)cb).setPassword(this.krbPassword.toCharArray());
                continue;
            }
            if (callbacks[i] instanceof RealmCallback) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Request for realm.");
                }
                cb = (RealmCallback)callbacks[i];
                ((TextInputCallback)cb).setText(this.krbRealm);
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i]);
        }
    }

    private void challengeOrPassThrough(FilterChain chain, HttpServletRequest req, HttpServletResponse res, HttpSession session) throws IOException, ServletException {
        try {
            ConnectorContext ctx;
            String userId = AuthenticationUtil.getUserId((HttpServletRequest)req);
            if (userId == null) {
                userId = req.getRemoteUser();
                session.setAttribute("_alfExternalAuth", (Object)Boolean.TRUE);
                if (userId != null && logger.isDebugEnabled()) {
                    logger.debug((Object)("Initial login from externally authenticated user " + userId));
                }
                if (userId == null && this.krbRealm == null) {
                    this.redirectToLoginPage(req, res);
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("Validating repository session for " + userId));
            }
            if (userId != null && !userId.equalsIgnoreCase(req.getRemoteUser()) && session.getAttribute(NTLM_AUTH_DETAILS) == null && session.getAttribute(AUTH_BY_KERBEROS) == null) {
                session.removeAttribute("_alfExternalAuth");
            }
            Connector conn = this.connectorService.getConnector(this.endpoint, userId, session);
            if (req.getHeader(HEADER_ACCEPT_LANGUAGE) != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Accept-Language header present: " + req.getHeader(HEADER_ACCEPT_LANGUAGE)));
                }
                ctx = new ConnectorContext(null, Collections.singletonMap(HEADER_ACCEPT_LANGUAGE, req.getHeader(HEADER_ACCEPT_LANGUAGE)));
            } else {
                ctx = new ConnectorContext();
            }
            Response remoteRes = conn.call("/touch", ctx);
            if (401 == remoteRes.getStatus().getCode()) {
                String authHdr;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Repository session timed out - restarting auth process...");
                }
                if ((authHdr = (String)remoteRes.getStatus().getHeaders().get(HEADER_WWWAUTHENTICATE)) != null) {
                    this.restartAuthProcess(session, req, res, authHdr);
                } else {
                    if (req.getRemoteUser() == null) {
                        try {
                            session.invalidate();
                        }
                        catch (IllegalStateException illegalStateException) {
                            // empty catch block
                        }
                    }
                    this.redirectToLoginPage(req, res);
                }
                return;
            }
            this.onSuccess(req, res, session, userId);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Authentication not required, chaining ...");
            }
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
            return;
        }
        catch (ConnectorServiceException cse) {
            throw new PlatformRuntimeException("Incorrectly configured endpoint ID: " + this.endpoint);
        }
    }

    public void destroy() {
    }

    private Map<String, String> getConnectionHeaders(Connector conn) {
        HashMap<String, String> headers = new HashMap<String, String>(4);
        headers.put("user-agent", "");
        if (conn.getConnectorSession().getCookie("JSESSIONID") == null) {
            headers.put("Cookie", null);
        }
        headers.put("Content-Type", null);
        headers.put("Content-Length", null);
        return headers;
    }

    private void restartAuthProcess(HttpSession session, HttpServletRequest req, HttpServletResponse res, String authHdr) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Restarting " + authHdr + " authentication."));
        }
        this.clearSession(session);
        this.setRedirectUrl(req);
        res.setHeader(HEADER_WWWAUTHENTICATE, authHdr);
        res.setStatus(401);
        res.setContentType(MIME_HTML_TEXT);
        PrintWriter out = res.getWriter();
        out.println("<html><head>");
        out.println("<meta http-equiv=\"Refresh\" content=\"0; url=" + req.getContextPath() + "/page?pt=login\">");
        out.println("</head><body><p>Please <a href=\"" + req.getContextPath() + "/page?pt=login\">log in</a>.</p>");
        out.println("</body></html>");
        out.close();
        res.flushBuffer();
    }

    private void processType1(Type1NTLMMessage type1Msg, HttpServletRequest req, HttpServletResponse res, HttpSession session) throws IOException {
        NTLMLogonDetails ntlmDetails;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Received type1 " + type1Msg));
        }
        if ((ntlmDetails = (NTLMLogonDetails)session.getAttribute(NTLM_AUTH_DETAILS)) != null && ntlmDetails.hasType2Message()) {
            Type2NTLMMessage cachedType2 = ntlmDetails.getType2Message();
            byte[] type2Bytes = cachedType2.getBytes();
            String ntlmBlob = "NTLM " + new String(Base64.encodeBytes((byte[])type2Bytes, (int)8));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Sending cached NTLM type2 to client - " + cachedType2));
            }
            res.setHeader(HEADER_WWWAUTHENTICATE, ntlmBlob);
            res.setStatus(401);
            res.flushBuffer();
        } else {
            session.removeAttribute(NTLM_AUTH_DETAILS);
            try {
                Connector conn = this.connectorService.getConnector(this.endpoint, session);
                ConnectorContext ctx = new ConnectorContext(null, this.getConnectionHeaders(conn));
                Response remoteRes = conn.call("/touch", ctx, req, null);
                if (401 == remoteRes.getStatus().getCode()) {
                    String authHdr = (String)remoteRes.getStatus().getHeaders().get(HEADER_WWWAUTHENTICATE);
                    if (authHdr.startsWith(AUTH_NTLM) && authHdr.length() > 4) {
                        byte[] authHdrByts = authHdr.substring(5).getBytes();
                        byte[] ntlmByts = Base64.decode((byte[])authHdrByts);
                        int ntlmType = NTLMMessage.isNTLMType((byte[])ntlmByts);
                        if (ntlmType == 2) {
                            Type2NTLMMessage type2Msg = new Type2NTLMMessage(ntlmByts);
                            ntlmDetails = new NTLMLogonDetails();
                            ntlmDetails.setType2Message(type2Msg);
                            session.setAttribute(NTLM_AUTH_DETAILS, (Object)ntlmDetails);
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Sending NTLM type2 to client - " + type2Msg));
                            }
                            byte[] type2Bytes = type2Msg.getBytes();
                            String ntlmBlob = "NTLM " + new String(Base64.encodeBytes((byte[])type2Bytes, (int)8));
                            res.setHeader(HEADER_WWWAUTHENTICATE, ntlmBlob);
                            res.setStatus(401);
                            res.flushBuffer();
                        } else {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Unexpected NTLM message type from repository: NTLMType" + ntlmType));
                            }
                            this.redirectToLoginPage(req, res);
                        }
                    } else {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Unexpected response from repository: WWW-Authenticate:" + authHdr));
                        }
                        this.redirectToLoginPage(req, res);
                    }
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Unexpected response from repository: " + remoteRes.getStatus().getMessage()));
                    }
                    this.redirectToLoginPage(req, res);
                }
            }
            catch (ConnectorServiceException cse) {
                throw new PlatformRuntimeException("Incorrectly configured endpoint ID: " + this.endpoint);
            }
        }
    }

    private void processType3(Type3NTLMMessage type3Msg, HttpServletRequest req, HttpServletResponse res, HttpSession session, FilterChain chain) throws IOException, ServletException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Received type3 " + type3Msg));
        }
        NTLMLogonDetails ntlmDetails = (NTLMLogonDetails)session.getAttribute(NTLM_AUTH_DETAILS);
        String userId = AuthenticationUtil.getUserId((HttpServletRequest)req);
        String userName = type3Msg.getUserName();
        String workstation = type3Msg.getWorkstation();
        String domain = type3Msg.getDomain();
        boolean authenticated = false;
        if (userId != null && ntlmDetails != null && ntlmDetails.hasNTLMHashedPassword()) {
            byte[] ntlmPwd = type3Msg.getNTLMHash();
            byte[] cachedPwd = ntlmDetails.getNTLMHashedPassword();
            if (ntlmPwd != null && ntlmPwd.length == cachedPwd.length) {
                authenticated = true;
                for (int i = 0; i < ntlmPwd.length; ++i) {
                    if (ntlmPwd[i] == cachedPwd[i]) continue;
                    authenticated = false;
                    break;
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Using cached NTLM hash, authenticated = " + authenticated));
            }
            if (!authenticated) {
                this.restartAuthProcess(session, req, res, AUTH_NTLM);
            } else {
                chain.doFilter((ServletRequest)req, (ServletResponse)res);
            }
        } else {
            try {
                Connector conn = this.connectorService.getConnector(this.endpoint, session);
                ConnectorContext ctx = new ConnectorContext(null, this.getConnectionHeaders(conn));
                Response remoteRes = conn.call("/touch", ctx, req, null);
                if (401 == remoteRes.getStatus().getCode()) {
                    String authHdr = (String)remoteRes.getStatus().getHeaders().get(HEADER_WWWAUTHENTICATE);
                    if (authHdr.equals(AUTH_NTLM)) {
                        String userAgent = req.getHeader("user-agent");
                        if (userAgent != null && userAgent.indexOf("Safari") != -1 && userAgent.indexOf("Chrome") == -1) {
                            res.setStatus(401);
                            PrintWriter out = res.getWriter();
                            out.println("<html><head></head>");
                            out.println("<body><p>Login authentication failed. Please close and re-open Safari to try again.</p>");
                            out.println("</body></html>");
                            out.close();
                        } else {
                            this.restartAuthProcess(session, req, res, authHdr);
                        }
                        res.flushBuffer();
                    } else {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Unexpected response from repository: WWW-Authenticate:" + authHdr));
                        }
                        this.redirectToLoginPage(req, res);
                    }
                } else if (200 == remoteRes.getStatus().getCode() || 307 == remoteRes.getStatus().getCode()) {
                    if (ntlmDetails == null) {
                        ntlmDetails = new NTLMLogonDetails(userName, workstation, domain, false, null);
                        ntlmDetails.setNTLMHashedPassword(type3Msg.getNTLMHash());
                        session.setAttribute(NTLM_AUTH_DETAILS, (Object)ntlmDetails);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"No cached NTLM details, created");
                        }
                    } else {
                        ntlmDetails.setDetails(userName, workstation, domain, false, null);
                        ntlmDetails.setNTLMHashedPassword(type3Msg.getNTLMHash());
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"Updated cached NTLM details");
                        }
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("User logged on via NTLM, " + ntlmDetails));
                    }
                    this.setExternalAuthSession(session);
                    this.onSuccess(req, res, session, userName);
                    chain.doFilter((ServletRequest)req, (ServletResponse)res);
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Unexpected response from repository: " + remoteRes.getStatus().getMessage()));
                    }
                    this.redirectToLoginPage(req, res);
                }
            }
            catch (ConnectorServiceException cse) {
                throw new PlatformRuntimeException("Incorrectly configured endpoint: " + this.endpoint);
            }
        }
    }

    private void redirectToLoginPage(HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Redirecting to the login page.");
        }
        if (PAGE_SERVLET_PATH.equals(req.getServletPath())) {
            this.setRedirectUrl(req);
            String error = req.getParameter(ERROR_PARAMETER);
            res.sendRedirect(req.getContextPath() + "/page?pt=login" + (String)(error == null ? "" : "&error=" + error));
        } else {
            res.setStatus(401);
            res.flushBuffer();
        }
    }

    private boolean isNTLMSSPBlob(byte[] byts, int offset) {
        boolean isNTLMSSP = false;
        if (byts.length - offset >= NTLM.Signature.length) {
            int idx;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Checking if the blob has the NTLMSSP signature.");
            }
            for (idx = 0; idx < NTLM.Signature.length && byts[offset + idx] == NTLM.Signature[idx]; ++idx) {
            }
            if (idx == NTLM.Signature.length) {
                isNTLMSSP = true;
            }
        }
        return isNTLMSSP;
    }

    private NegTokenTarg doKerberosLogon(NegTokenInit negToken, HttpServletRequest req, HttpServletResponse resp, HttpSession httpSess) {
        NegTokenTarg negTokenTarg;
        block8: {
            KerberosDetails krbDetails = null;
            negTokenTarg = null;
            try {
                KerberosSessionSetupPrivilegedAction sessSetupAction = new KerberosSessionSetupPrivilegedAction(this.krbAccountName, negToken.getMechtoken(), this.krbEndpointSPN);
                Object result = Subject.doAs(this.jaasLoginContext.getSubject(), sessSetupAction);
                if (result != null) {
                    Pair resultPair = (Pair)result;
                    krbDetails = (KerberosDetails)resultPair.getFirst();
                    String tokenForEndpoint = (String)resultPair.getSecond();
                    negTokenTarg = new NegTokenTarg(0, OID.KERBEROS5, krbDetails.getResponseToken());
                    if (negTokenTarg != null) {
                        boolean authenticated;
                        String userName;
                        String string = userName = this.stripUserNameSuffix ? krbDetails.getUserName() : krbDetails.getSourceName();
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("User " + userName + " logged on via Kerberos; attempting to log on to Alfresco then"));
                        }
                        if (!(authenticated = this.doKerberosDelegateLogin(req, resp, httpSess, userName, tokenForEndpoint))) {
                            return null;
                        }
                        httpSess.setAttribute(AUTH_BY_KERBEROS, (Object)true);
                    }
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)"No SPNEGO response, Kerberos logon failed");
                }
            }
            catch (Exception ex) {
                if (!logger.isDebugEnabled()) break block8;
                logger.debug((Object)"Kerberos logon error", (Throwable)ex);
            }
        }
        return negTokenTarg;
    }

    private boolean doKerberosDelegateLogin(HttpServletRequest req, HttpServletResponse res, HttpSession session, String userName, String tokenForEndpoint) throws IOException {
        block17: {
            try {
                ConnectorContext ctx;
                Connector conn = this.connectorService.getConnector(this.endpoint, session);
                if (req.getHeader(HEADER_ACCEPT_LANGUAGE) != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Accept-Language header present: " + req.getHeader(HEADER_ACCEPT_LANGUAGE)));
                    }
                    HashMap<String, String> headers = new HashMap<String, String>(7);
                    headers.put(HEADER_ACCEPT_LANGUAGE, req.getHeader(HEADER_ACCEPT_LANGUAGE));
                    ctx = new ConnectorContext(null, headers);
                } else {
                    ctx = new ConnectorContext();
                }
                Response remoteRes = conn.call("/touch", ctx);
                if (401 == remoteRes.getStatus().getCode()) {
                    String authHdr = (String)remoteRes.getStatus().getHeaders().get(HEADER_WWWAUTHENTICATE);
                    if (authHdr.equals(AUTH_SPNEGO)) {
                        HashMap<String, Object> headers = new HashMap<String, Object>(7);
                        headers.put(HEADER_AUTHORIZATION, "Negotiate " + tokenForEndpoint);
                        if (req.getHeader(HEADER_ACCEPT_LANGUAGE) != null) {
                            headers.put(HEADER_ACCEPT_LANGUAGE, req.getHeader(HEADER_ACCEPT_LANGUAGE));
                        }
                        if (200 == (remoteRes = conn.call("/touch", ctx = new ConnectorContext(null, headers))).getStatus().getCode() || 307 == remoteRes.getStatus().getCode()) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)"Authentication succeeded on the repo side.");
                            }
                            this.setExternalAuthSession(session);
                            this.onSuccess(req, res, session, userName);
                        } else if (401 == remoteRes.getStatus().getCode()) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)"Authentication failed on repo side - beging login process again.");
                            }
                            res.setHeader(HEADER_WWWAUTHENTICATE, authHdr);
                            res.setStatus(401);
                            res.flushBuffer();
                        }
                        break block17;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Unexpected response from repository: WWW-Authenticate:" + authHdr));
                    }
                    return false;
                }
                if (200 == remoteRes.getStatus().getCode() || 307 == remoteRes.getStatus().getCode()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Authentication succeeded on the repo side.");
                    }
                    this.setExternalAuthSession(session);
                    this.onSuccess(req, res, session, userName);
                    break block17;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Unexpected response from repository: " + remoteRes.getStatus().getMessage()));
                }
                return false;
            }
            catch (ConnectorServiceException cse) {
                throw new AlfrescoRuntimeException("Incorrectly configured endpoint: " + this.endpoint);
            }
        }
        return true;
    }

    private void setRedirectUrl(HttpServletRequest req) {
        HttpSession session = req.getSession();
        session.setAttribute("_redirectURI", (Object)req.getRequestURI());
        if (req.getQueryString() != null) {
            session.setAttribute("_redirectQueryString", (Object)req.getQueryString());
        }
    }

    private void setExternalAuthSession(HttpSession session) {
        session.setAttribute("_alfExternalAuth", (Object)Boolean.TRUE);
    }

    private void onSuccess(HttpServletRequest req, HttpServletResponse res, HttpSession session, String username) {
        session.setAttribute("_alf_USER_ID", (Object)username);
        try {
            this.loginController.beforeSuccess(req, res);
        }
        catch (Exception e) {
            throw new AlfrescoRuntimeException("Error during loginController.onSuccess()", (Throwable)e);
        }
    }
}

