/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.site.servlet;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.alfresco.web.site.servlet.config.AIMSConfig;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.adapters.servlet.OIDCFilterSessionStore;
import org.keycloak.adapters.spi.KeycloakAccount;
import org.keycloak.representations.adapters.config.AdapterConfig;
import org.springframework.extensions.surf.mvc.LogoutController;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class AIMSLogoutController
extends AbstractController {
    protected AIMSConfig config;
    protected LogoutController logoutController;

    public void setConfig(AIMSConfig config) {
        this.config = config;
    }

    public void setLogoutController(LogoutController logoutController) {
        this.logoutController = logoutController;
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.config.isEnabled()) {
            if (request.getParameter("success") != null) {
                this.logoutController.handleRequestInternal(request, response);
                this.doRedirect(response, request.getContextPath());
            } else {
                OIDCFilterSessionStore.SerializableKeycloakAccount account;
                String userId;
                HttpSession session = request.getSession(false);
                if (session != null && (userId = (String)session.getAttribute("_alf_USER_ID")) != null && (account = (OIDCFilterSessionStore.SerializableKeycloakAccount)session.getAttribute(KeycloakAccount.class.getName())) != null) {
                    KeycloakDeployment deployment = KeycloakDeploymentBuilder.build((AdapterConfig)this.config.getAdapterConfig());
                    UrlBuilder urlBuilder = new UrlBuilder(deployment.getLogoutUrl().clone().build(new Object[0]).toString());
                    urlBuilder.addParameter("id_token_hint", (Object)account.getKeycloakSecurityContext().getIdTokenString());
                    urlBuilder.addParameter("post_logout_redirect_uri", (Object)(request.getRequestURL() + "?success"));
                    this.doRedirect(response, urlBuilder.toString());
                }
            }
        }
        return null;
    }

    protected void doRedirect(HttpServletResponse response, String location) {
        response.setStatus(301);
        response.setHeader("Location", location);
        response.setHeader("Cache-Control", "max-age=0");
    }
}

