/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.site;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.alfresco.web.site.servlet.MTAuthenticationFilter;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.RequestContextUtil;
import org.springframework.extensions.surf.ServletUtil;
import org.springframework.extensions.surf.WebFrameworkServiceRegistry;
import org.springframework.extensions.surf.exception.UserFactoryException;
import org.springframework.extensions.surf.mvc.AbstractWebFrameworkInterceptor;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.surf.util.URLDecoder;
import org.springframework.ui.ModelMap;
import org.springframework.web.context.request.WebRequest;

public class UserDashboardInterceptor
extends AbstractWebFrameworkInterceptor {
    private static final Pattern PATTERN_DASHBOARD_PATH = Pattern.compile(".*/user/([^/]*)/dashboard");

    public void preHandle(WebRequest request) throws Exception {
        HttpServletRequest req;
        Matcher matcher;
        RequestContext rc = ThreadLocalRequestContext.getRequestContext();
        String pathInfo = rc.getUri();
        if (pathInfo != null && (matcher = PATTERN_DASHBOARD_PATH.matcher(pathInfo)).matches() && (req = MTAuthenticationFilter.getCurrentServletRequest()) != null) {
            try {
                ServletUtil.setRequest((HttpServletRequest)req);
                RequestContextUtil.populateRequestContext((RequestContext)rc, (HttpServletRequest)req);
                String userid = rc.getUserId();
                String usernameFromURL = URLDecoder.decode((String)matcher.group(1));
                if (this.isUserIDMatchingUsernameFromURL(userid, usernameFromURL)) {
                    WebFrameworkServiceRegistry serviceRegistry = rc.getServiceRegistry();
                    if (serviceRegistry.getModelObjectService().getPage("user/" + userid + "/dashboard") == null) {
                        HashMap<String, String> tokens = new HashMap<String, String>(2);
                        tokens.put("userid", userid);
                        serviceRegistry.getPresetsManager().constructPreset("user-dashboard", tokens);
                    }
                } else {
                    rc.setUser(null);
                    rc.setPage(ThreadLocalRequestContext.getRequestContext().getRootPage());
                }
            }
            catch (UserFactoryException userFactoryException) {
                // empty catch block
            }
        }
    }

    private boolean isUserIDMatchingUsernameFromURL(String userid, String usernameFromURL) {
        if (userid == null || usernameFromURL == null) {
            return false;
        }
        return this.shouldUseCaseSensitiveUsernameCompare() ? userid.equals(usernameFromURL) : userid.equalsIgnoreCase(usernameFromURL);
    }

    private boolean shouldUseCaseSensitiveUsernameCompare() {
        return false;
    }

    public void postHandle(WebRequest request, ModelMap model) throws Exception {
    }

    public void afterCompletion(WebRequest request, Exception ex) throws Exception {
    }
}

