/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.cmm;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.web.cmm.CMMService;
import org.alfresco.web.scripts.DictionaryQuery;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.springframework.extensions.surf.ModuleDeploymentService;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.ServletUtil;
import org.springframework.extensions.surf.exception.ConnectorServiceException;
import org.springframework.extensions.surf.exception.ModelObjectPersisterException;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.surf.types.ExtensionModule;
import org.springframework.extensions.surf.types.ModuleDeployment;
import org.springframework.extensions.surf.uri.UriUtils;
import org.springframework.extensions.surf.util.StringBuilderWriter;
import org.springframework.extensions.surf.util.URLEncoder;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Description;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.connector.Connector;
import org.springframework.extensions.webscripts.connector.ConnectorContext;
import org.springframework.extensions.webscripts.connector.HttpMethod;
import org.springframework.extensions.webscripts.connector.Response;
import org.springframework.extensions.webscripts.processor.FTLTemplateProcessor;

public abstract class CMMService
extends DeclarativeWebScript {
    private static final Log logger = LogFactory.getLog(CMMService.class);
    private static final String JSON_APPEARANCE = "appearance";
    private static final String JSON_LABEL = "label";
    private static final String JSON_STYLECLASS = "styleclass";
    private static final String JSON_STYLE = "style";
    private static final String JSON_MAXLENGTH = "maxlength";
    private static final String JSON_READ_ONLY = "read-only";
    private static final String JSON_HIDDEN = "hidden";
    private static final String JSON_FORCE = "force";
    private static final String JSON_ANY = "any";
    private static final String JSON_FOR_MODE = "for-mode";
    private static final String JSON_CONTROLTYPE = "controltype";
    private static final String JSON_ELEMENTCONFIG = "elementconfig";
    private static final String JSON_ID = "id";
    private static final String JSON_COLUMN = "column";
    private static final String JSON_PSEUDONYM = "pseudonym";
    private static final String JSON_PROPERTIES = "properties";
    private static final String JSON_TITLE = "title";
    private static final String JSON_PREFIXEDNAME = "prefixedName";
    private static final String JSON_ENTRY = "entry";
    private static final String JSON_ACTIVE = "ACTIVE";
    private static final String JSON_STATUS = "status";
    private static final String JSON_ARGUMENTS = "arguments";
    private static final String JSON_DATA = "data";
    private static final String JSON_OPERATION = "operation";
    private static final String JSON_TYPES = "types";
    private static final String TEMPLATE_SET = "set";
    private static final String TEMPLATE_LABEL = "label";
    private static final String TEMPLATE_APPEARANCE = "appearance";
    private static final String TEMPLATE_PASSWORD = "password";
    private static final String TEMPLATE_STYLE = "style";
    private static final String TEMPLATE_STYLECLASS = "styleclass";
    private static final String TEMPLATE_MAXLENGTH = "maxLength";
    private static final String TEMPLATE_READONLY = "readonly";
    private static final String TEMPLATE_FORCE = "force";
    private static final String TEMPLATE_MODE = "mode";
    private static final String TEMPLATE_PARAMS = "params";
    private static final String TEMPLATE_ID = "id";
    private static final String TEMPLATE_FIELDS = "fields";
    private static final String TEMPLATE_SETS = "sets";
    private static final String TEMPLATE_PROPERTIES = "properties";
    private static final String TEMPLATE_TITLE = "title";
    private static final String TEMPLATE_FORM = "form";
    private static final String TEMPLATE_NAME = "name";
    private static final String TEMPLATE_ENTITIES = "entities";
    private static final String TEMPLATE_ASPECTS = "aspects";
    private static final String TEMPLATE_SUBTYPES = "subtypes";
    private static final String TEMPLATE_TYPES = "types";
    private static final String TEMPLATE_MODULE_NAME = "moduleName";
    private static final String TEMPLATE_TEMPLATE = "template";
    private static final String CONTROLTYPE_DEFAULT = "default";
    private static final String CONTROLTYPE_PASSWORD = "password";
    private static final String CONTROLTYPE_RICHTEXT = "richtext";
    private static final String CONTROLTYPE_TEXTAREA = "textarea";
    private static final String CONTROLTYPE_CONTENT = "content";
    private static final String CONTROLTYPE_TEXTFIELD = "textfield";
    private static final String CONTROLTYPE_HIDDEN = "hidden";
    private static final String CONTROLTYPE_SIZE = "size";
    private static final String CONTROLTYPE_MIMETYPE = "mimetype";
    private static final String CONTROLTYPE_TAGGABLE = "taggable";
    private static final String CONTROLTYPE_CATEGORIES = "categories";
    private static final String CM_FOLDER = "cm:folder";
    private static final String CM_CONTENT = "cm:content";
    private static final String MODULE_PREFIX = "CMM_";
    private static final String MODULE_TEMPLATE_PATH = "/org/alfresco/cmm/components/module-configuration.ftl";
    protected static final String DEFAULT_OK_RESULT = "{\"success\":true}";
    private static final String OP_DELETE_PROPERTY = "deleteProperty";
    private static final String OP_EDIT_PROPERTY = "editProperty";
    private static final String OP_CREATE_PROPERTY = "createProperty";
    private static final String OP_DELETE_PROPERTY_GROUP = "deletePropertyGroup";
    private static final String OP_EDIT_PROPERTY_GROUP = "editPropertyGroup";
    private static final String OP_CREATE_PROPERTY_GROUP = "createPropertyGroup";
    private static final String OP_DELETE_TYPE = "deleteType";
    private static final String OP_EDIT_TYPE = "editType";
    private static final String OP_CREATE_TYPE = "createType";
    private static final String OP_DELETE_MODEL = "deleteModel";
    private static final String OP_DEACTIVATE_MODEL = "deactivateModel";
    private static final String OP_ACTIVATE_MODEL = "activateModel";
    private static final String OP_EDIT_MODEL = "editModel";
    private static final String OP_CREATE_MODEL = "createModel";
    protected static Map<String, String> operationMapping = new /* Unavailable Anonymous Inner Class!! */;
    protected ModuleDeploymentService moduleDeploymentService;
    protected DictionaryQuery dictionary;
    protected FTLTemplateProcessor templateProcessor;
    public static final Cache CACHE_NEVER = new Cache((Description.RequiredCache)new /* Unavailable Anonymous Inner Class!! */);

    public void setModuleDeploymentService(ModuleDeploymentService moduleDeploymentService) {
        this.moduleDeploymentService = moduleDeploymentService;
    }

    public void setDictionary(DictionaryQuery dictionary) {
        this.dictionary = dictionary;
    }

    public void setTemplateProcessor(FTLTemplateProcessor templateProcessor) {
        this.templateProcessor = templateProcessor;
    }

    protected String serviceModelOperation(Status status, String modelName, JSONObject json) throws IOException {
        int statusCode;
        String opId = (String)json.get((Object)JSON_OPERATION);
        JSONObject data = (JSONObject)json.get((Object)JSON_DATA);
        String url = (String)operationMapping.get(opId);
        if (url == null) {
            throw new IllegalArgumentException("Specified API operation does not map to a known URL: " + opId);
        }
        HashMap<String, String> args = new HashMap<String, String>();
        JSONObject arguments = (JSONObject)json.get((Object)JSON_ARGUMENTS);
        if (arguments != null) {
            for (String key : arguments.keySet()) {
                args.put(key, URLEncoder.encode((String)((String)arguments.get((Object)key))));
            }
        }
        url = UriUtils.replaceUriTokens((String)url, args);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Executing service operation: " + opId + " with URL: " + url + " method: " + this.getDescription().getMethod() + " - using data:\n" + (data != null ? data.toJSONString() : "null")));
        }
        Map updatedForms = null;
        Response preResponse = null;
        switch (opId) {
            case "deleteModel": 
            case "deactivateModel": {
                JSONObject model = this.getModel(modelName);
                String prefix = (String)model.get((Object)"namespacePrefix");
                preResponse = this.getConnector().call("/api/dictionary?model=" + URLEncoder.encode((String)prefix) + ":" + URLEncoder.encode((String)modelName));
                break;
            }
            case "editModel": {
                ExtensionModule module;
                JSONObject model = this.getModel(modelName);
                String oldPrefix = (String)model.get((Object)"namespacePrefix");
                String newPrefix = (String)data.get((Object)"namespacePrefix");
                if (newPrefix.equals(oldPrefix) || (module = this.getExtensionModule(modelName)) == null || (updatedForms = this.getFormDefinitions(module)).size() == 0) break;
                for (String formId : updatedForms.keySet()) {
                    String form = (String)updatedForms.get(formId);
                    updatedForms.put(formId, form.replace("\"id\":\"" + oldPrefix + ":", "\"id\":\"" + newPrefix + ":"));
                }
                break;
            }
        }
        Response res = data != null ? this.getAPIConnector().call(url, new ConnectorContext(HttpMethod.valueOf((String)this.getDescription().getMethod())), (InputStream)new ByteArrayInputStream(data.toJSONString().getBytes("UTF-8"))) : this.getAPIConnector().call(url, new ConnectorContext(HttpMethod.valueOf((String)this.getDescription().getMethod())));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Response: " + res.getStatus().getCode() + "\n" + res.getResponse()));
        }
        if ((statusCode = res.getStatus().getCode()) >= 200 && statusCode < 300) {
            switch (opId) {
                case "activateModel": {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("ACTIVATE model config id: " + modelName));
                    }
                    this.updateDictionaryForModel(modelName);
                    this.buildExtensionModule(status, modelName, null, true);
                    break;
                }
                case "deactivateModel": {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("DEACTIVATE model config id: " + modelName));
                    }
                    if (preResponse != null && preResponse.getStatus().getCode() == 200) {
                        this.dictionary.updateRemoveClasses(preResponse.getResponse());
                    } else if (logger.isWarnEnabled()) {
                        logger.warn((Object)"Unable to update Share local Data Dictionary as Repository API call failed.");
                    }
                    this.buildExtensionModule(status, modelName, null, false);
                    break;
                }
                case "createModel": {
                    break;
                }
                case "editModel": {
                    if (updatedForms == null || updatedForms.size() == 0) break;
                    this.buildExtensionModule(status, modelName, new FormOperation(this, FormOperationEnum.Create, updatedForms), false);
                    break;
                }
                case "deleteModel": {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Deleting extension and form definitions for model: " + modelName));
                    }
                    this.deleteExtensionModule(status, modelName);
                    break;
                }
                case "createType": 
                case "editType": {
                    if (!this.isModelActive(this.getModel(modelName))) break;
                    this.updateDictionaryForModel(modelName);
                    this.buildExtensionModule(status, modelName, null, true);
                    break;
                }
                case "deleteType": 
                case "deletePropertyGroup": {
                    break;
                }
                case "createPropertyGroup": 
                case "editPropertyGroup": {
                    if (!this.isModelActive(this.getModel(modelName))) break;
                    this.buildExtensionModule(status, modelName, null, true);
                    this.updateDictionaryForModel(modelName);
                    break;
                }
                case "createProperty": 
                case "deleteProperty": {
                    if (!this.isModelActive(this.getModel(modelName))) break;
                    this.buildExtensionModule(status, modelName, null, true);
                }
            }
        }
        status.setCode(statusCode);
        return res.getResponse();
    }

    private void updateDictionaryForModel(String modelName) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Updating dictionary for model: " + modelName));
        }
        JSONObject model = this.getModel(modelName);
        String prefix = (String)model.get((Object)"namespacePrefix");
        Response res = this.getConnector().call("/api/dictionary?model=" + URLEncoder.encode((String)prefix) + ":" + URLEncoder.encode((String)modelName));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Dictionary get response " + res.getStatus().getCode() + "\n" + res.getResponse()));
        }
        if (res.getStatus().getCode() == 200) {
            this.dictionary.updateAddClasses(res.getResponse());
        }
    }

    protected JSONObject getModel(String modelName) {
        Response res = this.getAPIConnector().call("/-default-/private/alfresco/versions/1/cmm/" + URLEncoder.encode((String)modelName));
        if (res.getStatus().getCode() == 200) {
            return (JSONObject)this.getJsonBody(res).get((Object)JSON_ENTRY);
        }
        throw new AlfrescoRuntimeException("Unable to retrieve model information: " + modelName + " (" + res.getStatus().getCode() + ")");
    }

    protected String buildModuleId(String modelName) {
        return MODULE_PREFIX + modelName;
    }

    private boolean isModelActive(JSONObject model) {
        return model.get((Object)JSON_STATUS).equals(JSON_ACTIVE);
    }

    protected void buildExtensionModule(Status status, String modelName, FormOperation formOp) {
        boolean active = this.isModelActive(this.getModel(modelName));
        this.buildExtensionModule(status, modelName, formOp, active);
    }

    protected void buildExtensionModule(Status status, String modelName, FormOperation formOp, JSONObject model) {
        boolean active = this.isModelActive(model);
        this.buildExtensionModule(status, modelName, formOp, active);
    }

    protected void buildExtensionModule(Status status, String modelName, FormOperation formOp, boolean active) {
        String moduleId = this.buildModuleId(modelName);
        TWrapper model = new TWrapper(8);
        model.put(TEMPLATE_MODULE_NAME, (Object)moduleId);
        ArrayList<TWrapper> typeList = new ArrayList<TWrapper>();
        model.put("types", typeList);
        ArrayList<TWrapper> subtypesList = new ArrayList<TWrapper>();
        model.put(TEMPLATE_SUBTYPES, subtypesList);
        ArrayList<TWrapper> aspectsList = new ArrayList<TWrapper>();
        model.put(TEMPLATE_ASPECTS, aspectsList);
        ArrayList<TWrapper> entitiesList = new ArrayList<TWrapper>();
        model.put(TEMPLATE_ENTITIES, entitiesList);
        Map formDefs = new HashMap();
        ExtensionModule module = this.getExtensionModule(modelName);
        if (module != null) {
            formDefs = this.getFormDefinitions(module);
        }
        if (formOp != null) {
            formOp.perform(formDefs);
        }
        for (String entityId : formDefs.keySet()) {
            TWrapper wrapper = new TWrapper(4);
            wrapper.put(TEMPLATE_NAME, (Object)entityId).put(TEMPLATE_FORM, formDefs.get(entityId));
            entitiesList.add(wrapper);
        }
        if (active) {
            Response response = this.getAPIConnector().call("/-default-/private/alfresco/versions/1/cmm/" + URLEncoder.encode((String)modelName) + "?select=all");
            if (response.getStatus().getCode() == 200) {
                JSONObject jsonData = this.getJsonBody(response);
                JSONArray types = (JSONArray)((JSONObject)jsonData.get((Object)JSON_ENTRY)).get((Object)"types");
                HashMap subtypeMap = new HashMap();
                for (Object t : types) {
                    JSONObject type = (JSONObject)t;
                    String typeName = (String)type.get((Object)JSON_PREFIXEDNAME);
                    TWrapper formWrappers = this.processFormWidgets(formDefs, type);
                    if (formWrappers.size() == 0) continue;
                    TWrapper typeWrapper = new TWrapper(8);
                    typeWrapper.put(TEMPLATE_NAME, (Object)typeName).put("title", (Object)((String)type.get((Object)"title")));
                    typeList.add(typeWrapper);
                    typeWrapper.putAll((Map)formWrappers);
                    if (!this.dictionary.isSubType(typeName, CM_CONTENT) && !this.dictionary.isSubType(typeName, CM_FOLDER)) continue;
                    String parentType = typeName;
                    do {
                        ArrayList<TWrapper> subtypes;
                        if ((subtypes = (ArrayList<TWrapper>)subtypeMap.get(parentType = this.dictionary.getParent(parentType))) == null) {
                            subtypes = new ArrayList<TWrapper>(4);
                            subtypeMap.put(parentType, subtypes);
                        }
                        boolean found = false;
                        for (TWrapper st : subtypes) {
                            if (!st.get((Object)TEMPLATE_NAME).equals(typeName)) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        TWrapper subtypeWrapper = new TWrapper(4);
                        subtypeWrapper.put(TEMPLATE_NAME, (Object)typeName).put("title", (Object)this.dictionary.getTitle(typeName));
                        subtypes.add(subtypeWrapper);
                    } while (!CM_CONTENT.equals(parentType) && !CM_FOLDER.equals(parentType));
                }
                for (String type : subtypeMap.keySet()) {
                    TWrapper stypeWrapper = new TWrapper(4);
                    stypeWrapper.put(TEMPLATE_NAME, (Object)type).put(TEMPLATE_SUBTYPES, subtypeMap.get(type));
                    subtypesList.add(stypeWrapper);
                }
                JSONArray aspects = (JSONArray)((JSONObject)jsonData.get((Object)JSON_ENTRY)).get((Object)TEMPLATE_ASPECTS);
                for (Object a : aspects) {
                    JSONObject aspect = (JSONObject)a;
                    String aspectName = (String)aspect.get((Object)JSON_PREFIXEDNAME);
                    TWrapper formWrappers = this.processFormWidgets(formDefs, aspect);
                    TWrapper aspectWrapper = new TWrapper(8);
                    aspectWrapper.put(TEMPLATE_NAME, (Object)aspectName).put("title", (Object)((String)aspect.get((Object)"title")));
                    aspectsList.add(aspectWrapper);
                    aspectWrapper.putAll((Map)formWrappers);
                }
            } else {
                throw new AlfrescoRuntimeException("Unable to retrieve types and aspects for model id: " + modelName);
            }
        }
        StringBuilderWriter out = new StringBuilderWriter(4096);
        try {
            this.templateProcessor.process(MODULE_TEMPLATE_PATH, (Object)model, (Writer)out);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Attempting to save module config:\r\n" + out.toString()));
            }
            if (module == null) {
                this.moduleDeploymentService.addModuleToExtension(out.toString());
            } else {
                this.moduleDeploymentService.updateModuleToExtension(out.toString());
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"addModuleToExtension() completed.");
            }
        }
        catch (DocumentException | ModelObjectPersisterException | WebScriptException err) {
            logger.error((Object)"Failed to execute template to construct module configuration.", err);
            this.errorResponse(status, err.getMessage());
        }
    }

    protected TWrapper processFormWidgets(Map<String, String> forms, JSONObject entity) {
        TWrapper formPropertyWrappers = new TWrapper(8);
        String entityName = (String)entity.get((Object)TEMPLATE_NAME);
        String formDef = forms.get(entityName);
        if (formDef != null) {
            try {
                JSONArray formElements;
                Object o = new JSONParser().parse(formDef);
                if (o instanceof JSONArray && (formElements = (JSONArray)o).size() != 0) {
                    ArrayList properties = new ArrayList();
                    formPropertyWrappers.put("properties", properties);
                    ArrayList<TWrapper> sets = new ArrayList<TWrapper>();
                    formPropertyWrappers.put(TEMPLATE_SETS, sets);
                    ArrayList fields = new ArrayList();
                    formPropertyWrappers.put(TEMPLATE_FIELDS, fields);
                    HashMap<String, TWrapper> fieldMap = new HashMap<String, TWrapper>();
                    for (Object item : formElements) {
                        JSONObject config;
                        String panelLabel;
                        TWrapper fieldWrapper;
                        String name;
                        if (!(item instanceof JSONObject)) {
                            throw new IllegalStateException("Unexpected item in form structure: " + formDef);
                        }
                        int numCols = 0;
                        String columnSetTemplate = null;
                        switch (name = (String)((JSONObject)item).get((Object)JSON_PSEUDONYM)) {
                            case "cmm/editor/layout/1cols": {
                                numCols = 1;
                                break;
                            }
                            case "cmm/editor/layout/2cols": {
                                numCols = 2;
                                columnSetTemplate = "/org/alfresco/components/form/2-column-set.ftl";
                                break;
                            }
                            case "cmm/editor/layout/2colswideleft": {
                                numCols = 2;
                                columnSetTemplate = "/org/alfresco/components/form/2-column-wide-left-set.ftl";
                                break;
                            }
                            case "cmm/editor/layout/3cols": {
                                numCols = 3;
                                columnSetTemplate = "/org/alfresco/components/form/3-column-set.ftl";
                            }
                        }
                        if (numCols == 0) continue;
                        ArrayList<TWrapper> colProperties = new ArrayList<TWrapper>();
                        JSONArray column = (JSONArray)((JSONObject)item).get((Object)JSON_COLUMN);
                        if (column != null) {
                            for (Object w : column) {
                                String styleClass;
                                String style;
                                Number maxLength;
                                Boolean readOnly;
                                Boolean hidden;
                                Boolean force;
                                JSONObject widget = (JSONObject)w;
                                String pseudonym = (String)widget.get((Object)JSON_PSEUDONYM);
                                String id = (String)widget.get((Object)"id");
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("Processing widget: " + id + " of type: " + pseudonym));
                                }
                                TWrapper controlProperties = new TWrapper(4).put(TEMPLATE_NAME, (Object)id);
                                colProperties.add(controlProperties);
                                JSONObject config2 = (JSONObject)widget.get((Object)JSON_ELEMENTCONFIG);
                                if (config2 == null) continue;
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)"Found 'elementconfig' for widget - processing...");
                                }
                                HashMap<String, Object> controlParams = new HashMap<String, Object>(4);
                                fieldWrapper = new TWrapper(4).put("id", (Object)id).put(TEMPLATE_PARAMS, controlParams);
                                fieldMap.put(id, fieldWrapper);
                                String controlType = (String)config2.get((Object)JSON_CONTROLTYPE);
                                String mode = (String)config2.get((Object)JSON_FOR_MODE);
                                if (mode != null && !mode.equals(JSON_ANY)) {
                                    controlProperties.put(TEMPLATE_MODE, (Object)mode);
                                }
                                if (config2.get((Object)"force") instanceof Boolean && Boolean.TRUE == (force = (Boolean)config2.get((Object)"force"))) {
                                    controlProperties.put("force", (Object)true);
                                }
                                if (config2.get((Object)"hidden") instanceof Boolean && Boolean.TRUE == (hidden = (Boolean)config2.get((Object)"hidden"))) {
                                    controlType = "hidden";
                                }
                                if (config2.get((Object)JSON_READ_ONLY) instanceof Boolean && Boolean.TRUE == (readOnly = (Boolean)config2.get((Object)JSON_READ_ONLY))) {
                                    fieldWrapper.put(TEMPLATE_READONLY, (Object)true);
                                }
                                if ((maxLength = (Number)config2.get((Object)JSON_MAXLENGTH)) != null) {
                                    controlParams.put(TEMPLATE_MAXLENGTH, maxLength);
                                }
                                if ((style = (String)config2.get((Object)"style")) != null && style.length() != 0) {
                                    controlParams.put("style", style);
                                }
                                if ((styleClass = (String)config2.get((Object)"styleclass")) != null && styleClass.length() != 0) {
                                    controlParams.put("styleclass", styleClass);
                                }
                                String template = null;
                                if (controlType == null) continue;
                                switch (controlType) {
                                    case "textfield": {
                                        template = "/org/alfresco/components/form/controls/textfield.ftl";
                                        break;
                                    }
                                    case "textarea": {
                                        template = "/org/alfresco/components/form/controls/textarea.ftl";
                                        break;
                                    }
                                    case "content": {
                                        template = "/org/alfresco/components/form/controls/content.ftl";
                                        break;
                                    }
                                    case "richtext": {
                                        template = "/org/alfresco/components/form/controls/richtext.ftl";
                                        break;
                                    }
                                    case "password": {
                                        template = "/org/alfresco/components/form/controls/textfield.ftl";
                                        controlParams.put("password", "true");
                                        break;
                                    }
                                    case "hidden": {
                                        template = "/org/alfresco/components/form/controls/hidden.ftl";
                                        break;
                                    }
                                    case "size": {
                                        template = "/org/alfresco/components/form/controls/size.ftl";
                                        break;
                                    }
                                    case "mimetype": {
                                        template = "/org/alfresco/components/form/controls/mimetype.ftl";
                                        break;
                                    }
                                    case "taggable": {
                                        controlParams.put("compactMode", "true");
                                        controlParams.put(TEMPLATE_PARAMS, "aspect=cm:taggable");
                                        controlParams.put("createNewItemUri", "/api/tag/workspace/SpacesStore");
                                        controlParams.put("createNewItemIcon", "tag");
                                        break;
                                    }
                                    case "categories": {
                                        controlParams.put("compactMode", "true");
                                        break;
                                    }
                                    case "default": {
                                        break;
                                    }
                                    default: {
                                        if (!logger.isDebugEnabled()) break;
                                        logger.debug((Object)("WARNING: unknown control type for template mapping: " + controlType));
                                    }
                                }
                                if (template == null) continue;
                                fieldWrapper.put(TEMPLATE_TEMPLATE, (Object)template);
                                if (!logger.isDebugEnabled()) continue;
                                logger.debug((Object)("Widget control template: " + template));
                            }
                        }
                        boolean hasLabel = (panelLabel = (String)(config = (JSONObject)((JSONObject)item).get((Object)JSON_ELEMENTCONFIG)).get((Object)"label")) != null && panelLabel.length() != 0;
                        String setId = entity.get((Object)JSON_PREFIXEDNAME) + "_cmm_set" + sets.size();
                        TWrapper setWrapper = new TWrapper(8);
                        setWrapper.put("appearance", hasLabel ? config.get((Object)"appearance") : "whitespace").put("id", (Object)setId);
                        if (numCols > 1) {
                            setWrapper.put(TEMPLATE_TEMPLATE, (Object)columnSetTemplate);
                        }
                        if (hasLabel) {
                            setWrapper.put("label", config.get((Object)"label"));
                        }
                        sets.add(setWrapper);
                        for (TWrapper property : colProperties) {
                            String id = (String)property.get((Object)TEMPLATE_NAME);
                            fieldWrapper = (TWrapper)fieldMap.get(id);
                            if (fieldWrapper == null) {
                                fieldWrapper = new TWrapper(4).put("id", (Object)id);
                                fieldMap.put(id, fieldWrapper);
                            }
                            fieldWrapper.put(TEMPLATE_SET, (Object)setId);
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug((Object)("Field mapping of: " + id + " mapped to set:" + setId));
                        }
                        properties.addAll(colProperties);
                    }
                    fields.addAll(fieldMap.values());
                }
            }
            catch (ParseException e) {
                logger.warn((Object)("Unable to parse Form definition for entity: " + entityName + "\n" + formDef + "\n" + e.getMessage()));
            }
        }
        return formPropertyWrappers;
    }

    protected void deleteExtensionModule(Status status, String modelName) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Attempting to delete module: " + this.buildModuleId(modelName)));
        }
        try {
            this.moduleDeploymentService.deleteModuleFromExtension(this.buildModuleId(modelName));
        }
        catch (DocumentException | ModelObjectPersisterException err) {
            logger.error((Object)"Failed to execute template to construct module configuration.", err);
            this.errorResponse(status, err.getMessage());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"deleteModuleFromExtension() completed.");
        }
    }

    protected ExtensionModule getExtensionModule(String modelName) {
        String moduleId = this.buildModuleId(modelName);
        ExtensionModule module = null;
        for (ModuleDeployment m : this.moduleDeploymentService.getDeployedModules()) {
            if (!moduleId.equals(m.getId())) continue;
            module = m.getExtensionModule();
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Found existing module for ID: " + moduleId));
        }
        if (module == null && logger.isDebugEnabled()) {
            logger.debug((Object)("No module found for ID: " + moduleId));
        }
        return module;
    }

    protected Map<String, String> getFormDefinitions(String modelName) {
        return this.getFormDefinitions(this.getExtensionModule(modelName));
    }

    protected Map<String, String> getFormDefinitions(ExtensionModule module) {
        HashMap<String, String> forms = new HashMap<String, String>();
        if (module != null) {
            List configs = module.getConfigurations();
            for (Element config : configs) {
                ArrayList<Element> nodeForms = new ArrayList<Element>();
                for (Object obj : config.selectNodes("config/form-definition")) {
                    nodeForms.add((Element)obj);
                }
                for (Element form : nodeForms) {
                    String formId = form.attributeValue("id");
                    String formJSON = form.getText();
                    forms.put(formId, formJSON);
                }
            }
        }
        return forms;
    }

    protected Connector getConnector() {
        RequestContext rc = ThreadLocalRequestContext.getRequestContext();
        try {
            return rc.getServiceRegistry().getConnectorService().getConnector("alfresco", rc.getUserId(), ServletUtil.getSession());
        }
        catch (ConnectorServiceException e) {
            throw new AlfrescoRuntimeException("Connector exception.", (Throwable)e);
        }
    }

    protected Connector getAPIConnector() {
        RequestContext rc = ThreadLocalRequestContext.getRequestContext();
        try {
            return rc.getServiceRegistry().getConnectorService().getConnector("alfresco-api", rc.getUserId(), ServletUtil.getSession());
        }
        catch (ConnectorServiceException e) {
            throw new AlfrescoRuntimeException("Connector exception.", (Throwable)e);
        }
    }

    protected JSONObject getJsonBody(WebScriptRequest req) {
        try {
            Object o;
            JSONObject jsonData = null;
            String content = req.getContent().getContent();
            if (content != null && content.length() != 0 && (o = new JSONParser().parse(content)) instanceof JSONObject) {
                jsonData = (JSONObject)o;
            }
            return jsonData;
        }
        catch (IOException | ParseException e) {
            throw new AlfrescoRuntimeException("Failed to retrieve or parse JSON body.", e);
        }
    }

    protected JSONObject getJsonBody(Response res) {
        try {
            Object o;
            JSONObject jsonData = null;
            String content = res.getResponse();
            if (content != null && content.length() != 0 && (o = new JSONParser().parse(content)) instanceof JSONObject) {
                jsonData = (JSONObject)o;
            }
            return jsonData;
        }
        catch (ParseException e) {
            throw new AlfrescoRuntimeException("Failed to retrieve or parse JSON body.", (Throwable)e);
        }
    }

    protected void errorResponse(Status status, String msg) {
        status.setCode(500);
        status.setMessage(msg);
        status.setRedirect(true);
    }
}

