/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.site.servlet;

import java.io.IOException;
import java.util.Collections;
import java.util.UUID;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.web.site.servlet.SlingshotLoginController;
import org.alfresco.web.site.servlet.config.AIMSConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.adapters.servlet.KeycloakOIDCFilter;
import org.keycloak.adapters.servlet.OIDCFilterSessionStore;
import org.keycloak.adapters.spi.KeycloakAccount;
import org.keycloak.representations.adapters.config.AdapterConfig;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.surf.FrameworkUtil;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.ServletUtil;
import org.springframework.extensions.surf.UserFactory;
import org.springframework.extensions.surf.exception.ConnectorServiceException;
import org.springframework.extensions.surf.exception.RequestContextException;
import org.springframework.extensions.surf.exception.UserFactoryException;
import org.springframework.extensions.surf.site.AuthenticationUtil;
import org.springframework.extensions.surf.support.ServletRequestContextFactory;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.webscripts.connector.Connector;
import org.springframework.extensions.webscripts.connector.ConnectorContext;
import org.springframework.extensions.webscripts.connector.ConnectorService;
import org.springframework.extensions.webscripts.connector.CredentialVault;
import org.springframework.extensions.webscripts.connector.Credentials;
import org.springframework.extensions.webscripts.connector.HttpMethod;
import org.springframework.extensions.webscripts.connector.Response;
import org.springframework.extensions.webscripts.connector.User;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class AIMSFilter
extends KeycloakOIDCFilter {
    private static final Log logger = LogFactory.getLog(AIMSFilter.class);
    private ApplicationContext context;
    private ConnectorService connectorService;
    private SlingshotLoginController loginController;
    private boolean enabled = false;
    public static final String ALFRESCO_ENDPOINT_ID = "alfresco";
    public static final String ALFRESCO_API_ENDPOINT_ID = "alfresco-api";
    public static final String SHARE_PAGE = "/share/page";
    public static final String SHARE_AIMS_LOGOUT = "/share/page/aims/logout";

    public void init(FilterConfig filterConfig) throws ServletException {
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Initializing the AIMS filter.");
        }
        super.init(filterConfig);
        this.context = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)filterConfig.getServletContext());
        AIMSConfig config = (AIMSConfig)this.context.getBean("aims.config");
        this.enabled = config.isEnabled();
        this.connectorService = (ConnectorService)this.context.getBean("connector.service");
        this.loginController = (SlingshotLoginController)this.context.getBean("loginController");
        if (this.enabled) {
            KeycloakDeployment deployment = KeycloakDeploymentBuilder.build((AdapterConfig)config.getAdapterConfig());
            if (!deployment.isConfigured() || deployment.getRealm().isEmpty() || deployment.getResourceName().isEmpty() || deployment.getAuthServerBaseUrl().isEmpty()) {
                throw new AlfrescoRuntimeException("AIMS is not configured properly; realm, resource and auth-server-url should not be empty.");
            }
            this.deploymentContext.updateDeployment(config.getAdapterConfig());
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)"AIMS filter initialized.");
        }
    }

    public void doFilter(ServletRequest sreq, ServletResponse sres, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)sreq;
        HttpServletResponse response = (HttpServletResponse)sres;
        HttpSession session = request.getSession();
        if (this.enabled && (request.getRequestURI().contains(SHARE_PAGE) || request.getRequestURI().contains(SHARE_AIMS_LOGOUT))) {
            OIDCFilterSessionStore.SerializableKeycloakAccount account;
            if (session != null && (account = (OIDCFilterSessionStore.SerializableKeycloakAccount)session.getAttribute(KeycloakAccount.class.getName())) != null && !account.getKeycloakSecurityContext().refreshExpiredToken(false)) {
                session.invalidate();
            }
            super.doFilter(sreq, sres, chain);
            RefreshableKeycloakSecurityContext context = (RefreshableKeycloakSecurityContext)request.getAttribute(KeycloakSecurityContext.class.getName());
            if (context != null && !AuthenticationUtil.isAuthenticated((HttpServletRequest)request)) {
                this.onSuccess(request, response, session, context);
            }
        } else {
            chain.doFilter(sreq, sres);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSuccess(HttpServletRequest request, HttpServletResponse response, HttpSession session, RefreshableKeycloakSecurityContext context) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Completing the AIMS authentication.");
        }
        String username = context.getToken().getPreferredUsername();
        String accessToken = context.getTokenString();
        AIMSFilter aIMSFilter = this;
        synchronized (aIMSFilter) {
            try {
                this.initRequestContext(request, response);
                String alfTicket = this.getAlfTicket(session, username, accessToken);
                if (alfTicket != null) {
                    session.setAttribute("_alf_USER_ID", (Object)username);
                    session.setAttribute("_alfExternalAuthAIMS", (Object)true);
                    Connector connector = this.connectorService.getConnector(ALFRESCO_ENDPOINT_ID, username, session);
                    connector.getConnectorSession().setParameter("alfTicket", alfTicket);
                    CredentialVault vault = FrameworkUtil.getCredentialVault((HttpSession)session, (String)username);
                    Credentials credentials = vault.newCredentials(ALFRESCO_ENDPOINT_ID);
                    credentials.setProperty("cleartextUsername", (Object)username);
                    vault.store(credentials);
                    this.loginController.beforeSuccess(request, response);
                    this.initUser(request);
                } else {
                    logger.error((Object)"Could not get an alfTicket from Repository.");
                }
            }
            catch (Exception e) {
                throw new AlfrescoRuntimeException("Failed to complete AIMS authentication process.", (Throwable)e);
            }
        }
    }

    private void initRequestContext(HttpServletRequest request, HttpServletResponse response) throws RequestContextException {
        RequestContext context = ThreadLocalRequestContext.getRequestContext();
        if (context == null) {
            ServletRequestContextFactory factory = (ServletRequestContextFactory)this.context.getBean("webframework.factory.requestcontext.servlet");
            context = factory.newInstance((WebRequest)new ServletWebRequest(request));
            request.setAttribute("requestContext", (Object)context);
        }
        RequestContextHolder.setRequestAttributes((RequestAttributes)new ServletRequestAttributes(request, response));
        ServletUtil.setRequest((HttpServletRequest)request);
    }

    private void initUser(HttpServletRequest request) throws UserFactoryException {
        RequestContext context = ThreadLocalRequestContext.getRequestContext();
        if (context != null && context.getUser() == null) {
            String userEndpointId = (String)((Object)context.getAttribute("alfUserEndpoint"));
            UserFactory userFactory = context.getServiceRegistry().getUserFactory();
            User user = userFactory.initialiseUser(context, request, userEndpointId);
            context.setUser(user);
        }
    }

    private String getAlfTicket(HttpSession session, String username, String accessToken) throws ConnectorServiceException {
        String alfTicket;
        block6: {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Retrieving the Alfresco Ticket from Repository.");
            }
            alfTicket = null;
            Connector connector = this.connectorService.getConnector(ALFRESCO_API_ENDPOINT_ID, username, session);
            ConnectorContext c = new ConnectorContext(HttpMethod.GET, null, Collections.singletonMap("Authorization", "Bearer " + accessToken));
            c.setContentType("application/json");
            Response r = connector.call("/-default-/public/authentication/versions/1/tickets/-me-?noCache=" + UUID.randomUUID().toString(), c);
            if (200 != r.getStatus().getCode()) {
                if (logger.isErrorEnabled()) {
                    logger.error((Object)"Failed to retrieve Alfresco Ticket from Repository.");
                }
            } else {
                JSONObject json = new JSONObject(r.getText());
                try {
                    alfTicket = json.getJSONObject("entry").getString("id");
                }
                catch (JSONException e) {
                    if (!logger.isErrorEnabled()) break block6;
                    logger.error((Object)"Failed to parse Alfresco Ticket from Repository response.");
                }
            }
        }
        return alfTicket;
    }
}

