/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.scripts;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.htmlparser.Attribute;
import org.htmlparser.Node;
import org.htmlparser.NodeFactory;
import org.htmlparser.Parser;
import org.htmlparser.PrototypicalNodeFactory;
import org.htmlparser.tags.DoctypeTag;
import org.htmlparser.util.NodeIterator;
import org.htmlparser.util.ParserException;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.extensions.webscripts.connector.HttpMethod;
import org.springframework.extensions.webscripts.connector.RemoteClient;
import org.springframework.extensions.webscripts.ui.common.StringUtils;

public class SlingshotRemoteClient
extends RemoteClient {
    private static final Pattern CONTENT_PATTERN_TO_CHECK = Pattern.compile(".*/(api|slingshot)/(node|path)/(content.*/)?workspace/SpacesStore/.+");
    private static final Pattern TRASHCAN_PATTERN_TO_CHECK = Pattern.compile(".*/(api|slingshot)/(node|path)/(content.*/)?archive/SpacesStore/.+");
    private static final Pattern CONTENT_PATTERN_TO_WHITE_LIST = Pattern.compile(".*/api/node/workspace/SpacesStore/[a-z0-9-]+/content/thumbnails/webpreview");
    private static final Pattern SLINGSHOT_WIKI_PAGE_PATTERN = Pattern.compile(".*/slingshot/wiki/page/.*");
    private static final Pattern SLINGSHOT_WIKI_VERSION_PATTERN = Pattern.compile(".*/slingshot/wiki/version/.*");
    private boolean swfEnabled = false;

    public void setSwfEnabled(boolean swfEnabled) {
        this.swfEnabled = swfEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyResponseStreamOutput(URL url, HttpServletResponse res, OutputStream out, HttpResponse response, String contentType, int bufferSize) throws IOException {
        Header cd;
        boolean processed = false;
        if (res != null && this.getRequestMethod() == HttpMethod.GET && response.getStatusLine().getStatusCode() >= 200 && response.getStatusLine().getStatusCode() < 300 && ((cd = response.getFirstHeader("Content-Disposition")) == null || !cd.getValue().startsWith("attachment")) && (contentType != null && (CONTENT_PATTERN_TO_CHECK.matcher(url.getPath()).matches() && !CONTENT_PATTERN_TO_WHITE_LIST.matcher(url.getPath()).matches() || SLINGSHOT_WIKI_PAGE_PATTERN.matcher(url.getPath()).matches() || SLINGSHOT_WIKI_VERSION_PATTERN.matcher(url.getPath()).matches()) || TRASHCAN_PATTERN_TO_CHECK.matcher(url.getPath()).matches())) {
            String mimetype = contentType;
            String encoding = null;
            int csi = contentType.indexOf("charset=");
            if (csi != -1) {
                mimetype = contentType.substring(0, csi - 1).toLowerCase();
                encoding = contentType.substring(csi + "charset=".length());
            }
            if (mimetype.contains("text/html") || mimetype.contains("application/xhtml+xml") || mimetype.contains("text/xml") && !encoding.contains("UTF-16")) {
                InputStream input;
                ByteArrayOutputStream bos = new ByteArrayOutputStream(bufferSize);
                if (response.getEntity() != null && (input = response.getEntity().getContent()) != null) {
                    String content;
                    try {
                        byte[] buffer = new byte[bufferSize];
                        int read = input.read(buffer);
                        while (read != -1) {
                            for (int i = 0; i < read; ++i) {
                                if (buffer[i] != 0) continue;
                                res.setContentLength(0);
                                out.close();
                                return;
                            }
                            bos.write(buffer, 0, read);
                            read = input.read(buffer);
                        }
                    }
                    finally {
                        input.close();
                    }
                    String string = content = encoding != null ? new String(bos.toByteArray(), encoding) : new String(bos.toByteArray());
                    if (mimetype.contains("text/html") || mimetype.contains("application/xhtml+xml")) {
                        content = StringUtils.stripUnsafeHTMLDocument((String)content, (boolean)false);
                    } else if (mimetype.contains("text/xml")) {
                        res.setContentType("text/plain");
                    } else if (mimetype.contains("text/x-component")) {
                        res.setContentType("text/plain");
                    }
                    try {
                        byte[] bytes = encoding != null ? content.getBytes(encoding) : content.getBytes();
                        res.setContentLength(bytes.length);
                        out.write(bytes);
                    }
                    finally {
                        out.close();
                    }
                }
                processed = true;
            } else if ((mimetype.contains("application/x-shockwave-flash") || mimetype.contains("image/svg+xml")) && !this.swfEnabled) {
                String msg = I18NUtil.getMessage((String)"security.insecuremimetype");
                try {
                    byte[] bytes = encoding != null ? msg.getBytes(encoding) : msg.getBytes();
                    res.setContentType("text/plain");
                    res.setContentLength(bytes.length);
                    out.write(bytes);
                }
                finally {
                    out.close();
                }
                processed = true;
            }
        }
        if (!processed) {
            super.copyResponseStreamOutput(url, res, out, response, contentType, bufferSize);
        }
    }

    protected boolean hasDocType(String content, String docType, boolean encode) {
        try {
            Parser parser = Parser.createParser((String)content, (String)"UTF-8");
            PrototypicalNodeFactory factory = new PrototypicalNodeFactory();
            parser.setNodeFactory((NodeFactory)factory);
            NodeIterator itr = parser.elements();
            while (itr.hasMoreNodes()) {
                DoctypeTag docTypeTag;
                Vector attrs;
                Node node = itr.nextNode();
                if (!(node instanceof DoctypeTag) || (attrs = (docTypeTag = (DoctypeTag)node).getAttributesEx()) == null || attrs.size() <= 1) continue;
                for (Attribute attr : attrs) {
                    String name = attr.getName();
                    if (name == null || !name.equalsIgnoreCase(docType)) continue;
                    return true;
                }
            }
        }
        catch (ParserException parserException) {
            // empty catch block
        }
        return false;
    }
}

