/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config.properties;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.web.config.util.BaseTest;
import org.alfresco.web.site.servlet.config.AIMSConfig;
import org.junit.Assert;
import org.keycloak.common.enums.SslRequired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.config.ConfigService;
import org.springframework.extensions.config.xml.XMLConfigService;

public class AIMSConfigTest
extends BaseTest {
    public static final String CLASSPATH_SHARE_CONFIG_PROPERTIES = "classpath*:alfresco/module/*/share-config.properties";
    private static final String TEST_CONFIG_AIMS_BASIC_XML = "test-config-aims-basic.xml";

    private List<String> getConfigFiles() {
        ArrayList<String> result = new ArrayList<String>(1);
        result.add(TEST_CONFIG_AIMS_BASIC_XML);
        return result;
    }

    @Override
    public String getResourcesDir() {
        return "classpath:";
    }

    private void clearSystemProperties() {
        System.clearProperty("aims.enabled");
        System.clearProperty("aims.realm");
        System.clearProperty("aims.resource");
        System.clearProperty("aims.authServerUrl");
        System.clearProperty("aims.sslRequired");
        System.clearProperty("aims.publicClient");
        System.clearProperty("aims.autodetectBearerOnly");
        System.clearProperty("aims.alwaysRefreshToken");
        System.clearProperty("aims.principalAttribute");
        System.clearProperty("aims.enableBasicAuth");
    }

    private AIMSConfig initAIMSConfig() {
        AIMSConfig aimsConfig = new AIMSConfig();
        try {
            Resource[] resources = new PathMatchingResourcePatternResolver().getResources(CLASSPATH_SHARE_CONFIG_PROPERTIES);
            XMLConfigService configService = this.initXMLConfigServiceWithProperties(this.getConfigFiles(), resources);
            Assert.assertNotNull((Object)configService);
            Config config = configService.getConfig((Object)"AIMS");
            Assert.assertNotNull((Object)config);
            aimsConfig.setConfigService((ConfigService)configService);
            aimsConfig.init();
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
        return aimsConfig;
    }

    public void testDefaultPropertiesAreSetCorrectly() {
        this.clearSystemProperties();
        AIMSConfig aimsConfig = this.initAIMSConfig();
        Assert.assertFalse((boolean)aimsConfig.isEnabled());
        Assert.assertEquals((Object)aimsConfig.getAdapterConfig().getRealm(), (Object)"");
        Assert.assertEquals((Object)aimsConfig.getAdapterConfig().getResource(), (Object)"");
        Assert.assertEquals((Object)aimsConfig.getAdapterConfig().getAuthServerUrl(), (Object)"");
        Assert.assertEquals((Object)aimsConfig.getAdapterConfig().getSslRequired().toUpperCase(), (Object)SslRequired.EXTERNAL.toString());
        Assert.assertFalse((boolean)aimsConfig.getAdapterConfig().isPublicClient());
        Assert.assertFalse((boolean)aimsConfig.getAdapterConfig().isAutodetectBearerOnly());
        Assert.assertFalse((boolean)aimsConfig.getAdapterConfig().isAlwaysRefreshToken());
        Assert.assertEquals((Object)aimsConfig.getAdapterConfig().getPrincipalAttribute(), (Object)"sub");
        Assert.assertFalse((boolean)aimsConfig.getAdapterConfig().isEnableBasicAuth());
    }

    public void testSslRequiredCantHaveInvalidValueSet() {
        this.clearSystemProperties();
        System.setProperty("aims.sslRequired", "invalid");
        AIMSConfig aimsConfig = this.initAIMSConfig();
        Assert.assertEquals((Object)aimsConfig.getAdapterConfig().getSslRequired().toUpperCase(), (Object)SslRequired.EXTERNAL.toString());
    }

    public void testSslRequiredIsCorrectlySetForAValidValue() {
        this.clearSystemProperties();
        System.setProperty("aims.sslRequired", SslRequired.ALL.toString().toLowerCase());
        AIMSConfig aimsConfig = this.initAIMSConfig();
        Assert.assertEquals((Object)aimsConfig.getAdapterConfig().getSslRequired().toUpperCase(), (Object)SslRequired.ALL.toString());
    }

    public void testFromSystemEnvironmentAreSetCorrectly() {
        this.clearSystemProperties();
        System.setProperty("aims.enabled", "false");
        System.setProperty("aims.realm", "alfresco");
        System.setProperty("aims.resource", "alfresco");
        System.setProperty("aims.authServerUrl", "http://localhost:8080/auth");
        System.setProperty("aims.sslRequired", "none");
        System.setProperty("aims.publicClient", "true");
        System.setProperty("aims.autodetectBearerOnly", "true");
        System.setProperty("aims.alwaysRefreshToken", "true");
        System.setProperty("aims.principalAttribute", "email");
        System.setProperty("aims.enableBasicAuth", "true");
        AIMSConfig aimsConfig = this.initAIMSConfig();
        Assert.assertEquals((Object)Boolean.parseBoolean(System.getProperty("aims.enabled")), (Object)aimsConfig.isEnabled());
        Assert.assertEquals((Object)System.getProperty("aims.realm"), (Object)aimsConfig.getAdapterConfig().getRealm());
        Assert.assertEquals((Object)System.getProperty("aims.resource"), (Object)aimsConfig.getAdapterConfig().getResource());
        Assert.assertEquals((Object)System.getProperty("aims.authServerUrl"), (Object)aimsConfig.getAdapterConfig().getAuthServerUrl());
        Assert.assertEquals((Object)System.getProperty("aims.sslRequired"), (Object)aimsConfig.getAdapterConfig().getSslRequired());
        Assert.assertEquals((Object)Boolean.parseBoolean(System.getProperty("aims.publicClient")), (Object)aimsConfig.getAdapterConfig().isPublicClient());
        Assert.assertEquals((Object)Boolean.parseBoolean(System.getProperty("aims.autodetectBearerOnly")), (Object)aimsConfig.getAdapterConfig().isAutodetectBearerOnly());
        Assert.assertEquals((Object)Boolean.parseBoolean(System.getProperty("aims.alwaysRefreshToken")), (Object)aimsConfig.getAdapterConfig().isAlwaysRefreshToken());
        Assert.assertEquals((Object)System.getProperty("aims.principalAttribute"), (Object)aimsConfig.getAdapterConfig().getPrincipalAttribute());
        Assert.assertEquals((Object)Boolean.parseBoolean(System.getProperty("aims.enableBasicAuth")), (Object)aimsConfig.getAdapterConfig().isEnableBasicAuth());
    }
}

