/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.utils;

import org.alfresco.mobile.android.api.session.AlfrescoSession;
import org.alfresco.mobile.android.api.session.CloudSession;
import org.alfresco.mobile.android.api.session.RepositorySession;

public class PublicAPIUrlRegistry {
    public static final String PREFIX_PUBLIC_API = "/api/-default-/public/alfresco/versions/1";
    private static final String PREFIX_CLOUD_PUBLIC_API = "/public/alfresco/versions/1";
    private static final String PREFIX_CLOUD_PUBLIC_API_WORKFLOW = "/public/workflow/versions/1";
    public static final String PREFIX_PUBLIC_API_WORKFLOW = "/api/-default-/public/workflow/versions/1";
    public static final String BINDING_NETWORK_CMISATOM = "/api/-default-/public/cmis/versions/1.0/atom/";
    public static final String VARIABLE_PERSONID = "{personId}";
    public static final String VARIABLE_SITEID = "{siteId}";
    public static final String VARIABLE_NODEID = "{nodeId}";
    public static final String VARIABLE_RENDITIONID = "{renditionId}";
    public static final String VARIABLE_COMMENTID = "{commentId}";
    public static final String VARIABLE_NETWORKID = "{networkId}";
    public static final String URL_USER_PREFERENCE = "people/{personId}/favorites";
    public static final String PREFERENCE_FAVOURITES_DOCUMENTS = "people/{personId}/favorites?where=(EXISTS(target/file))";
    public static final String PREFERENCE_FAVOURITES_FOLDERS = "people/{personId}/favorites?where=(EXISTS(target/folder))";
    public static final String PREFERENCE_FAVOURITES_ALL = "people/{personId}/favorites?where=(EXISTS(target/file)%20OR%20EXISTS(target/folder))";
    public static final String PREFERENCE_FAVOURITE = "people/{personId}/favorites/{nodeId}";
    public static final String URL_USER_PREFERENCE_REMOVE = "people/{personId}/favorites/{siteId}";
    public static final String URL_ALL_SITES = "sites";
    public static final String URL_USER_SITES = "people/{personId}/sites";
    public static final String URL_USER_FAVORITES_SITES = "people/{personId}/favorite-sites";
    public static final String URL_DOCLIB = "sites/{siteId}/containers";
    public static final String URL_SITE = "sites/{siteId}";
    public static final String URL_JOIN_SITE = "people/{personId}/site-membership-requests";
    public static final String URL_CANCEL_JOIN_SITE_REQUEST = "people/{personId}/site-membership-requests/{siteId}";
    public static final String URL_LEAVE_SITE = "sites/{siteId}/members/{personId}";
    public static final String URL_ALLMEMBERSOF = "sites/{siteId}/members";
    public static final String URL_MEMBEROF = "sites/{siteId}/members/{personId}";
    public static final String URL_TAGS = "nodes/{nodeId}/tags";
    public static final String URL_ALL_TAGS = "tags";
    public static final String URL_ACTIVITIES = "people/{personId}/activities";
    public static final String URL_SITE_ACTIVITIES = "people/{personId}/activities?siteId={siteId}";
    public static final String URL_COMMENTS = "nodes/{nodeId}/comments";
    public static final String URL_COMMENT = "nodes/{nodeId}/comments/{commentId}";
    public static final String URL_RATINGS = "nodes/{nodeId}/ratings";
    public static final String URL_PERSON_DETAILS = "people/{personId}";
    private static final String URL_SEARCH_PERSON = "api/people";
    public static final String VARIABLE_PROCESSDEFINITIONID = "{processDefinitionId}";
    public static final String VARIABLE_PROCESSID = "{processId}";
    public static final String VARIABLE_TASKID = "{taskId}";
    public static final String VARIABLE_ITEMID = "{itemId}";
    private static final String VARIABLE_NAME = "{variableName}";
    public static final String URL_PROCESS_DEFINITIONS = "process-definitions";
    public static final String URL_PROCESS_DEFINITION = "process-definitions/{processDefinitionId}";
    public static final String URL_PROCESSES = "processes";
    public static final String URL_PROCESS = "processes/{processId}";
    public static final String URL_PROCESS_DIAGRAM = "processes/{processId}/image";
    public static final String URL_ITEMS_PROCESS = "processes/{processId}/items";
    public static final String URL_PROCESS_VARIABLES = "processes/{processId}/variables";
    public static final String URL_TASKS = "tasks";
    public static final String URL_TASK = "tasks/{taskId}";
    public static final String URL_TASK_VARIABLES = "tasks/{taskId}/variables";
    public static final String URL_TASK_VARIABLE = "tasks/{taskId}/variables/{variableName}";
    public static final String URL_ITEMS_TASK = "tasks/{taskId}/items";
    public static final String URL_ITEM_ID_TASK = "tasks/{taskId}/items/{itemId}";
    public static final String URL_TASK_FOR_PROCESS = "processes/{processId}/tasks";

    protected PublicAPIUrlRegistry() {
    }

    public static String getUserPreferenceUrl(AlfrescoSession session, String username) {
        return PublicAPIUrlRegistry.createPrefix(session).append(URL_USER_PREFERENCE.replace(VARIABLE_PERSONID, PublicAPIUrlRegistry.getEncodingPersonIdentifier(username))).toString();
    }

    public static String getRemoveUserPreferenceUrl(AlfrescoSession session, String username, String siteGUID) {
        return PublicAPIUrlRegistry.createPrefix(session).append(URL_USER_PREFERENCE_REMOVE.replace(VARIABLE_PERSONID, PublicAPIUrlRegistry.getEncodingPersonIdentifier(username)).replace(VARIABLE_SITEID, siteGUID)).toString();
    }

    public static String getUserFavouriteDocumentsUrl(AlfrescoSession session, String username) {
        return PublicAPIUrlRegistry.createPrefix(session).append(PREFERENCE_FAVOURITES_DOCUMENTS.replace(VARIABLE_PERSONID, PublicAPIUrlRegistry.getEncodingPersonIdentifier(username))).toString();
    }

    public static String getUserFavouriteFoldersUrl(AlfrescoSession session, String username) {
        return PublicAPIUrlRegistry.createPrefix(session).append(PREFERENCE_FAVOURITES_FOLDERS.replace(VARIABLE_PERSONID, PublicAPIUrlRegistry.getEncodingPersonIdentifier(username))).toString();
    }

    public static String getUserFavouritesUrl(AlfrescoSession session, String username) {
        return PublicAPIUrlRegistry.createPrefix(session).append(PREFERENCE_FAVOURITES_ALL.replace(VARIABLE_PERSONID, PublicAPIUrlRegistry.getEncodingPersonIdentifier(username))).toString();
    }

    public static String getUserFavouriteUrl(AlfrescoSession session, String username, String identifier) {
        return PublicAPIUrlRegistry.createPrefix(session).append(PREFERENCE_FAVOURITE.replace(VARIABLE_PERSONID, PublicAPIUrlRegistry.getEncodingPersonIdentifier(username)).replace(VARIABLE_NODEID, identifier)).toString();
    }

    public static String getAllSitesUrl(AlfrescoSession session) {
        return PublicAPIUrlRegistry.createPrefix(session).append(URL_ALL_SITES).toString();
    }

    public static String getUserSitesUrl(AlfrescoSession session, String username) {
        return PublicAPIUrlRegistry.createPrefix(session).append(URL_USER_SITES.replace(VARIABLE_PERSONID, PublicAPIUrlRegistry.getEncodingPersonIdentifier(username))).toString();
    }

    public static String getUserFavoriteSitesUrl(AlfrescoSession session, String username) {
        return PublicAPIUrlRegistry.createPrefix(session).append(URL_USER_FAVORITES_SITES.replace(VARIABLE_PERSONID, PublicAPIUrlRegistry.getEncodingPersonIdentifier(username))).toString();
    }

    public static String getSiteUrl(AlfrescoSession session, String siteShortName) {
        return PublicAPIUrlRegistry.createPrefix(session).append(URL_SITE.replace(VARIABLE_SITEID, siteShortName)).toString();
    }

    public static String getDocContainerSiteUrl(AlfrescoSession session, String siteId) {
        return PublicAPIUrlRegistry.createPrefix(session).append(URL_DOCLIB.replace(VARIABLE_SITEID, siteId)).toString();
    }

    public static String getJoinSiteUrl(AlfrescoSession session, String username) {
        return PublicAPIUrlRegistry.createPrefix(session).append(URL_JOIN_SITE.replace(VARIABLE_PERSONID, PublicAPIUrlRegistry.getEncodingPersonIdentifier(username))).toString();
    }

    public static String getLeaveSiteUrl(AlfrescoSession session, String siteShortName, String username) {
        return PublicAPIUrlRegistry.createPrefix(session).append("sites/{siteId}/members/{personId}".replace(VARIABLE_PERSONID, PublicAPIUrlRegistry.getEncodingPersonIdentifier(session.getPersonIdentifier())).replace(VARIABLE_SITEID, siteShortName)).toString();
    }

    public static String getJoinRequestSiteUrl(AlfrescoSession session, String username) {
        return PublicAPIUrlRegistry.getJoinSiteUrl(session, username);
    }

    public static String getCancelJoinSiteRequestUrl(AlfrescoSession session, String siteIdentifier, String username) {
        return PublicAPIUrlRegistry.createPrefix(session).append(URL_CANCEL_JOIN_SITE_REQUEST.replace(VARIABLE_PERSONID, PublicAPIUrlRegistry.getEncodingPersonIdentifier(username)).replace(VARIABLE_SITEID, siteIdentifier)).toString();
    }

    public static String getAllMembersSiteUrl(AlfrescoSession session, String siteShortName) {
        return PublicAPIUrlRegistry.createPrefix(session).append(URL_ALLMEMBERSOF.replace(VARIABLE_SITEID, siteShortName)).toString();
    }

    public static String getMemberOfSiteUrl(AlfrescoSession session, String siteIdentifier, String inviteId) {
        return PublicAPIUrlRegistry.createPrefix(session).append("sites/{siteId}/members/{personId}".replace(VARIABLE_SITEID, siteIdentifier).replace(VARIABLE_PERSONID, PublicAPIUrlRegistry.getEncodingPersonIdentifier(inviteId))).toString();
    }

    public static String getTagsUrl(AlfrescoSession session) {
        return PublicAPIUrlRegistry.createPrefix(session).append(URL_ALL_TAGS).toString();
    }

    public static String getTagsUrl(AlfrescoSession session, String nodeRef) {
        return PublicAPIUrlRegistry.createPrefix(session).append(URL_TAGS.replace(VARIABLE_NODEID, nodeRef)).toString();
    }

    public static String getUserActivitiesUrl(AlfrescoSession session) {
        return PublicAPIUrlRegistry.createPrefix(session).append(URL_ACTIVITIES.replace(VARIABLE_PERSONID, PublicAPIUrlRegistry.getEncodingPersonIdentifier(session.getPersonIdentifier()))).toString();
    }

    public static String getUserActivitiesUrl(AlfrescoSession session, String username) {
        return PublicAPIUrlRegistry.createPrefix(session).append(URL_ACTIVITIES.replace(VARIABLE_PERSONID, PublicAPIUrlRegistry.getEncodingPersonIdentifier(username))).toString();
    }

    public static String getSiteActivitiesUrl(AlfrescoSession session, String siteShortName) {
        return PublicAPIUrlRegistry.createPrefix(session).append(URL_SITE_ACTIVITIES.replace(VARIABLE_PERSONID, PublicAPIUrlRegistry.getEncodingPersonIdentifier(session.getPersonIdentifier())).replace(VARIABLE_SITEID, siteShortName)).toString();
    }

    public static String getCommentsUrl(AlfrescoSession session, String nodeIdentifier) {
        return PublicAPIUrlRegistry.createPrefix(session).append(URL_COMMENTS.replace(VARIABLE_NODEID, nodeIdentifier)).toString();
    }

    public static String getCommentUrl(AlfrescoSession session, String nodeIdentifier, String commentIdentifier) {
        return PublicAPIUrlRegistry.createPrefix(session).append(URL_COMMENT.replace(VARIABLE_NODEID, nodeIdentifier).replace(VARIABLE_COMMENTID, commentIdentifier)).toString();
    }

    public static String getRatingsUrl(AlfrescoSession session, String nodeIdentifier) {
        return PublicAPIUrlRegistry.createPrefix(session).append(URL_RATINGS.replace(VARIABLE_NODEID, nodeIdentifier)).toString();
    }

    public static String getUnlikeUrl(AlfrescoSession session, String nodeIdentifier) {
        return PublicAPIUrlRegistry.createPrefix(session).append(URL_RATINGS.replace(VARIABLE_NODEID, nodeIdentifier)).append("/").append("likes").toString();
    }

    public static String getPersonDetailssUrl(AlfrescoSession session, String username) {
        return PublicAPIUrlRegistry.createPrefix(session).append(URL_PERSON_DETAILS.replace(VARIABLE_PERSONID, PublicAPIUrlRegistry.getEncodingPersonIdentifier(username))).toString();
    }

    public static String getSearchPersonUrl(AlfrescoSession session) {
        return PublicAPIUrlRegistry.createInternalPrefix(session, null).append(URL_SEARCH_PERSON).toString();
    }

    public static String getProcessDefinitionsUrl(AlfrescoSession session) {
        return PublicAPIUrlRegistry.createWorkflowPrefix(session).append(URL_PROCESS_DEFINITIONS).toString();
    }

    public static String getProcessDefinitionUrl(AlfrescoSession session, String workflowDefinitionId) {
        return PublicAPIUrlRegistry.createWorkflowPrefix(session).append(URL_PROCESS_DEFINITION.replace(VARIABLE_PROCESSDEFINITIONID, workflowDefinitionId)).toString();
    }

    public static String getProcessesUrl(AlfrescoSession session) {
        return PublicAPIUrlRegistry.createWorkflowPrefix(session).append(URL_PROCESSES).toString();
    }

    public static String getProcessUrl(AlfrescoSession session, String processId) {
        return PublicAPIUrlRegistry.createWorkflowPrefix(session).append(URL_PROCESS.replace(VARIABLE_PROCESSID, processId)).toString();
    }

    public static String getTasksForProcessIdUrl(AlfrescoSession session, String processId) {
        return PublicAPIUrlRegistry.createWorkflowPrefix(session).append(URL_TASK_FOR_PROCESS.replace(VARIABLE_PROCESSID, processId)).toString();
    }

    public static String getProcessItemsUrl(AlfrescoSession session, String processId) {
        return PublicAPIUrlRegistry.createWorkflowPrefix(session).append(URL_ITEMS_PROCESS.replace(VARIABLE_PROCESSID, processId)).toString();
    }

    public static String getProcessItemsVariableUrl(AlfrescoSession session, String processId) {
        return PublicAPIUrlRegistry.createWorkflowPrefix(session).append(URL_ITEMS_PROCESS.replace(VARIABLE_PROCESSID, processId)).toString();
    }

    public static String getTasksUrl(AlfrescoSession session) {
        return PublicAPIUrlRegistry.createWorkflowPrefix(session).append(URL_TASKS).toString();
    }

    public static String getTaskUrl(AlfrescoSession session, String taskId) {
        return PublicAPIUrlRegistry.createWorkflowPrefix(session).append(URL_TASK.replace(VARIABLE_TASKID, taskId)).toString();
    }

    public static String getTaskVariablesUrl(AlfrescoSession session, String taskId) {
        return PublicAPIUrlRegistry.createWorkflowPrefix(session).append(URL_TASK_VARIABLES.replace(VARIABLE_TASKID, taskId)).toString();
    }

    public static String getTaskVariableUrl(AlfrescoSession session, String taskId, String variableId) {
        return PublicAPIUrlRegistry.createWorkflowPrefix(session).append(URL_TASK_VARIABLE.replace(VARIABLE_TASKID, taskId).replace(VARIABLE_NAME, variableId)).toString();
    }

    public static String getProcessVariablesUrl(AlfrescoSession session, String processId) {
        return PublicAPIUrlRegistry.createWorkflowPrefix(session).append(URL_PROCESS_VARIABLES.replace(VARIABLE_PROCESSID, processId)).toString();
    }

    public static String getTaskItemsUrl(AlfrescoSession session, String taskId) {
        return PublicAPIUrlRegistry.createWorkflowPrefix(session).append(URL_ITEMS_TASK.replace(VARIABLE_TASKID, taskId)).toString();
    }

    public static String getTaskItemByIdUrl(AlfrescoSession session, String taskId, String documentId) {
        return PublicAPIUrlRegistry.createWorkflowPrefix(session).append(URL_ITEM_ID_TASK.replace(VARIABLE_TASKID, taskId).replace(VARIABLE_ITEMID, documentId)).toString();
    }

    public static String getWorkflowDiagram(AlfrescoSession session, String processId) {
        return PublicAPIUrlRegistry.createWorkflowPrefix(session).append(URL_PROCESS_DIAGRAM.replace(VARIABLE_PROCESSID, processId)).toString();
    }

    protected static StringBuilder createWorkflowPrefix(AlfrescoSession session) {
        return PublicAPIUrlRegistry.createCloudWorkflowPrefix(session, null);
    }

    private static StringBuilder createCloudWorkflowPrefix(AlfrescoSession session, String networkIdentifier) {
        StringBuilder sb = new StringBuilder(session.getBaseUrl());
        if (session instanceof CloudSession) {
            sb.append("/");
            if (networkIdentifier != null) {
                sb.append(networkIdentifier);
            } else if (((CloudSession)session).getNetwork() != null) {
                sb.append(((CloudSession)session).getNetwork().getIdentifier());
            }
            sb.append(PublicAPIUrlRegistry.getCloudPubliWorkflowcApiPrefix());
        } else if (session instanceof RepositorySession) {
            sb.append(PublicAPIUrlRegistry.getPublicWorkflowApiPrefix());
        }
        sb.append("/");
        return sb;
    }

    protected static String getPublicWorkflowApiPrefix() {
        return PREFIX_PUBLIC_API_WORKFLOW;
    }

    protected static String getCloudPubliWorkflowcApiPrefix() {
        return PREFIX_CLOUD_PUBLIC_API_WORKFLOW;
    }

    protected static StringBuilder createPrefix(AlfrescoSession session) {
        return PublicAPIUrlRegistry.createPrefix(session, null);
    }

    protected static StringBuilder createPrefix(CloudSession session) {
        return PublicAPIUrlRegistry.createPrefix(session, null);
    }

    private static StringBuilder createPrefix(AlfrescoSession session, String networkIdentifier) {
        StringBuilder sb = new StringBuilder(session.getBaseUrl());
        if (session instanceof CloudSession) {
            sb.append("/");
            if (networkIdentifier != null) {
                sb.append(networkIdentifier);
            } else if (((CloudSession)session).getNetwork() != null) {
                sb.append(((CloudSession)session).getNetwork().getIdentifier());
            }
            sb.append(PublicAPIUrlRegistry.getCloudPublicApiPrefix());
        } else if (session instanceof RepositorySession) {
            sb.append(PublicAPIUrlRegistry.getPublicApiPrefix());
        }
        sb.append("/");
        return sb;
    }

    private static StringBuilder createInternalPrefix(AlfrescoSession session, String networkIdentifier) {
        StringBuilder sb = new StringBuilder(session.getBaseUrl());
        if (session instanceof CloudSession) {
            sb.append("/");
            if (networkIdentifier != null) {
                sb.append(networkIdentifier);
            } else if (((CloudSession)session).getNetwork() != null) {
                sb.append(((CloudSession)session).getNetwork().getIdentifier());
            }
        }
        sb.append("/");
        return sb;
    }

    protected static String getPublicApiPrefix() {
        return PREFIX_PUBLIC_API;
    }

    protected static String getCloudPublicApiPrefix() {
        return PREFIX_CLOUD_PUBLIC_API;
    }

    private static String getEncodingPersonIdentifier(String identifier) {
        String personIdentifier = null;
        if (identifier != null) {
            personIdentifier = identifier.replace(" ", "%20");
        }
        return personIdentifier;
    }

    public static String getPublicAPIUrl(String baseUrl) {
        StringBuilder sb = new StringBuilder(baseUrl);
        sb.append(BINDING_NETWORK_CMISATOM);
        sb.append("/");
        return sb.toString();
    }
}

