/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.utils;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.alfresco.mobile.android.api.exceptions.AlfrescoServiceException;
import org.alfresco.mobile.android.api.utils.JsonUtils;
import org.alfresco.mobile.android.api.utils.messages.Messagesl18n;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Response;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;

public class PublicAPIResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Boolean hasMoreItems;
    private int size;
    private List<Object> entries;

    public PublicAPIResponse(Response resp) {
        if (resp == null || resp.getStream() == null) {
            throw new AlfrescoServiceException(201, Messagesl18n.getString("ErrorCodeRegistry.PARSING_JSONDATA_EMPTY"));
        }
        Map<String, Object> json = JsonUtils.parseObject(resp.getStream(), resp.getCharset());
        Map list = (Map)json.get("list");
        Map pagination = (Map)list.get("pagination");
        this.hasMoreItems = JSONConverter.getBoolean((Map)pagination, (String)"hasMoreItems");
        this.size = 0;
        this.size = pagination.containsKey("totalItems") ? JSONConverter.getInteger((Map)pagination, (String)"totalItems").intValue() : -1;
        this.entries = (List)list.get("entries");
    }

    public Boolean getHasMoreItems() {
        return this.hasMoreItems;
    }

    public int getSize() {
        return this.size;
    }

    public List<Object> getEntries() {
        return this.entries;
    }
}

