/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.utils;

import org.alfresco.mobile.android.api.session.AlfrescoSession;
import org.alfresco.mobile.android.api.utils.NodeRefUtils;

public final class OnPremiseUrlRegistry {
    public static final String BINDING_CMISATOM = "/cmisatom";
    public static final String BINDING_CMIS = "/service/cmis";
    public static final String PREFIX_SERVICE = "/service/";
    public static final String PREFIX_CMIS = "cmis";
    public static final String VARIABLE_SITE = "{site}";
    public static final String VARIABLE_USER = "{userid}";
    public static final String VARIABLE_PREFERENCE = "{preferencefilter}";
    public static final String VARIABLE_STORE_TYPE = "{store_type}";
    public static final String VARIABLE_STORE_ID = "{store_id}";
    public static final String VARIABLE_SHORTNAME = "{shortname}";
    public static final String VARIABLE_ID = "{id}";
    public static final String VARIABLE_THUMBNAIL = "{thumbnailname}";
    public static final String VARIABLE_USERNAME = "{username}";
    public static final String VARIABLE_SCHEME = "{scheme}";
    public static final String VARIABLE_INVITEID = "{inviteid}";
    public static final String URL_USER_PREFERENCE = "api/people/{userid}/preferences";
    public static final String URL_USER_PREFERENCES = "api/people/{userid}/preferences?pf={preferencefilter}";
    public static final String URL_LOGIN = "api/login";
    public static final String PREFERENCE_FAVOURITES_DOCUMENTS = "org.alfresco.share.documents.favourites";
    public static final String PREFERENCE_FAVOURITES_FOLDERS = "org.alfresco.share.folders.favourites";
    public static final String URL_ALL_SITES = "api/sites";
    public static final String URL_SITE = "api/sites/{shortname}";
    public static final String URL_USER_SITES = "api/people/{userid}/sites";
    public static final String PREFERENCE_SITES = "org.alfresco.share.sites";
    public static final String FAVOURITES = "favourites";
    public static final String URL_DOCLIB = "slingshot/doclib/containers/{site}";
    public static final String URL_MEMBEROF = "api/sites/{shortname}/memberships/{userid}";
    public static final String URL_JOIN_PUBLIC_SITE = "api/sites/{shortname}/memberships";
    public static final String URL_JOIN_MODERATED_SITE = "api/sites/{shortname}/invitations";
    public static final String URL_LEAVE_SITE = "api/sites/{shortname}/memberships/{userid}";
    public static final String URL_JOIN_SITE_REQUEST = "api/invitations?inviteeUserName={userid}";
    public static final String URL_CANCEL_JOIN_SITE_REQUEST = "api/sites/{shortname}/invitations/{inviteid}";
    public static final String URL_ALLMEMBERSOF = "api/sites/{shortname}/memberships";
    public static final String URL_COMMENTS = "api/node/{store_type}/{store_id}/{id}/comments";
    public static final String URL_COMMENT = "api/comment/node/{store_type}/{store_id}/{id}";
    public static final String URL_TAGS = "api/node/{store_type}/{store_id}/{id}/tags";
    public static final String URL_ALL_TAGS = "api/tags/{store_type}/{store_id}";
    public static final String URL_MY_ACTIVITIES = "api/activities/feed/user?format=json";
    public static final String URL_USER_ACTIVITIES = "api/activities/feed/user/{userid}?format=json";
    public static final String URL_SITE_ACTIVITIES = "api/activities/feed/site/{site}?format=json";
    public static final String URL_THUMBNAILS = "api/node/{store_type}/{store_id}/{id}/content/thumbnails/{thumbnailname}";
    public static final String URL_THUMBNAIL = "api/node/{store_type}/{store_id}/{id}/content/thumbnails";
    public static final String URL_AVATAR = "slingshot/profile/avatar/{username}";
    public static final String RATINGS_SCHEME_LIKE = "likesRatingScheme";
    public static final String URL_RATINGS = "api/node/{store_type}/{store_id}/{id}/ratings";
    public static final String URL_RATINGS_DELETE = "api/node/{store_type}/{store_id}/{id}/ratings/{scheme}";
    public static final String URL_PERSON_DETAILS = "api/people/{username}";
    public static final String URL_SEARCH_PERSON = "api/people";
    public static final String URL_ACTION_QUEUE = "api/actionQueue";
    public static final String VARIABLE_PROCESSDEFINITIONID = "{processDefinitionId}";
    public static final String VARIABLE_PROCESSID = "{processId}";
    public static final String VARIABLE_PROCESSKEY = "{processKey}";
    public static final String VARIABLE_TASKID = "{taskId}";
    public static final String URL_PROCESS_DEFINITIONS = "api/workflow-definitions";
    public static final String URL_PROCESS_DEFINITION = "api/workflow-definitions/{processDefinitionId}";
    public static final String URL_PROCESSES = "api/workflow-instances";
    public static final String URL_PROCESS = "api/workflow-instances/{processId}";
    public static final String URL_TASK_FOR_PROCESS = "api/workflow-instances/{processId}/task-instances";
    public static final String URL_PROCESS_DIAGRAM = "api/workflow-instances/{processId}/diagram";
    public static final String URL_TASKS = "api/task-instances";
    public static final String URL_TASK = "api/task-instances/{taskId}";
    public static final String URL_FORM_DEFINITIONS = "api/formdefinitions";
    public static final String URL_FORM_PROCESS = "api/workflow/{processKey}/formprocessor";
    public static final String URL_FORM_TASK = "api/task/{taskId}/formprocessor";
    public static final String URL_PERSON_GUID = "api/forms/picker/authority/children?selectableType=cm:person&searchTerm={username}&size=1";
    public static final String URL_SERVER_INFO = "api/server";

    private OnPremiseUrlRegistry() {
    }

    public static String getTicketLoginUrl(String baseAlfrescoUrl) {
        return baseAlfrescoUrl.concat(PREFIX_SERVICE).concat(URL_LOGIN);
    }

    public static String getUserPreferenceUrl(AlfrescoSession session, String username) {
        return session.getBaseUrl().concat(PREFIX_SERVICE).concat(URL_USER_PREFERENCE.replace(VARIABLE_USER, OnPremiseUrlRegistry.getEncodingPersonIdentifier(username)));
    }

    public static String getUserFavouriteDocumentsUrl(AlfrescoSession session, String username) {
        return OnPremiseUrlRegistry.getPreferencesUrl(session, username, PREFERENCE_FAVOURITES_DOCUMENTS);
    }

    public static String getUserFavouriteFoldersUrl(AlfrescoSession session, String username) {
        return OnPremiseUrlRegistry.getPreferencesUrl(session, username, PREFERENCE_FAVOURITES_FOLDERS);
    }

    public static String getPreferencesUrl(AlfrescoSession session, String username, String preferenceFilter) {
        return session.getBaseUrl().concat(PREFIX_SERVICE).concat(URL_USER_PREFERENCES.replace(VARIABLE_USER, OnPremiseUrlRegistry.getEncodingPersonIdentifier(username)).replace(VARIABLE_PREFERENCE, preferenceFilter));
    }

    public static String getAllSitesUrl(AlfrescoSession session) {
        return session.getBaseUrl().concat(PREFIX_SERVICE).concat(URL_ALL_SITES);
    }

    public static String getUserSitesUrl(AlfrescoSession session, String username) {
        return session.getBaseUrl().concat(PREFIX_SERVICE).concat(URL_USER_SITES.replace(VARIABLE_USER, OnPremiseUrlRegistry.getEncodingPersonIdentifier(username)));
    }

    public static String getSiteUrl(AlfrescoSession session, String siteShortName) {
        return session.getBaseUrl().concat(PREFIX_SERVICE).concat(URL_SITE.replace(VARIABLE_SHORTNAME, siteShortName));
    }

    public static String getUserFavoriteSitesUrl(AlfrescoSession session, String username) {
        return OnPremiseUrlRegistry.getPreferencesUrl(session, username, PREFERENCE_SITES);
    }

    public static String getDocContainerSiteUrl(AlfrescoSession session, String siteId) {
        return session.getBaseUrl().concat(PREFIX_SERVICE).concat(URL_DOCLIB.replace(VARIABLE_SITE, siteId));
    }

    public static String getJoinPublicSiteUrl(AlfrescoSession session, String siteShortName) {
        return session.getBaseUrl().concat(PREFIX_SERVICE).concat("api/sites/{shortname}/memberships".replace(VARIABLE_SHORTNAME, siteShortName));
    }

    public static String getJoinModeratedSiteUrl(AlfrescoSession session, String siteShortName) {
        return session.getBaseUrl().concat(PREFIX_SERVICE).concat(URL_JOIN_MODERATED_SITE.replace(VARIABLE_SHORTNAME, siteShortName));
    }

    public static String getLeaveSiteUrl(AlfrescoSession session, String siteShortName, String username) {
        return session.getBaseUrl().concat(PREFIX_SERVICE).concat("api/sites/{shortname}/memberships/{userid}".replace(VARIABLE_SHORTNAME, siteShortName).replace(VARIABLE_USER, OnPremiseUrlRegistry.getEncodingPersonIdentifier(username)));
    }

    public static String getJoinRequestSiteUrl(AlfrescoSession session, String username) {
        return session.getBaseUrl().concat(PREFIX_SERVICE).concat(URL_JOIN_SITE_REQUEST.replace(VARIABLE_USER, OnPremiseUrlRegistry.getEncodingPersonIdentifier(username)));
    }

    public static String getCancelJoinSiteRequestUrl(AlfrescoSession session, String siteIdentifier, String inviteId) {
        return session.getBaseUrl().concat(PREFIX_SERVICE).concat(URL_CANCEL_JOIN_SITE_REQUEST.replace(VARIABLE_SHORTNAME, siteIdentifier).replace(VARIABLE_INVITEID, OnPremiseUrlRegistry.getEncodingPersonIdentifier(inviteId)));
    }

    public static String getMemberOfSiteUrl(AlfrescoSession session, String siteIdentifier, String inviteId) {
        return session.getBaseUrl().concat(PREFIX_SERVICE).concat("api/sites/{shortname}/memberships/{userid}".replace(VARIABLE_SHORTNAME, siteIdentifier).replace(VARIABLE_USER, OnPremiseUrlRegistry.getEncodingPersonIdentifier(inviteId)));
    }

    public static String getSiteMembershipUrl(AlfrescoSession session, String siteIdentifier) {
        return session.getBaseUrl().concat(PREFIX_SERVICE).concat("api/sites/{shortname}/memberships".replace(VARIABLE_SHORTNAME, siteIdentifier));
    }

    public static String getCommentsUrl(AlfrescoSession session, String nodeIdentifier) {
        return session.getBaseUrl().concat(PREFIX_SERVICE).concat(URL_COMMENTS.replace(VARIABLE_STORE_TYPE, NodeRefUtils.getStoreProtocol(nodeIdentifier)).replace(VARIABLE_STORE_ID, NodeRefUtils.getStoreIdentifier(nodeIdentifier)).replace(VARIABLE_ID, NodeRefUtils.getNodeIdentifier(nodeIdentifier)));
    }

    public static String getCommentUrl(AlfrescoSession session, String commentId) {
        return session.getBaseUrl().concat(PREFIX_SERVICE).concat(URL_COMMENT.replace(VARIABLE_STORE_TYPE, NodeRefUtils.getStoreProtocol(commentId)).replace(VARIABLE_STORE_ID, NodeRefUtils.getStoreIdentifier(commentId)).replace(VARIABLE_ID, NodeRefUtils.getNodeIdentifier(commentId)));
    }

    public static String getTagsUrl(AlfrescoSession session) {
        return session.getBaseUrl().concat(PREFIX_SERVICE).concat(URL_ALL_TAGS.replace(VARIABLE_STORE_TYPE, "workspace").replace(VARIABLE_STORE_ID, "SpacesStore"));
    }

    public static String getTagsUrl(AlfrescoSession session, String nodeRef) {
        return session.getBaseUrl().concat(PREFIX_SERVICE).concat(URL_TAGS.replace(VARIABLE_STORE_TYPE, NodeRefUtils.getStoreProtocol(nodeRef)).replace(VARIABLE_STORE_ID, NodeRefUtils.getStoreIdentifier(nodeRef)).replace(VARIABLE_ID, NodeRefUtils.getNodeIdentifier(nodeRef)));
    }

    public static String getUserActivitiesUrl(AlfrescoSession session) {
        return session.getBaseUrl().concat(PREFIX_SERVICE).concat(URL_MY_ACTIVITIES);
    }

    public static String getUserActivitiesUrl(AlfrescoSession session, String username) {
        return session.getBaseUrl().concat(PREFIX_SERVICE).concat(URL_USER_ACTIVITIES.replace(VARIABLE_USER, OnPremiseUrlRegistry.getEncodingPersonIdentifier(username)));
    }

    public static String getSiteActivitiesUrl(AlfrescoSession session, String siteShortName) {
        return session.getBaseUrl().concat(PREFIX_SERVICE).concat(URL_SITE_ACTIVITIES.replace(VARIABLE_SITE, siteShortName));
    }

    public static String getAvatarUrl(AlfrescoSession session, String username) {
        return session.getBaseUrl().concat(PREFIX_SERVICE).concat(URL_AVATAR.replace(VARIABLE_USERNAME, OnPremiseUrlRegistry.getEncodingPersonIdentifier(username)));
    }

    public static String getThumbnailsUrl(AlfrescoSession session, String nodeRef, String thumbnailName) {
        return session.getBaseUrl().concat(PREFIX_SERVICE).concat(URL_THUMBNAILS.replace(VARIABLE_STORE_TYPE, NodeRefUtils.getStoreProtocol(nodeRef)).replace(VARIABLE_STORE_ID, NodeRefUtils.getStoreIdentifier(nodeRef)).replace(VARIABLE_ID, NodeRefUtils.getNodeIdentifier(nodeRef)).replace(VARIABLE_THUMBNAIL, thumbnailName));
    }

    public static String getThumbnailUrl(AlfrescoSession session, String nodeRef) {
        return session.getBaseUrl().concat(PREFIX_SERVICE).concat(URL_THUMBNAIL.replace(VARIABLE_STORE_TYPE, NodeRefUtils.getStoreProtocol(nodeRef)).replace(VARIABLE_STORE_ID, NodeRefUtils.getStoreIdentifier(nodeRef)).replace(VARIABLE_ID, NodeRefUtils.getNodeIdentifier(nodeRef)));
    }

    public static String getRatingsUrl(AlfrescoSession session, String nodeIdentifier) {
        return session.getBaseUrl().concat(PREFIX_SERVICE).concat(URL_RATINGS.replace(VARIABLE_STORE_TYPE, NodeRefUtils.getStoreProtocol(nodeIdentifier)).replace(VARIABLE_STORE_ID, NodeRefUtils.getStoreIdentifier(nodeIdentifier)).replace(VARIABLE_ID, NodeRefUtils.getNodeIdentifier(nodeIdentifier)));
    }

    public static String getUnlikeUrl(AlfrescoSession session, String nodeIdentifier) {
        return session.getBaseUrl().concat(PREFIX_SERVICE).concat(URL_RATINGS_DELETE.replace(VARIABLE_STORE_TYPE, NodeRefUtils.getStoreProtocol(nodeIdentifier)).replace(VARIABLE_STORE_ID, NodeRefUtils.getStoreIdentifier(nodeIdentifier)).replace(VARIABLE_ID, NodeRefUtils.getNodeIdentifier(nodeIdentifier)).replace(VARIABLE_SCHEME, RATINGS_SCHEME_LIKE));
    }

    public static String getPersonDetailsUrl(AlfrescoSession session, String username) {
        return session.getBaseUrl().concat(PREFIX_SERVICE).concat(URL_PERSON_DETAILS.replace(VARIABLE_USERNAME, OnPremiseUrlRegistry.getEncodingPersonIdentifier(username)));
    }

    public static String getSearchPersonUrl(AlfrescoSession session) {
        return session.getBaseUrl().concat(PREFIX_SERVICE).concat(URL_SEARCH_PERSON);
    }

    public static String getActionQueue(AlfrescoSession session) {
        return session.getBaseUrl().concat(PREFIX_SERVICE).concat(URL_ACTION_QUEUE);
    }

    public static String getProcessDefinitionsUrl(AlfrescoSession session) {
        return session.getBaseUrl().concat(PREFIX_SERVICE).concat(URL_PROCESS_DEFINITIONS);
    }

    public static String getProcessDefinitionUrl(AlfrescoSession session, String workflowDefinitionId) {
        return session.getBaseUrl().concat(PREFIX_SERVICE).concat(URL_PROCESS_DEFINITION).replace(VARIABLE_PROCESSDEFINITIONID, workflowDefinitionId);
    }

    public static String getProcessesUrl(AlfrescoSession session) {
        return session.getBaseUrl().concat(PREFIX_SERVICE).concat(URL_PROCESSES);
    }

    public static String getProcessUrl(AlfrescoSession session, String processId) {
        return session.getBaseUrl().concat(PREFIX_SERVICE).concat(URL_PROCESS).replace(VARIABLE_PROCESSID, processId);
    }

    public static String getTasksForProcessIdUrl(AlfrescoSession session, String processId) {
        return session.getBaseUrl().concat(PREFIX_SERVICE).concat(URL_TASK_FOR_PROCESS).replace(VARIABLE_PROCESSID, processId);
    }

    public static String getAllTasksForProcessIdUrl(AlfrescoSession session, String processId) {
        return session.getBaseUrl().concat(PREFIX_SERVICE).concat(URL_PROCESS).replace(VARIABLE_PROCESSID, processId);
    }

    public static String getProcessItemsUrl(AlfrescoSession session, String processId) {
        return session.getBaseUrl().concat(PREFIX_SERVICE).concat(URL_FORM_DEFINITIONS);
    }

    public static String getTasksUrl(AlfrescoSession session) {
        return session.getBaseUrl().concat(PREFIX_SERVICE).concat(URL_TASKS);
    }

    public static String getWorkflowDiagram(AlfrescoSession session, String processId) {
        return session.getBaseUrl().concat(PREFIX_SERVICE).concat(URL_PROCESS_DIAGRAM).replace(VARIABLE_PROCESSID, processId);
    }

    public static String getFormProcessUrl(AlfrescoSession session, String processKey) {
        return session.getBaseUrl().concat(PREFIX_SERVICE).concat(URL_FORM_PROCESS).replace(VARIABLE_PROCESSKEY, processKey);
    }

    public static String getFormTaskUrl(AlfrescoSession session, String taskId) {
        return session.getBaseUrl().concat(PREFIX_SERVICE).concat(URL_FORM_TASK).replace(VARIABLE_TASKID, taskId);
    }

    public static String getTaskUrl(AlfrescoSession session, String taskIdentifier) {
        return session.getBaseUrl().concat(PREFIX_SERVICE).concat(URL_TASK).replace(VARIABLE_TASKID, taskIdentifier);
    }

    public static String getPersonGUIDUrl(AlfrescoSession session, String username) {
        return session.getBaseUrl().concat(PREFIX_SERVICE).concat(URL_PERSON_GUID).replace(VARIABLE_USERNAME, OnPremiseUrlRegistry.getEncodingPersonIdentifier(username));
    }

    private static String getEncodingPersonIdentifier(String identifier) {
        String personIdentifier = null;
        if (identifier != null) {
            personIdentifier = identifier.replace(" ", "%20");
        }
        return personIdentifier;
    }

    public static String getServerInfo(String baseUrl) {
        return baseUrl.concat(PREFIX_SERVICE).concat(URL_SERVER_INFO);
    }
}

