/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class NodeRefUtils {
    public static final int IDENTIFIER_LENGTH = 36;
    public static final String URI_FILLER = "://";
    private static final Pattern NODEREF_PATTERN = Pattern.compile(".+://.+/.+");
    private static final Pattern IDENTIFIER_PATTERN = Pattern.compile("[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}");
    private static final Pattern IDENTIFIER_VERSION_PATTERN = Pattern.compile("[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12};.+");
    public static final String PROTOCOL_WORKSPACE = "workspace";
    public static final String IDENTIFIER_SPACESSTORE = "SpacesStore";
    public static final String STORE_REF_WORKSPACE_SPACESSTORE = "workspace://SpacesStore";

    private NodeRefUtils() {
    }

    public static boolean isNodeRef(String nodeRef) {
        Matcher matcher = NODEREF_PATTERN.matcher(nodeRef);
        return matcher.matches();
    }

    public static String getStoreRef(String nodeRef) {
        if (NodeRefUtils.isNodeRef(nodeRef)) {
            int lastForwardSlash = nodeRef.lastIndexOf(47);
            return nodeRef.substring(0, lastForwardSlash);
        }
        return null;
    }

    public static String getStoreProtocol(String nodeRef) {
        if (NodeRefUtils.isNodeRef(nodeRef)) {
            int dividerPatternPosition = nodeRef.indexOf(URI_FILLER);
            return nodeRef.substring(0, dividerPatternPosition);
        }
        return null;
    }

    public static String getStoreIdentifier(String nodeRef) {
        if (NodeRefUtils.isNodeRef(nodeRef)) {
            int dividerPatternPosition = nodeRef.indexOf(URI_FILLER);
            int lastForwardSlash = nodeRef.lastIndexOf(47);
            return nodeRef.substring(dividerPatternPosition + 3, lastForwardSlash);
        }
        return null;
    }

    public static String getNodeIdentifier(String nodeRef) {
        if (NodeRefUtils.isNodeRef(nodeRef)) {
            int lastForwardSlash = nodeRef.lastIndexOf(47);
            int versionNumber = nodeRef.lastIndexOf(59) == -1 ? nodeRef.length() : nodeRef.lastIndexOf(59);
            return nodeRef.substring(lastForwardSlash + 1, versionNumber);
        }
        if (NodeRefUtils.isIdentifier(nodeRef) || NodeRefUtils.isVersionIdentifier(nodeRef)) {
            return nodeRef;
        }
        return null;
    }

    public static String createNodeRefByIdentifier(String identifier) {
        return "workspace://SpacesStore/" + identifier;
    }

    public static String getCleanIdentifier(String nodeRef) {
        int versionNumber = nodeRef.lastIndexOf(59) == -1 ? nodeRef.length() : nodeRef.lastIndexOf(59);
        return nodeRef.substring(0, versionNumber);
    }

    public static boolean isIdentifier(String id) {
        Matcher matcher = IDENTIFIER_PATTERN.matcher(id);
        return matcher.matches();
    }

    public static boolean isVersionIdentifier(String id) {
        Matcher matcher = IDENTIFIER_VERSION_PATTERN.matcher(id);
        return matcher.matches();
    }

    public static String getVersionIdentifier(String nodeRef) {
        if (NodeRefUtils.isNodeRef(nodeRef)) {
            int lastForwardSlash = nodeRef.lastIndexOf(47);
            return nodeRef.substring(lastForwardSlash + 1, nodeRef.length());
        }
        if (NodeRefUtils.isVersionIdentifier(nodeRef)) {
            return nodeRef;
        }
        if (NodeRefUtils.isIdentifier(nodeRef)) {
            return nodeRef;
        }
        return null;
    }
}

