/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.utils;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;
import org.alfresco.mobile.android.api.model.Node;
import org.alfresco.mobile.android.api.services.DocumentFolderService;

public class NodeComparator
implements Serializable,
Comparator<Node> {
    private static final long serialVersionUID = 1L;
    private boolean asc;
    private String propertySorting;

    public NodeComparator(boolean asc, String propertySorting) {
        this.asc = asc;
        this.propertySorting = propertySorting;
    }

    @Override
    public int compare(Node nodeA, Node nodeB) {
        if (nodeA == null || nodeB == null) {
            return 0;
        }
        int b = 0;
        if (DocumentFolderService.SORT_PROPERTY_NAME.equals(this.propertySorting)) {
            if (nodeA.getName() == null) {
                return 0;
            }
            b = nodeA.getName().compareToIgnoreCase(nodeB.getName());
        } else if (DocumentFolderService.SORT_PROPERTY_TITLE.equals(this.propertySorting)) {
            if (nodeA.getTitle() == null) {
                return 0;
            }
            b = nodeA.getTitle().compareToIgnoreCase(nodeB.getTitle());
        } else if (DocumentFolderService.SORT_PROPERTY_DESCRIPTION.equals(this.propertySorting)) {
            if (nodeA.getDescription() == null) {
                return 0;
            }
            b = nodeA.getDescription().compareToIgnoreCase(nodeB.getDescription());
        } else {
            if (DocumentFolderService.SORT_PROPERTY_CREATED_AT.equals(this.propertySorting)) {
                if (nodeA.getCreatedAt() == null || nodeB.getCreatedAt() == null) {
                    return 0;
                }
                return this.compareDate(nodeA.getCreatedAt().getTime(), nodeB.getCreatedAt().getTime());
            }
            if (DocumentFolderService.SORT_PROPERTY_MODIFIED_AT.equals(this.propertySorting)) {
                if (nodeA.getModifiedAt() == null || nodeB.getModifiedAt() == null) {
                    return 0;
                }
                return this.compareDate(nodeA.getModifiedAt().getTime(), nodeB.getModifiedAt().getTime());
            }
            if (nodeA.getName() == null) {
                return 0;
            }
            b = nodeA.getName().compareToIgnoreCase(nodeB.getName());
        }
        if (this.asc) {
            return b;
        }
        return -b;
    }

    public int compareDate(Date d1, Date d2) {
        if (d1 == null && d2 == null) {
            return -1;
        }
        if (d1 == null || d2 == null) {
            return -1;
        }
        if (d1.after(d2)) {
            if (this.asc) {
                return 1;
            }
            return -1;
        }
        if (d1.before(d2)) {
            if (this.asc) {
                return -1;
            }
            return 1;
        }
        return 0;
    }
}

