/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.utils;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.mobile.android.api.exceptions.AlfrescoServiceException;
import org.alfresco.mobile.android.api.utils.IOUtils;
import org.alfresco.mobile.android.api.utils.messages.Messagesl18n;
import org.apache.chemistry.opencmis.commons.impl.json.parser.ContainerFactory;
import org.apache.chemistry.opencmis.commons.impl.json.parser.JSONParser;

public final class JsonUtils {
    protected static final ContainerFactory SIMPLE_CONTAINER_FACTORY = new ContainerFactory(){

        public Map createObjectContainer() {
            return new LinkedHashMap();
        }

        public List creatArrayContainer() {
            return new ArrayList();
        }
    };

    private JsonUtils() {
    }

    public static Map<String, Object> parseObject(InputStream stream, String charset) {
        Object obj = JsonUtils.parse(stream, charset, SIMPLE_CONTAINER_FACTORY);
        if (obj instanceof Map) {
            return (Map)obj;
        }
        throw new AlfrescoServiceException(200, Messagesl18n.getString("JsonUtils.0"));
    }

    public static List<Object> parseArray(InputStream stream, String charset) {
        Object obj = JsonUtils.parse(stream, charset, SIMPLE_CONTAINER_FACTORY);
        if (obj instanceof List) {
            return (List)obj;
        }
        throw new AlfrescoServiceException(200, Messagesl18n.getString("JsonUtils.0"));
    }

    public static Map<String, Object> parseObject(String value) {
        Object obj = null;
        try {
            JSONParser parser = new JSONParser();
            obj = parser.parse(value, SIMPLE_CONTAINER_FACTORY);
            if (obj instanceof Map) {
                return (Map)obj;
            }
        }
        catch (Exception e) {
            throw new AlfrescoServiceException(200, (Throwable)e);
        }
        return null;
    }

    public static Object parse(InputStream stream, String charset, ContainerFactory containerFactory) {
        InputStreamReader reader = null;
        Object obj = null;
        try {
            reader = new InputStreamReader(stream, charset);
            JSONParser parser = new JSONParser();
            obj = parser.parse((Reader)reader, containerFactory);
        }
        catch (Exception e) {
            try {
                throw new AlfrescoServiceException(200, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(reader);
                IOUtils.closeStream(stream);
                throw throwable;
            }
        }
        IOUtils.closeStream(reader);
        IOUtils.closeStream(stream);
        return obj;
    }

    public static String convertStreamToString(InputStream is) {
        String line = null;
        StringBuilder sb = new StringBuilder();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
        }
        catch (Exception e) {
            throw new AlfrescoServiceException(200, (Throwable)e);
        }
        finally {
            IOUtils.closeStream(is);
        }
        return sb.toString();
    }

    public static void join(StringBuilder sb, CharSequence delimiter, Object[] tokens) {
        boolean firstTime = true;
        for (Object token : tokens) {
            if (firstTime) {
                firstTime = false;
            } else {
                sb.append(delimiter);
            }
            sb.append("'" + token + "'");
        }
    }
}

