/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.utils;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.chemistry.opencmis.commons.impl.json.JSONArray;
import org.apache.chemistry.opencmis.commons.impl.json.JSONObject;

public class JsonDataWriter {
    private static final String CONTENT_TYPE_URLENCODED = "application/json;charset=utf-8";
    private static final String CRLF = "\r\n";
    private Object jsonObject;

    public JsonDataWriter(JSONObject json) {
        this.jsonObject = json;
    }

    public JsonDataWriter(org.json.JSONArray jsonArray) {
        this.jsonObject = jsonArray;
    }

    public JsonDataWriter(JSONArray jsonArray) {
        this.jsonObject = jsonArray;
    }

    public String getContentType() {
        return CONTENT_TYPE_URLENCODED;
    }

    public void write(OutputStream out) throws IOException {
        if (this.jsonObject == null) {
            return;
        }
        if (this.jsonObject instanceof JSONObject) {
            this.writeLine(out, ((JSONObject)this.jsonObject).toJSONString());
        } else {
            this.writeLine(out, this.jsonObject.toString());
        }
    }

    private void writeLine(OutputStream out, String s) throws IOException {
        String tmpString = s == null ? CRLF : s + CRLF;
        out.write(tmpString.getBytes("UTF-8"));
    }
}

