/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.alfresco.mobile.android.api.model.ContentFile;

public final class IOUtils {
    public static final int MAX_BUFFER_SIZE = 1024;

    public static void closeStream(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static File createUniqueName(File file) {
        if (!file.exists()) {
            return file;
        }
        File tmpFile = file;
        for (int index = 1; index < 500; ++index) {
            if ((tmpFile = new File(tmpFile.getParentFile(), tmpFile.getName() + "-" + index)).exists()) continue;
            return tmpFile;
        }
        return null;
    }

    public static void ensureOrCreatePathAndFile(File contentFile) {
        contentFile.getParentFile().mkdirs();
        IOUtils.createUniqueName(contentFile);
    }

    public static boolean copyFile(InputStream src, File dest) throws IOException {
        IOUtils.ensureOrCreatePathAndFile(dest);
        return IOUtils.copyStream(src, new FileOutputStream(dest));
    }

    public static boolean copyStream(InputStream src, OutputStream osstream) throws IOException {
        BufferedOutputStream bos = null;
        MonitoredBufferedInputStream bis = null;
        boolean copied = true;
        try {
            int count;
            bos = new BufferedOutputStream(osstream);
            bis = new MonitoredBufferedInputStream(src);
            byte[] buffer = new byte[1024];
            while ((count = bis.read(buffer)) != -1) {
                bos.write(buffer, 0, count);
            }
            bos.flush();
        }
        catch (IOException e) {
            try {
                copied = false;
                throw e;
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(osstream);
                IOUtils.closeStream(src);
                IOUtils.closeStream(bis);
                throw throwable;
            }
        }
        IOUtils.closeStream(osstream);
        IOUtils.closeStream(src);
        IOUtils.closeStream(bis);
        return copied;
    }

    public static InputStream getContentFileInputStream(ContentFile contentFile) {
        try {
            if (contentFile != null) {
                MonitoredBufferedInputStream mb = new MonitoredBufferedInputStream(new FileInputStream(contentFile.getFile()));
                mb.setContentFile(contentFile);
                return mb;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return null;
    }

    static class MonitoredBufferedInputStream
    extends BufferedInputStream {
        ContentFile contentFile = null;
        int block = 0;

        public MonitoredBufferedInputStream(InputStream in) {
            super(in);
        }

        void setContentFile(ContentFile cf) {
            this.contentFile = cf;
        }

        @Override
        public synchronized int read() throws IOException {
            if (this.contentFile != null) {
                this.contentFile.fileReadCallback(1);
            }
            return super.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            ++this.block;
            int nBytes = super.read(b);
            --this.block;
            if (this.contentFile != null && this.block == 0) {
                this.contentFile.fileReadCallback(nBytes);
            }
            return nBytes;
        }

        @Override
        public synchronized int read(byte[] b, int off, int len) throws IOException {
            ++this.block;
            int nBytes = super.read(b, off, len);
            --this.block;
            if (this.contentFile != null && this.block == 0) {
                this.contentFile.fileReadCallback(nBytes);
            }
            return nBytes;
        }
    }
}

