/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.utils;

import java.text.FieldPosition;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;

public final class DateUtils {
    public static final String FORMAT_1 = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final String FORMAT_2 = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    public static final String FORMAT_3 = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final String FORMAT_4 = "MMM dd yyyy HH:mm:ss zzzz";
    public static final String FORMAT_5 = "dd MMM yyyy HH:mm:ss zzzz";
    public static final String FORMAT_6 = "yyyy-MM-dd'T'hh:mm:ss.SSS";
    private static final String[] DATE_FORMATS = new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", "yyyy-MM-dd'T'HH:mm:ss'Z'", "yyyy-MM-dd'T'HH:mm:ss.SSSZ", "MMM dd yyyy HH:mm:ss zzzz", "dd MMM yyyy HH:mm:ss zzzz"};

    private DateUtils() {
    }

    public static Date parseJsonDate(String jsonDate) {
        Date d = null;
        if (jsonDate != null && (d = DateUtils.parseDate(jsonDate, FORMAT_4)) == null) {
            d = DateUtils.parseDate(jsonDate);
        }
        return d;
    }

    public static Date parseDate(String atomPubDate) {
        return DateUtils.parseDate(atomPubDate, Locale.getDefault());
    }

    public static Date parseDate(String atomPubDate, Locale locale) {
        SimpleDateFormat sdf;
        int i;
        Date d = null;
        for (i = 0; i < DATE_FORMATS.length; ++i) {
            sdf = new SimpleDateFormat(DATE_FORMATS[i], locale);
            sdf.setLenient(true);
            try {
                d = sdf.parse(atomPubDate);
                break;
            }
            catch (ParseException e) {
                continue;
            }
        }
        if (d == null) {
            for (i = 0; i < DATE_FORMATS.length; ++i) {
                sdf = new SimpleDateFormat(DATE_FORMATS[i], Locale.ENGLISH);
                sdf.setLenient(true);
                try {
                    d = sdf.parse(atomPubDate);
                    break;
                }
                catch (ParseException e) {
                    continue;
                }
            }
        }
        return d;
    }

    public static Date parseDate(String date, String format) {
        if (date == null) {
            return null;
        }
        return DateUtils.parseDate(date, new SimpleDateFormat(format, Locale.getDefault()));
    }

    public static Date parseDate(String date, SimpleDateFormat sdf) {
        Date d = null;
        sdf.setLenient(true);
        try {
            d = sdf.parse(date);
        }
        catch (ParseException e) {
            d = DateUtils.parseDate(date);
        }
        return d;
    }

    public static String format(GregorianCalendar calendar) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss.SSSZ"){
            private static final long serialVersionUID = 1L;

            @Override
            public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition pos) {
                StringBuffer toFix = super.format(date, toAppendTo, pos);
                return toFix.insert(toFix.length() - 2, ':');
            }
        };
        return dateFormat.format(calendar.getTime());
    }

    public static String formatISO(GregorianCalendar calendar) {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mmZ").format(calendar.getTime());
    }
}

