/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.utils;

import org.alfresco.mobile.android.api.session.CloudSession;
import org.alfresco.mobile.android.api.utils.PublicAPIUrlRegistry;

public final class CloudUrlRegistry
extends PublicAPIUrlRegistry {
    public static final String VARIABLE_PERSONID = "{personId}";
    public static final String VARIABLE_SITEID = "{siteId}";
    public static final String VARIABLE_NODEID = "{nodeId}";
    public static final String VARIABLE_RENDITIONID = "{renditionId}";
    public static final String VARIABLE_COMMENTID = "{commentId}";
    public static final String VARIABLE_NETWORKID = "{networkId}";
    public static final String PREFIX_PUBLIC_API = "/public/alfresco/versions/1";
    public static final String BINDING_NETWORK_CMISATOM = "/{networkId}/public/cmis/versions/1.0/atom/";
    public static final String URL_USER_PREFERENCE = "people/{personId}/favorites";
    public static final String PREFERENCE_FAVOURITES_DOCUMENTS = "people/{personId}/favorites?where=(EXISTS(target/file))";
    public static final String PREFERENCE_FAVOURITES_FOLDERS = "people/{personId}/favorites?where=(EXISTS(target/folder))";
    public static final String PREFERENCE_FAVOURITES_ALL = "people/{personId}/favorites? where=(EXISTS(target/file) OR EXISTS(target/folder))";
    public static final String PREFERENCE_FAVOURITE = "people/{personId}/favorites/{nodeId}";
    public static final String URL_USER_PREFERENCE_REMOVE = "people/{personId}/favorites/{siteId}";
    public static final String URL_ALL_SITES = "sites";
    public static final String URL_USER_SITES = "people/{personId}/sites";
    public static final String URL_USER_FAVORITES_SITES = "people/{personId}/favorite-sites";
    public static final String URL_DOCLIB = "sites/{siteId}/containers";
    public static final String URL_SITE = "sites/{siteId}";
    public static final String URL_JOIN_SITE = "people/{personId}/site-membership-requests";
    public static final String URL_CANCEL_JOIN_SITE_REQUEST = "people/{personId}/site-membership-requests/{siteId}";
    public static final String URL_LEAVE_SITE = "sites/{siteId}/members/{personId}";
    public static final String URL_ALLMEMBERSOF = "sites/{siteId}/members";
    public static final String URL_NETWORKS = "people/{personId}/networks";
    public static final String URL_NETWORK = "people/{personId}/networks/{networkId}";
    public static final String URL_TAGS = "nodes/{nodeId}/tags";
    public static final String URL_ALL_TAGS = "tags";
    public static final String URL_ACTIVITIES = "people/{personId}/activities";
    public static final String URL_SITE_ACTIVITIES = "people/{personId}/activities?siteId={siteId}";
    public static final String URL_COMMENTS = "nodes/{nodeId}/comments";
    public static final String URL_COMMENT = "nodes/{nodeId}/comments/{commentId}";
    public static final String URL_RATINGS = "nodes/{nodeId}/ratings";
    public static final String URL_PERSON_DETAILS = "people/{personId}";
    public static final String URL_RENDITION = "content?id={nodeId}&streamId={renditionId}";

    private CloudUrlRegistry() {
    }

    public static String getUserPreferenceUrl(CloudSession session, String username) {
        return CloudUrlRegistry.createPrefix(session).append(URL_USER_PREFERENCE.replace(VARIABLE_PERSONID, CloudUrlRegistry.getEncodingPersonIdentifier(username))).toString();
    }

    public static String getRemoveUserPreferenceUrl(CloudSession session, String username, String siteGUID) {
        return CloudUrlRegistry.createPrefix(session).append(URL_USER_PREFERENCE_REMOVE.replace(VARIABLE_PERSONID, CloudUrlRegistry.getEncodingPersonIdentifier(username)).replace(VARIABLE_SITEID, siteGUID)).toString();
    }

    public static String getUserFavouriteDocumentsUrl(CloudSession session, String username) {
        return CloudUrlRegistry.createPrefix(session).append(PREFERENCE_FAVOURITES_DOCUMENTS.replace(VARIABLE_PERSONID, CloudUrlRegistry.getEncodingPersonIdentifier(username))).toString();
    }

    public static String getUserFavouriteFoldersUrl(CloudSession session, String username) {
        return CloudUrlRegistry.createPrefix(session).append(PREFERENCE_FAVOURITES_FOLDERS.replace(VARIABLE_PERSONID, CloudUrlRegistry.getEncodingPersonIdentifier(username))).toString();
    }

    public static String getUserFavouritesUrl(CloudSession session, String username) {
        return CloudUrlRegistry.createPrefix(session).append(PREFERENCE_FAVOURITES_ALL.replace(VARIABLE_PERSONID, CloudUrlRegistry.getEncodingPersonIdentifier(username))).toString();
    }

    public static String getUserFavouriteUrl(CloudSession session, String username, String identifier) {
        return CloudUrlRegistry.createPrefix(session).append(PREFERENCE_FAVOURITE.replace(VARIABLE_PERSONID, CloudUrlRegistry.getEncodingPersonIdentifier(username)).replace(VARIABLE_NODEID, identifier)).toString();
    }

    public static String getAllSitesUrl(CloudSession session) {
        return CloudUrlRegistry.createPrefix(session).append(URL_ALL_SITES).toString();
    }

    public static String getUserSitesUrl(CloudSession session, String username) {
        return CloudUrlRegistry.createPrefix(session).append(URL_USER_SITES.replace(VARIABLE_PERSONID, CloudUrlRegistry.getEncodingPersonIdentifier(username))).toString();
    }

    public static String getUserFavoriteSitesUrl(CloudSession session, String username) {
        return CloudUrlRegistry.createPrefix(session).append(URL_USER_FAVORITES_SITES.replace(VARIABLE_PERSONID, CloudUrlRegistry.getEncodingPersonIdentifier(username))).toString();
    }

    public static String getSiteUrl(CloudSession session, String siteShortName) {
        return CloudUrlRegistry.createPrefix(session).append(URL_SITE.replace(VARIABLE_SITEID, siteShortName)).toString();
    }

    public static String getDocContainerSiteUrl(CloudSession session, String siteId) {
        return CloudUrlRegistry.createPrefix(session).append(URL_DOCLIB.replace(VARIABLE_SITEID, siteId)).toString();
    }

    public static String getJoinSiteUrl(CloudSession session, String username) {
        return CloudUrlRegistry.createPrefix(session).append(URL_JOIN_SITE.replace(VARIABLE_PERSONID, CloudUrlRegistry.getEncodingPersonIdentifier(username))).toString();
    }

    public static String getLeaveSiteUrl(CloudSession session, String siteShortName, String username) {
        return CloudUrlRegistry.createPrefix(session).append(URL_LEAVE_SITE.replace(VARIABLE_PERSONID, CloudUrlRegistry.getEncodingPersonIdentifier(session.getPersonIdentifier())).replace(VARIABLE_SITEID, siteShortName)).toString();
    }

    public static String getJoinRequestSiteUrl(CloudSession session, String username) {
        return CloudUrlRegistry.getJoinSiteUrl(session, username);
    }

    public static String getCancelJoinSiteRequestUrl(CloudSession session, String siteIdentifier, String username) {
        return CloudUrlRegistry.createPrefix(session).append(URL_CANCEL_JOIN_SITE_REQUEST.replace(VARIABLE_PERSONID, CloudUrlRegistry.getEncodingPersonIdentifier(username)).replace(VARIABLE_SITEID, siteIdentifier)).toString();
    }

    public static String getAllMembersSiteUrl(CloudSession session, String siteShortName) {
        return CloudUrlRegistry.createPrefix(session).append(URL_ALLMEMBERSOF.replace(VARIABLE_SITEID, siteShortName)).toString();
    }

    public static String getUserNetworks(String baseUrl) {
        return baseUrl;
    }

    public static String getUserNetworks(CloudSession session, String username) {
        return CloudUrlRegistry.createPrefix(session).append(URL_NETWORKS.replace(VARIABLE_PERSONID, CloudUrlRegistry.getEncodingPersonIdentifier(username))).toString();
    }

    public static String getNetwork(CloudSession session, String username, String networkIdentifier) {
        return CloudUrlRegistry.createPrefix(session, networkIdentifier).append(URL_NETWORK.replace(VARIABLE_PERSONID, CloudUrlRegistry.getEncodingPersonIdentifier(username)).replace(VARIABLE_NETWORKID, networkIdentifier)).toString();
    }

    public static String getTagsUrl(CloudSession session) {
        return CloudUrlRegistry.createPrefix(session).append(URL_ALL_TAGS).toString();
    }

    public static String getTagsUrl(CloudSession session, String nodeRef) {
        return CloudUrlRegistry.createPrefix(session).append(URL_TAGS.replace(VARIABLE_NODEID, nodeRef)).toString();
    }

    public static String getUserActivitiesUrl(CloudSession session) {
        return CloudUrlRegistry.createPrefix(session).append(URL_ACTIVITIES.replace(VARIABLE_PERSONID, CloudUrlRegistry.getEncodingPersonIdentifier(session.getPersonIdentifier()))).toString();
    }

    public static String getUserActivitiesUrl(CloudSession session, String username) {
        return CloudUrlRegistry.createPrefix(session).append(URL_ACTIVITIES.replace(VARIABLE_PERSONID, CloudUrlRegistry.getEncodingPersonIdentifier(username))).toString();
    }

    public static String getSiteActivitiesUrl(CloudSession session, String siteShortName) {
        return CloudUrlRegistry.createPrefix(session).append(URL_SITE_ACTIVITIES.replace(VARIABLE_PERSONID, CloudUrlRegistry.getEncodingPersonIdentifier(session.getPersonIdentifier())).replace(VARIABLE_SITEID, siteShortName)).toString();
    }

    public static String getCommentsUrl(CloudSession session, String nodeIdentifier) {
        return CloudUrlRegistry.createPrefix(session).append(URL_COMMENTS.replace(VARIABLE_NODEID, nodeIdentifier)).toString();
    }

    public static String getCommentUrl(CloudSession session, String nodeIdentifier, String commentIdentifier) {
        return CloudUrlRegistry.createPrefix(session).append(URL_COMMENT.replace(VARIABLE_NODEID, nodeIdentifier).replace(VARIABLE_COMMENTID, commentIdentifier)).toString();
    }

    public static String getRatingsUrl(CloudSession session, String nodeIdentifier) {
        return CloudUrlRegistry.createPrefix(session).append(URL_RATINGS.replace(VARIABLE_NODEID, nodeIdentifier)).toString();
    }

    public static String getUnlikeUrl(CloudSession session, String nodeIdentifier) {
        return CloudUrlRegistry.createPrefix(session).append(URL_RATINGS.replace(VARIABLE_NODEID, nodeIdentifier)).append("/").append("likes").toString();
    }

    public static String getPersonDetailssUrl(CloudSession session, String username) {
        return CloudUrlRegistry.createPrefix(session).append(URL_PERSON_DETAILS.replace(VARIABLE_PERSONID, CloudUrlRegistry.getEncodingPersonIdentifier(username))).toString();
    }

    public static String getThumbnailUrl(CloudSession session, String nodeIdentifier, String thumbnailIdentifier) {
        return session.getBaseUrl().concat(BINDING_NETWORK_CMISATOM).replace(VARIABLE_NETWORKID, session.getNetwork().getIdentifier()).concat(URL_RENDITION.replace(VARIABLE_NODEID, nodeIdentifier).replace(VARIABLE_RENDITIONID, thumbnailIdentifier));
    }

    protected static StringBuilder createPrefix(CloudSession session) {
        return CloudUrlRegistry.createPrefix(session, null);
    }

    private static StringBuilder createPrefix(CloudSession session, String networkIdentifier) {
        StringBuilder sb = new StringBuilder(session.getBaseUrl());
        sb.append("/");
        if (networkIdentifier != null) {
            sb.append(networkIdentifier);
        } else if (session.getNetwork() != null) {
            sb.append(session.getNetwork().getIdentifier());
        }
        sb.append(PREFIX_PUBLIC_API);
        sb.append("/");
        return sb;
    }

    protected static String getPublicApiPrefix() {
        return PREFIX_PUBLIC_API;
    }

    private static String getEncodingPersonIdentifier(String identifier) {
        String personIdentifier = null;
        if (identifier != null) {
            personIdentifier = identifier.replace(" ", "%20");
        }
        return personIdentifier;
    }
}

