/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.session.impl;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import java.io.Serializable;
import java.util.Map;
import org.alfresco.mobile.android.api.exceptions.AlfrescoSessionException;
import org.alfresco.mobile.android.api.model.Folder;
import org.alfresco.mobile.android.api.model.RepositoryInfo;
import org.alfresco.mobile.android.api.model.impl.FolderImpl;
import org.alfresco.mobile.android.api.model.impl.onpremise.OnPremiseRepositoryInfoImpl;
import org.alfresco.mobile.android.api.network.NetworkHttpInvoker;
import org.alfresco.mobile.android.api.services.impl.onpremise.OnPremiseServiceRegistry;
import org.alfresco.mobile.android.api.session.RepositorySession;
import org.alfresco.mobile.android.api.session.authentication.impl.PassthruAuthenticationProviderImpl;
import org.alfresco.mobile.android.api.utils.JsonUtils;
import org.alfresco.mobile.android.api.utils.OnPremiseUrlRegistry;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.api.SessionFactory;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Response;
import org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUnauthorizedException;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;

public class RepositorySessionImpl
extends RepositorySession {
    public static final Parcelable.Creator<RepositorySessionImpl> CREATOR = new Parcelable.Creator<RepositorySessionImpl>(){

        public RepositorySessionImpl createFromParcel(Parcel in) {
            return new RepositorySessionImpl(in);
        }

        public RepositorySessionImpl[] newArray(int size) {
            return new RepositorySessionImpl[size];
        }
    };

    public RepositorySessionImpl() {
    }

    public RepositorySessionImpl(String url, String username, String password) {
        this(url, username, password, null);
    }

    public RepositorySessionImpl(String url, String username, String password, Map<String, Serializable> settings) {
        this.initSettings(url, username, password, settings);
        this.authenticate();
    }

    private void authenticate() {
        SessionFactoryImpl sessionFactory = SessionFactoryImpl.newInstance();
        Map<String, String> param = this.retrieveSessionParameters();
        String[] bindingUrls = new String[]{this.baseUrl.concat("/api/-default-/public/cmis/versions/1.0/atom/"), this.baseUrl.concat("/cmisatom"), this.baseUrl.concat("/service/cmis")};
        Exception creationException = null;
        this.hasPublicAPI = true;
        for (String bindingUrl : bindingUrls) {
            if (!this.hasForceBinding()) {
                param.put("org.apache.chemistry.opencmis.binding.atompub.url", bindingUrl);
            }
            try {
                this.cmisSession = this.createSession((SessionFactory)sessionFactory, param);
            }
            catch (Exception err) {
                creationException = err;
                if (err.getCause() instanceof CmisUnauthorizedException) break;
                this.hasPublicAPI = false;
            }
            if (this.cmisSession != null) {
                creationException = null;
                break;
            }
            if (this.hasForceBinding()) break;
        }
        if (this.cmisSession == null) {
            throw new AlfrescoSessionException(100, creationException);
        }
        boolean isAlfresco = this.cmisSession.getRepositoryInfo().getProductName().startsWith("Alfresco");
        if (!isAlfresco) {
            throw new AlfrescoSessionException(106, (Throwable)creationException);
        }
        this.repositoryInfo = new OnPremiseRepositoryInfoImpl(this.cmisSession.getRepositoryInfo(), this.hasPublicAPI);
        if (this.repositoryInfo.getEdition() == "unknown") {
            try {
                UrlBuilder builder = new UrlBuilder(OnPremiseUrlRegistry.getServerInfo(this.baseUrl));
                Response resp = NetworkHttpInvoker.invokeGET(builder, this.cmisSession.getBinding().getAuthenticationProvider().getHTTPHeaders(this.baseUrl));
                Map<String, Object> json = JsonUtils.parseObject(resp.getStream(), resp.getCharset());
                if (json.containsKey("data")) {
                    String editionValue = JSONConverter.getString((Map)JSONConverter.getMap((Object)json.get("data")), (String)"edition");
                    this.repositoryInfo = new OnPremiseRepositoryInfoImpl(this.cmisSession.getRepositoryInfo(), editionValue);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.rootNode = new FolderImpl((CmisObject)this.cmisSession.getRootFolder());
        this.initServices();
    }

    private void initServices() {
        this.passThruAuthenticator = this.cmisSession.getBinding().getAuthenticationProvider();
        this.authenticator = ((PassthruAuthenticationProviderImpl)this.passThruAuthenticator).getAlfrescoAuthenticationProvider();
        this.services = this.hasParameter("org.alfresco.mobile.api.services.onpremise") ? this.createServiceRegistry((String)((Object)this.getParameter("org.alfresco.mobile.api.services.onpremise"))) : new OnPremiseServiceRegistry(this);
        ((OnPremiseServiceRegistry)this.services).init();
    }

    public boolean hasPublicAPI() {
        return this.hasPublicAPI;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int arg1) {
        dest.writeString(this.baseUrl);
        dest.writeString(this.userIdentifier);
        dest.writeString(this.password);
        dest.writeParcelable((Parcelable)this.rootNode, 1);
        dest.writeSerializable((Serializable)this.repositoryInfo);
        dest.writeSerializable((Serializable)this.cmisSession);
        Bundle b = new Bundle();
        b.putSerializable("userParameters", (Serializable)((Object)this.userParameters));
        dest.writeBundle(b);
    }

    public RepositorySessionImpl(Parcel o) {
        this.baseUrl = o.readString();
        this.userIdentifier = o.readString();
        this.password = o.readString();
        this.rootNode = (Folder)o.readParcelable(FolderImpl.class.getClassLoader());
        this.repositoryInfo = (RepositoryInfo)o.readSerializable();
        this.cmisSession = (Session)o.readSerializable();
        Bundle b = o.readBundle();
        this.userParameters = (Map)((Object)b.getSerializable("userParameters"));
        this.initServices();
    }
}

